/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.aef.GetBizBillInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ArGetBizBillInfoNewImpl
implements GetBizBillInfo {
    private static final Log logger = LogFactory.getLog(ArGetBizBillInfoNewImpl.class);

    public Map<Long, List<JSONObject>> getBizBillTicketList(String billType, Set<Long> billIds) {
        logger.info("ArGetBizBillInfoNewImpl ar_param-billType:" + billType + " billIds:" + billIds);
        HashMap<Long, List<JSONObject>> result = new HashMap<Long, List<JSONObject>>(billIds.size());
        if (StringUtils.isEmpty(billType) || ObjectUtils.isEmpty(billIds)) {
            return result;
        }
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"org,currency,bookdate,entry.id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
        if (finArBills.length == 0) {
            return result;
        }
        HashSet<Long> idSet = new HashSet<Long>(8);
        HashSet<Long> entryIdSet = new HashSet<Long>(8);
        for (DynamicObject bill : finArBills) {
            idSet.add(bill.getLong("id"));
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : entryColl) {
                entryIdSet.add(dynamicObject.getLong("id"));
            }
        }
        Map<Long, List<Long>> tarInvoiceMap = BOTPHelper.loadNearTarBillIds("ar_finarbill", "entry", idSet.toArray(new Long[0]), entryIdSet.toArray(new Long[0]), "sim_vatinvoice");
        if (tarInvoiceMap.size() > 0) {
            HashMap<Long, DynamicObject> finArBillMap = new HashMap<Long, DynamicObject>(32);
            for (DynamicObject finArBill : finArBills) {
                finArBillMap.put(finArBill.getLong("id"), finArBill);
            }
            Map<Long, List<String>> contractInfoMap = this.getContractInfoMap(billIds);
            Map<String, String> invoiceTypeMap = this.getInvoiceTypeMap();
            ArrayList tarInvoiceIdList = new ArrayList(10);
            for (Map.Entry entry : tarInvoiceMap.entrySet()) {
                tarInvoiceIdList.addAll((Collection)entry.getValue());
            }
            DataSet vatinvoiceDataSet = QueryServiceHelper.queryDataSet((String)"querysim_vatinvoice", (String)"sim_vatinvoice", (String)"id,invoicecode,invoiceno,invoicetype,orderno", (QFilter[])new QFilter[]{new QFilter("id", "in", tarInvoiceIdList)}, (String)"");
            HashMap hashMap = new HashMap(tarInvoiceIdList.size());
            for (Row row : vatinvoiceDataSet) {
                HashMap<String, String> propMap = new HashMap<String, String>(4);
                propMap.put("invoicecode", row.getString("invoicecode"));
                propMap.put("invoiceno", row.getString("invoiceno"));
                propMap.put("serialno", row.getString("orderno"));
                propMap.put("invoicetype", row.getString("invoicetype"));
                hashMap.put(row.getLong("id"), propMap);
            }
            logger.info("vatinvoiceMap:" + hashMap);
            if (hashMap.isEmpty()) {
                return result;
            }
            for (Map.Entry<Long, List<Long>> entry : tarInvoiceMap.entrySet()) {
                Long billId = entry.getKey();
                DynamicObject finArBill = (DynamicObject)finArBillMap.get(billId);
                List<Long> vatinvoiceIds = entry.getValue();
                List<String> contractList = contractInfoMap.get(billId);
                ArrayList<JSONObject> invoiceJsonList = new ArrayList<JSONObject>(vatinvoiceIds.size());
                for (Long vatinvoiceId : vatinvoiceIds) {
                    String type;
                    String invoicetype;
                    Map propMap = (Map)hashMap.get(vatinvoiceId);
                    if (propMap == null || StringUtils.isEmpty(invoicetype = (String)propMap.get("invoicetype")) || (type = invoiceTypeMap.get(invoicetype)) == null) continue;
                    JSONObject invoiceJson = new JSONObject();
                    invoiceJson.put("tickettype", (Object)type);
                    invoiceJson.put("uniquecode", propMap.get("serialno"));
                    invoiceJson.put("contractnumber", (Object)(contractList == null || contractList.isEmpty() ? "" : String.join((CharSequence)",", contractList)));
                    invoiceJson.put("MatchingStateBetweenBusinessDocumentsAndVatEInvoice", (Object)(StringUtils.isEmpty((String)propMap.get("invoicecode")) || StringUtils.isEmpty((String)propMap.get("invoiceno")) ? "false" : "true"));
                    invoiceJson.put("fileurl", (Object)" ");
                    invoiceJson.put("billid", (Object)vatinvoiceId);
                    if ("inv_ord_receiver".equals(type) || "inv_spcl_receiver".equals(type) || "inv_tlf_receiver".equals(type)) {
                        invoiceJson.put("seqno", (Object)((String)propMap.get("invoicecode") + (String)propMap.get("invoiceno")));
                    } else {
                        invoiceJson.put("seqno", propMap.get("serialno"));
                    }
                    invoiceJson.put("batchcode", (Object)" ");
                    invoiceJson.put("org", (Object)finArBill.getLong("org.id"));
                    invoiceJson.put("costcompany", (Object)finArBill.getLong("org.id"));
                    invoiceJson.put("currency", (Object)finArBill.getLong("currency.id"));
                    invoiceJson.put("bookdate", (Object)finArBill.getDate("bookdate"));
                    invoiceJsonList.add(invoiceJson);
                }
                if (invoiceJsonList.isEmpty()) continue;
                result.put(billId, invoiceJsonList);
            }
        }
        logger.info("ArGetBizBillInfoNewImpl ar_getBizBillTicketList-result:" + result);
        return result;
    }

    private Map<Long, List<String>> getContractInfoMap(Set<Long> ids) {
        HashMap<Long, List<String>> contractInfoMap = new HashMap<Long, List<String>>(8);
        Map<Long, List<Long>> sourceBillMap = BOTPHelper.loadNearUpBillIds("ar_finarbill", "conm_salcontract", ids.toArray(new Long[0]));
        if (sourceBillMap != null && sourceBillMap.size() > 0) {
            ArrayList contractIdList = new ArrayList();
            for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                contractIdList.addAll(entry.getValue());
            }
            DataSet contractDatsSet = QueryServiceHelper.queryDataSet((String)"querycontract", (String)"conm_salcontract", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", contractIdList)}, (String)"");
            HashMap<Long, String> contractBillnoMap = new HashMap<Long, String>(contractIdList.size());
            for (Row row : contractDatsSet) {
                contractBillnoMap.put(row.getLong("id"), row.getString("billno"));
            }
            for (Map.Entry<Long, List<Long>> entry : sourceBillMap.entrySet()) {
                Long billId = entry.getKey();
                List<Long> contractBillIds = entry.getValue();
                ArrayList contractBillNos = new ArrayList(contractBillIds.size());
                for (Long contractBillId : contractBillIds) {
                    contractBillNos.add(contractBillnoMap.get(contractBillId));
                }
                contractInfoMap.put(billId, contractBillNos);
            }
        }
        logger.info("ar_contractInfoMap:" + contractInfoMap);
        return contractInfoMap;
    }

    private Map<String, String> getInvoiceTypeMap() {
        HashMap<String, String> invoiceTypeMap = new HashMap<String, String>(8);
        invoiceTypeMap.put("026", "inv_ord_receiver");
        invoiceTypeMap.put("028", "inv_spcl_receiver");
        invoiceTypeMap.put("TRAIN", "rai_receiver");
        invoiceTypeMap.put("PLANE", "atr_receiver");
        invoiceTypeMap.put("TOLL", "inv_tlf_receiver");
        return invoiceTypeMap;
    }
}

