/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;

public class BOTPConditionService {
    private MainEntityType entityType = null;
    private boolean isAllRowMatch = true;

    public BOTPConditionService(String entityName, boolean isAllRowMatch) {
        this.entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        this.isAllRowMatch = isAllRowMatch;
    }

    public boolean isMatch(DynamicObject bill, String condition_tag) {
        if (ObjectUtils.isEmpty((Object)bill) || ObjectUtils.isEmpty((Object)condition_tag)) {
            return true;
        }
        CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)condition_tag, CRCondition.class);
        boolean isFormMatch = true;
        boolean isExpressionMatch = true;
        FilterCondition condition = formula.getFilterCondition();
        if (condition != null && !ObjectUtils.isEmpty((Object)condition.getFilterRow())) {
            FilterBuilder filterBuilder = new FilterBuilder(this.entityType, condition);
            String[] script = filterBuilder.buildFilterScript();
            BOSExpression formulaExpr = new BOSExpression(script[0]);
            isFormMatch = this.isFormulaMatch(bill, formulaExpr.getExpr(), formulaExpr.getVars());
        }
        if (!isFormMatch) {
            return false;
        }
        String expression = formula.getExpression();
        if (!ObjectUtils.isEmpty((Object)expression)) {
            HashSet<String> expressionFields = new HashSet<String>(8);
            Expr expressionExpr = FormulaEngine.parseFormula((String)expression);
            String[] variables = FormulaEngine.extractVariables((String)expression);
            expressionFields.addAll(Arrays.asList(variables));
            isExpressionMatch = this.isFormulaMatch(bill, expressionExpr, expressionFields);
        }
        return isExpressionMatch;
    }

    public Set<String> getFormulaFieldsName(String condition_tag) {
        HashSet<String> selectors = new HashSet<String>(64);
        if (ObjectUtils.isEmpty((Object)condition_tag)) {
            return selectors;
        }
        CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)condition_tag, CRCondition.class);
        FilterCondition condition = formula.getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(this.entityType, condition);
        filterBuilder.buildFilter();
        String[] script = filterBuilder.buildFilterScript();
        BOSExpression formulaExpr = new BOSExpression(script[0]);
        selectors.addAll(formulaExpr.getVars());
        String expression = formula.getExpression();
        if (!ObjectUtils.isEmpty((Object)expression)) {
            String[] variables = FormulaEngine.extractVariables((String)expression);
            selectors.addAll(Arrays.asList(variables));
        }
        return selectors;
    }

    private boolean isFormulaMatch(DynamicObject bill, Expr expr, Set<String> fieldNames) {
        String entryName = null;
        for (String fieldName : fieldNames) {
            String parentName;
            String[] sp = fieldName.split("\\.");
            IDataEntityProperty property = this.entityType.findProperty(sp[0]);
            if (property == null || (parentName = property.getParent().getName()).equals(this.entityType.getName()) || entryName != null) continue;
            entryName = parentName;
        }
        FunctionTypes functionTypes = FunctionTypes.get();
        FunctionManage functionManage = FunctionManage.get((FunctionTypes)functionTypes);
        Map funcMap = functionManage.getFuncMap();
        UDFunction[] functions = (UDFunction[])funcMap.values().toArray(new BOSUDFunction[0]);
        if (entryName == null) {
            HashMap<String, Object> formulaValueMap = new HashMap<String, Object>(8);
            for (String fieldName : fieldNames) {
                String[] sp = fieldName.split("\\.");
                IDataEntityProperty property = this.entityType.findProperty(sp[0]);
                if (property == null) continue;
                formulaValueMap.put(fieldName, this.getFieldValue(property, bill, fieldName));
            }
            return (Boolean)FormulaEngine.execExcelFormula((Expr)expr, formulaValueMap, (UDFunction[])functions);
        }
        boolean isMatch = true;
        DynamicObjectCollection entryCollection = bill.getDynamicObjectCollection(entryName);
        for (DynamicObject entryRow : entryCollection) {
            HashMap<String, Object> formulaValueMap = new HashMap<String, Object>(8);
            for (String fieldName : fieldNames) {
                String[] sp = fieldName.split("\\.");
                IDataEntityProperty property = this.entityType.findProperty(sp[0]);
                if (property == null) continue;
                String parentName = property.getParent().getName();
                if (parentName.equals(this.entityType.getName())) {
                    formulaValueMap.put(fieldName, this.getFieldValue(property, bill, fieldName));
                    continue;
                }
                formulaValueMap.put(fieldName, this.getFieldValue(property, entryRow, fieldName));
            }
            boolean rowMatchResult = (Boolean)FormulaEngine.execExcelFormula((Expr)expr, formulaValueMap, (UDFunction[])functions);
            if (this.isAllRowMatch) {
                isMatch = isMatch && rowMatchResult;
                continue;
            }
            if (!rowMatchResult) continue;
            isMatch = true;
            break;
        }
        return isMatch;
    }

    private Object getFieldValue(IDataEntityProperty property, DynamicObject dynamicObject, String fieldName) {
        if (property instanceof MuliLangTextProp) {
            return dynamicObject.getLocaleString(fieldName).getLocaleValue();
        }
        return dynamicObject.get(fieldName);
    }
}

