/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.balance.BalanceBuilder;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

public class BalanceService {
    private String appName;

    public BalanceService(String appName) {
        this.appName = appName;
    }

    public boolean isAr() {
        return "ar".equals(this.appName);
    }

    public void deleteBalanceByInit(Long orgId) {
        if (this.isAr()) {
            DeleteServiceHelper.delete((String)"ar_balance", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        } else {
            DeleteServiceHelper.delete((String)"ap_newbalance", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        }
    }

    public void saveBalance(Long orgId, DynamicObject curperiod) {
        BalanceBuilder balanceCalculator = new BalanceBuilder(!this.isAr());
        List<DynamicObject> balanceObjs = balanceCalculator.buildBalance(orgId, curperiod);
        DecimalScopeValidator decimalScopeValidator = new DecimalScopeValidator();
        for (DynamicObject obj : balanceObjs) {
            decimalScopeValidator.validate(obj);
        }
        SaveServiceHelper.save((DynamicObject[])balanceObjs.toArray(new DynamicObject[0]));
    }

    public void saveBalance(Long orgId, Date startDate, Date stopDate) {
        BalanceBuilder balanceCalculator = new BalanceBuilder(!this.isAr());
        List<DynamicObject> balanceObjs = balanceCalculator.buildBalance(orgId, startDate, stopDate);
        DecimalScopeValidator decimalScopeValidator = new DecimalScopeValidator();
        for (DynamicObject obj : balanceObjs) {
            decimalScopeValidator.validate(obj);
        }
        SaveServiceHelper.save((DynamicObject[])balanceObjs.toArray(new DynamicObject[0]));
    }

    public void deleteBalanceByClose(Long orgId, Date stopDate) {
        QFilter dateFilter = new QFilter("stopdate", ">", (Object)DateUtils.getDataFormat(stopDate, false));
        if (this.isAr()) {
            DeleteServiceHelper.delete((String)"ar_balance", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), dateFilter});
        } else {
            DeleteServiceHelper.delete((String)"ap_newbalance", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), dateFilter});
        }
    }
}

