/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.factory.SettleServiceFactory;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.vo.UnSettleParam;

public class BillDeleteProcessSRService {
    private static final Log logger = LogFactory.getLog(BillDeleteProcessSRService.class);
    private static final String HAS_WRITEOFF = "has_writeoff";
    private static final String HAS_NOT_WRITEOFF = "has_no_writeoff";
    private static final String HAS_WRITEOFF_VOUCHER = "has_writeoff_voucher";

    public Map<Long, String> validateSettleRecordForDelete(String entity, List<Long> billIds) {
        logger.info("validateSettleRecordForDelete begin");
        HashMap<Long, String> validateMsgResult = new HashMap<Long, String>(4);
        if (ObjectUtils.isEmpty((Object)entity) || ObjectUtils.isEmpty(billIds)) {
            return validateMsgResult;
        }
        Object[] settleRecords = this.getSettleRecords(billIds);
        if (ObjectUtils.isEmpty((Object[])settleRecords)) {
            logger.info("validateSettleRecordForDelete settleRecords is null");
            return validateMsgResult;
        }
        HashMap billMap = new HashMap(billIds.size());
        for (Long l : billIds) {
            ArrayList<Object> values = (ArrayList<Object>)billMap.get(l);
            if (values == null) {
                values = new ArrayList<Object>(2);
            }
            block1: for (Object settleRecord2 : settleRecords) {
                long mainbillid = settleRecord2.getLong("mainbillid");
                if (mainbillid == l) {
                    values.add(settleRecord2);
                    continue;
                }
                DynamicObjectCollection entries = settleRecord2.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    long asstBillId = entry.getLong("billid");
                    if (asstBillId != l) continue;
                    values.add(settleRecord2);
                    continue block1;
                }
            }
            if (ObjectUtils.isEmpty(values)) continue;
            billMap.put(l, values);
        }
        for (Map.Entry entry : billMap.entrySet()) {
            Long billId = (Long)entry.getKey();
            List values = (List)entry.getValue();
            if (ObjectUtils.isEmpty((Object)values)) {
                validateMsgResult.put(billId, "");
            }
            ArrayList<DynamicObject> hasNotWriteOffList = new ArrayList<DynamicObject>(values.size());
            for (DynamicObject sr : values) {
                DynamicObjectCollection entryColl = sr.getDynamicObjectCollection("entry");
                boolean iswrittenoff = sr.getBoolean("iswrittenoff");
                boolean hadwrittenoff = sr.getBoolean("hadwrittenoff");
                for (DynamicObject srEntry : entryColl) {
                    if (!srEntry.getBoolean("e_hadwrittenoff")) continue;
                    hadwrittenoff = true;
                    break;
                }
                if (iswrittenoff || hadwrittenoff) continue;
                hasNotWriteOffList.add(sr);
            }
            if (!hasNotWriteOffList.isEmpty()) {
                validateMsgResult.put(billId, HAS_NOT_WRITEOFF);
                continue;
            }
            Optional<DynamicObject> hasWriteoffVoucher = values.stream().filter(settleRecord -> settleRecord.getBoolean("isvoucher")).findAny();
            if (hasWriteoffVoucher.isPresent()) {
                validateMsgResult.put(billId, HAS_WRITEOFF_VOUCHER);
                continue;
            }
            validateMsgResult.put(billId, HAS_WRITEOFF);
        }
        logger.info("validateSettleRecordForDelete validateMsgResult:" + validateMsgResult);
        return validateMsgResult;
    }

    public void billDeleteCompensate(String entity, List<Long> hasWriteoffIds, List<Long> billIds) {
        logger.info("billDeleteCompensate begin");
        if (!ObjectUtils.isEmpty(hasWriteoffIds)) {
            DynamicObject[] settleRecords = this.getSettleRecords(billIds);
            Map<String, List<DynamicObject>> map = SettleRecordOpHelper.classfySettleRecord(settleRecords);
            for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
                List<DynamicObject> value = entry.getValue();
                ArrayList<DynamicObject> wholeAndNeedDeleteRecords = new ArrayList<DynamicObject>(value.size());
                ArrayList<DynamicObject> partAndNeedDeleteRecords = new ArrayList<DynamicObject>(value.size());
                block1: for (DynamicObject sr : value) {
                    if (!sr.getBoolean("hadwrittenoff") && !sr.getBoolean("iswrittenoff")) {
                        DynamicObjectCollection entryColl = sr.getDynamicObjectCollection("entry");
                        for (DynamicObject srEntry : entryColl) {
                            if (!srEntry.getBoolean("e_hadwrittenoff")) continue;
                            partAndNeedDeleteRecords.add(sr);
                            continue block1;
                        }
                        continue;
                    }
                    wholeAndNeedDeleteRecords.add(sr);
                }
                if (!wholeAndNeedDeleteRecords.isEmpty()) {
                    SettleRecordOpHelper.deleteSettleRecord(wholeAndNeedDeleteRecords.toArray(new DynamicObject[0]));
                }
                if (partAndNeedDeleteRecords.isEmpty()) continue;
                this.resolvePartNeedDeleteRecord(partAndNeedDeleteRecords);
            }
            logger.info("billDeleteCompensate Compensatesettlerecord");
        }
        if (!ObjectUtils.isEmpty((Object)entity) && !ObjectUtils.isEmpty(billIds)) {
            logger.info("billDeleteCompensate Compensatejournal");
            JournalService journalService = new JournalService();
            journalService.deleteJournals(entity, billIds.toArray(new Long[0]));
        }
    }

    private void resolvePartNeedDeleteRecord(List<DynamicObject> partAndNeedDeleteRecords) {
        DynamicObjectCollection entries;
        if (partAndNeedDeleteRecords.size() == 0) {
            return;
        }
        logger.info("billDeleteCompensate.resolvePartNeedDeleteRecord partAndNeedDeleteRecords:" + partAndNeedDeleteRecords.size());
        ArrayList<DynamicObject> partRecordsTemp = new ArrayList<DynamicObject>(partAndNeedDeleteRecords.size());
        CloneUtils clone = new CloneUtils(false, false);
        for (DynamicObject settleRecord : partAndNeedDeleteRecords) {
            partRecordsTemp.add((DynamicObject)clone.clone((IDataEntityBase)settleRecord));
        }
        for (DynamicObject partRecord : partAndNeedDeleteRecords) {
            entries = partRecord.getDynamicObjectCollection("entry");
            entries.removeIf(entry -> !entry.getBoolean("e_hadwrittenoff"));
        }
        this.repairSettleRecordMainData(partAndNeedDeleteRecords);
        BillDeleteProcessSRService.invokeUnSettle(partAndNeedDeleteRecords);
        for (DynamicObject partRecord : partRecordsTemp) {
            entries = partRecord.getDynamicObjectCollection("entry");
            entries.removeIf(entry -> entry.getBoolean("e_hadwrittenoff"));
        }
        this.repairSettleRecordMainData(partRecordsTemp);
        SettleRecordOpHelper.updateSettleRecordsByPart(partRecordsTemp.toArray(new DynamicObject[0]));
    }

    private void repairSettleRecordMainData(List<DynamicObject> partAndNeedDeleteRecords) {
        for (DynamicObject partRecord : partAndNeedDeleteRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            BigDecimal tempSettleAmt = BigDecimal.ZERO;
            BigDecimal tempSettleLocalAmt = BigDecimal.ZERO;
            BigDecimal tempSwapL = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                tempSettleAmt = tempSettleAmt.add(entry.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry.getBigDecimal("e_swappl"));
            }
            partRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("totalsettleamt").signum())));
            partRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("localtotalsettleamt").signum())));
            partRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(partRecord.getBigDecimal("swappl").signum())));
        }
    }

    private static void invokeUnSettle(List<DynamicObject> settleRecords) {
        String key = settleRecords.get(0).getString("settlerelation");
        AbstractSettleTemplate service = SettleServiceFactory.getService(key);
        UnSettleParam unSettleParam = new UnSettleParam();
        unSettleParam.setUnSettleByListOP(false);
        unSettleParam.setRedSettleRecord(true);
        service.unSettle(settleRecords.toArray(new DynamicObject[0]), unSettleParam);
    }

    private DynamicObject[] getSettleRecords(List<Long> billIds) {
        String settleRecordSelector = CommonSettleServiceHelper.getSettleRecordSelector();
        Object[] mains = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleRecordSelector, (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", billIds)});
        Object[] assts = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleRecordSelector, (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", billIds)});
        DynamicObject[] settleRecords = (DynamicObject[])ArrayUtils.addAll((Object[])mains, (Object[])assts);
        return settleRecords;
    }
}

