/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.WriteOffBillWriteBackService;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusBillWriteBackFromFinBillAuditService
implements WriteOffBillWriteBackService {
    @Override
    public void writeBack(List<DynamicObject> billList, boolean arBill) {
        String busBillEntityName = arBill ? "ar_busbill" : "ap_busbill";
        List<DynamicObject> adjustBusBillList = this.rebuildAdjustBusBillList(billList, busBillEntityName);
        if (EmptyUtils.isEmpty(adjustBusBillList)) {
            return;
        }
        List<DynamicObject> subAdjustBusBillList = this.generatePushAdjustBusBillList(billList, adjustBusBillList, busBillEntityName, arBill);
        OperationServiceHelper.executeOperate((String)"save", (String)busBillEntityName, (DynamicObject[])subAdjustBusBillList.toArray(new DynamicObject[subAdjustBusBillList.size()]), (OperateOption)OperateOption.create());
        subAdjustBusBillList.stream().forEach(entity -> {
            entity.set("isselfwoff", (Object)Boolean.FALSE);
            entity.set("billstatus", (Object)"C");
        });
        SaveServiceHelper.update((DynamicObject[])adjustBusBillList.toArray(new DynamicObject[adjustBusBillList.size()]));
        DynamicObject[] subAdjustBusBillArray = subAdjustBusBillList.toArray(new DynamicObject[subAdjustBusBillList.size()]);
        SaveServiceHelper.update((DynamicObject[])subAdjustBusBillArray);
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(subAdjustBusBillArray);
    }

    private Map<Long, Long> getAdjustBusBillIdTofinBillIdMap(List<DynamicObject> billList, List<DynamicObject> adjustBusBillList) {
        HashMap adjustBusBillIdToSrcFinBillIdMap = new HashMap(16);
        adjustBusBillList.stream().forEach(entity -> adjustBusBillIdToSrcFinBillIdMap.put(entity.getLong("id"), entity.getLong("srcfinbillid")));
        HashMap sourceBillIdToFinBillIdMap = new HashMap(16);
        billList.stream().forEach(entity -> sourceBillIdToFinBillIdMap.put(entity.getLong("sourcebillid"), entity.getLong("id")));
        HashMap<Long, Long> adjustBusBillIdTofinBillIdMap = new HashMap<Long, Long>(16);
        adjustBusBillIdToSrcFinBillIdMap.keySet().stream().forEach(key -> {
            long srcFinBillId = (Long)adjustBusBillIdToSrcFinBillIdMap.get(key);
            long finBillId = (Long)sourceBillIdToFinBillIdMap.get(srcFinBillId);
            adjustBusBillIdTofinBillIdMap.put((Long)key, finBillId);
        });
        return adjustBusBillIdTofinBillIdMap;
    }

    private List<DynamicObject> generatePushAdjustBusBillList(List<DynamicObject> billList, List<DynamicObject> adjustBusBillList, String adjustEntityName, boolean arBill) {
        List<Long> busBillIds = adjustBusBillList.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        String ruleId = arBill ? "697561685841434624" : "712748085842822144";
        List<DynamicObject> subWriteOffBusBillList = BOTPHelper.push(adjustEntityName, adjustEntityName, ruleId, busBillIds);
        Map<Long, Long> adjustBusBillIdTofinBillIdMap = this.getAdjustBusBillIdTofinBillIdMap(billList, adjustBusBillList);
        HashMap busBillIdToAdjustBusBillMap = new HashMap(16);
        adjustBusBillList.stream().forEach(entity -> {
            String billNo = entity.getString("billno");
            busBillIdToAdjustBusBillMap.put(entity.getLong("id"), String.format(ResManager.loadKDString((String)"\u51b2\u9500%s", (String)"BusBillWriteBackFromFinBillAuditService_0", (String)"fi-arapcommon", (Object[])new Object[0]), billNo));
        });
        Map writeOffBillIdMap = billList.stream().collect(Collectors.toMap(entity -> entity.getLong("id"), Function.identity()));
        subWriteOffBusBillList.stream().forEach(entity -> {
            entity.set("isselfwoff", (Object)Boolean.TRUE);
            long sourceBillId = entity.getLong("sourcebillid");
            long srcFinBillId = adjustBusBillIdTofinBillIdMap.getOrDefault(sourceBillId, 0L);
            if (srcFinBillId > 0L) {
                entity.set("srcfinbillid", (Object)srcFinBillId);
                entity.set("writeoffbusiness", (Object)Boolean.TRUE);
                entity.set("remark", busBillIdToAdjustBusBillMap.get(sourceBillId));
                Date date = EmptyUtils.isEmpty(writeOffBillIdMap.get(srcFinBillId)) ? entity.getDate("bizdate") : ((DynamicObject)writeOffBillIdMap.get(srcFinBillId)).getDate("bizdate");
                entity.set("bizdate", (Object)date);
            }
        });
        return subWriteOffBusBillList;
    }

    private List<DynamicObject> rebuildAdjustBusBillList(List<DynamicObject> billList, String busBillEntityName) {
        List<DynamicObject> adjustBusBillList = this.listAdjustBusBillByFinBill(billList, busBillEntityName);
        adjustBusBillList.stream().forEach(entity -> {
            entity.set("writeoffbusiness", (Object)Boolean.TRUE);
            entity.getDynamicObjectCollection("entry").stream().forEach(rowEntity -> rowEntity.set("e_iswriteoff", (Object)Boolean.TRUE));
        });
        return adjustBusBillList;
    }

    private List<DynamicObject> listAdjustBusBillByFinBill(List<DynamicObject> billList, String busBillEntityName) {
        List finBillIds = billList.stream().map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toList());
        return Arrays.asList(BusinessDataServiceHelper.load((String)busBillEntityName, (String)"id,billno,srcfinbillid,writeoffbusiness,entry.e_iswriteoff", (QFilter[])new QFilter("srcfinbillid", "in", finBillIds).and(new QFilter("isadjust", "=", (Object)Boolean.TRUE)).toArray()));
    }
}

