/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.WriteBackBillQueryHelper;
import kd.fi.arapcommon.helper.WriteOffBillWriteBackHelper;
import kd.fi.arapcommon.service.WriteOffBillWriteBackService;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusBillWriteBackFromFinBillSaveService
implements WriteOffBillWriteBackService {
    @Override
    public void writeBack(List<DynamicObject> billList, boolean arBill) {
        ArrayList<DynamicObject> updateBusBillList = new ArrayList<DynamicObject>(16);
        List<DynamicObject> sameSourceAdjustBusBillList = WriteBackBillQueryHelper.listSameSourceAdjustBusBill(billList, arBill);
        if (EmptyUtils.isEmpty(sameSourceAdjustBusBillList)) {
            return;
        }
        Map<Long, DynamicObject> sourceBusBillIdMap = WriteBackBillQueryHelper.getSourceBusBillIdMap(sameSourceAdjustBusBillList, arBill);
        List<Long> sourceFinBillIds = sameSourceAdjustBusBillList.stream().map(entity -> entity.getLong("srcfinbillid")).collect(Collectors.toList());
        Map<Long, DynamicObject> sourceFinBillIdMap = WriteBackBillQueryHelper.getSourceFinBillIdMap(sourceFinBillIds, arBill);
        for (DynamicObject busBill : sameSourceAdjustBusBillList) {
            long sourceBillId = busBill.getLong("sourcebillid");
            DynamicObject sourceBusBill = sourceBusBillIdMap.get(sourceBillId);
            DynamicObject sourceFinBill = sourceFinBillIdMap.get(busBill.getLong("srcfinbillid"));
            if (EmptyUtils.isEmpty(sourceBusBill) || EmptyUtils.isEmpty(sourceFinBill)) continue;
            this.resetBusBillDetailEntry(busBill, sourceFinBill, sourceBusBill, arBill);
            WriteOffBillWriteBackHelper.resetHeadAmt(sourceBusBill);
            updateBusBillList.add(sourceBusBill);
        }
        SaveServiceHelper.update((DynamicObject[])updateBusBillList.toArray(new DynamicObject[0]));
    }

    private void resetBusBillDetailEntry(DynamicObject adjustBusBill, DynamicObject sourceFinBill, DynamicObject writeBackBusBill, boolean arBill) {
        Map<Long, DynamicObject> busBillDetailEntryIdMap = this.getBusBillDetailEntryIdMap(writeBackBusBill);
        Map writeOffBillDetailEntryIdMap = sourceFinBill.getDynamicObjectCollection(arBill ? "entry" : "detailentry").stream().collect(Collectors.toMap(entity -> entity.getLong("id"), Function.identity()));
        Map<Long, Long> writeOffDetailEntryIdMap = WriteBackBillQueryHelper.getBusBillToFinBillDetailEntryIdMap(sourceFinBill, writeBackBusBill);
        Map<String, String> busBillPropertyMap = WriteOffBillWriteBackHelper.getBusBillPropertyMap(arBill);
        Map<String, String> finBillPropertyMap = WriteOffBillWriteBackHelper.getFinBillPropertyMap(arBill);
        DynamicObject payProperty = adjustBusBill.getDynamicObject("payproperty");
        for (DynamicObject row : adjustBusBill.getDynamicObjectCollection("entry")) {
            long sourceEntryId = row.getLong("e_srcentryid");
            DynamicObject writeOffBackBillDetailEntry = (DynamicObject)writeOffBillDetailEntryIdMap.get(writeOffDetailEntryIdMap.get(sourceEntryId));
            if (EmptyUtils.isEmpty(busBillDetailEntryIdMap.get(sourceEntryId)) || EmptyUtils.isEmpty(writeOffBackBillDetailEntry)) continue;
            DynamicObject busBillRow = busBillDetailEntryIdMap.get(sourceEntryId);
            this.propertyAmtWriteBack(writeOffBackBillDetailEntry, finBillPropertyMap.get("e_recAmt"), busBillRow, "e_invoicedamt", true);
            this.propertyAmtWriteBack(writeOffBackBillDetailEntry, finBillPropertyMap.get("e_recLocalAmt"), busBillRow, "e_invoicedlocamt", true);
            busBillRow.set("e_iswriteoff", (Object)Boolean.FALSE);
            BigDecimal recAmount = busBillRow.getBigDecimal(busBillPropertyMap.get("e_recAmt"));
            BigDecimal invoiceAmt = busBillRow.getBigDecimal("e_invoicedamt");
            BigDecimal recLocalAmt = busBillRow.getBigDecimal(busBillPropertyMap.get("e_recLocalAmt"));
            BigDecimal invoiceLocalAmt = busBillRow.getBigDecimal("e_invoicedlocamt");
            busBillRow.set("e_uninvoicedamt", (Object)recAmount.subtract(invoiceAmt));
            busBillRow.set("e_uninvoicedlocamt", (Object)recLocalAmt.subtract(invoiceLocalAmt));
            boolean baseOnAmt = payProperty.getBoolean("isbasedonamt");
            boolean present = busBillRow.getBoolean("e_ispresent");
            if (!present && baseOnAmt) {
                busBillRow.set("e_invoicedqty", (Object)WriteOffBillWriteBackHelper.getInvoiceQty(busBillRow, arBill));
            }
            if (present && baseOnAmt) {
                busBillRow.set("e_invoicedqty", (Object)BigDecimal.ZERO);
            }
            if (!baseOnAmt) {
                this.propertyAmtWriteBack(writeOffBackBillDetailEntry, finBillPropertyMap.get("e_quantity"), busBillRow, "e_invoicedqty", true);
            }
            BigDecimal quantity = busBillRow.getBigDecimal("e_quantity");
            BigDecimal invoiceQuantity = busBillRow.getBigDecimal("e_invoicedqty");
            busBillRow.set("e_uninvoicedqty", (Object)quantity.subtract(invoiceQuantity));
            if (!present && baseOnAmt) {
                busBillRow.set("e_unwoffqty", (Object)quantity.subtract(WriteOffBillWriteBackHelper.getInvoiceQty(busBillRow, arBill)));
            }
            if (present && baseOnAmt) {
                busBillRow.set("e_unwoffqty", (Object)quantity);
            }
            if (!baseOnAmt) {
                this.propertyAmtWriteBack(row, "e_unwoffqty", busBillRow, "e_unwoffqty", true);
            }
            this.propertyAmtWriteBack(row, "e_unwoffamt", busBillRow, "e_unwoffamt", true);
            this.propertyAmtWriteBack(row, "e_unwofflocamt", busBillRow, "e_unwofflocamt", true);
        }
    }

    private Map<Long, DynamicObject> getBusBillDetailEntryIdMap(DynamicObject writeBackBusBill) {
        DynamicObjectCollection entryCollection = writeBackBusBill.getDynamicObjectCollection("entry");
        return entryCollection.stream().collect(Collectors.toMap(row -> row.getLong("id"), Function.identity()));
    }

    private void propertyAmtWriteBack(DynamicObject source, String sourceProperty, DynamicObject target, String targetProperty, boolean reverse) {
        BigDecimal sourceAmt = reverse ? source.getBigDecimal(sourceProperty).negate() : source.getBigDecimal(sourceProperty);
        BigDecimal targetAmt = target.getBigDecimal(targetProperty);
        BigDecimal result = targetAmt.add(sourceAmt);
        target.set(targetProperty, (Object)result);
    }
}

