/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.util.DateUtils;

public class CloseRecordService {
    private String entityKey;
    private String balanceKey;

    public CloseRecordService(String appName) {
        this("ap".equals(appName));
    }

    public CloseRecordService(boolean isAp) {
        if (isAp) {
            this.entityKey = "ap_closerecord";
            this.balanceKey = "ap_newbalance";
        } else {
            this.entityKey = "ar_closerecord";
            this.balanceKey = "ar_balance";
        }
    }

    public void saveCloseRecord(Long orgId, Date closeDate) {
        this.checkRepCloseRecord(orgId, closeDate);
        DynamicObject closeRecord = BusinessDataServiceHelper.newDynamicObject((String)this.entityKey);
        closeRecord.set("org", (Object)orgId);
        closeRecord.set("closedate", (Object)closeDate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{closeRecord});
    }

    private void checkRepCloseRecord(Long orgId, Date closeDate) {
        DynamicObjectCollection closeRecords = QueryServiceHelper.query((String)this.entityKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("closedate", "=", (Object)closeDate)});
        List closeIds = closeRecords.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        DeleteServiceHelper.delete((String)this.balanceKey, (QFilter[])new QFilter[]{new QFilter("closeid", "in", closeIds)});
        DeleteServiceHelper.delete((String)this.entityKey, (QFilter[])new QFilter[]{new QFilter("id", "in", closeIds)});
    }

    public void deleteCloseRecordByAntiInit(Long orgId) {
        DeleteServiceHelper.delete((String)this.entityKey, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
    }

    public void deleteCloseRecordByAntiClose(Long orgId, Date closeDate) {
        Date standardCloseDate = DateUtils.getDataFormat(closeDate, false);
        QFilter filters = new QFilter("org", "=", (Object)orgId);
        filters.and("closedate", ">", (Object)standardCloseDate);
        DeleteServiceHelper.delete((String)this.entityKey, (QFilter[])new QFilter[]{filters});
    }

    public DynamicObject queryCloseRecord(Long orgId, Date closeDate) {
        if (closeDate == null) {
            return null;
        }
        Date standardCloseDate = DateUtils.getDataFormat(closeDate, false);
        QFilter filters = new QFilter("org", "=", (Object)orgId);
        filters.and("closedate", "<=", (Object)standardCloseDate);
        DynamicObject[] closeRecords = BusinessDataServiceHelper.load((String)this.entityKey, (String)"id,org,closedate", (QFilter[])new QFilter[]{filters}, (String)"closeDate desc", (int)1);
        if (closeRecords.length > 0) {
            return closeRecords[0];
        }
        return null;
    }

    public DynamicObject queryLastestCloseRecord(Long orgId) {
        QFilter filters = new QFilter("org", "=", (Object)orgId);
        DynamicObject[] closeRecords = BusinessDataServiceHelper.load((String)this.entityKey, (String)"id,org,closedate", (QFilter[])new QFilter[]{filters}, (String)"closeDate desc", (int)1);
        if (closeRecords.length > 0) {
            return closeRecords[0];
        }
        return null;
    }
}

