/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DimensionJoiner {
    private static final String DIMENSION_PREIX = "dimensionPrefix";
    private final List<String[]> dimensionValues = new ArrayList<String[]>(8);

    public void addDimensionValue(String[] aDimensionValue) {
        this.dimensionValues.add(aDimensionValue);
    }

    public List<String> join() {
        ArrayList<StringBuilder> resultSBList = new ArrayList<StringBuilder>(8);
        if (this.dimensionValues.size() == 0) {
            resultSBList.add(new StringBuilder(DIMENSION_PREIX));
        } else {
            ArrayList<StringBuilder> remainSBList = new ArrayList<StringBuilder>(8);
            for (String[] dimensionValue : this.dimensionValues) {
                if (remainSBList.size() == 0) {
                    for (String splitValue : dimensionValue) {
                        resultSBList.add(new StringBuilder(DIMENSION_PREIX).append(splitValue));
                    }
                } else {
                    resultSBList.clear();
                    for (StringBuilder remainSB : remainSBList) {
                        for (String splitValue : dimensionValue) {
                            resultSBList.add(new StringBuilder(remainSB).append(splitValue));
                        }
                    }
                    remainSBList.clear();
                }
                remainSBList.addAll(resultSBList);
            }
            remainSBList.clear();
        }
        return resultSBList.stream().map(StringBuilder::toString).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        DimensionJoiner.dataTest();
    }

    private static void dataTest() {
        DimensionJoiner joiner = new DimensionJoiner();
        joiner.addDimensionValue(new String[]{"A"});
        DimensionJoiner.print(joiner, "1");
        DimensionJoiner joiner1_1 = new DimensionJoiner();
        joiner1_1.addDimensionValue(new String[]{"A"});
        joiner1_1.addDimensionValue(new String[]{"B"});
        DimensionJoiner.print(joiner1_1, "1-1");
        DimensionJoiner joiner1_2 = new DimensionJoiner();
        joiner1_2.addDimensionValue(new String[]{"A"});
        joiner1_2.addDimensionValue(new String[]{"B1", "B2"});
        DimensionJoiner.print(joiner1_2, "1-2");
        DimensionJoiner joiner2_1 = new DimensionJoiner();
        joiner2_1.addDimensionValue(new String[]{"A1", "A2"});
        joiner2_1.addDimensionValue(new String[]{"B1"});
        DimensionJoiner.print(joiner2_1, "2-1");
        DimensionJoiner joiner2_2 = new DimensionJoiner();
        joiner2_2.addDimensionValue(new String[]{"A1", "A2"});
        joiner2_2.addDimensionValue(new String[]{"B1", "B2"});
        DimensionJoiner.print(joiner2_2, "2-2");
        DimensionJoiner joiner1_2_2 = new DimensionJoiner();
        joiner1_2_2.addDimensionValue(new String[]{"A1"});
        joiner1_2_2.addDimensionValue(new String[]{"B1", "B2"});
        joiner1_2_2.addDimensionValue(new String[]{"C1", "C2"});
        DimensionJoiner.print(joiner1_2_2, "1-2-2");
        DimensionJoiner joiner2_1_2 = new DimensionJoiner();
        joiner2_1_2.addDimensionValue(new String[]{"A1", "A2"});
        joiner2_1_2.addDimensionValue(new String[]{"B1"});
        joiner2_1_2.addDimensionValue(new String[]{"C1", "C2"});
        DimensionJoiner.print(joiner2_1_2, "2-1-2");
        DimensionJoiner joiner2_2_2 = new DimensionJoiner();
        joiner2_2_2.addDimensionValue(new String[]{"A1", "A2"});
        joiner2_2_2.addDimensionValue(new String[]{"B1", "B2"});
        joiner2_2_2.addDimensionValue(new String[]{"C1", "C2"});
        DimensionJoiner.print(joiner2_2_2, "2-2-2");
        System.out.println("begin");
        long begin = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            DimensionJoiner join2_2_2 = new DimensionJoiner();
            join2_2_2.addDimensionValue(new String[]{"A1", "A2"});
            join2_2_2.addDimensionValue(new String[]{"B1", "B2"});
            join2_2_2.addDimensionValue(new String[]{"C1", "C2"});
            join2_2_2.join();
        }
        long end = System.currentTimeMillis();
        System.out.println("time ms:" + (end - begin));
    }

    private static void print(DimensionJoiner joiner, String joinName) {
        List<String> result = joiner.join();
        System.out.println(joinName + ":" + result);
    }
}

