/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.vo.ProRateDisPram;

public class DiscountRateService {
    public Map<Integer, BigDecimal> apportAmtByRatio(ProRateDisPram proRateDisPram) {
        BigDecimal discountAmt = proRateDisPram.getDiscountTotalAmt();
        BigDecimal totalAmt = proRateDisPram.getBillTotalAmt();
        String moleAmtFiled = proRateDisPram.getEntryTotalAmtFiled();
        DynamicObjectCollection entrys = proRateDisPram.getEntrys();
        int scale = proRateDisPram.getAmtScale();
        BigDecimal discountTotalAmt = BigDecimal.ZERO;
        HashMap<Integer, BigDecimal> discountMapBySeq = new HashMap<Integer, BigDecimal>(16);
        int presentLastRow = 0;
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            BigDecimal e_pricetaxtotal = entry.getBigDecimal(moleAmtFiled);
            if (e_pricetaxtotal.compareTo(BigDecimal.ZERO) == 0 || totalAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            presentLastRow = i;
            BigDecimal proportion = e_pricetaxtotal.divide(totalAmt, 10, RoundingMode.DOWN);
            BigDecimal entryDiscountAmt = discountAmt.multiply(proportion).setScale(scale, RoundingMode.DOWN);
            discountMapBySeq.put(entry.getInt("seq"), entryDiscountAmt);
            discountTotalAmt = discountTotalAmt.add(entryDiscountAmt);
        }
        BigDecimal balanceAmt = discountAmt.subtract(discountTotalAmt);
        for (int i = presentLastRow; i >= 0; --i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            BigDecimal entryPricetaxTotal = entry.getBigDecimal(moleAmtFiled);
            BigDecimal entryDisAmt = (BigDecimal)discountMapBySeq.get(entry.getInt("seq"));
            if (entryDisAmt == null) continue;
            BigDecimal balaceRowAmt = entryDisAmt.add(balanceAmt);
            if (entryPricetaxTotal.compareTo(BigDecimal.ZERO) == 0 || totalAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            if (balanceAmt.compareTo(BigDecimal.ZERO) == 0) break;
            if (balaceRowAmt.abs().compareTo(entryPricetaxTotal.abs()) >= 0) {
                balanceAmt = balanceAmt.subtract(entryPricetaxTotal.subtract(entryDisAmt));
                discountMapBySeq.put(entry.getInt("seq"), entryPricetaxTotal);
                continue;
            }
            BigDecimal lastRowCountAmt = entryDisAmt.add(balanceAmt);
            discountMapBySeq.put(entry.getInt("seq"), lastRowCountAmt);
            break;
        }
        return discountMapBySeq;
    }
}

