/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EditInBulkService {
    private static String editsettingsinbulk = "ar_editsettingsinbulk";
    private static String editinbulk = "ar_editinbulk";
    protected IFormView view;
    protected IFormView parentView;
    protected String pluginName;
    protected String parentEntityId;
    protected DynamicObjectCollection parentEntrys;
    protected Map<String, String> entryDescriptionMap;
    protected Map<String, DynamicObject> entryMap;
    protected Map<String, List<Integer>> srcEntryRowMap;
    protected long userId;
    protected boolean isFinAp = false;
    protected boolean isBusAp = false;

    private void EditInBulkServiceCommon() {
        this.parentEntityId = this.parentView.getEntityId();
        this.isFinAp = "ap_finapbill".equals(this.parentEntityId);
        this.isBusAp = "ap_busbill".equals(this.parentEntityId);
        editsettingsinbulk = this.isFinAp || this.isBusAp ? "ap_editsettingsinbulk" : "ar_editsettingsinbulk";
        String entryKey = "entry";
        if (this.isFinAp) {
            entryKey = "detailentry";
        }
        this.parentEntrys = this.parentView.getModel().getEntryEntity(entryKey);
        this.entryDescriptionMap = new HashMap<String, String>();
        this.entryMap = new HashMap<String, DynamicObject>();
        this.srcEntryRowMap = new HashMap<String, List<Integer>>();
        this.userId = RequestContext.get().getCurrUserId();
    }

    public EditInBulkService(IFormView parentView, String pluginName) {
        this.parentView = parentView;
        this.pluginName = pluginName;
        this.EditInBulkServiceCommon();
    }

    public EditInBulkService(IFormView view) {
        this.view = view;
        this.parentView = view.getParentView();
        this.EditInBulkServiceCommon();
    }

    public void showEditSettingsInBulk() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(editsettingsinbulk);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter lfp = new ListFilterParameter();
        QFilter statusQF = new QFilter("status", "=", (Object)"C");
        QFilter creatorQF = new QFilter("creator", "=", (Object)this.userId);
        lfp.setFilter(statusQF.and(creatorQF));
        lsp.setListFilterParameter(lfp);
        this.parentView.showForm((FormShowParameter)lsp);
    }

    public void showEditInBulk() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(editinbulk);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(this.pluginName, "editinbulk");
        fsp.setCloseCallBack(closeCallBack);
        this.parentView.showForm(fsp);
    }

    private List<String> getGroupKeys() {
        ArrayList<String> groupKeys = new ArrayList<String>();
        groupKeys.add("e_material");
        groupKeys.add("e_measureunit");
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)editsettingsinbulk, (String)"id,entryentity.groupby", (QFilter[])new QFilter[]{new QFilter("isdefault", "=", (Object)"1"), new QFilter("creator", "=", (Object)this.userId)});
        for (DynamicObject entry : entrys) {
            String groupby = entry.getString("entryentity.groupby");
            if (ObjectUtils.isEmpty((Object)groupby)) continue;
            groupKeys.add(groupby);
        }
        return groupKeys;
    }

    private String getKeys(List<String> groupKeys, Map<String, LocaleString> groupNames, DynamicObject parentEntry) {
        StringBuilder keyBuffer = new StringBuilder();
        StringBuffer descriptionBuffer = new StringBuffer();
        Iterator<String> iterator = groupKeys.iterator();
        while (iterator.hasNext()) {
            String groupKey;
            String key = groupKey = iterator.next();
            if (this.isFinAp) {
                if ("e_material".equals(groupKey) || "e_measureunit".equals(groupKey) || "e_spectype".equals(groupKey)) {
                    key = groupKey.substring(2, groupKey.length());
                } else if ("e_taxunitprice".equals(groupKey)) {
                    key = "pricetax";
                }
            }
            Object groupValue = null;
            try {
                groupValue = parentEntry.get(key);
            }
            catch (Exception e) {
                this.parentView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6279\u91cf\u8c03\u4ef7\u914d\u7f6e\u6269\u5c55\u5c5e\u6027\uff1a%s", (String)"EditInBulkService_0", (String)"fi-arapcommon", (Object[])new Object[0]), e.getMessage()));
                this.view.close();
                return null;
            }
            if (groupValue instanceof DynamicObject) {
                DynamicObject groupDy = (DynamicObject)groupValue;
                if ("001".equals(groupDy.getDataEntityType().getExtendName())) {
                    keyBuffer.append(groupDy.get("id"));
                } else {
                    keyBuffer.append(groupDy.getString("number"));
                }
            } else {
                keyBuffer.append(groupValue);
            }
            keyBuffer.append('/');
            if (ObjectUtils.isEmpty((Object)groupValue)) continue;
            LocaleString groupName = groupNames.get(key);
            if (ObjectUtils.isEmpty((Object)groupName)) {
                groupName = ((IDataEntityProperty)parentEntry.getDataEntityType().getProperties().get((Object)key)).getDisplayName();
                groupNames.put(key, groupName);
            }
            this.getDescriptions(groupKey, groupName, groupValue, descriptionBuffer);
        }
        String key = keyBuffer.toString();
        if (descriptionBuffer.length() > 0) {
            this.entryDescriptionMap.put(key, descriptionBuffer.substring(0, descriptionBuffer.length() - 1));
        }
        return key;
    }

    private void getDescriptions(String groupKey, LocaleString groupName, Object groupValue, StringBuffer descriptionBuffer) {
        if (!("e_material".equals(groupKey) || "material".equals(groupKey) || "e_measureunit".equals(groupKey) || "measureunit".equals(groupKey) || "e_materialversion".equals(groupKey) || "e_spectype".equals(groupKey) || "spectype".equals(groupKey) || "e_assistantattr".equals(groupKey) || "e_taxunitprice".equals(groupKey) || "pricetax".equals(groupKey))) {
            descriptionBuffer.append(groupName).append(':');
            if (groupValue instanceof DynamicObject) {
                DynamicObject groupDy = (DynamicObject)groupValue;
                if ("001".equals(groupDy.getDataEntityType().getExtendName())) {
                    descriptionBuffer.append(groupDy.get("id"));
                } else {
                    descriptionBuffer.append(groupDy.getLocaleString("name"));
                }
            } else if (groupValue instanceof Date) {
                String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(groupValue);
                descriptionBuffer.append(dateStr);
            } else {
                descriptionBuffer.append(groupValue);
            }
            descriptionBuffer.append('/');
        }
    }

    public Map<String, List<Integer>> prepareData() {
        if (ObjectUtils.isEmpty((Object)this.parentEntrys)) {
            return null;
        }
        List<String> groupKeys = this.getGroupKeys();
        HashMap<String, LocaleString> groupNames = new HashMap<String, LocaleString>();
        for (int row = this.parentEntrys.size() - 1; row > -1; --row) {
            DynamicObject parentEntry = (DynamicObject)this.parentEntrys.get(row);
            if (parentEntry.getBoolean(this.isFinAp ? "ispresent" : "e_ispresent")) continue;
            String key = this.getKeys(groupKeys, groupNames, parentEntry);
            if (ObjectUtils.isEmpty((Object)key)) {
                return null;
            }
            DynamicObject entry = parentEntry;
            if (this.entryMap.get(key) != null) {
                DynamicObject sumEntry = this.entryMap.get(key);
                entry.set("e_tax", (Object)entry.getBigDecimal("e_tax").add(sumEntry.getBigDecimal("e_tax")));
                entry.set("e_amount", (Object)entry.getBigDecimal("e_amount").add(sumEntry.getBigDecimal("e_amount")));
                String quantityKey = "e_quantity";
                String pricetaxtotalKey = "e_recamount";
                if (this.isFinAp) {
                    quantityKey = "quantity";
                    pricetaxtotalKey = "e_pricetaxtotal";
                }
                if (this.isBusAp) {
                    pricetaxtotalKey = "e_pricetaxtotal";
                }
                entry.set(quantityKey, (Object)entry.getBigDecimal(quantityKey).add(sumEntry.getBigDecimal(quantityKey)));
                entry.set(pricetaxtotalKey, (Object)entry.getBigDecimal(pricetaxtotalKey).add(sumEntry.getBigDecimal(pricetaxtotalKey)));
            }
            this.entryMap.put(key, entry);
            List<Integer> srcEntryRowList = new ArrayList<Integer>();
            if (this.srcEntryRowMap.get(key) != null) {
                srcEntryRowList = this.srcEntryRowMap.get(key);
            }
            srcEntryRowList.add(row);
            this.srcEntryRowMap.put(key, srcEntryRowList);
        }
        return this.srcEntryRowMap;
    }

    public void fillentry() {
        if (this.entryMap.size() < 1) {
            return;
        }
        IDataModel parentModel = this.parentView.getModel();
        IDataModel model = this.view.getModel();
        model.setValue("org", parentModel.getValue("org"));
        model.setValue("bizdate", parentModel.getValue("bizdate"));
        model.setValue("currency", parentModel.getValue("currency"));
        model.setValue("isincludetax", parentModel.getValue("isincludetax"));
        model.batchCreateNewEntryRow("entryentity", this.entryMap.size());
        int row = 0;
        for (Map.Entry<String, DynamicObject> mapentry : this.entryMap.entrySet()) {
            String key = mapentry.getKey();
            DynamicObject entry = mapentry.getValue();
            model.setValue("e_material", (Object)entry.getDynamicObject(this.isFinAp ? "material" : "e_material"), row);
            model.setValue("e_measureunit", (Object)entry.getDynamicObject(this.isFinAp ? "measureunit" : "e_measureunit"), row);
            model.setValue("e_materialversion", (Object)entry.getDynamicObject("e_materialversion"), row);
            model.setValue("e_spectype", (Object)entry.getString(this.isFinAp ? "spectype" : "e_spectype"), row);
            model.setValue("e_assistantattr", (Object)entry.getDynamicObject("e_assistantattr"), row);
            model.setValue("e_key", (Object)key, row);
            model.setValue("e_description", (Object)this.entryDescriptionMap.get(key), row);
            model.setValue("e_quantity", (Object)entry.getBigDecimal(this.isFinAp ? "quantity" : "e_quantity"), row);
            model.setValue("e_taxrateid", (Object)entry.getDynamicObject("taxrateid"), row);
            model.setValue("e_taxrate", (Object)entry.getBigDecimal(this.isFinAp ? "taxrate" : "e_taxrate"), row);
            String discountMode = entry.getString(this.isFinAp ? "discountmode" : "e_discountmode");
            if ("TOTAL".equals(discountMode)) {
                model.setValue("e_discountmode", (Object)"NULL", row);
            } else {
                model.setValue("e_discountmode", (Object)discountMode, row);
            }
            model.setValue("e_discountrate", (Object)entry.getBigDecimal(this.isFinAp ? "discountrate" : "e_discountrate"), row);
            model.setValue("e_amount", (Object)entry.getBigDecimal("e_amount"), row);
            model.setValue("e_tax", (Object)entry.getBigDecimal("e_tax"), row);
            model.setValue("e_pricetaxtotal", (Object)entry.getBigDecimal(this.isFinAp || this.isBusAp ? "e_pricetaxtotal" : "e_recamount"), row);
            ++row;
        }
    }

    public void returnFillParent(DynamicObjectCollection returnEntrys, Map<String, List<Integer>> srcEntryRowMap) {
        for (int row = 0; row < returnEntrys.size(); ++row) {
            DynamicObject returnEntry = (DynamicObject)returnEntrys.get(row);
            String key = returnEntry.getString("e_key");
            List<Integer> srcEntryRowList = srcEntryRowMap.get(key);
            for (int srcEntryRow : srcEntryRowList) {
                DynamicObject parentEntry = (DynamicObject)this.parentEntrys.get(srcEntryRow);
                boolean isFinAp = "ap_finapbill".equals(this.parentEntityId);
                parentEntry.set(isFinAp ? "price" : "e_unitprice", (Object)returnEntry.getBigDecimal("e_unitprice"));
                parentEntry.set("taxrateid", (Object)returnEntry.getDynamicObject("e_taxrateid"));
                parentEntry.set(isFinAp ? "taxrate" : "e_taxrate", (Object)returnEntry.getBigDecimal("e_taxrate"));
                parentEntry.set(isFinAp ? "pricetax" : "e_taxunitprice", (Object)returnEntry.getBigDecimal("e_taxunitprice"));
                parentEntry.set(isFinAp ? "discountmode" : "e_discountmode", (Object)returnEntry.getString("e_discountmode"));
                parentEntry.set(isFinAp ? "discountrate" : "e_discountrate", (Object)returnEntry.getBigDecimal("e_discountrate"));
            }
        }
    }

    public void calculateLastRow(DynamicObjectCollection returnEntrys, Map<String, List<Integer>> srcEntryRowMap, BigDecimal exchangerate, int localprecision) {
        for (int row = 0; row < returnEntrys.size(); ++row) {
            DynamicObject returnEntry = (DynamicObject)returnEntrys.get(row);
            String key = returnEntry.getString("e_key");
            BigDecimal sumRate = returnEntry.getBigDecimal("e_tax");
            BigDecimal sumAmount = returnEntry.getBigDecimal("e_amount");
            BigDecimal pricetaxtotal = returnEntry.getBigDecimal("e_pricetaxtotal");
            String pricetaxtotalKey = this.isFinAp ? "e_pricetaxtotal" : "e_recamount";
            List<Integer> srcEntryRowList = srcEntryRowMap.get(key);
            for (int i = srcEntryRowList.size() - 1; i > 0; --i) {
                DynamicObject parentEntry = (DynamicObject)this.parentEntrys.get(srcEntryRowList.get(i).intValue());
                sumRate = sumRate.subtract(parentEntry.getBigDecimal("e_tax"));
                sumAmount = sumAmount.subtract(parentEntry.getBigDecimal("e_amount"));
                pricetaxtotal = pricetaxtotal.subtract(parentEntry.getBigDecimal(pricetaxtotalKey));
            }
            BigDecimal sumAmountLoc = sumAmount.multiply(exchangerate).setScale(localprecision, RoundingMode.HALF_UP);
            BigDecimal pricetaxtotalLoc = pricetaxtotal.multiply(exchangerate).setScale(localprecision, RoundingMode.HALF_UP);
            DynamicObject parentEntry = (DynamicObject)this.parentEntrys.get(srcEntryRowList.get(0).intValue());
            parentEntry.set("e_tax", (Object)sumRate);
            parentEntry.set("e_amount", (Object)sumAmount);
            parentEntry.set(this.isFinAp ? "e_amountbase" : "e_localamt", (Object)sumAmountLoc);
            parentEntry.set(pricetaxtotalKey, (Object)pricetaxtotal);
            parentEntry.set(this.isFinAp ? "e_pricetaxtotalbase" : "e_reclocalamt", (Object)pricetaxtotalLoc);
            if (this.isFinAp) {
                parentEntry.set("e_unverifyamount", (Object)sumAmount);
                parentEntry.set("unlockamt", (Object)pricetaxtotal);
                parentEntry.set("unsettleamt", (Object)pricetaxtotal);
                parentEntry.set("unsettleamtbase", (Object)pricetaxtotalLoc);
                continue;
            }
            parentEntry.set("e_unverifyamt", (Object)sumAmount);
            parentEntry.set("e_unlockamt", (Object)pricetaxtotal);
            parentEntry.set("e_unsettleamt", (Object)pricetaxtotal);
            parentEntry.set("e_unsettlelocalamt", (Object)pricetaxtotalLoc);
            parentEntry.set("e_unconfirmamt", (Object)sumAmount);
            parentEntry.set("e_uninvoicedamt", (Object)pricetaxtotal);
        }
    }

    public void returnParent(DynamicObjectCollection returnEntrys, Map<String, List<Integer>> srcEntryRowMap) {
    }
}

