/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.RecBillHandlerHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.ManualSettleParam;

public interface IManualSettleService {
    public void manualSettle(DynamicObject[] var1, DynamicObject[] var2, ManualSettleParam var3) throws KDBizException;

    default public DynamicObject[] reloadRecArr(Set<Long> recBillIdSet) {
        if (recBillIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", recBillIdSet)};
            DynamicObject[] recBills = RecBillHandlerHelper.loadRec(filter);
            return recBills;
        }
        return new DynamicObject[0];
    }

    default public DynamicObject[] reloadRecedArr(Set<Long> recedBillIdSet) {
        if (recedBillIdSet.size() > 0) {
            QFilter[] filter = new QFilter[]{new QFilter("id", "in", recedBillIdSet)};
            DynamicObject[] recedObjs = RecBillHandlerHelper.loadReced(filter);
            return recedObjs;
        }
        return new DynamicObject[0];
    }

    default public DynamicObject[] reloadPayArr(Set<Long> billIdSet) {
        if (billIdSet.size() > 0) {
            QFilter filter = new QFilter("id", "in", billIdSet);
            DynamicObject[] asstArr = PayBillHandleHelper.loadPay(new QFilter[]{filter});
            return asstArr;
        }
        return new DynamicObject[0];
    }

    default public DynamicObject[] reloadPaidArr(Set<Long> billIdSet) {
        if (billIdSet.size() > 0) {
            QFilter filter = new QFilter("id", "in", billIdSet);
            DynamicObject[] asstArr = PayBillHandleHelper.loadPaid(new QFilter[]{filter});
            return asstArr;
        }
        return new DynamicObject[0];
    }

    default public List<BillSettleVO> getPositiveList(List<BillSettleVO> voList) {
        ArrayList<BillSettleVO> positiveList = new ArrayList<BillSettleVO>();
        if (voList != null && voList.size() > 0) {
            for (BillSettleVO vo : voList) {
                if (vo.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) <= 0) continue;
                positiveList.add(vo);
            }
        }
        return positiveList;
    }

    default public List<BillSettleVO> getNegativeList(List<BillSettleVO> voList) {
        ArrayList<BillSettleVO> negativeList = new ArrayList<BillSettleVO>();
        if (voList != null && voList.size() > 0) {
            for (BillSettleVO vo : voList) {
                if (vo.getEntryUnSettleAmt().compareTo(BigDecimal.ZERO) >= 0) continue;
                negativeList.add(vo);
            }
        }
        return negativeList;
    }

    default public String getApEntryKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "detailentry" : "planentity";
    }

    default public String getArEntryKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "entry" : "planentity";
    }

    default public String getApEntryAmtKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "unsettleamt" : "unplansettleamt";
    }

    default public String getApEntryUnLockKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "unlockamt" : "unplanlockamt";
    }

    default public String getArEntryAmtKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "e_unsettleamt" : "unplansettleamt";
    }

    default public String getArEntryUnLockKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "e_unlockamt" : "unplanlockamt";
    }

    default public String getBadEntryKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "entry" : "planentry";
    }

    default public String getBadEntryAmtKey(int settleEntryParam) {
        return settleEntryParam == 1 ? "e_unsettleamt" : "p_unsettleamt";
    }
}

