/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevCfmChargeAgainstService {
    private static final Log LOGGER = LogFactory.getLog(RevCfmChargeAgainstService.class);
    private static final String RULE = "1281716490650811392";

    public List<DynamicObject> generate(List<DynamicObject> finChargeAgainstBills) {
        HashSet srcBillIds = new HashSet(finChargeAgainstBills.size());
        finChargeAgainstBills.stream().forEach(finChargeAgainstBill -> srcBillIds.add(Long.parseLong(String.valueOf(finChargeAgainstBill.getString("sourcebillid")))));
        Map<Long, Set<Long>> target = BOTPHelper.findDirtTargetBillIds("ar_finarbill", srcBillIds.toArray(new Long[0]), "ar_revcfmbill", "ar_revcfmbill");
        HashSet<Long> targetRevcfmBillIds = new HashSet<Long>(16);
        Set<Object> subRevCfmBillIds = new HashSet(finChargeAgainstBills.size());
        for (Long srcBillId : srcBillIds) {
            Set<Long> revcfmBillIds = target.get(srcBillId);
            if (ObjectUtils.isEmpty(revcfmBillIds)) continue;
            targetRevcfmBillIds.addAll(revcfmBillIds);
        }
        if (EmptyUtils.isEmpty(targetRevcfmBillIds)) {
            return Collections.emptyList();
        }
        DynamicObjectCollection trgRevcfmBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", targetRevcfmBillIds), new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE)});
        subRevCfmBillIds = trgRevcfmBills.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtils.isEmpty(subRevCfmBillIds)) {
            return Collections.emptyList();
        }
        QFilter filter = new QFilter("id", "in", subRevCfmBillIds);
        filter.and(new QFilter("verifystatus", "=", (Object)"verified")).and(new QFilter("isvoucher", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection revcfmBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id", (QFilter[])new QFilter[]{filter});
        List<Long> srcRevcfmBillIds = revcfmBills.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        Map<Long, Boolean> inventoryResult = this.revInventoryCostResult(srcRevcfmBillIds);
        ArrayList<Long> canGetCostIds = new ArrayList<Long>(2);
        for (Map.Entry<Long, Boolean> entrySet : inventoryResult.entrySet()) {
            Long revcfmBillId = entrySet.getKey();
            if (!Boolean.TRUE.equals(entrySet.getValue())) continue;
            canGetCostIds.add(revcfmBillId);
        }
        if (canGetCostIds.size() > 0) {
            OperationResult result = OperationServiceHelper.executeOperate((String)"getinventorycost", (String)"ar_revcfmbill", (Object[])canGetCostIds.toArray(), (OperateOption)OperateOption.create());
            OperationHelper.assertResult(result);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("billsrctype", "auto");
        Map<String, Object> resultMap = BOTPHelper.push4Result("ar_revcfmbill", "ar_revcfmbill", RULE, new ArrayList<Long>(subRevCfmBillIds), paramMap);
        ArrayList<DynamicObject> trgBillList = new ArrayList(2);
        ConvertOperationResult result = (ConvertOperationResult)resultMap.get("convertResult");
        if (result != null) {
            String convertReport = BOTPHelper.getConvertReport(result);
            ErrorCode ec = new ErrorCode("botp", convertReport);
            throw new KDBizException(ec, new Object[0]);
        }
        trgBillList = (List)resultMap.get("trgBills");
        return trgBillList;
    }

    public void executeSourceBillDispose(List<DynamicObject> entities) {
        List sourceBillIds = entities.stream().map(entity -> entity.getLong("sourcebillid")).collect(Collectors.toList());
        LOGGER.info("sourceBillIds:" + sourceBillIds);
        DynamicObject[] sourceRevCfmBills = BusinessDataServiceHelper.load((String)"ar_revcfmbill", (String)"id, hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
        if (EmptyUtils.isEmpty(sourceRevCfmBills)) {
            return;
        }
        for (DynamicObject entity2 : sourceRevCfmBills) {
            entity2.set("hadwrittenoff", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.save((DynamicObject[])sourceRevCfmBills);
    }

    public void executeSubmitAndAudit(List<DynamicObject> entities) {
        if (EmptyUtils.isEmpty(entities)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ar_revcfmbill", (DynamicObject[])entities.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(saveResult);
    }

    private Map<Long, Boolean> revInventoryCostResult(List<Long> revcfmIds) {
        QFilter filter = new QFilter("entry.e_billid", "in", revcfmIds);
        filter.and(new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill"));
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter("ar_revcfmbill", revcfmIds.toArray(), true);
        filter.and(commonFilter);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)"ar_verifyrecord", (String)"id as verifyId,entry.e_billid as revcfmId,billid as mainBillId", (QFilter[])new QFilter[]{filter});
        HashMap<Long, ArrayList<Long>> revcfmToVerifyMap = new HashMap<Long, ArrayList<Long>>();
        for (DynamicObject entity2 : dataList) {
            long verifyId = entity2.getLong("verifyId");
            long revcfmId = entity2.getLong("revcfmId");
            ArrayList<Long> verifyIdList = (ArrayList<Long>)revcfmToVerifyMap.get(revcfmId);
            if (EmptyUtils.isEmpty(verifyIdList)) {
                verifyIdList = new ArrayList<Long>(16);
            }
            verifyIdList.add(verifyId);
            revcfmToVerifyMap.put(revcfmId, verifyIdList);
        }
        List<Long> verifyRecordIds = dataList.stream().map(entity -> entity.getLong("verifyId")).distinct().collect(Collectors.toList());
        List<Long> mainBillIds = dataList.stream().map(entity -> entity.getLong("mainBillId")).distinct().collect(Collectors.toList());
        Map<Long, BigDecimal> verifyBaseUnitCost = this.getBaseUnitActualCost(verifyRecordIds, mainBillIds);
        HashMap<Long, Boolean> costResult = new HashMap<Long, Boolean>(16);
        for (Long revcfmId : revcfmIds) {
            List verifyIds = (List)revcfmToVerifyMap.get(revcfmId);
            boolean containsCost = this.containsVerifyCost(verifyIds, verifyBaseUnitCost);
            costResult.put(revcfmId, containsCost);
        }
        return costResult;
    }

    private boolean containsVerifyCost(List<Long> verifyIds, Map<Long, BigDecimal> verifyCostMap) {
        if (EmptyUtils.isEmpty(verifyIds)) {
            return false;
        }
        for (Long verifyId : verifyIds) {
            BigDecimal inventoryCost = verifyCostMap.get(verifyId);
            if (EmptyUtils.isEmpty(inventoryCost) || BigDecimal.ZERO.compareTo(inventoryCost) >= 0) continue;
            return true;
        }
        return false;
    }

    private Map<Long, BigDecimal> getBaseUnitActualCost(List<Long> verifyRecordIds, List<Long> mainBillIds) {
        HashMap<Long, BigDecimal> baseUnitActualCost = new HashMap<Long, BigDecimal>(16);
        QFilter bizbillIdf = new QFilter("bizbillid", "in", mainBillIds);
        QFilter writeOffIdf = new QFilter("entry.writeoffid", "in", verifyRecordIds);
        DataSet costDs = QueryServiceHelper.queryDataSet((String)RevCfmChargeAgainstService.class.getName(), (String)"cal_costrecord", (String)"bizbillid,entry.writeoffid as writeoffid,entry.unitactualcost as unitactualcost", (QFilter[])new QFilter[]{bizbillIdf, writeOffIdf}, (String)"bizbillid,costaccount.ismainaccount desc");
        for (Row row : costDs) {
            baseUnitActualCost.putIfAbsent(row.getLong("writeoffid"), row.getBigDecimal("unitactualcost"));
        }
        return baseUnitActualCost;
    }
}

