/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.factory.SettleServiceFactory;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.UnSettleParam;

public class WriteOffUnSettleService {
    private static final Log logger = LogFactory.getLog(WriteOffUnSettleService.class);
    private static final String AR_SR_RULEID = "750450292776019968";
    private static final String AP_SR_RULEID = "733772355079280640";
    private final String settleRecordEntity;
    private final String billEntity;
    private final Long billPk;
    private final Date bookDate;
    private final String settleRecordRedRuleId;

    public WriteOffUnSettleService(Long billPk, Date bookDate, boolean isAr) {
        this.settleRecordEntity = isAr ? "ar_settlerecord" : "ap_settlerecord";
        this.billEntity = isAr ? "ar_finarbill" : "ap_finapbill";
        this.settleRecordRedRuleId = isAr ? AR_SR_RULEID : AP_SR_RULEID;
        this.billPk = billPk;
        this.bookDate = bookDate;
    }

    public void unSettle() {
        logger.info("WriteOffUnSettleService.unSettle4Main start");
        this.unSettle4Main();
        logger.info("WriteOffUnSettleService.unSettle4Main end");
        logger.info("WriteOffUnSettleService.unSettle4Asst start");
        this.unSettle4Asst();
        logger.info("WriteOffUnSettleService.unSettle4Asst end");
    }

    private void unSettle4Main() {
        QFilter filter = new QFilter("mainbillid", "=", (Object)this.billPk);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)this.settleRecordEntity, (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
        if (settleRecords.length == 0) {
            return;
        }
        Set<Long> hadWrittenOffEntryIdSet = this.cacheSrcSettleRecordHadRedEntryId(settleRecords);
        List<Long> resultIds = Arrays.stream(settleRecords).map(result -> result.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> redSettleRecords = BOTPHelper.push(this.settleRecordEntity, this.settleRecordEntity, this.settleRecordRedRuleId, resultIds);
        this.updateSettleRecord(redSettleRecords, hadWrittenOffEntryIdSet);
        this.settleRecordSubmitAndAudit(redSettleRecords);
        this.updateSrcSettleRecord(settleRecords);
        this.updateSettleRecord(Arrays.stream(settleRecords).collect(Collectors.toList()), hadWrittenOffEntryIdSet);
        this.unSettleWriteBackBill(settleRecords);
    }

    private void unSettle4Asst() {
        QFilter filter = new QFilter("entry.billid", "=", (Object)this.billPk);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = SettleRecordQueryHelper.getSettleRecords(this.settleRecordEntity, CommonSettleServiceHelper.getSettleRecordSelector(), this.billEntity, new Object[]{this.billPk}, filter);
        List<DynamicObject> settleRecordList = Arrays.stream(settleRecords).collect(Collectors.toList());
        Iterator settleRecordItr = settleRecordList.iterator();
        while (settleRecordItr.hasNext()) {
            boolean isRemove = false;
            DynamicObject settleRecord = (DynamicObject)settleRecordItr.next();
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long asstBillId = entry.getLong("billid");
                boolean hadWriteOff = entry.getBoolean("e_hadwrittenoff");
                if (!hadWriteOff || !asstBillId.equals(this.billPk)) continue;
                isRemove = true;
                break;
            }
            if (!isRemove) continue;
            settleRecordItr.remove();
        }
        settleRecords = settleRecordList.toArray(new DynamicObject[0]);
        if (settleRecords.length == 0) {
            return;
        }
        ArrayList<DynamicObject> wholeNeedRedRecords = new ArrayList<DynamicObject>(settleRecords.length);
        ArrayList<DynamicObject> partNeedRedRecords = new ArrayList<DynamicObject>(settleRecords.length);
        for (DynamicObject result : settleRecords) {
            boolean isWhole = true;
            DynamicObjectCollection entrys = result.getDynamicObjectCollection("entry");
            long defaultPayId = 0L;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if (i == 0) {
                    defaultPayId = entry.getLong("billid");
                    continue;
                }
                if (entry.getLong("billid") == defaultPayId) continue;
                isWhole = false;
                break;
            }
            if (isWhole) {
                wholeNeedRedRecords.add(result);
                continue;
            }
            partNeedRedRecords.add(result);
        }
        if (wholeNeedRedRecords.size() > 0) {
            this.resolveWholeNeedRedRecord(wholeNeedRedRecords);
        }
        if (partNeedRedRecords.size() > 0) {
            this.resolvePartNeedRedRecord(partNeedRedRecords);
        }
    }

    private void resolveWholeNeedRedRecord(List<DynamicObject> wholeAndNeedRedRecords) {
        if (wholeAndNeedRedRecords.size() == 0) {
            return;
        }
        List<Long> resultIds = wholeAndNeedRedRecords.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> redSettleRecords = BOTPHelper.push(this.settleRecordEntity, this.settleRecordEntity, this.settleRecordRedRuleId, resultIds);
        this.settleRecordSubmitAndAudit(redSettleRecords);
        this.updateSrcSettleRecord(wholeAndNeedRedRecords.toArray(new DynamicObject[0]));
        this.unSettleWriteBackBill(wholeAndNeedRedRecords.toArray(new DynamicObject[0]));
    }

    private void resolvePartNeedRedRecord(List<DynamicObject> partAndNeedRedRecords) {
        if (partAndNeedRedRecords.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> srcSettleRecordsTemp = new ArrayList<DynamicObject>(partAndNeedRedRecords.size());
        CloneUtils clone = new CloneUtils(false, false);
        for (DynamicObject settleRecord : partAndNeedRedRecords) {
            srcSettleRecordsTemp.add((DynamicObject)clone.clone((IDataEntityBase)settleRecord));
        }
        for (DynamicObject partRecord : partAndNeedRedRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long asstBillId = entry.getLong("billid");
                if (this.billPk.equals(asstBillId)) continue;
                iterator.remove();
            }
        }
        this.repairSettleRecordMainData(partAndNeedRedRecords);
        this.unSettleWriteBackBill(partAndNeedRedRecords.toArray(new DynamicObject[0]));
        List<Long> resultIds = partAndNeedRedRecords.stream().map(result -> result.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> redSettleRecords = BOTPHelper.push(this.settleRecordEntity, this.settleRecordEntity, this.settleRecordRedRuleId, resultIds);
        for (DynamicObject partRecord : redSettleRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                Long asstBillId = entry.getLong("billid");
                if (this.billPk.equals(asstBillId)) continue;
                iterator.remove();
            }
        }
        this.repairSettleRecordMainData(redSettleRecords);
        this.settleRecordSubmitAndAudit(redSettleRecords);
        this.updateSrcSettleRecordPart(srcSettleRecordsTemp);
    }

    private void repairSettleRecordMainData(List<DynamicObject> partRecords) {
        for (DynamicObject partRecord : partRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            BigDecimal tempSettleAmt = BigDecimal.ZERO;
            BigDecimal tempSettleLocalAmt = BigDecimal.ZERO;
            BigDecimal tempSwapL = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                tempSettleAmt = tempSettleAmt.add(entry.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry.getBigDecimal("e_swappl"));
            }
            partRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("totalsettleamt").signum())));
            partRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("localtotalsettleamt").signum())));
            partRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(partRecord.getBigDecimal("swappl").signum())));
        }
    }

    private void settleRecordSubmitAndAudit(List<DynamicObject> redSettleRecords) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        if (EmptyUtils.isNotEmpty(this.bookDate)) {
            option.setVariableValue("settleDate", DateUtils.formatString(this.bookDate, "yyyy-MM-dd HH:mm:ss"));
        }
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.settleRecordEntity, (DynamicObject[])redSettleRecords.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(saveResult);
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.settleRecordEntity, (Object[])saveResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.settleRecordEntity, (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)option);
        OperationHelper.assertResult(auditResult);
    }

    private void updateSrcSettleRecord(DynamicObject[] srcSettleRecords) {
        for (DynamicObject record : srcSettleRecords) {
            record.set("hadwrittenoff", (Object)1);
            DynamicObjectCollection entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                entry.set("e_hadwrittenoff", (Object)1);
            }
        }
        SaveServiceHelper.save((DynamicObject[])srcSettleRecords);
    }

    private void updateSettleRecord(List<DynamicObject> redSettleRecords, Set<Long> hadWrittenOffEntryIdSet) {
        if (hadWrittenOffEntryIdSet.size() == 0) {
            return;
        }
        for (DynamicObject redSettleRecord : redSettleRecords) {
            DynamicObjectCollection entryColl = redSettleRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entryColl.iterator();
            BigDecimal totalSettleAmt = redSettleRecord.getBigDecimal("totalsettleamt");
            BigDecimal localTotalSettleAmt = redSettleRecord.getBigDecimal("localtotalsettleamt");
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                long billEntryId = entry.getLong("billentryid");
                if (!hadWrittenOffEntryIdSet.contains(billEntryId)) continue;
                totalSettleAmt = totalSettleAmt.subtract(entry.getBigDecimal("settleamt"));
                localTotalSettleAmt = localTotalSettleAmt.subtract(entry.getBigDecimal("localsettleamt"));
                iterator.remove();
            }
            redSettleRecord.set("totalsettleamt", (Object)totalSettleAmt);
            redSettleRecord.set("localtotalsettleamt", (Object)localTotalSettleAmt);
        }
    }

    private Set<Long> cacheSrcSettleRecordHadRedEntryId(DynamicObject[] settleRecords) {
        HashSet<Long> hadWrittenOffEntryIdSet = new HashSet<Long>(8);
        for (DynamicObject settleRecord : settleRecords) {
            DynamicObjectCollection entryColl = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                long billEntryId = entry.getLong("billentryid");
                boolean hadWrittenOff = entry.getBoolean("e_hadwrittenoff");
                if (!hadWrittenOff) continue;
                hadWrittenOffEntryIdSet.add(billEntryId);
            }
        }
        return hadWrittenOffEntryIdSet;
    }

    private void updateSrcSettleRecordPart(List<DynamicObject> srcSettleRecords) {
        DynamicObjectCollection entries;
        for (DynamicObject record : srcSettleRecords) {
            entries = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long asstId = entry.getLong("billid");
                if (!this.billPk.equals(asstId)) continue;
                entry.set("e_hadwrittenoff", (Object)1);
            }
        }
        for (DynamicObject record : srcSettleRecords) {
            entries = record.getDynamicObjectCollection("entry");
            boolean isFlag = true;
            for (DynamicObject entry : entries) {
                boolean isHadWrittenOff = entry.getBoolean("e_hadwrittenoff");
                if (isHadWrittenOff) continue;
                isFlag = false;
                break;
            }
            if (!isFlag) continue;
            record.set("hadwrittenoff", (Object)1);
        }
        SaveServiceHelper.update((DynamicObject[])srcSettleRecords.toArray(new DynamicObject[0]));
    }

    private void unSettleWriteBackBill(DynamicObject[] settleRecords) {
        Map<String, List<DynamicObject>> map = SettleRecordOpHelper.classfySettleRecord(settleRecords);
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String key = entry.getKey();
            AbstractSettleTemplate service = SettleServiceFactory.getService(key);
            List<DynamicObject> settleRecordList = entry.getValue();
            if (SettleRelationEnum.APARSETTLE.getValue().equals(key) || SettleRelationEnum.ARAPSETTLE.getValue().equals(key)) {
                Map<String, List<DynamicObject>> settleModelGroup = SettleRecordOpHelper.classfySettleRecordBySettleModel(settleRecordList);
                for (Map.Entry<String, List<DynamicObject>> entryGroup : settleModelGroup.entrySet()) {
                    List<DynamicObject> groupSettleRecordLsit = entryGroup.getValue();
                    UnSettleParam unSettleParam = new UnSettleParam();
                    unSettleParam.setUnSettleByListOP(true);
                    unSettleParam.setRedSettleRecord(true);
                    service.unSettle(groupSettleRecordLsit.toArray(new DynamicObject[0]), unSettleParam);
                }
                continue;
            }
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setUnSettleByListOP(true);
            unSettleParam.setRedSettleRecord(true);
            service.unSettle(settleRecordList.toArray(new DynamicObject[0]), unSettleParam);
        }
    }
}

