/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.adjustexch.AdjustExchangeService;
import kd.fi.arapcommon.vo.adjexch.AdjExchTransferObject;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeResult;

public class AdjExchBatchAsynchronousTask
extends AbstractTask {
    protected static final Log logger = LogFactory.getLog(AdjExchBatchAsynchronousTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4e2d", (String)"AdjExchBatchAsynchronousTask_0", (String)"fi-arapcommon", (Object[])new Object[0]), null);
        AdjExchTransferObject adjExchTransferObject = (AdjExchTransferObject)SerializationUtils.fromJsonString((String)params.get("adjExchTransferObject").toString(), AdjExchTransferObject.class);
        Set<Long> orgIds = adjExchTransferObject.getOrgIds();
        String bizSystem = adjExchTransferObject.getBizSystem();
        Boolean firstPeriod = adjExchTransferObject.getFirstPeriod();
        Long adjExchPeriodId = adjExchTransferObject.getCurPeriodId();
        String adjExchMode = adjExchTransferObject.getAdjExchMode();
        Map<String, BigDecimal> rateMap = adjExchTransferObject.getRateMap();
        Map<String, String> quotationMap = adjExchTransferObject.getQuotationMap();
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        try {
            int count = 0;
            AdjustExchangeService service = new AdjustExchangeService();
            for (Long orgPk : orgIds) {
                this.checkIsStop();
                int percent = count * 100 / orgIds.size();
                this.feedbackProgress(percent, ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4e2d", (String)"AdjExchBatchAsynchronousTask_0", (String)"fi-arapcommon", (Object[])new Object[0]), null);
                ++count;
                AdjustExchangeResult adjustExchangeResult = service.adjustExchange(bizSystem, orgPk, firstPeriod, adjExchPeriodId, rateMap, quotationMap);
                result.put(orgPk.toString(), adjustExchangeResult);
                logger.info(String.format("AdjExchBatchAsynchronousTask-AdjustExchangeResult:orgId:%s,period:%s,sucess:%s,errMsg:%s,gainloss:%s", orgPk, adjustExchangeResult.getPeriodId(), adjustExchangeResult.isSuccess(), adjustExchangeResult.getErrorMsg(), adjustExchangeResult.getTotalgainloss()));
            }
        }
        finally {
            this.reBuildAdjExchRecord(result, bizSystem, adjExchMode);
            this.feedbackCustomdata(result);
        }
    }

    private void reBuildAdjExchRecord(Map<String, Object> result, String bizSystem, String adjExchMode) {
        DynamicObject[] adjExchRecords;
        HashMap<Long, BigDecimal> orgTotalgainlossMap = new HashMap<Long, BigDecimal>(2);
        ArrayList<Long> periodIds = new ArrayList<Long>(2);
        HashSet<Long> orgIds = new HashSet<Long>(2);
        for (Map.Entry<String, Object> resultData : result.entrySet()) {
            AdjustExchangeResult adjustExchangeResult = (AdjustExchangeResult)resultData.getValue();
            if (!adjustExchangeResult.isSuccess()) continue;
            Long orgId = Long.valueOf(resultData.getKey());
            orgIds.add(orgId);
            periodIds.add(adjustExchangeResult.getPeriodId());
            orgTotalgainlossMap.put(orgId, adjustExchangeResult.getTotalgainloss());
        }
        if (orgIds.size() == 0) {
            return;
        }
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter periodFilter = new QFilter("period", "=", periodIds.get(0));
        QFilter bizSystemFilter = new QFilter("bizsystem", "=", (Object)bizSystem);
        for (DynamicObject adjExchRecord : adjExchRecords = BusinessDataServiceHelper.load((String)("ar".equalsIgnoreCase(bizSystem) ? "ar_adjustexch" : "ap_adjustexch"), (String)AdjExchBatchAsynchronousTask.getAdjExchRecordSelector(), (QFilter[])new QFilter[]{orgFilter, periodFilter, bizSystemFilter})) {
            adjExchRecord.set("isadjexch", (Object)Boolean.TRUE);
            adjExchRecord.set("adjexchmode", (Object)adjExchMode);
            adjExchRecord.set("gainloss", orgTotalgainlossMap.get(adjExchRecord.getDynamicObject("org").getLong("id")));
        }
        OperationServiceHelper.executeOperate((String)"save", (String)("ar".equalsIgnoreCase(bizSystem) ? "ar_adjustexch" : "ap_adjustexch"), (DynamicObject[])adjExchRecords, (OperateOption)OperateOption.create());
    }

    public static String getAdjExchRecordSelector() {
        ArrayList<String> selectors = new ArrayList<String>(16);
        selectors.add("id");
        selectors.add("org");
        selectors.add("isadjexch");
        selectors.add("gainloss");
        selectors.add("adjexchmode");
        selectors.add("adjexchdate");
        selectors.add("e_fromcurr");
        selectors.add("e_tocurr");
        selectors.add("e_exratetable");
        selectors.add("e_exratedate");
        selectors.add("e_exrate");
        selectors.add("e_quotation");
        return String.join((CharSequence)",", selectors);
    }

    private void deleteAdjExch(Long periodId, Long orgId, String bizSystem) {
        QFilter exitFilter = new QFilter("period.id", "=", (Object)periodId);
        exitFilter.and(new QFilter("org.id", "=", (Object)orgId));
        exitFilter.and(new QFilter("bizsystem", "=", (Object)bizSystem));
        QFilter isVoucherFilter = new QFilter("isvoucher", "=", (Object)Boolean.TRUE);
        boolean isVoucherAdjExchBillTap = QueryServiceHelper.exists((String)"ap_adjexchbill", (QFilter[])new QFilter[]{exitFilter, isVoucherFilter});
        if (isVoucherAdjExchBillTap) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u671f\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u8c03\u6c47\u5355\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u8bd5\u3002", (String)"AdjExchBatchAsynchronousTask_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        boolean exitsTap = QueryServiceHelper.exists((String)"ap_adjexchbill", (QFilter[])exitFilter.toArray());
        if (exitsTap) {
            DeleteServiceHelper.delete((String)"ap_adjexchbill", (QFilter[])exitFilter.toArray());
            logger.info("----- \u5220\u9664\u8c03\u6c47\u5355\uff1a\u7ec4\u7ec7\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u4e1a\u52a1\uff1a%s ------ ", new Object[]{orgId, periodId, bizSystem});
        }
    }

    private Object getCurOrgSettleModel(Long orgID, String appID) {
        Object settleModel = "ar".equals(appID) ? SystemParameterHelper.getARAppParameter(orgID, "ar_003") : SystemParameterHelper.getAPAppParameter(orgID, "ap_003");
        return settleModel;
    }

    private Boolean isAr(String bizSystem) {
        return "AR".equals(bizSystem);
    }
}

