/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.vo.adjexch.AdjExchBillEntryVO;
import kd.fi.arapcommon.vo.adjexch.AdjExchBillVO;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeContext;
import kd.fi.arapcommon.vo.adjexch.BillFieldMappingVO;
import kd.fi.arapcommon.vo.adjexch.CalculateVO;
import org.apache.commons.lang.StringUtils;

public class AdjustExchHelper {
    private static final Log logger = LogFactory.getLog(AdjustExchHelper.class);
    private static final String ADJENTITYKEY = "ap_adjexchbill";
    private static final String AR_ADJENTITYKEY = "ar_adjustexchbill";
    private static final String AP_BILLFIELDMAPPING = "ap_billfieldmapping";

    public static Set<String> screenExtendFields(Set<String> entryFields, String entityKey, String entryKey) {
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Set billEntryFields = ((EntityType)billEntityType.getAllEntities().get(entryKey)).getFields().keySet();
        HashSet<String> extendEntryFields = new HashSet<String>(16);
        for (String entryField : entryFields) {
            if (billEntryFields.contains(entryField)) {
                extendEntryFields.add(entryKey + "." + entryField);
                continue;
            }
            boolean isContains = billEntryFields.contains(entryField.substring(0, entryField.length() - 3));
            if (isContains && (entityKey.startsWith("ar") || "cas_recbill".equals(entityKey)) && entryField.endsWith("_ar")) {
                extendEntryFields.add(entryKey + "." + entryField);
                continue;
            }
            if (!isContains || !entityKey.startsWith("ap") && !"cas_paybill".equals(entityKey) || !entryField.endsWith("_ap")) continue;
            extendEntryFields.add(entryKey + "." + entryField);
        }
        return extendEntryFields;
    }

    public static void handleBillExtFields(List<String> billSelector, Set<String> fields) {
        if (fields != null) {
            for (String field : fields) {
                if (field.endsWith("_ap") || field.endsWith("_ar")) {
                    field = field.substring(0, field.length() - 3);
                }
                billSelector.add(field);
            }
        }
    }

    public static DataSet queryBillDataSet(Object[] pks, String entityKey, List<String> selector, Set<String> fields) {
        AdjustExchHelper.handleBillExtFields(selector, fields);
        return QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)entityKey, (String)AdjustExchHelper.generateSelector(selector), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())}, (String)"bookdate");
    }

    public static void handleBillEntryKeyMap(DataSet dataSet, Map<Object, Set<Object>> billEntryKeyMap, String entryKeyStr) {
        if (dataSet != null) {
            for (Row row : dataSet) {
                Object billKey = row.get("id");
                Object entryKey = row.get(entryKeyStr);
                Set<Object> entryKeys = billEntryKeyMap.get(billKey);
                if (entryKeys == null) {
                    entryKeys = new HashSet<Object>(16);
                    entryKeys.add(entryKey);
                    billEntryKeyMap.put(billKey, entryKeys);
                    continue;
                }
                entryKeys.add(entryKey);
            }
            dataSet.close();
        }
    }

    public static QFilter getPeriodSettleFilter(AdjustExchangeContext context, String billEntityKey, boolean isMain) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and(new QFilter("settledate", ">=", (Object)context.getEndDate()));
        if (isMain) {
            filter.and(new QFilter("billentity", "=", (Object)billEntityKey));
            filter.and(new QFilter("mainbizdate", "<", (Object)context.getEndDate()));
            filter.and(new QFilter("maincurrency", "<>", (Object)context.getStandardCurrencyId()));
        } else {
            filter.and(new QFilter("entry.e_billentity", "=", (Object)billEntityKey));
            filter.and(new QFilter("entry.billdate", "<", (Object)context.getEndDate()));
            filter.and(new QFilter("entry.currency", "<>", (Object)context.getStandardCurrencyId()));
        }
        return filter;
    }

    public static QFilter getPeriodBillFilter(AdjustExchangeContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        filter.and(new QFilter("currency", "<>", (Object)context.getStandardCurrencyId()));
        filter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
        return filter;
    }

    public static List<String> getSettleSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billentity");
        selector.add("settledate");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("mainbillid");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("entry.e_billentity");
        selector.add("entry.settleamt");
        selector.add("entry.localsettleamt");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        return selector;
    }

    public static List<String> getWoffSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("entry.id");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        return selector;
    }

    public static List<String> getBusBillSelector() {
        List<String> selector = AdjustExchHelper.getBaseBillSelector();
        selector.add("isadjust");
        selector.add("bookdate");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.project");
        selector.add("entry.e_unwoffamt");
        selector.add("entry.e_unwofflocamt");
        return selector;
    }

    public static List<String> getFinArSelector() {
        List<String> selector = AdjustExchHelper.getBaseBillSelector();
        selector.add("bookdate");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettleamt");
        selector.add("entry.e_unsettlelocalamt");
        selector.add("entry.project");
        return selector;
    }

    public static List<String> getRecSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("payertype");
        selector.add("payer");
        selector.add("txt_description");
        selector.add("quotation");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettledamt");
        selector.add("entry.project");
        return selector;
    }

    public static List<String> getPaySelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("payeetype");
        selector.add("payee");
        selector.add("description");
        selector.add("payquotation");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettledamt");
        selector.add("entry.project");
        return selector;
    }

    public static List<String> getReceivedBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(17);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("department");
        selector.add("description");
        selector.add("quotation");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettledamt");
        selector.add("entry.project");
        return selector;
    }

    public static List<String> getPaidBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("payeetype");
        selector.add("payee");
        selector.add("usage");
        selector.add("department");
        selector.add("quotation");
        selector.add("entry.id");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.e_unsettledamt");
        selector.add("entry.project");
        return selector;
    }

    public static List<String> getBaseBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("remark");
        selector.add("department");
        selector.add("quotation");
        return selector;
    }

    public static List<String> getAdjustExchangeSelector() {
        List<String> selector = AdjustExchHelper.getBaseBillSelector();
        selector.add("sourcebilldate");
        selector.add("sourcebilltype");
        selector.add("isincludeentry");
        selector.add("lastexchangerate");
        selector.add("srcbillquotation");
        selector.add("entry.e_curgainloss");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.project");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        return selector;
    }

    public static List<String> getBizType(boolean isPay) {
        ArrayList<String> typeList = new ArrayList<String>();
        if (isPay) {
            typeList.add("202");
        } else {
            typeList.add("101");
        }
        String bizType = SettingMapperHelper.getValueFromCache("adjustexchange", isPay ? "paymentbiztype" : "receivingbiztype");
        if (!EmptyUtils.isEmpty(bizType)) {
            String[] split = bizType.split(",");
            typeList.addAll(Arrays.asList(split));
        }
        return typeList;
    }

    public static Set<String> getExtBillEntity(boolean isAr) {
        HashSet<String> entityList = new HashSet<String>(8);
        String bizType = SettingMapperHelper.getValueFromCache("adjustexchangeextbillentity", isAr ? "ar" : "ap");
        if (!EmptyUtils.isEmpty(bizType)) {
            String[] split = bizType.split(",");
            entityList.addAll(Arrays.asList(split));
        }
        return entityList;
    }

    public static List<String> getExtHandlerClassName(Set<String> serviceName) {
        ArrayList<String> classNameList = new ArrayList<String>(8);
        if (serviceName == null || serviceName.isEmpty()) {
            return classNameList;
        }
        QFilter[] filters = new QFilter[]{new QFilter("type", "=", (Object)"adjustexchange"), new QFilter("key", "in", serviceName)};
        Map classNameMap = BusinessDataServiceHelper.loadFromCache((String)"ap_settingmapper", (QFilter[])filters);
        for (Map.Entry entry : classNameMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            if (value == null) continue;
            classNameList.add(value.getString("value"));
        }
        return classNameList;
    }

    public static void setEntryMap(Row row, CalculateVO vo, Set<String> entryFieldSet) {
        Map<String, Object> entryMap = vo.getEntryMap();
        if (entryFieldSet != null) {
            for (String entryField : entryFieldSet) {
                if (entryField.endsWith("_ar") || entryField.endsWith("_ap")) {
                    entryMap.put(entryField, row.get(entryField.substring(0, entryField.length() - 3)));
                    continue;
                }
                entryMap.put(entryField, row.get(entryField));
            }
        }
    }

    public static String generateSelector(List<String> settleSelector) {
        return StringUtils.join((Object[])settleSelector.toArray(), (String)",");
    }

    public static List<DynamicObject> gainLossVO2Dyn(List<AdjExchBillVO> vos) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(vos.size());
        DynamicObjectType dt = null;
        for (AdjExchBillVO temporaryVO : vos) {
            List<AdjExchBillEntryVO> entries;
            if (BigDecimal.ZERO.compareTo(temporaryVO.getCurGainLoss()) == 0 && BigDecimal.ZERO.compareTo(temporaryVO.getGainLoss()) == 0 && temporaryVO.getEntries().size() <= 1) continue;
            DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)AdjustExchHelper.getAdjExchBillEntityName("AR".equals(temporaryVO.getBizSystem())));
            result.set("bizsystem", (Object)temporaryVO.getBizSystem());
            result.set("billno", (Object)temporaryVO.getBillNo());
            result.set("org", (Object)temporaryVO.getOrgId());
            result.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
            result.set("sourcebilltype", (Object)temporaryVO.getSourceBillType());
            String sourceBillId = temporaryVO.getSourceBillId();
            if (sourceBillId != null && sourceBillId.trim().length() != 0) {
                result.set("sourcebillid", (Object)Long.parseLong(sourceBillId));
            }
            result.set("sourcebilldate", (Object)temporaryVO.getSourceBillDate());
            result.set("bizdate", (Object)DateUtils.truncateDate(temporaryVO.getBizDate()));
            result.set("period", (Object)temporaryVO.getPeriodId());
            result.set("asstacttype", (Object)temporaryVO.getAsstactType());
            result.set("asstact", (Object)temporaryVO.getAsstactId());
            result.set("isincludeentry", (Object)temporaryVO.getIncludeEntry());
            result.set("currency", (Object)temporaryVO.getCurrencyId());
            result.set("basecurrency", (Object)temporaryVO.getBaseCurrencyId());
            result.set("exratetable", (Object)temporaryVO.getExrateTableId());
            result.set("exchangerate", (Object)temporaryVO.getExchangeRate());
            result.set("lastexchangerate", (Object)temporaryVO.getLastExchangeRate());
            result.set("balance", (Object)temporaryVO.getBalance());
            result.set("localbalance", (Object)temporaryVO.getLocalBalance());
            result.set("curlocalbalance", (Object)temporaryVO.getCurLocalBalance());
            result.set("curgainloss", (Object)temporaryVO.getCurGainLoss());
            result.set("lastgainloss", (Object)temporaryVO.getLastGainLoss());
            result.set("gainloss", (Object)temporaryVO.getGainLoss());
            result.set("quotation", (Object)temporaryVO.getQuotation());
            result.set("srcbillquotation", (Object)temporaryVO.getSrcBillQuotation());
            Map<String, Object> headExtendFieldMap = temporaryVO.getBillMap();
            if (EmptyUtils.isNotEmpty(headExtendFieldMap)) {
                for (Map.Entry<String, Object> headMap : headExtendFieldMap.entrySet()) {
                    String key = headMap.getKey();
                    Object value = headMap.getValue();
                    result.set(key, value);
                }
            }
            if (dt == null) {
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)result.getDataEntityType().getName()).findProperty("entry");
                dt = prop.getDynamicCollectionItemPropertyType();
            }
            if ((entries = temporaryVO.getEntries()) == null) continue;
            int invalidEntryCount = 0;
            int i = 0;
            entries = entries.stream().sorted(Comparator.comparing(AdjExchBillEntryVO::getSrcEntryId)).collect(Collectors.toList());
            for (AdjExchBillEntryVO entry : entries) {
                if (BigDecimal.ZERO.compareTo(entry.getCurGainLoss()) == 0 && BigDecimal.ZERO.compareTo(entry.getGainLoss()) == 0) {
                    ++invalidEntryCount;
                    continue;
                }
                DynamicObject entriesResult = new DynamicObject(dt);
                entriesResult.set("seq", (Object)(++i));
                entriesResult.set("e_material", (Object)entry.getMaterialId());
                entriesResult.set("e_expenseitem", (Object)entry.getExpenseItemId());
                entriesResult.set("project", (Object)entry.getProjectId());
                entriesResult.set("e_srcbillid", (Object)entry.getSrcBillId());
                entriesResult.set("e_srcentryid", (Object)entry.getSrcEntryId());
                entriesResult.set("e_balance", (Object)entry.getBalance());
                entriesResult.set("e_localbalance", (Object)entry.getLocalBalance());
                entriesResult.set("e_curlocalbalance", (Object)entry.getCurLocalBalance());
                entriesResult.set("e_curgainloss", (Object)entry.getCurGainLoss());
                entriesResult.set("e_lastgainloss", (Object)entry.getLastGainLoss());
                entriesResult.set("e_gainloss", (Object)entry.getGainLoss());
                Map<String, Object> entryMap = entry.getEntryMap();
                if (!entryMap.isEmpty()) {
                    for (Map.Entry<String, Object> mapEntry : entryMap.entrySet()) {
                        String key = mapEntry.getKey();
                        if (key.contains(".")) {
                            key = key.split("\\.")[1];
                        }
                        Object value = mapEntry.getValue();
                        entriesResult.set(key, value);
                    }
                }
                result.getDynamicObjectCollection("entry").add((Object)entriesResult);
            }
            if (invalidEntryCount == entries.size()) continue;
            AdjustExchHelper.validateBigDecimalPrecision(result);
            billList.add(result);
        }
        return billList;
    }

    public static void validateBigDecimalPrecision(DynamicObject bill) {
        IDataEntityType dataEntityType = bill.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof AmountProp) {
                Object value = prop.getValueFast((Object)bill);
                AdjustExchHelper.check(prop, value);
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(prop.getName());
            DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
            for (IDataEntityProperty entryProp : entryProperties) {
                if (!(entryProp instanceof AmountProp)) continue;
                for (DynamicObject dynamicObject : entry) {
                    Object value = entryProp.getValueFast((Object)dynamicObject);
                    AdjustExchHelper.check(entryProp, value);
                }
            }
        }
    }

    private static void check(IDataEntityProperty prop, Object value) {
        int realScale;
        if (!(value instanceof BigDecimal)) {
            return;
        }
        int precision = ((DecimalProp)prop).getPrecision();
        int scale = ((DecimalProp)prop).getScale();
        int truncPrecison = precision - scale;
        if (precision <= 0 || scale <= 0) {
            return;
        }
        int realPrecision = ((BigDecimal)value).precision();
        int realTruncPrecision = realPrecision - (realScale = ((BigDecimal)value).scale());
        if (realTruncPrecision > truncPrecison) {
            String message = ResManager.loadKDString((String)"%s\u8d85\u8fc7\u7cfb\u7edf\u5141\u8bb8\u7684\u6700\u5927\u503c\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6b63\u5f55\u5165\u7684\u6570\u636e\u3002", (String)"DecimalScopeValidator_1", (String)"fi-arapcommon", (Object[])new Object[]{prop.getDisplayName().getLocaleValue()});
            throw new KDBizException(message);
        }
    }

    public static List<AdjExchBillVO> gainLossDyn2VO(DynamicObject[] billArr) {
        ArrayList<AdjExchBillVO> vos = new ArrayList<AdjExchBillVO>(billArr.length);
        long start = System.currentTimeMillis();
        for (DynamicObject temporaryDyn : billArr) {
            AdjExchBillVO result = new AdjExchBillVO();
            result.setBillNo(temporaryDyn.getString("billno"));
            result.setOrgId(temporaryDyn.getLong("org"));
            result.setSourceBillType(temporaryDyn.getString("sourcebilltype"));
            result.setSourceBillId(temporaryDyn.getString("sourcebillid"));
            result.setSourceBillDate(temporaryDyn.getDate("sourcebilldate"));
            result.setBizDate(temporaryDyn.getDate("bizdate"));
            result.setPeriodId(temporaryDyn.getLong("period"));
            result.setAsstactType(temporaryDyn.getString("asstacttype"));
            result.setAsstactId(temporaryDyn.getLong("asstact"));
            result.setCurrencyId(temporaryDyn.getLong("currency"));
            result.setBaseCurrencyId(temporaryDyn.getLong("basecurrency"));
            result.setExrateTableId(temporaryDyn.getLong("exratetable"));
            result.setExchangeRate(temporaryDyn.getBigDecimal("exchangerate"));
            result.setLastExchangeRate(temporaryDyn.getBigDecimal("lastexchangerate"));
            result.setBalance(temporaryDyn.getBigDecimal("balance"));
            result.setLocalBalance(temporaryDyn.getBigDecimal("localbalance"));
            result.setCurLocalBalance(temporaryDyn.getBigDecimal("curlocalbalance"));
            result.setCurGainLoss(temporaryDyn.getBigDecimal("curgainloss"));
            result.setLastGainLoss(temporaryDyn.getBigDecimal("lastgainloss"));
            result.setGainLoss(temporaryDyn.getBigDecimal("gainloss"));
            DynamicObjectCollection entries = temporaryDyn.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                AdjExchBillEntryVO entriesResult = new AdjExchBillEntryVO();
                entriesResult.setMaterialId(entry.getLong("e_material"));
                entriesResult.setSrcBillId(entry.getLong("e_srcbillid"));
                entriesResult.setSrcEntryId(entry.getLong("e_srcentryid"));
                entriesResult.setBalance(entry.getBigDecimal("e_balance"));
                entriesResult.setLocalBalance(entry.getBigDecimal("e_localbalance"));
                entriesResult.setCurLocalBalance(entry.getBigDecimal("e_curlocalbalance"));
                entriesResult.setCurGainLoss(entry.getBigDecimal("e_curgainloss"));
                entriesResult.setLastGainLoss(entry.getBigDecimal("e_lastgainloss"));
                entriesResult.setGainLoss(entry.getBigDecimal("e_gainloss"));
                result.getEntries().add(entriesResult);
            }
            vos.add(result);
        }
        long end = System.currentTimeMillis();
        logger.info("gainLossDyn2VO spend:" + (end - start));
        return vos;
    }

    public static List<List<Object>> splitList(List<Object> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(8);
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<Object> subList = list.subList(i * len, Math.min((i + 1) * len, size));
            result.add(subList);
        }
        return result;
    }

    public static String getAdjExchBillEntityName(boolean isAr) {
        if (isAr) {
            return AR_ADJENTITYKEY;
        }
        return ADJENTITYKEY;
    }

    public static BigDecimal calculateAmtLocal(BigDecimal balance, BigDecimal exchangeRate, int precision, String quotation) {
        if ("1".equals(quotation)) {
            return balance.divide(exchangeRate, precision, 4);
        }
        return balance.multiply(exchangeRate).setScale(precision, 4);
    }

    public static Set<BillFieldMappingVO> getBillFieldMapping(String srcBillEntity, String targetBillEntity) {
        QFilter entityFilter = new QFilter("srcbillentity", "=", (Object)srcBillEntity);
        entityFilter.and(new QFilter("targetbillentity", "=", (Object)targetBillEntity));
        DynamicObjectCollection billFieldMapping = QueryServiceHelper.query((String)AP_BILLFIELDMAPPING, (String)"srcbillentity,entry.e_srcfield,entry.e_srcfieldsite,targetbillentity,entry.e_targetfield,entry.e_targetfieldsite", (QFilter[])new QFilter[]{entityFilter});
        List<IDataEntityProperty> srcProperties = EntityMetadataUtils.getProperties(srcBillEntity);
        Set srcPropField = srcProperties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        List<IDataEntityProperty> targetProperties = EntityMetadataUtils.getProperties(targetBillEntity);
        Set targetPropField = targetProperties.stream().map(IMetadata::getName).collect(Collectors.toSet());
        HashSet<BillFieldMappingVO> mappingVOSet = new HashSet<BillFieldMappingVO>(8);
        for (DynamicObject fieldMapping : billFieldMapping) {
            BillFieldMappingVO mappingVO = new BillFieldMappingVO();
            String srcField = fieldMapping.getString("entry.e_srcfield");
            String targetField = fieldMapping.getString("entry.e_targetfield");
            if (!srcPropField.contains(srcField) || !targetPropField.contains(targetField)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u5b57\u6bb5\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002%1$s:(%2$s)\uff0c%3$s:(%4$s)", (String)"AdjustExchHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), srcBillEntity, srcField, targetBillEntity, targetField));
            }
            mappingVO.setSrcBillEntity(srcBillEntity);
            mappingVO.setSrcField(srcField);
            mappingVO.setSrcFieldSite(fieldMapping.getString("entry.e_srcfieldsite"));
            mappingVO.setTargetBillEntity(targetBillEntity);
            mappingVO.setTargetField(targetField);
            mappingVO.setTargetFieldSite(fieldMapping.getString("entry.e_targetfieldsite"));
            mappingVOSet.add(mappingVO);
        }
        return mappingVOSet;
    }
}

