/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.adjustexch.AdjExchBillHandlerFactory;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.service.adjustexch.BillHandler;
import kd.fi.arapcommon.service.adjustexch.IAdjustExchange;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.AdjExchBillEntryVO;
import kd.fi.arapcommon.vo.adjexch.AdjExchBillVO;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeContext;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeResult;
import kd.fi.arapcommon.vo.adjexch.CalculateVO;
import kd.fi.arapcommon.vo.adjexch.CommonBillVO;

public class AdjustExchangeService
implements IAdjustExchange {
    protected static final Log logger = LogFactory.getLog(AdjustExchangeService.class);
    protected String bizSystem = "";
    protected long orgId = 0L;
    protected boolean isPeroid = false;
    protected Long periodId = 0L;
    protected AdjustExchangeContext context = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdjustExchangeResult adjustExchange(String bizSystem, long orgId, boolean isPeroid, Long adjExchperiodId, Map<String, BigDecimal> rateMap, Map<String, String> quotationMap) {
        this.bizSystem = bizSystem;
        this.orgId = orgId;
        this.isPeroid = isPeroid;
        this.periodId = adjExchperiodId;
        HashSet<Long> keySet = new HashSet<Long>(1);
        try {
            long mutexKey = this.isAr() ? (long)"arAdjustexch".hashCode() : (long)"apAdjustexch".hashCode();
            keySet.add(mutexKey += orgId);
            MutexLockHelper.requireMutex("ap_adjexchbill", keySet, "tbladjustexch", ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6b63\u5728\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"AdjustExchangeService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            AdjustExchangeResult result = new AdjustExchangeResult();
            String errorMsg = this.validate();
            if (errorMsg != null) {
                result.setSuccess(false);
                result.setErrorMsg(errorMsg);
                AdjustExchangeResult adjustExchangeResult = result;
                return adjustExchangeResult;
            }
            this.context = new AdjustExchangeContext(bizSystem, orgId, isPeroid, adjExchperiodId, rateMap, quotationMap);
            List<BillHandler> billHandlers = this.getBillHandlers();
            if (!billHandlers.isEmpty()) {
                this.deleteDatas(bizSystem, orgId, this.context.getPeriodId());
                for (BillHandler billHandler : billHandlers) {
                    billHandler.context = this.context;
                    BigDecimal gainloss = this.adjustExchangeByBill(billHandler);
                    result.setTotalgainloss(result.getTotalgainloss().add(gainloss));
                }
            }
            result.setPeriodId(this.context.getPeriodId());
            AdjustExchangeResult adjustExchangeResult = result;
            return adjustExchangeResult;
        }
        catch (Exception e) {
            AdjustExchangeResult result = new AdjustExchangeResult();
            result.setSuccess(false);
            result.setErrorMsg(e.getMessage());
            AdjustExchangeResult adjustExchangeResult = result;
            return adjustExchangeResult;
        }
        finally {
            logger.info("--------\u5b9e\u4f53\u540d\uff1aap_adjexchbill\uff0c\u91ca\u653e\u4e92\u65a5\u9501--------");
            MutexLockHelper.batchRelease("ap_adjexchbill", keySet, "tbladjustexch");
        }
    }

    public BigDecimal adjustExchangeByBill(BillHandler billHandler) {
        billHandler.initBillFieldMappingVOMap();
        List<CommonBillVO> billIds = billHandler.getBillIds();
        Map<Object, CalculateVO> processBillData = billHandler.getProcessBills();
        Map<Object, AdjExchBillEntryVO> lastAdjExchBillData = billHandler.getLastAdjExchBills(billHandler.getEntityKey());
        BigDecimal gainLoss = BigDecimal.ZERO;
        if (billIds.isEmpty()) {
            gainLoss = gainLoss.add(this.batchAdjustExchange(billHandler.getMappingMap(), new HashMap<Object, CalculateVO>(8), processBillData, lastAdjExchBillData, true));
        }
        for (int i = 0; i < billIds.size(); i += this.context.getBillCount()) {
            boolean lastTime = i + this.context.getBillCount() > billIds.size();
            List<CommonBillVO> subBillIds = billIds.subList(i, lastTime ? billIds.size() : i + this.context.getBillCount());
            Map<Object, CalculateVO> BillData = billHandler.getBills(subBillIds);
            gainLoss = gainLoss.add(this.batchAdjustExchange(billHandler.getMappingMap(), BillData, processBillData, lastAdjExchBillData, lastTime));
        }
        return gainLoss;
    }

    private String validate() {
        InitHelper init = new InitHelper(this.orgId, "AR".equals(this.bizSystem) ? "ar_init" : "ap_init");
        if (init.getInitId() == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u7ec4\u7ec7\u8fdb\u884c\u521d\u59cb\u5316\u8bbe\u7f6e\u3002", (String)"AdjustExchangeService_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        if (init.getCurperiodId() == null) {
            return ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5f53\u524d\u7ec4\u7ec7\u7684\u671f\u95f4\u3002", (String)"AdjustExchangeService_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        QFilter exitFilter = new QFilter("period.id", "=", init.getCurperiodId());
        exitFilter.and(new QFilter("org.id", "=", (Object)this.orgId));
        exitFilter.and(new QFilter("bizsystem", "=", (Object)this.bizSystem));
        QFilter isVoucherFilter = new QFilter("isvoucher", "=", (Object)Boolean.TRUE);
        boolean isVoucher = QueryServiceHelper.exists((String)(this.isAr() ? "ar_adjustexchbill" : "ap_adjexchbill"), (QFilter[])new QFilter[]{exitFilter, isVoucherFilter});
        if (isVoucher) {
            return ResManager.loadKDString((String)"\u672c\u671f\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u8c03\u6c47\u5355\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u91cd\u8bd5\u3002", (String)"AdjustExchangeService_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        return null;
    }

    protected BigDecimal batchAdjustExchange(Map<String, List<Long>> mappingMap, Map<Object, CalculateVO> BillData, Map<Object, CalculateVO> processBillData, Map<Object, AdjExchBillEntryVO> lastAdjExchBillData, boolean lastTime) {
        ArrayList<AdjExchBillVO> gainLossVOs;
        List<DynamicObject> gainLossBills;
        this.correctAllBillVO(BillData, processBillData);
        HashMap<Object, AdjExchBillVO> adjExchBillVOMap = new HashMap<Object, AdjExchBillVO>(BillData.size());
        for (Map.Entry<Object, CalculateVO> allBillVOEntry : BillData.entrySet()) {
            Object key = allBillVOEntry.getKey();
            CalculateVO billVO = allBillVOEntry.getValue();
            AdjExchBillVO adjExchBillVO = this.buildAdjExchBillVO(billVO);
            AdjExchBillEntryVO adjExchBillEntryVO = this.buildAdjExchBillEntryVO(billVO);
            AdjExchBillEntryVO lastAdjExchBillVO = lastAdjExchBillData.get(key);
            if (lastAdjExchBillVO != null) {
                adjExchBillEntryVO.setLastGainLoss(lastAdjExchBillVO.getCurGainLoss());
                lastAdjExchBillData.remove(key);
            }
            adjExchBillEntryVO.calculateGainloss();
            this.sumAdjExchEntry(adjExchBillVO, adjExchBillEntryVO);
            adjExchBillVO.getEntries().add(adjExchBillEntryVO);
            this.mergeAdjExchBillVOMap(adjExchBillVOMap, adjExchBillVO);
        }
        this.handleUnexpectEntry(adjExchBillVOMap, mappingMap, lastAdjExchBillData);
        if (lastTime) {
            this.writeOffLastGainLossBill(adjExchBillVOMap, lastAdjExchBillData);
            mappingMap.clear();
        }
        if (EmptyUtils.isEmpty(gainLossBills = AdjustExchHelper.gainLossVO2Dyn(gainLossVOs = new ArrayList<AdjExchBillVO>(adjExchBillVOMap.values())))) {
            return BigDecimal.ZERO;
        }
        this.saveAdjExchBill(gainLossBills);
        return this.countGainloss(gainLossVOs);
    }

    private void saveAdjExchBill(List<DynamicObject> gainLossBills) {
        try (TXHandle tx = TX.requiresNew((String)"AdjustExch");){
            try {
                DynamicObject[] gainLossBillArr = gainLossBills.toArray(new DynamicObject[0]);
                Object[] saveResultArr = SaveServiceHelper.save((DynamicObject[])gainLossBillArr);
                Object[] pkArr = new Object[saveResultArr.length];
                for (int i = 0; i < saveResultArr.length; ++i) {
                    pkArr[i] = ((DynamicObject)saveResultArr[i]).getPkValue();
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                option.setVariableValue("WF", "false");
                option.setVariableValue("mutex_writeback", "false");
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ap_adjexchbill", (Object[])pkArr, (OperateOption)option);
                if (!auditResult.isSuccess()) {
                    OperationHelper.assertResult(auditResult);
                }
                this.pushJournal(gainLossBillArr);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("AdjustExchangeService", String.format(ResManager.loadKDString((String)"\u8c03\u6c47\u5355\u4fdd\u5b58\u5931\u8d25%s\u3002", (String)"AdjustExchangeService_4", (String)"fi-arapcommon", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
    }

    private BigDecimal countGainloss(List<AdjExchBillVO> gainLossVOs) {
        BigDecimal result = new BigDecimal(0);
        for (AdjExchBillVO gainLossData : gainLossVOs) {
            result = result.add(gainLossData.getGainLoss());
        }
        return result;
    }

    protected void pushJournal(DynamicObject[] gainLossBillArr) {
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(gainLossBillArr);
    }

    private AdjExchBillEntryVO buildAdjExchBillEntryVO(CalculateVO billVO) {
        AdjExchBillEntryVO adjExchBillEntryVO = new AdjExchBillEntryVO();
        adjExchBillEntryVO.setSrcEntryId(billVO.getBillEntryId());
        adjExchBillEntryVO.setSrcBillId(billVO.getBillId());
        adjExchBillEntryVO.setExpenseItemId(billVO.getExpenseItemId());
        adjExchBillEntryVO.setProjectId(billVO.getProjectId());
        adjExchBillEntryVO.setMaterialId(billVO.getMaterialId());
        adjExchBillEntryVO.setBalance(billVO.getBalance());
        adjExchBillEntryVO.setLocalBalance(billVO.getLocalBalance());
        if ("0".equals(billVO.getQuotation())) {
            adjExchBillEntryVO.setCurLocalBalance(billVO.getBalance().multiply(billVO.getCurExchangeRate()).setScale(this.context.getPrecision(), 4));
        } else {
            adjExchBillEntryVO.setCurLocalBalance(billVO.getBalance().divide(billVO.getCurExchangeRate(), this.context.getPrecision(), 4));
        }
        adjExchBillEntryVO.setEntryMap(billVO.getEntryMap());
        return adjExchBillEntryVO;
    }

    private AdjExchBillVO buildAdjExchBillVO(CalculateVO billVO) {
        AdjExchBillVO adjExchBillVO = new AdjExchBillVO();
        adjExchBillVO.setBizSystem(this.context.getBizSystem());
        adjExchBillVO.setBizDate(this.context.getEndDate());
        adjExchBillVO.setOrgId(this.context.getOrgId());
        adjExchBillVO.setPeriodId(this.context.getPeriodId());
        adjExchBillVO.setBaseCurrencyId(this.context.getStandardCurrencyId());
        adjExchBillVO.setIncludeEntry(Boolean.TRUE);
        adjExchBillVO.setSourceBillType(billVO.getBillType());
        adjExchBillVO.setSourceBillDate(billVO.getBizDate());
        adjExchBillVO.setSourceBillId(String.valueOf(billVO.getBillId()));
        adjExchBillVO.setBillNo(billVO.getBillNo());
        adjExchBillVO.setAsstactType(billVO.getAsstactType());
        adjExchBillVO.setAsstactId(billVO.getAsstactId());
        adjExchBillVO.setExrateTableId(billVO.getExrateTableId());
        adjExchBillVO.setCurrencyId(billVO.getCurrencyId());
        adjExchBillVO.setDepartmentId(billVO.getDepartmentId());
        adjExchBillVO.setRemark(billVO.getRemark());
        adjExchBillVO.setExchangeRate(billVO.getCurExchangeRate());
        adjExchBillVO.setLastExchangeRate(billVO.getExchangeRate());
        adjExchBillVO.setQuotation(billVO.getQuotation());
        adjExchBillVO.setSrcBillQuotation(billVO.getSrcBillQuotation());
        adjExchBillVO.setBillMap(billVO.getBillMap());
        return adjExchBillVO;
    }

    protected AdjExchBillVO writeOffGainLossBill(AdjExchBillEntryVO lastAdjExchBillEntryVO) {
        AdjExchBillVO adjExchBillVO = new AdjExchBillVO();
        adjExchBillVO.setBizSystem(this.context.getBizSystem());
        adjExchBillVO.setBizDate(this.context.getEndDate());
        adjExchBillVO.setOrgId(this.context.getOrgId());
        adjExchBillVO.setPeriodId(this.context.getPeriodId());
        adjExchBillVO.setBaseCurrencyId(this.context.getStandardCurrencyId());
        adjExchBillVO.setIncludeEntry(lastAdjExchBillEntryVO.getIncludeEntry());
        adjExchBillVO.setSourceBillType(lastAdjExchBillEntryVO.getSourceBillType());
        adjExchBillVO.setSourceBillId(String.valueOf(lastAdjExchBillEntryVO.getSrcBillId()));
        adjExchBillVO.setBillNo(lastAdjExchBillEntryVO.getBillNo());
        adjExchBillVO.setAsstactType(lastAdjExchBillEntryVO.getAsstactType());
        adjExchBillVO.setAsstactId(lastAdjExchBillEntryVO.getAsstactId());
        adjExchBillVO.setSourceBillDate(lastAdjExchBillEntryVO.getSourceBillDate());
        adjExchBillVO.setExrateTableId(lastAdjExchBillEntryVO.getExrateTableId());
        adjExchBillVO.setCurrencyId(lastAdjExchBillEntryVO.getCurrencyId());
        adjExchBillVO.setDepartmentId(lastAdjExchBillEntryVO.getDepartmentId());
        adjExchBillVO.setRemark(lastAdjExchBillEntryVO.getRemark());
        adjExchBillVO.setQuotation(lastAdjExchBillEntryVO.getQuotation());
        adjExchBillVO.setSrcBillQuotation(lastAdjExchBillEntryVO.getSrcBillQuotation());
        adjExchBillVO.setExchangeRate(this.getCurExchangeRate(adjExchBillVO.getBillNo(), lastAdjExchBillEntryVO.getExrateTableId(), lastAdjExchBillEntryVO.getCurrencyId(), lastAdjExchBillEntryVO.getQuotation()));
        adjExchBillVO.setLastExchangeRate(lastAdjExchBillEntryVO.getLastExchangeRate());
        adjExchBillVO.setBillMap(lastAdjExchBillEntryVO.getBillMap());
        AdjExchBillEntryVO adjExchBillEntryVO = new AdjExchBillEntryVO();
        adjExchBillEntryVO.setLastGainLoss(lastAdjExchBillEntryVO.getCurGainLoss());
        adjExchBillEntryVO.setSrcEntryId(lastAdjExchBillEntryVO.getSrcEntryId());
        adjExchBillEntryVO.setSrcBillId(lastAdjExchBillEntryVO.getSrcBillId());
        adjExchBillEntryVO.setExpenseItemId(lastAdjExchBillEntryVO.getExpenseItemId());
        adjExchBillEntryVO.setProjectId(lastAdjExchBillEntryVO.getProjectId());
        adjExchBillEntryVO.setMaterialId(lastAdjExchBillEntryVO.getMaterialId());
        adjExchBillEntryVO.setBalance(BigDecimal.ZERO);
        adjExchBillEntryVO.setLocalBalance(BigDecimal.ZERO);
        adjExchBillEntryVO.setCurLocalBalance(BigDecimal.ZERO);
        adjExchBillEntryVO.setEntryMap(lastAdjExchBillEntryVO.getEntryMap());
        adjExchBillEntryVO.calculateGainloss();
        this.sumAdjExchEntry(adjExchBillVO, adjExchBillEntryVO);
        adjExchBillVO.getEntries().add(adjExchBillEntryVO);
        return adjExchBillVO;
    }

    private void handleUnexpectEntry(Map<Object, AdjExchBillVO> adjExchBillVOMap, Map<String, List<Long>> mappingMap, Map<Object, AdjExchBillEntryVO> lastAdjExchBillData) {
        for (Map.Entry<Object, AdjExchBillVO> adjExchBillVOEntry : adjExchBillVOMap.entrySet()) {
            AdjExchBillVO adjExchBillVO = adjExchBillVOEntry.getValue();
            String sourceBillId = adjExchBillVO.getSourceBillId();
            List<Long> entryIds = mappingMap.get(sourceBillId);
            if (!EmptyUtils.isNotEmpty(entryIds)) continue;
            for (Long entryId : entryIds) {
                AdjExchBillEntryVO adjExchBillEntryVO = lastAdjExchBillData.get(entryId);
                if (!EmptyUtils.isNotEmpty(adjExchBillEntryVO)) continue;
                AdjExchBillVO billVO = this.writeOffGainLossBill(adjExchBillEntryVO);
                this.mergeAdjExchBillVOMap(adjExchBillVOMap, billVO);
                lastAdjExchBillData.remove(entryId);
            }
        }
    }

    protected Map<Object, AdjExchBillVO> writeOffLastGainLossBill(Map<Object, AdjExchBillVO> adjExchBillVOMap, Map<Object, AdjExchBillEntryVO> lastGainLossVOMap) {
        for (Map.Entry<Object, AdjExchBillEntryVO> exchBillVOEntry : lastGainLossVOMap.entrySet()) {
            AdjExchBillEntryVO lastAdjExchBillEntryVO = exchBillVOEntry.getValue();
            this.mergeAdjExchBillVOMap(adjExchBillVOMap, this.writeOffGainLossBill(lastAdjExchBillEntryVO));
        }
        return adjExchBillVOMap;
    }

    private void deleteDatas(String bizSystem, long orgId, Long periodId) {
        QFilter dateFilter;
        QFilter bizFilter;
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject[] adjExchBill = BusinessDataServiceHelper.load((String)"ap_adjexchbill", (String)"id", (QFilter[])new QFilter[]{orgFilter, bizFilter = new QFilter("bizsystem", "=", (Object)bizSystem), dateFilter = new QFilter("period", "=", (Object)periodId)});
        if (EmptyUtils.isNotEmpty(adjExchBill)) {
            Object[] adjExchBillIds = (Long[])Arrays.stream(adjExchBill).map(bill -> bill.getLong("id")).toArray(Long[]::new);
            JournalService journalService = new JournalService();
            journalService.deleteJournals(this.isAr() ? "ar_adjustexchbill" : "ap_adjexchbill", (Long[])adjExchBillIds);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ap_adjexchbill", (Object[])adjExchBillIds, (OperateOption)option);
            logger.info("----- \u5220\u9664\u8c03\u6c47\u5355\uff1a\u7ec4\u7ec7\uff1a%s\uff0c\u671f\u95f4\uff1a%s\uff0c\u4e1a\u52a1\uff1a%s ------ ", new Object[]{orgId, periodId, bizSystem});
            if (!deleteResult.isSuccess()) {
                logger.info("------adjexchbill:operationResult.Message------" + deleteResult.getMessage());
                OperationHelper.assertResult(deleteResult);
            }
        }
    }

    protected void correctAllBillVO(Map<Object, CalculateVO> allBillVOMap, Map<Object, CalculateVO> processBillVOMap) {
        for (Map.Entry<Object, CalculateVO> processBillVOEntry : processBillVOMap.entrySet()) {
            CalculateVO processBillVO = processBillVOEntry.getValue();
            Object processBillVOEntryKey = processBillVOEntry.getKey();
            CalculateVO billVO = allBillVOMap.get(processBillVOEntryKey);
            if (billVO == null) continue;
            if (processBillVO.getBillType().contains("settle")) {
                billVO.setBalance(billVO.getBalance().add(processBillVO.getBalance()));
                billVO.setLocalBalance(billVO.getLocalBalance().add(processBillVO.getLocalBalance()));
            } else {
                billVO.setBalance(billVO.getBalance().subtract(processBillVO.getBalance()));
                billVO.setLocalBalance(billVO.getLocalBalance().subtract(processBillVO.getLocalBalance()));
            }
            if (!"ap_paidbill".equals(billVO.getBillType()) && !"ar_receivedbill".equals(billVO.getBillType())) continue;
            if ("0".equals(billVO.getSrcBillQuotation())) {
                billVO.setLocalBalance(billVO.getBalance().multiply(billVO.getExchangeRate()).setScale(this.context.getPrecision(), 4));
                continue;
            }
            billVO.setLocalBalance(billVO.getBalance().divide(billVO.getExchangeRate(), this.context.getPrecision(), 4));
        }
    }

    private void sumAdjExchEntry(AdjExchBillVO billVO, AdjExchBillEntryVO entryVO) {
        billVO.setBalance(billVO.getBalance().add(entryVO.getBalance()));
        billVO.setLocalBalance(billVO.getLocalBalance().add(entryVO.getLocalBalance()));
        billVO.setCurLocalBalance(billVO.getCurLocalBalance().add(entryVO.getCurLocalBalance()));
        billVO.setGainLoss(billVO.getGainLoss().add(entryVO.getGainLoss()));
        billVO.setCurGainLoss(billVO.getCurGainLoss().add(entryVO.getCurGainLoss()));
        billVO.setLastGainLoss(billVO.getLastGainLoss().add(entryVO.getLastGainLoss()));
    }

    private void mergeAdjExchBillVOMap(Map<Object, AdjExchBillVO> adjExchBillVOMap, AdjExchBillVO gainLossVO) {
        AdjExchBillVO adjExchBillVO = adjExchBillVOMap.get(gainLossVO.getSourceBillId());
        if (adjExchBillVO != null) {
            AdjExchBillEntryVO adjExchBillEntryVO = gainLossVO.getEntries().get(0);
            adjExchBillVO.getEntries().add(adjExchBillEntryVO);
            this.sumAdjExchEntry(adjExchBillVO, adjExchBillEntryVO);
        } else {
            adjExchBillVOMap.put(gainLossVO.getSourceBillId(), gainLossVO);
        }
    }

    protected BigDecimal getCurExchangeRate(String billNo, Long exratetableId, Long currencyId, String quotation) {
        StringBuilder exchangeRateMapKey = new StringBuilder();
        exchangeRateMapKey.append(currencyId);
        BigDecimal exchangeRate = this.context.getExchangeRateMap().get(exchangeRateMapKey.toString());
        if (exchangeRate != null) {
            return exchangeRate;
        }
        exchangeRate = BaseDataHelper.getExchangeRate(exratetableId, currencyId, this.context.getStandardCurrencyId(), quotation, this.context.getEndDate());
        if (exchangeRate == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u7ef4\u62a4\u6c47\u7387\u7684\u5e01\u79cd\uff1a%s\u3002", (String)"AdjustExchangeService_5", (String)"fi-arapcommon", (Object[])new Object[0]), billNo));
        }
        this.context.getExchangeRateMap().put(exchangeRateMapKey.toString(), exchangeRate);
        return exchangeRate;
    }

    private boolean isAr() {
        return "AR".equals(this.bizSystem);
    }

    private List<BillHandler> getBillHandlers() {
        ArrayList<BillHandler> billHandlers = new ArrayList<BillHandler>(8);
        boolean isAr = this.isAr();
        AdjExchBillHandlerFactory adjExchBillHandlerFactory = new AdjExchBillHandlerFactory();
        if (isAr) {
            billHandlers.add(adjExchBillHandlerFactory.getHandler("ar_finarbill"));
            billHandlers.add(adjExchBillHandlerFactory.getHandler("ar_busbill"));
            if (this.context.isIncludeCas()) {
                billHandlers.add(adjExchBillHandlerFactory.getHandler("ar_receivedbill"));
                billHandlers.add(adjExchBillHandlerFactory.getHandler("cas_recbill"));
            }
        } else {
            billHandlers.add(adjExchBillHandlerFactory.getHandler("ap_finapbill"));
            billHandlers.add(adjExchBillHandlerFactory.getHandler("ap_busbill"));
            if (this.context.isIncludeCas()) {
                billHandlers.add(adjExchBillHandlerFactory.getHandler("ap_paidbill"));
                billHandlers.add(adjExchBillHandlerFactory.getHandler("cas_paybill"));
            }
        }
        billHandlers.addAll(AdjExchBillHandlerFactory.getExtBillHandler(AdjustExchHelper.getExtBillEntity(isAr)));
        return billHandlers;
    }
}

