/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.AdjExchBillEntryVO;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeContext;
import kd.fi.arapcommon.vo.adjexch.BillFieldMappingVO;
import kd.fi.arapcommon.vo.adjexch.CalculateVO;
import kd.fi.arapcommon.vo.adjexch.CommonBillVO;
import org.apache.commons.lang.StringUtils;

public abstract class BillHandler {
    protected static final Log logger = LogFactory.getLog(BillHandler.class);
    protected static final String AR_ADJENTITYKEY = "ar_adjustexchbill";
    protected static final String ADJENTITYKEY = "ap_adjexchbill";
    protected AdjustExchangeContext context = null;
    protected List<CalculateVO> inverseBills = new ArrayList<CalculateVO>(8);
    protected Map<String, List<Long>> mappingMap = new HashMap<String, List<Long>>(16);
    protected Map<String, Set<BillFieldMappingVO>> billFieldMappingVOMap = new HashMap<String, Set<BillFieldMappingVO>>(16);

    public BillHandler() {
    }

    public BillHandler(AdjustExchangeContext context) {
        this.context = context;
        this.initBillFieldMappingVOMap();
    }

    public abstract List<CommonBillVO> getBillIds();

    public abstract Map<Object, CalculateVO> getBills(List<CommonBillVO> var1);

    public abstract Map<Object, CalculateVO> getProcessBills();

    public List<String> getSelector() {
        List<String> selector = this.getOriginSelector();
        String entityKey = this.getEntityKey();
        for (BillFieldMappingVO vo : this.billFieldMappingVOMap.get(entityKey)) {
            if (entityKey.equals(vo.getSrcFieldSite())) {
                selector.add(vo.getSrcField());
                continue;
            }
            selector.add(vo.getSrcFieldSite() + "." + vo.getSrcField());
        }
        return selector.stream().distinct().collect(Collectors.toList());
    }

    public abstract List<String> getOriginSelector();

    protected static List<String> getBaseBillSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("exratetable");
        selector.add("exchangerate");
        selector.add("currency");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("remark");
        selector.add("department");
        selector.add("quotation");
        return selector;
    }

    protected List<String> getAdjustExchangeSelector() {
        List<String> selector = BillHandler.getBaseBillSelector();
        selector.add("sourcebilldate");
        selector.add("sourcebilltype");
        selector.add("isincludeentry");
        selector.add("lastexchangerate");
        selector.add("srcbillquotation");
        selector.add("entry.e_curgainloss");
        selector.add("entry.e_material");
        selector.add("entry.e_expenseitem");
        selector.add("entry.project");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_srcentryid");
        String entityKey = this.getEntityKey();
        boolean isAr = "AR".equals(this.context.getBizSystem());
        for (BillFieldMappingVO billFieldMappingVO : this.billFieldMappingVOMap.get(entityKey)) {
            if ((isAr ? AR_ADJENTITYKEY : ADJENTITYKEY).equals(billFieldMappingVO.getTargetFieldSite())) {
                selector.add(billFieldMappingVO.getTargetField());
                continue;
            }
            selector.add(billFieldMappingVO.getTargetFieldSite() + "." + billFieldMappingVO.getTargetField());
        }
        return selector.stream().distinct().collect(Collectors.toList());
    }

    public abstract String getEntityKey();

    public Map<String, List<Long>> getMappingMap() {
        return this.mappingMap;
    }

    public void setMappingMap(Map<String, List<Long>> mappingMap) {
        this.mappingMap = mappingMap;
    }

    public Map<Object, AdjExchBillEntryVO> getLastAdjExchBills(String entityKey) {
        HashMap<Object, AdjExchBillEntryVO> billVOMap = new HashMap<Object, AdjExchBillEntryVO>(64);
        if (this.context.getLastPeriodId() == null) {
            return billVOMap;
        }
        QFilter filter = new QFilter("org.id", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("period.id", "=", (Object)this.context.getLastPeriodId()));
        filter.and(new QFilter("bizsystem", "=", (Object)this.context.getBizSystem()));
        filter.and(new QFilter("sourcebilltype", "=", (Object)entityKey));
        filter.and(new QFilter("entry.e_curgainloss", "!=", (Object)BigDecimal.ZERO));
        String selector = StringUtils.join((Object[])this.getAdjustExchangeSelector().toArray(), (String)",");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)("AR".equals(this.context.getBizSystem()) ? AR_ADJENTITYKEY : ADJENTITYKEY), (String)selector, (QFilter[])filter.toArray(), (String)"bizdate");
        if (!dataSet.isEmpty()) {
            for (Row dataSetRow : dataSet) {
                AdjExchBillEntryVO adjExchBillEntryVO = new AdjExchBillEntryVO();
                adjExchBillEntryVO.setSourceBillType(dataSetRow.getString("sourcebilltype"));
                adjExchBillEntryVO.setMaterialId(dataSetRow.getLong("entry.e_material"));
                adjExchBillEntryVO.setExpenseItemId(dataSetRow.getLong("entry.e_expenseitem"));
                adjExchBillEntryVO.setProjectId(dataSetRow.getLong("entry.project"));
                adjExchBillEntryVO.setAsstactId(dataSetRow.getLong("asstact"));
                adjExchBillEntryVO.setAsstactType(dataSetRow.getString("asstacttype"));
                adjExchBillEntryVO.setDepartmentId(dataSetRow.getLong("department"));
                adjExchBillEntryVO.setExrateTableId(dataSetRow.getLong("exratetable"));
                adjExchBillEntryVO.setRemark(dataSetRow.getString("remark"));
                adjExchBillEntryVO.setIncludeEntry(dataSetRow.getBoolean("isincludeentry"));
                adjExchBillEntryVO.setBillNo(dataSetRow.getString("billno"));
                adjExchBillEntryVO.setSourceBillDate(dataSetRow.getDate("sourcebilldate"));
                adjExchBillEntryVO.setCurrencyId(dataSetRow.getLong("currency"));
                adjExchBillEntryVO.setCurGainLoss(dataSetRow.getBigDecimal("entry.e_curgainloss"));
                adjExchBillEntryVO.setLastExchangeRate(dataSetRow.getBigDecimal("lastexchangerate"));
                adjExchBillEntryVO.setQuotation(dataSetRow.getString("quotation"));
                adjExchBillEntryVO.setSrcBillQuotation(dataSetRow.getString("srcbillquotation"));
                Long srcentryid = dataSetRow.getLong("entry.e_srcentryid");
                adjExchBillEntryVO.setSrcEntryId(srcentryid);
                Long srcbillid = dataSetRow.getLong("entry.e_srcbillid");
                adjExchBillEntryVO.setSrcBillId(srcbillid);
                String srcbillidStr = srcbillid.toString();
                List<Long> entryIdList = this.mappingMap.get(srcbillidStr);
                if (EmptyUtils.isNotEmpty(entryIdList)) {
                    entryIdList.add(srcentryid);
                } else {
                    entryIdList = new ArrayList<Long>(1);
                    entryIdList.add(srcentryid);
                    this.mappingMap.put(srcbillidStr, entryIdList);
                }
                boolean isAr = "AR".equals(this.context.getBizSystem());
                for (BillFieldMappingVO billFieldMappingVO : this.billFieldMappingVOMap.get(entityKey)) {
                    if ((isAr ? AR_ADJENTITYKEY : ADJENTITYKEY).equals(billFieldMappingVO.getTargetFieldSite())) {
                        adjExchBillEntryVO.getBillMap().put(billFieldMappingVO.getTargetField(), dataSetRow.get(billFieldMappingVO.getTargetField()));
                        continue;
                    }
                    adjExchBillEntryVO.getEntryMap().put(billFieldMappingVO.getTargetField(), dataSetRow.get(billFieldMappingVO.getTargetFieldSite() + "." + billFieldMappingVO.getTargetField()));
                }
                billVOMap.put(srcentryid, adjExchBillEntryVO);
            }
            dataSet.close();
        }
        return billVOMap;
    }

    public List<CalculateVO> getInverseBills() {
        return this.inverseBills;
    }

    public void setInverseBills(List<CalculateVO> inverseBills) {
        this.inverseBills = inverseBills;
    }

    public BigDecimal getCurExchangeRate(String billNo, Long exratetableId, Long currencyId, String quotation) {
        StringBuilder exchangeRateMapKey = new StringBuilder();
        exchangeRateMapKey.append(currencyId);
        BigDecimal exchangeRate = this.context.getExchangeRateMap().get(exchangeRateMapKey.toString());
        if (exchangeRate != null) {
            return exchangeRate;
        }
        exchangeRate = BaseDataHelper.getExchangeRate(exratetableId, currencyId, this.context.getStandardCurrencyId(), quotation, this.context.getEndDate());
        if (exchangeRate == null) {
            logger.info(String.format("AdjustExchService -- getCurExchangeRate(exratetableId -- %s): %s (currencyId -- %s)", exratetableId, billNo, currencyId));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u7ef4\u62a4\u6c47\u7387\u7684\u7ed3\u7b97\u5e01\uff1a%s\u3002", (String)"AbsAdjustExchService_1", (String)"fi-arapcommon", (Object[])new Object[0]), billNo));
        }
        this.context.getExchangeRateMap().put(exchangeRateMapKey.toString(), exchangeRate);
        return exchangeRate;
    }

    public String getQuotation(String billNo, Long exratetableId, Long currencyId) {
        StringBuilder exchangeRateMapKey = new StringBuilder();
        exchangeRateMapKey.append(currencyId);
        String quotation = this.context.getQuotationMap().get(exchangeRateMapKey.toString());
        if (quotation != null) {
            return quotation;
        }
        Map<String, Object> exchangeRateMap = BaseDataHelper.getExchangeRateMap(exratetableId, currencyId, this.context.getStandardCurrencyId(), this.context.getEndDate());
        if (EmptyUtils.isNotEmpty(exchangeRateMap) && EmptyUtils.isNotEmpty(exchangeRateMap.get("quoteType"))) {
            String string = quotation = (Boolean)exchangeRateMap.get("quoteType") != false ? "1" : "0";
        }
        if (EmptyUtils.isEmpty(quotation)) {
            logger.info(String.format("AdjustExchService -- getQuotation(exratetableId -- %s),(billNo -- %s),(currencyId -- %s)", exratetableId, billNo, currencyId));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u7ef4\u62a4\u6362\u7b97\u65b9\u5f0f\u7684\u7ed3\u7b97\u5e01\uff1a%s", (String)"AbsAdjustExchService_2", (String)"fi-arapcommon", (Object[])new Object[0]), billNo));
        }
        this.context.getQuotationMap().put(exchangeRateMapKey.toString(), quotation);
        return quotation;
    }

    public final void initBillFieldMappingVOMap() {
        Set<BillFieldMappingVO> billFieldMappingVOS;
        String entityKey = this.getEntityKey();
        if ("AR".equals(this.context.getBizSystem())) {
            this.billFieldMappingVOMap.put(entityKey, AdjustExchHelper.getBillFieldMapping(entityKey, AR_ADJENTITYKEY));
        } else {
            this.billFieldMappingVOMap.put(entityKey, AdjustExchHelper.getBillFieldMapping(entityKey, ADJENTITYKEY));
        }
        boolean materialSettle = this.context.isMaterialSettle();
        if (("ap_finapbill".equals(entityKey) || "ar_finarbill".equals(entityKey)) && (billFieldMappingVOS = this.billFieldMappingVOMap.get(entityKey)) != null && !billFieldMappingVOS.isEmpty()) {
            Iterator<BillFieldMappingVO> iterator = billFieldMappingVOS.iterator();
            while (iterator.hasNext()) {
                BillFieldMappingVO next = iterator.next();
                String srcFieldSite = next.getSrcFieldSite();
                if ((!materialSettle || !"planentity".equals(srcFieldSite)) && (materialSettle || !"entry".equals(srcFieldSite) && !"detailentry".equals(srcFieldSite))) continue;
                iterator.remove();
            }
        }
    }

    public void extendFieldVoluation(CalculateVO vo, Row row) {
        boolean isAr = "AR".equals(this.context.getBizSystem());
        for (BillFieldMappingVO billFieldMappingVO : this.billFieldMappingVOMap.get(this.getEntityKey())) {
            if ((isAr ? AR_ADJENTITYKEY : ADJENTITYKEY).equals(billFieldMappingVO.getTargetFieldSite())) {
                vo.getBillMap().put(billFieldMappingVO.getTargetField(), row.get(billFieldMappingVO.getSrcField()));
                continue;
            }
            vo.getEntryMap().put(billFieldMappingVO.getTargetField(), row.get(billFieldMappingVO.getSrcFieldSite() + "." + billFieldMappingVO.getSrcField()));
        }
    }
}

