/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.service.adjustexch.BillHandler;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeContext;
import kd.fi.arapcommon.vo.adjexch.CalculateVO;
import kd.fi.arapcommon.vo.adjexch.CommonBillVO;
import org.apache.commons.lang.StringUtils;

public class FinArBillHandler
extends BillHandler {
    protected static final Log logger = LogFactory.getLog(FinArBillHandler.class);

    public FinArBillHandler() {
    }

    public FinArBillHandler(AdjustExchangeContext context) {
        super(context);
    }

    @Override
    public List<CommonBillVO> getBillIds() {
        ArrayList<CommonBillVO> resultOfCommonBillVOS = new ArrayList<CommonBillVO>(32);
        HashMap<Object, CommonBillVO> temporaryVOMap = new HashMap<Object, CommonBillVO>(32);
        QFilter finFilter = this.getFinFilter();
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)this.getFinIdSelector(), (QFilter[])finFilter.toArray(), (String)"");
        String settleSelector = this.getSettleSelector();
        QFilter settleMainFilter = this.getSettleMainFilter();
        Object[] settleMainDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleMainFilter.toArray());
        Set<Object> settleMainDataSetIds = this.getSettleMainDataSetIds((DynamicObject[])settleMainDatas);
        QFilter settleAssistFilter = this.getSettleAssistFilter(settleMainDataSetIds);
        Object[] settleAssistDatas = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)settleSelector, (QFilter[])settleAssistFilter.toArray());
        DynamicObject[] settleRecordArr = (DynamicObject[])ArrayUtils.addAll((Object[])settleMainDatas, (Object[])settleAssistDatas);
        Set<Object> finBillIdSet = this.getIdOrEntryIdBySettle(settleRecordArr);
        this.setInverseBills(this.convertSettleBillToVO(settleRecordArr));
        DataSet unexpectedFinDataSet = null;
        if (!finBillIdSet.isEmpty()) {
            QFilter unexpectedFinFilter = this.getUnexpectedFinFilter(finBillIdSet);
            unexpectedFinDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)this.getFinIdSelector(), (QFilter[])unexpectedFinFilter.toArray(), (String)"");
        }
        this.buildCommonBillVOByFin(finDataSet, temporaryVOMap);
        this.buildCommonBillVOByFin(unexpectedFinDataSet, temporaryVOMap);
        resultOfCommonBillVOS.addAll(new ArrayList(temporaryVOMap.values()));
        return resultOfCommonBillVOS;
    }

    @Override
    public Map<Object, CalculateVO> getBills(List<CommonBillVO> subBillIds) {
        List<String> selector = this.getSelector();
        QFilter idAndEntryIdFilter = this.getFilterByCommonBillVO(subBillIds);
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"adjustexchange", (String)this.getEntityKey(), (String)AdjustExchHelper.generateSelector(selector), (QFilter[])idAndEntryIdFilter.toArray(), (String)"bizdate");
        return this.convertFinBillToVO(finDataSet);
    }

    @Override
    public Map<Object, CalculateVO> getProcessBills() {
        HashMap<Object, CalculateVO> processBillVOMap = new HashMap<Object, CalculateVO>(64);
        List<CalculateVO> calculateVOS = this.getInverseBills();
        for (CalculateVO calculateVO : calculateVOS) {
            CalculateVO vo = (CalculateVO)processBillVOMap.get(calculateVO.getBillEntryId());
            if (vo != null) {
                vo.setBalance(vo.getBalance().add(calculateVO.getBalance()));
                vo.setLocalBalance(vo.getLocalBalance().add(calculateVO.getLocalBalance()));
                continue;
            }
            processBillVOMap.put(calculateVO.getBillEntryId(), calculateVO);
        }
        return processBillVOMap;
    }

    @Override
    public List<String> getOriginSelector() {
        List<String> selector = FinArBillHandler.getBaseBillSelector();
        if (this.context.isMaterialSettle()) {
            selector.add("entry.id");
            selector.add("entry.e_material");
            selector.add("entry.e_expenseitem");
            selector.add("entry.project");
            selector.add("entry.e_unsettleamt");
            selector.add("entry.e_unsettlelocalamt");
        } else {
            selector.add("planentity.id");
            selector.add("planentity.unplansettleamt");
            selector.add("planentity.unplansettlelocamt");
        }
        return selector;
    }

    @Override
    public String getEntityKey() {
        return "ar_finarbill";
    }

    private String getEntryIdKey() {
        return this.context.isMaterialSettle() ? "entry.id" : "planentity.id";
    }

    private String getFinIdSelector() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add("id");
        selectors.add(this.getEntryIdKey());
        return StringUtils.join(selectors, (String)",");
    }

    private QFilter getFinFilter() {
        QFilter filter;
        if (this.context.isPeriod()) {
            filter = new QFilter("org", "=", (Object)this.context.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("currency", "<>", (Object)this.context.getStandardCurrencyId()));
            filter.and(new QFilter("isperiod", "=", (Object)Boolean.TRUE));
            if (this.context.isMaterialSettle()) {
                filter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            } else {
                filter.and(new QFilter("planentity.unplansettleamt", "<>", (Object)0));
            }
        } else {
            filter = new QFilter("org", "=", (Object)this.context.getOrgId());
            filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
            filter.and(new QFilter("bookdate", "<=", (Object)this.context.getEndDate()));
            filter.and(new QFilter("currency", "<>", (Object)this.context.getStandardCurrencyId()));
            if (this.context.isMaterialSettle()) {
                filter.and(new QFilter("entry.e_unsettleamt", "<>", (Object)0));
            } else {
                filter.and(new QFilter("planentity.unplansettleamt", "<>", (Object)0));
            }
        }
        return filter;
    }

    private String getSettleSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("billentity");
        selector.add("settledate");
        selector.add("totalsettleamt");
        selector.add("localtotalsettleamt");
        selector.add("mainbillid");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("entry.e_billentity");
        selector.add("entry.settleamt");
        selector.add("entry.localsettleamt");
        selector.add("entry.billid");
        selector.add("entry.billentryid");
        return StringUtils.join((Object[])selector.toArray(), (String)",");
    }

    private QFilter getSettleMainFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("settledate", ">", (Object)this.context.getEndDate()));
        filter.and(new QFilter("billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("mainbizdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("maincurrency", "<>", (Object)this.context.getStandardCurrencyId()));
        return filter;
    }

    private Set<Object> getSettleMainDataSetIds(DynamicObject[] settleMainDatas) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (EmptyUtils.isNotEmpty(settleMainDatas)) {
            for (DynamicObject data : settleMainDatas) {
                Object billId = data.getPkValue();
                set.add(billId);
            }
        }
        return set;
    }

    private QFilter getSettleAssistFilter(Set<Object> settleMainDataSetIds) {
        QFilter filter = new QFilter("org", "=", (Object)this.context.getOrgId());
        filter.and(new QFilter("id", "not in", settleMainDataSetIds));
        filter.and(new QFilter("settledate", ">", (Object)this.context.getEndDate()));
        filter.and(new QFilter("entry.e_billentity", "=", (Object)this.getEntityKey()));
        filter.and(new QFilter("entry.billdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("entry.currency", "<>", (Object)this.context.getStandardCurrencyId()));
        return filter;
    }

    private Set<Object> getIdOrEntryIdBySettle(DynamicObject[] settleRecordArr) {
        HashSet<Object> billIdSet = new HashSet<Object>();
        for (DynamicObject settleRecord : settleRecordArr) {
            if ("ar_finarbill".equals(settleRecord.get("billentity"))) {
                billIdSet.add(settleRecord.get("mainbillentryid"));
            }
            ArrayList<String> notParticipateSettleRelation = new ArrayList<String>(3);
            notParticipateSettleRelation.add(SettleRelationEnum.PAYTRANS.getValue());
            notParticipateSettleRelation.add(SettleRelationEnum.ARTRANSFER.getValue());
            notParticipateSettleRelation.add(SettleRelationEnum.PREMSETTLE.getValue());
            if (notParticipateSettleRelation.contains(settleRecord.getString("settlerelation"))) continue;
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                if (!"ar_finarbill".equals(entry.get("e_billentity"))) continue;
                billIdSet.add(entry.get("billentryid"));
            }
        }
        return billIdSet;
    }

    private List<CalculateVO> convertSettleBillToVO(DynamicObject[] settleRecordArr) {
        ArrayList<CalculateVO> voList = new ArrayList<CalculateVO>();
        if (settleRecordArr != null) {
            for (DynamicObject bill : settleRecordArr) {
                if ("ar_finarbill".equals(bill.get("billentity"))) {
                    CalculateVO vo = new CalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(bill.getLong("mainbillid"));
                    vo.setBillEntryId(bill.getLong("mainbillentryid"));
                    vo.setBalance(bill.getBigDecimal("totalsettleamt"));
                    vo.setLocalBalance(bill.getBigDecimal("localtotalsettleamt"));
                    voList.add(vo);
                }
                ArrayList<String> notParticipateSettleRelation = new ArrayList<String>(3);
                notParticipateSettleRelation.add(SettleRelationEnum.PAYTRANS.getValue());
                notParticipateSettleRelation.add(SettleRelationEnum.ARTRANSFER.getValue());
                notParticipateSettleRelation.add(SettleRelationEnum.PREMSETTLE.getValue());
                if (notParticipateSettleRelation.contains(bill.getString("settlerelation"))) continue;
                DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    if (!"ar_finarbill".equals(entry.get("e_billentity"))) continue;
                    CalculateVO vo = new CalculateVO();
                    vo.setBillType("ap_settlerecord");
                    vo.setBillId(entry.getLong("billid"));
                    vo.setBillEntryId(entry.getLong("billentryid"));
                    vo.setBalance(entry.getBigDecimal("settleamt"));
                    vo.setLocalBalance(entry.getBigDecimal("localsettleamt"));
                    voList.add(vo);
                }
            }
        }
        return voList;
    }

    private QFilter getUnexpectedFinFilter(Set<Object> finBillIdSet) {
        QFilter filter = new QFilter(this.getEntryIdKey(), "in", finBillIdSet);
        filter.and(new QFilter("bookdate", "<=", (Object)this.context.getEndDate()));
        filter.and(new QFilter("org", "=", (Object)this.context.getOrgId()));
        return filter;
    }

    private List<CommonBillVO> buildCommonBillVOByFin(DataSet finDataSet, Map<Object, CommonBillVO> temporaryVOMap) {
        if (EmptyUtils.isNotEmpty(finDataSet)) {
            String idKey = this.getEntryIdKey();
            for (Row row : finDataSet) {
                Object billId = row.get("id");
                Object entryId = row.get(idKey);
                if (EmptyUtils.isEmpty(temporaryVOMap.get(billId))) {
                    CommonBillVO commonBillVO = new CommonBillVO(Long.parseLong(billId.toString()));
                    commonBillVO.getEntryIds().add(Long.parseLong(entryId.toString()));
                    temporaryVOMap.put(billId, commonBillVO);
                    continue;
                }
                temporaryVOMap.get(billId).getEntryIds().add(Long.parseLong(entryId.toString()));
            }
        }
        return new ArrayList<CommonBillVO>(temporaryVOMap.values());
    }

    private QFilter getFilterByCommonBillVO(List<CommonBillVO> subbillids) {
        HashSet<Long> idSet = new HashSet<Long>(subbillids.size());
        HashSet<Long> entryIdSet = new HashSet<Long>(subbillids.size());
        for (CommonBillVO commonBillVO : subbillids) {
            idSet.add(commonBillVO.getId());
            entryIdSet.addAll(commonBillVO.getEntryIds());
        }
        QFilter filter = new QFilter("id", "in", idSet);
        filter.and(new QFilter(this.getEntryIdKey(), "in", entryIdSet));
        return filter;
    }

    private Map<Object, CalculateVO> convertFinBillToVO(DataSet finDataSet) {
        HashMap<Object, CalculateVO> billVOMap = new HashMap<Object, CalculateVO>(64);
        if (finDataSet != null) {
            for (Row row : finDataSet) {
                CalculateVO vo = new CalculateVO();
                vo.setBillType("ar_finarbill");
                vo.setBillId(row.getLong("id"));
                vo.setBillEntryId(row.getLong(this.getEntryIdKey()));
                vo.setBillNo(row.getString("billno"));
                vo.setAsstactType(row.getString("asstacttype"));
                vo.setAsstactId(row.getLong("asstact"));
                vo.setDepartmentId(row.getLong("department"));
                vo.setRemark(row.getString("remark"));
                vo.setBizDate(row.getDate("bizdate"));
                vo.setCurrencyId(row.getLong("currency"));
                vo.setExrateTableId(row.getLong("exratetable"));
                vo.setExchangeRate(row.getBigDecimal("exchangerate"));
                vo.setQuotation(this.getQuotation(vo.getBillNo(), row.getLong("exratetable"), row.getLong("currency")));
                vo.setSrcBillQuotation(row.getString("quotation"));
                vo.setCurExchangeRate(this.getCurExchangeRate(vo.getBillNo(), vo.getExrateTableId(), vo.getCurrencyId(), vo.getQuotation()));
                if (this.context.isMaterialSettle()) {
                    vo.setLocalBalance(row.getBigDecimal("entry.e_unsettlelocalamt"));
                    vo.setMaterialId(row.getLong("entry.e_material"));
                    vo.setExpenseItemId(row.getLong("entry.e_expenseitem"));
                    vo.setProjectId(row.getLong("entry.project"));
                    vo.setBalance(row.getBigDecimal("entry.e_unsettleamt"));
                } else {
                    vo.setLocalBalance(row.getBigDecimal("planentity.unplansettlelocamt"));
                    vo.setBalance(row.getBigDecimal("planentity.unplansettleamt"));
                }
                this.extendFieldVoluation(vo, row);
                billVOMap.put(vo.getBillEntryId(), vo);
            }
        }
        return billVOMap;
    }
}

