/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.adjustexch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RequireAdjExchRecordOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Long orgId;
        Boolean key;
        DynamicObject org;
        String selector = "id,org,standardcurrency,exratetable,curperiod";
        QFilter finishFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE);
        DynamicObject[] apInitDatas = BusinessDataServiceHelper.load((String)"ap_init", (String)selector, (QFilter[])new QFilter[]{finishFilter});
        DynamicObject[] arInitDatas = BusinessDataServiceHelper.load((String)"ar_init", (String)selector, (QFilter[])new QFilter[]{finishFilter});
        List<Long> apOrgIds = this.getorgId(apInitDatas);
        List<Long> arOrgIds = this.getorgId(arInitDatas);
        Map<Long, Boolean> apOrgAndParamMap = this.getIsParticipateInAdjExchMap(apOrgIds, false);
        Map<Long, Boolean> arOrgAndParamMap = this.getIsParticipateInAdjExchMap(arOrgIds, true);
        for (DynamicObject apInitData : apInitDatas) {
            org = apInitData.getDynamicObject("org");
            if (org == null || (key = apOrgAndParamMap.get(orgId = Long.valueOf(org.getLong("id")))) == null || !key.booleanValue()) continue;
            this.insertAdjExchRecord(apInitData, false);
        }
        for (DynamicObject arInitData : arInitDatas) {
            org = arInitData.getDynamicObject("org");
            if (org == null || (key = arOrgAndParamMap.get(orgId = Long.valueOf(arInitData.getDynamicObject("org").getLong("id")))) == null || !key.booleanValue()) continue;
            this.insertAdjExchRecord(arInitData, true);
        }
    }

    private List<Long> getorgId(DynamicObject[] initDatas) {
        ArrayList<Long> orgIds = new ArrayList<Long>(32);
        for (DynamicObject init : initDatas) {
            DynamicObject org = init.getDynamicObject("org");
            if (org == null) continue;
            orgIds.add(org.getLong("id"));
        }
        return orgIds;
    }

    public Map<Long, Boolean> getIsParticipateInAdjExchMap(List<Long> orgIds, boolean isAr) {
        Map<Long, Object> appParameter = SystemParameterHelper.batchGetAppParameter(isAr, orgIds, isAr ? "ar_031" : "ap_031");
        HashMap<Long, Boolean> isParticipateInAdjExchMap = new HashMap<Long, Boolean>(appParameter.size());
        for (Map.Entry<Long, Object> entryMap : appParameter.entrySet()) {
            isParticipateInAdjExchMap.put(entryMap.getKey(), (Boolean)entryMap.getValue());
        }
        return isParticipateInAdjExchMap;
    }

    public void insertAdjExchRecord(DynamicObject info, boolean isAr) {
        DynamicObject standardcurrency = info.getDynamicObject("standardcurrency");
        DynamicObject exratetable = info.getDynamicObject("exratetable");
        DynamicObject curperiod = info.getDynamicObject("curperiod");
        if (standardcurrency == null || exratetable == null || curperiod == null) {
            return;
        }
        DynamicObject[] adjExchRecord = new DynamicObject[]{BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_adjustexch" : "ap_adjustexch"))};
        adjExchRecord[0].set("org", (Object)info.getDynamicObject("org"));
        adjExchRecord[0].set("basecurrency", (Object)standardcurrency);
        adjExchRecord[0].set("exratetable", (Object)exratetable);
        adjExchRecord[0].set("isadjexch", (Object)Boolean.FALSE);
        adjExchRecord[0].set("isperiod", (Object)Boolean.FALSE);
        adjExchRecord[0].set("period", (Object)curperiod);
        adjExchRecord[0].set("listperiod", (Object)adjExchRecord[0].getDynamicObject("period").getString("name"));
        if (isAr) {
            adjExchRecord[0].set("bizsystem", (Object)"AR");
        } else {
            adjExchRecord[0].set("bizsystem", (Object)"AP");
        }
        if (!this.validateAdjExchRecord(adjExchRecord[0], false, isAr).booleanValue()) {
            SaveServiceHelper.save((DynamicObject[])adjExchRecord);
        }
    }

    public Boolean validateAdjExchRecord(DynamicObject adjExchRecord, boolean isPeriod, boolean isAr) {
        QFilter bizsystemfilter;
        QFilter periodfilter;
        QFilter filter;
        DynamicObject validateData;
        DynamicObject org = adjExchRecord.getDynamicObject("org");
        Long periodId = 0L;
        if (!isPeriod) {
            periodId = (Long)adjExchRecord.getDynamicObject("period").getPkValue();
        }
        if (EmptyUtils.isEmpty(validateData = BusinessDataServiceHelper.loadSingle((String)(isAr ? "ar_adjustexch" : "ap_adjustexch"), (String)"id,basecurrency,exratetable,isadjexch", (QFilter[])new QFilter[]{filter = new QFilter("org", "=", org.get("id")), periodfilter = new QFilter("period", "=", (Object)periodId), bizsystemfilter = new QFilter("bizsystem", "=", (Object)(isAr ? "AR" : "AP"))}))) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

