/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.archi;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.archi.AbstractBillArchiPlugin;

public abstract class AbstractBusBillArchiPlugin
extends AbstractBillArchiPlugin {
    private static Log logger = LogFactory.getLog(AbstractBusBillArchiPlugin.class);

    public Iterator<Long> queryEntityIds() {
        HashSet<Long> idSet = new HashSet<Long>();
        try {
            Date archiveDate = this.getArchiveDate();
            logger.info("AbstractBusBillArchiPlugin-archiveDate:" + archiveDate);
            if (archiveDate == null) {
                return idSet.iterator();
            }
            QFilter srcFilter = this.getBillFilter(archiveDate);
            DataSet srcBillDS = QueryServiceHelper.queryDataSet((String)"querySrcBusIds", (String)this.getEntityKey(), (String)"id", (QFilter[])new QFilter[]{srcFilter}, (String)"");
            for (Object srcRow : srcBillDS) {
                idSet.add(srcRow.getLong("id"));
            }
            logger.info("AbstractBusBillArchiPlugin-idSet:" + idSet.size());
            if (!idSet.isEmpty()) {
                HashSet<String> srcBillIdStrSet = new HashSet<String>(idSet.size());
                for (Long srcBillId : idSet) {
                    srcBillIdStrSet.add(String.valueOf(srcBillId));
                }
                QFilter woffFilter = new QFilter("sourcebillid", "in", srcBillIdStrSet);
                woffFilter.and("billstatus", "=", (Object)"C");
                DataSet woffBillDS = QueryServiceHelper.queryDataSet((String)"queryWoffBusIds", (String)this.getEntityKey(), (String)"id,sourcebillid,bizdate", (QFilter[])new QFilter[]{woffFilter}, (String)"sourcebillid,bizdate desc");
                HashSet<Long> noArchiveSrcBillIds = new HashSet<Long>(8);
                HashSet<Long> archiveWoffBillIds = new HashSet<Long>(8);
                for (Row woffRow : woffBillDS) {
                    Long woffId = woffRow.getLong("id");
                    Long srcId = woffRow.getLong("sourcebillid");
                    Date bizdate = woffRow.getDate("bizdate");
                    if (!bizdate.before(archiveDate)) {
                        noArchiveSrcBillIds.add(srcId);
                    }
                    if (noArchiveSrcBillIds.contains(srcId)) continue;
                    archiveWoffBillIds.add(woffId);
                }
                HashSet<Long> noArchiveWoffBillIds = new HashSet<Long>(8);
                HashSet<Long> archiveWriteOffWoffBillIds = new HashSet<Long>(8);
                if (!archiveWoffBillIds.isEmpty()) {
                    HashSet<String> woffBillIdStrSet = new HashSet<String>(archiveWoffBillIds.size());
                    for (Long woffBillId : archiveWoffBillIds) {
                        woffBillIdStrSet.add(String.valueOf(woffBillId));
                    }
                    QFilter writeOffWoffFilter = new QFilter("sourcebillid", "in", woffBillIdStrSet);
                    writeOffWoffFilter.and("billstatus", "=", (Object)"C");
                    DataSet writeOffWoffBillDS = QueryServiceHelper.queryDataSet((String)"queryWriteOffWoffBillDS", (String)this.getEntityKey(), (String)"id,sourcebillid,mostsrcbusbillid,bizdate", (QFilter[])new QFilter[]{writeOffWoffFilter}, (String)"sourcebillid,bizdate desc");
                    for (Row writeOffWoffRow : writeOffWoffBillDS) {
                        Long writeOffWoffId = writeOffWoffRow.getLong("id");
                        Long woffId = writeOffWoffRow.getLong("sourcebillid");
                        Long srcId = writeOffWoffRow.getLong("mostsrcbusbillid");
                        Date bizdate = writeOffWoffRow.getDate("bizdate");
                        if (!bizdate.before(archiveDate)) {
                            noArchiveSrcBillIds.add(srcId);
                            noArchiveWoffBillIds.add(woffId);
                        }
                        if (noArchiveWoffBillIds.contains(woffId)) continue;
                        archiveWriteOffWoffBillIds.add(writeOffWoffId);
                    }
                }
                idSet.removeAll(noArchiveSrcBillIds);
                idSet.addAll(archiveWoffBillIds);
                idSet.removeAll(noArchiveWoffBillIds);
                idSet.addAll(archiveWriteOffWoffBillIds);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return idSet.iterator();
    }

    @Override
    public QFilter getBillFilter(Date archiveDate) {
        QFilter srcFilter = new QFilter("bizdate", "<", (Object)archiveDate);
        srcFilter.and("billstatus", "=", (Object)"C");
        srcFilter.and("unwoffamt", "=", (Object)BigDecimal.ZERO);
        return srcFilter;
    }
}

