/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.audit;

import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.service.audit.CostItem;
import kd.fi.arapcommon.service.audit.CostItemPresistentTask;
import kd.fi.arapcommon.util.StdConfig;

public class Audit {
    public static final String AUDIT_PARAM = "open";
    private static ThreadLocal<CostItem> CURRENT_AUIDTABLE = new ThreadLocal();
    private static ThreadPool THREADPOOL = ThreadPools.newFixedThreadPool((String)"audit-pool", (int)2);

    public static CostItem audit(String name) {
        CostItem costItem = new CostItem(name);
        costItem.setAuditOpen(Audit.auditIsOpen());
        if (costItem.isAuditOpen()) {
            CostItem currentAuditable = CURRENT_AUIDTABLE.get();
            if (currentAuditable != null) {
                costItem.setParent(currentAuditable);
                currentAuditable.addSubItem(costItem);
            }
            costItem.setBeginTime(System.currentTimeMillis());
            CURRENT_AUIDTABLE.set(costItem);
        }
        return costItem;
    }

    public static void auditSubBegin(CostItem parent, String name) {
        if (parent == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        CostItem costItem = new CostItem(name);
        costItem.setAuditOpen(parent.isAuditOpen());
        if (costItem.isAuditOpen()) {
            costItem.setParent(parent);
            parent.addSubItem(costItem);
            costItem.setBeginTime(System.currentTimeMillis());
            CURRENT_AUIDTABLE.set(costItem);
        }
    }

    public static void auditSubEnd(CostItem parent, String name) {
        CostItem currentAuditable;
        if (parent == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        if (parent.isAuditOpen() && (currentAuditable = CURRENT_AUIDTABLE.get()) != null && name.equals(currentAuditable.getNumber())) {
            currentAuditable.setEndTime(System.currentTimeMillis());
            currentAuditable.setCostTime(currentAuditable.getEndTime() - currentAuditable.getBeginTime());
            Audit.set(parent);
        }
    }

    public static void get() {
        CURRENT_AUIDTABLE.get();
    }

    public static void set(CostItem value) {
        CURRENT_AUIDTABLE.set(value);
    }

    public static void presistent(CostItem value) {
        THREADPOOL.execute((Runnable)new CostItemPresistentTask(value), RequestContext.get());
        CURRENT_AUIDTABLE.remove();
    }

    public static boolean auditIsOpen() {
        String auditParam = StdConfig.get("auditparam");
        return AUDIT_PARAM.equalsIgnoreCase(auditParam);
    }
}

