/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.audit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.EntryProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.service.audit.CostItem;

public class CostItemPresistentTask
implements Runnable {
    private CostItem costItem;
    private int count = 1;

    public CostItemPresistentTask(CostItem costItem) {
        this.costItem = costItem;
    }

    @Override
    public void run() {
        try {
            if (this.costItem != null) {
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"ap_apmaudit");
                obj.set("number", (Object)this.costItem.getNumber());
                Date beginTime = new Date(this.costItem.getBeginTime());
                Date endTime = new Date(this.costItem.getEndTime());
                obj.set("begintime", (Object)beginTime);
                obj.set("endtime", (Object)endTime);
                long totalTime_ms = this.costItem.getCostTime();
                obj.set("costtime", (Object)totalTime_ms);
                obj.set("traceid", (Object)this.costItem.getTraceId());
                obj.set("description", (Object)this.costItem.getDescription());
                List<CostItem> subItems = this.costItem.getSubItems();
                if (!subItems.isEmpty()) {
                    EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)obj.getDataEntityType().getName()).findProperty("treeentry");
                    DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
                    for (CostItem subItem : subItems) {
                        this.addCostItemEntry(obj, subItem, totalTime_ms, null, dt);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void addCostItemEntry(DynamicObject obj, CostItem costItem, long totalTime_ms, Object parentId, DynamicObjectType dt) {
        DynamicObject entry = new DynamicObject(dt);
        entry.set("e_number", (Object)costItem.getNumber());
        Date beginTime = new Date(costItem.getBeginTime());
        Date endTime = new Date(costItem.getEndTime());
        long costtime = costItem.getCostTime();
        entry.set("e_costtime", (Object)costtime);
        entry.set("e_begintime", (Object)beginTime);
        entry.set("e_endtime", (Object)endTime);
        entry.set("e_description", (Object)costItem.getDescription());
        BigDecimal percentage = BigDecimal.valueOf(costtime).divide(BigDecimal.valueOf(totalTime_ms), 4, RoundingMode.HALF_UP);
        entry.set("e_percentage", (Object)percentage.multiply(new BigDecimal(100)));
        long currentId = DB.genLongId((String)"t_ap_apmauditentry");
        entry.set("id", (Object)currentId);
        entry.set("pid", parentId);
        entry.set("seq", (Object)this.count);
        obj.getDynamicObjectCollection("treeentry").add((Object)entry);
        ++this.count;
        List<CostItem> subItems = costItem.getSubItems();
        if (!subItems.isEmpty()) {
            for (CostItem subItem : subItems) {
                this.addCostItemEntry(obj, subItem, totalTime_ms, currentId, dt);
            }
        }
    }
}

