/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.bus;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.exception.OperationException;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.bus.IWoffService;
import kd.fi.arapcommon.service.bus.WoffDetailInfo;
import kd.fi.arapcommon.service.bus.WoffHelper;
import kd.fi.arapcommon.service.bus.WoffModeEnum;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.ErrorInfo;
import kd.fi.arapcommon.vo.Result;

public abstract class AbstractWoffService
implements IWoffService {
    private static final Log logger = LogFactory.getLog(AbstractWoffService.class);
    protected String finBillKey;
    protected String finEntryKey;
    protected String finQuantityKey;
    protected String finSrcIdKey;
    protected String finSrcEntryIdKey;
    protected String busEntityKey;
    protected String woffRuleId;
    protected String priceTaxTotalKey;
    protected String amountKey;
    protected String localAmtKey;
    protected String e_amountKey;
    protected String e_localAmtKey;
    protected String priceTaxTotalLocalKey;
    protected String e_priceTaxTotalKey;
    protected String e_priceTaxTotalLocalKey;
    protected HashMap<Long, List<WoffDetailInfo>> woffDetailInfoMap = new HashMap(64);
    protected Map<Long, Long> woffIdMap = new HashMap<Long, Long>(64);
    protected List<WoffDetailInfo> sameSourceWoffDetailInfos = new ArrayList<WoffDetailInfo>(64);
    protected Set<Long> srcEntryIds = new HashSet<Long>(64);
    protected Set<Long> srcBusFinIds = new HashSet<Long>(64);
    private Map<String, BigDecimal> unitRateConvCache = new HashMap<String, BigDecimal>(8);

    public AbstractWoffService() {
        logger.info("WoffService-\u8bf7\u521d\u59cb\u5316\u5168\u5c40\u53c2\u6570\u3002");
    }

    public Set<Long> initWoffDetailInfo(DynamicObject[] finBills) throws KDBizException {
        long begin = System.currentTimeMillis();
        logger.info("---WoffService.begin---" + begin + "ms");
        this.initSrcModel(finBills);
        for (DynamicObject finBill : finBills) {
            if (!this.matchConditions(finBill)) continue;
            Long orgId = finBill.getLong("org.id");
            boolean isbasedonamt = finBill.getBoolean("payproperty.isbasedonamt");
            DynamicObjectCollection entrys = finBill.getDynamicObjectCollection(this.finEntryKey);
            List<WoffDetailInfo> woffDetailInfos = this.woffDetailInfoMap.get(orgId);
            if (woffDetailInfos == null) {
                woffDetailInfos = new ArrayList<WoffDetailInfo>(entrys.size());
                this.woffDetailInfoMap.put(orgId, woffDetailInfos);
            }
            for (DynamicObject entry : entrys) {
                WoffDetailInfo woffDetailInfo2 = this.getWoffDetailInfoByFin(finBill, entry, isbasedonamt);
                woffDetailInfos.add(woffDetailInfo2);
            }
        }
        logger.info("---WoffService.finBill---" + (System.currentTimeMillis() - begin) + "ms");
        begin = System.currentTimeMillis();
        HashSet<Long> srcBusIdSet = new HashSet<Long>(64);
        Iterator<Map.Entry<Long, List<WoffDetailInfo>>> iterator = this.woffDetailInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<WoffDetailInfo>> woffDetailInfoEntry = iterator.next();
            Long orgId = woffDetailInfoEntry.getKey();
            List<WoffDetailInfo> woffDetailInfos = woffDetailInfoEntry.getValue();
            this.fillSrcBusInfoByMode(orgId, woffDetailInfos);
            woffDetailInfos.removeIf(woffDetailInfo -> ObjectUtils.isEmpty((Object)woffDetailInfo.getSrcBusId()) || ObjectUtils.isEmpty((Object)woffDetailInfo.getSrcBusEntryId()));
            if (woffDetailInfos.size() == 0) {
                iterator.remove();
            } else {
                this.woffDetailInfoMap.put(orgId, woffDetailInfos);
                Set srcBusIds = woffDetailInfos.stream().map(WoffDetailInfo::getSrcBusId).collect(Collectors.toSet());
                logger.info("---WoffService.orgId:" + orgId + ",srcBusIds:" + srcBusIds);
                srcBusIdSet.addAll(srcBusIds);
            }
            logger.info("---WoffService.srcBusBill---" + (System.currentTimeMillis() - begin) + "ms");
            begin = System.currentTimeMillis();
        }
        logger.info("WoffService-\u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u88ab\u51b2\u56de\u7684\u6e90\u6682\u4f30\u5355ID\u96c6\u5408\uff1a" + srcBusIdSet);
        return srcBusIdSet;
    }

    public void initSrcModel(DynamicObject[] finBills) {
        boolean isAr;
        String entityName = finBills[0].getDataEntityType().getName();
        boolean bl = isAr = "ar_finarbill".equals(entityName);
        if (isAr) {
            HashSet<Long> sourceEntryIds = new HashSet<Long>(8);
            HashSet<Long> finIds = new HashSet<Long>(8);
            HashSet<Long> finEntryIds = new HashSet<Long>(8);
            for (DynamicObject finBill : finBills) {
                finIds.add(finBill.getLong("id"));
                DynamicObjectCollection entryCol = finBill.getDynamicObjectCollection(this.finEntryKey);
                for (DynamicObject entryInfo2 : entryCol) {
                    finEntryIds.add(entryInfo2.getLong("id"));
                    Long srcEntryId = entryInfo2.getLong("e_srcentryid");
                    if (srcEntryId == null || srcEntryId == 0L) continue;
                    sourceEntryIds.add(srcEntryId);
                }
            }
            DynamicObjectCollection arBusCol = QueryServiceHelper.query((String)"ar_busbill", (String)"id,entry.e_srcentryid", (QFilter[])new QFilter[]{new QFilter("entry.e_srcentryid", "in", sourceEntryIds), new QFilter("isadjust", "=", (Object)Boolean.FALSE)});
            this.srcEntryIds = arBusCol.stream().map(arBusBill -> arBusBill.getLong("entry.e_srcentryid")).collect(Collectors.toSet());
            Map<Long, List<Long>> map = BOTPHelper.loadNearUpBillIds("ar_finarbill", "entry", finIds.toArray(new Long[0]), finEntryIds.toArray(new Long[0]), "ar_busbill");
            for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
                Long key = entry.getKey();
                for (DynamicObject finBill : finBills) {
                    Long finId = finBill.getLong("id");
                    if (!key.equals(finId)) continue;
                    DynamicObjectCollection entryCol = finBill.getDynamicObjectCollection(this.finEntryKey);
                    this.srcBusFinIds.addAll(entryCol.stream().map(entryInfo -> entryInfo.getLong("id")).collect(Collectors.toSet()));
                }
            }
        }
    }

    private WoffDetailInfo getWoffDetailInfoByFin(DynamicObject finBill, DynamicObject entry, boolean isbasedonamt) {
        String entityName = finBill.getDataEntityType().getName();
        boolean isAr = "ar_finarbill".equals(entityName);
        String expenseId = isAr ? "e_expenseitem.id" : "expenseitem.id";
        WoffDetailInfo woffDetailInfo = new WoffDetailInfo();
        woffDetailInfo.setFinId(finBill.getLong("id"));
        woffDetailInfo.setFinEntryId(entry.getLong("id"));
        woffDetailInfo.setBasedonamt(isbasedonamt);
        woffDetailInfo.setFinWrittenoff(finBill.getBoolean("iswrittenoff"));
        String sourcebilltype = finBill.getString("sourcebilltype");
        woffDetailInfo.setFinSrcBillType(sourcebilltype);
        woffDetailInfo.setFinSrcId(entry.getLong(this.finSrcIdKey));
        woffDetailInfo.setFinSrcEntryId(entry.getLong(this.finSrcEntryIdKey));
        woffDetailInfo.setAllverify(entry.getBoolean("e_isallverify"));
        woffDetailInfo.setFinQuantity(entry.getBigDecimal(this.finQuantityKey));
        woffDetailInfo.setFinAmount(entry.getBigDecimal(this.e_amountKey));
        woffDetailInfo.setFinLocAmt(entry.getBigDecimal(this.e_localAmtKey));
        woffDetailInfo.setFinPriceTaxTotal(entry.getBigDecimal(this.e_priceTaxTotalKey));
        woffDetailInfo.setFinPriceTaxTotalLocal(entry.getBigDecimal(this.e_priceTaxTotalLocalKey));
        woffDetailInfo.setWoffBizDate(finBill.getDate("bizdate"));
        woffDetailInfo.setLineType(entry.getLong("linetype.id"));
        woffDetailInfo.setExpenseItem(entry.getLong(expenseId));
        boolean scmcBill = this.isScmcBill(isAr, sourcebilltype, entry);
        if (scmcBill) {
            woffDetailInfo.setScmcBill(scmcBill);
            woffDetailInfo.setWoffMode(WoffModeEnum.SAMESOURCE);
        } else if (isAr) {
            boolean isCoreBill;
            boolean bl = isCoreBill = !"ar_busbill".equals(sourcebilltype) && this.isCoreBill(isAr, entry);
            if (isCoreBill) {
                woffDetailInfo.setCoreBill(isCoreBill);
                String coreBillType = entry.getString("e_corebilltype");
                String coreBillNo = entry.getString("e_corebillno");
                int coreBillEntrySeq = entry.getInt("e_corebillentryseq");
                String coreBillKey = coreBillType + "_" + coreBillNo + "_" + coreBillEntrySeq;
                woffDetailInfo.setCoreBillType(coreBillType);
                woffDetailInfo.setCoreBillNo(coreBillNo);
                woffDetailInfo.setCoreBillEntrySeq(coreBillEntrySeq);
                woffDetailInfo.setCoreBillKey(coreBillKey);
            }
        }
        woffDetailInfo.initWoffMode();
        return woffDetailInfo;
    }

    private void fillSrcBusInfoByMode(Long orgId, List<WoffDetailInfo> woffDetailInfos) {
        Map<WoffModeEnum, List<WoffDetailInfo>> woffModeInfosMap = woffDetailInfos.stream().collect(Collectors.groupingBy(WoffDetailInfo::getWoffMode));
        woffModeInfosMap.forEach((woffMode, infoGroups) -> {
            logger.info("WoffService-getSrcBusQfilter Mode:" + woffMode.getName());
            switch (woffMode.getValue()) {
                case "direct": {
                    Map<Long, List<WoffDetailInfo>> finSrcBusEntryIdMap = infoGroups.stream().collect(Collectors.groupingBy(WoffDetailInfo::getFinSrcEntryId));
                    WoffHelper.fillSrcBusInfo(this.busEntityKey, orgId, "entry.id", finSrcBusEntryIdMap);
                    break;
                }
                case "samesource": {
                    this.fillSrcBusInfo4SameSource(orgId, (List<WoffDetailInfo>)infoGroups);
                    break;
                }
                case "corebill": {
                    this.fillSrcBusInfo4CoreBill(orgId, (List<WoffDetailInfo>)infoGroups);
                    break;
                }
                case "writtenoff": {
                    Map<Long, List<WoffDetailInfo>> finWoffSrcIdMap = infoGroups.stream().collect(Collectors.groupingBy(WoffDetailInfo::getFinSrcId));
                    WoffHelper.fillSrcBusInfo(this.busEntityKey, null, "srcfinbillid", finWoffSrcIdMap);
                    break;
                }
                case "indirect": {
                    this.fillSrcBusInfo4Indirect(orgId, (List<WoffDetailInfo>)infoGroups);
                }
            }
        });
    }

    private void fillSrcBusInfo4Indirect(Long orgId, List<WoffDetailInfo> infoGroups) {
        Map<Long, List<WoffDetailInfo>> tempFinEntryMap = infoGroups.stream().collect(Collectors.groupingBy(WoffDetailInfo::getFinEntryId));
        Map<Long, Set<Long>> srcBusBFRowIdMap = BOTPHelper.loadSourceRowIdsMap(this.finBillKey, this.finEntryKey, tempFinEntryMap.keySet().toArray(new Long[0]), this.busEntityKey);
        for (Map.Entry<Long, Set<Long>> entry : srcBusBFRowIdMap.entrySet()) {
            Set<Long> srcBusEntryIds = entry.getValue();
            if (srcBusEntryIds == null || srcBusEntryIds.size() <= 0) continue;
            WoffDetailInfo info = tempFinEntryMap.get(entry.getKey()).get(0);
            info.setSrcBusEntryId(srcBusEntryIds.toArray(new Long[0])[0]);
        }
        Map<Long, List<WoffDetailInfo>> finSrcBusEntryIdMap = infoGroups.stream().filter(woffDetailInfo -> !ObjectUtils.isEmpty((Object)woffDetailInfo.getSrcBusEntryId())).collect(Collectors.groupingBy(WoffDetailInfo::getSrcBusEntryId));
        WoffHelper.fillSrcBusInfo(this.busEntityKey, orgId, "entry.id", finSrcBusEntryIdMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> genWoffBill() throws KDBizException {
        HashMap<String, Object> returnData = new HashMap<String, Object>(8);
        try (TXHandle tx = TX.required((String)"genWoffBill");){
            for (Map.Entry<Long, List<WoffDetailInfo>> woffDetailInfoEntry : this.woffDetailInfoMap.entrySet()) {
                long begin = System.currentTimeMillis();
                Long orgId = woffDetailInfoEntry.getKey();
                List<WoffDetailInfo> woffDetailInfos = woffDetailInfoEntry.getValue();
                if (ObjectUtils.isEmpty(woffDetailInfos)) {
                    String message = String.format(ResManager.loadKDString((String)"WoffService-\u7ec4\u7ec7Id:%s\u6ca1\u6709\u6ee1\u8db3\u51b2\u56de\u6761\u4ef6\u9700\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (String)"AbstractWoffService_2", (String)"fi-arapcommon", (Object[])new Object[0]), orgId);
                    logger.info(message);
                    returnData.put("message", message + '\n' + returnData.get("message"));
                    HashMap<String, Object> hashMap = returnData;
                    return hashMap;
                }
                logger.info("---WoffService.genWoffBill.orgId---" + orgId);
                this.fillCurBusWoffInfo(orgId, woffDetailInfos);
                woffDetailInfos.removeIf(info -> info.getQuantity().compareTo(BigDecimal.ZERO) == 0);
                if (ObjectUtils.isEmpty(woffDetailInfos)) continue;
                logger.info("---WoffService.fillCurBusWoffInfo---" + (System.currentTimeMillis() - begin) + "ms");
                begin = System.currentTimeMillis();
                Map<Long, List<WoffDetailInfo>> finIdMap = woffDetailInfos.stream().collect(Collectors.groupingBy(WoffDetailInfo::getFinId));
                ArrayList<DynamicObject> woffList = new ArrayList<DynamicObject>(64);
                ArrayList<Long> srcBusIds = new ArrayList<Long>(64);
                for (Map.Entry<Long, List<WoffDetailInfo>> entry : finIdMap.entrySet()) {
                    Set srcBusIdTemp = entry.getValue().stream().map(WoffDetailInfo::getSrcBusId).collect(Collectors.toSet());
                    srcBusIds.addAll(srcBusIdTemp);
                }
                List<Set<Long>> groupList = WoffHelper.splitList(srcBusIds);
                for (Set<Long> group : groupList) {
                    List<Long> tempSrcBusIds = group.stream().collect(Collectors.toList());
                    List<DynamicObject> tempWoffList = this.pushWoffBill(tempSrcBusIds);
                    woffList.addAll(tempWoffList);
                    logger.info("---WoffService.pushSrcBusIds:" + tempSrcBusIds);
                    logger.info("---WoffService.pushWoffBill---" + (System.currentTimeMillis() - begin) + "ms");
                    begin = System.currentTimeMillis();
                }
                if (woffList.size() < 1) {
                    String string = ResManager.loadKDString((String)"WoffService-\u6ca1\u6709\u83b7\u5f97\u4e0b\u63a8\u751f\u6210\u7684\u51b2\u56de\u5355\u3002", (String)"AbstractWoffService_4", (String)"fi-arapcommon", (Object[])new Object[0]);
                    logger.info(string);
                    returnData.put("message", string + '\n' + returnData.get("message"));
                    HashMap<String, Object> hashMap = returnData;
                    return hashMap;
                }
                try {
                    this.buildWoffBill(woffDetailInfos, woffList);
                    logger.info("---WoffService.buildWoffBill---" + (System.currentTimeMillis() - begin) + "ms");
                    begin = System.currentTimeMillis();
                    this.doOperation(woffDetailInfos, woffList);
                    logger.info("---WoffService.doOperation---" + (System.currentTimeMillis() - begin) + "ms");
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                    return returnData;
                }
            }
        }
    }

    private void fillCurBusWoffInfo(Long orgId, List<WoffDetailInfo> woffDetailInfos) {
        Set<Long> srcBusEntryIds = woffDetailInfos.stream().map(WoffDetailInfo::getSrcBusEntryId).collect(Collectors.toSet());
        logger.info("WoffService-\u67e5\u8be2\u5386\u53f2\u5df2\u5b58\u5728\u51b2\u56de\u91d1\u989d\u4fe1\u606f\uff08\u4e0e\u6e90\u5355\u65b9\u5411\u76f8\u53cd\uff09\uff0c\u6e90\u6682\u4f30\u5355\u5206\u5f55ID\u96c6\u5408\uff1a" + srcBusEntryIds);
        Map<Long, BusEntryInfo> woffMap = WoffHelper.getWoffInfoMap(this.busEntityKey, orgId, srcBusEntryIds);
        for (WoffDetailInfo woffDetailInfo : woffDetailInfos) {
            Long srcBusEntryId = woffDetailInfo.getSrcBusEntryId();
            BusEntryInfo busWoffInfo = woffMap.get(srcBusEntryId);
            if (busWoffInfo == null) {
                busWoffInfo = new BusEntryInfo();
                woffMap.put(srcBusEntryId, busWoffInfo);
            }
            if (busWoffInfo.isWoff()) continue;
            woffDetailInfo.fillWoffInfo(busWoffInfo, this.e_priceTaxTotalKey, this.e_priceTaxTotalLocalKey);
        }
    }

    private List<DynamicObject> pushWoffBill(List<Long> srcBusIds) {
        Map<String, Object> map = BOTPHelper.push4Result(this.busEntityKey, this.busEntityKey, this.woffRuleId, srcBusIds);
        Object convertResult = map.get("convertResult");
        if (convertResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertResult;
            String convertReport = BOTPHelper.getConvertReport(result);
            logger.info("------WoffService-botp.ConvertReport------" + convertReport);
            ErrorCode ec = new ErrorCode("botp", convertReport);
            throw new KDBizException(ec, new Object[0]);
        }
        return (List)map.get("trgBills");
    }

    private void buildWoffBill(List<WoffDetailInfo> woffDetailInfos, List<DynamicObject> woffList) {
        ArrayList<WoffDetailInfo> woffDetailInfoTemps = new ArrayList<WoffDetailInfo>(woffDetailInfos.size());
        woffDetailInfoTemps.addAll(woffDetailInfos);
        for (DynamicObject woffBill : woffList) {
            String sourcebillid = woffBill.getString("sourcebillid");
            if (ObjectUtils.isEmpty((Object)sourcebillid)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6682\u4f30\u51b2\u56de\u8f6c\u6362\u89c4\u5219\u7684\u5b57\u6bb5\u6620\u5c04\u4e2d\u3010\u5355\u636e\u5934.\u6e90\u5355ID\u3011\u3002", (String)"AbstractWoffService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            Long srcBusId = Long.parseLong(sourcebillid.split(",")[0]);
            Map<Long, List<WoffDetailInfo>> infoGroupMap = woffDetailInfoTemps.stream().filter(woffDetailInfo -> srcBusId.equals(woffDetailInfo.getSrcBusId())).collect(Collectors.groupingBy(WoffDetailInfo::getFinId));
            Long[] FinIds = infoGroupMap.keySet().toArray(new Long[0]);
            if (FinIds.length <= 0) continue;
            List<WoffDetailInfo> infoGroups = infoGroupMap.get(FinIds[0]);
            this.resetWoffBill(woffBill, infoGroups);
            woffDetailInfoTemps.removeAll(infoGroups);
        }
    }

    private void resetWoffBill(DynamicObject woffBill, List<WoffDetailInfo> infoGroups) {
        Map<Long, List<WoffDetailInfo>> infoGroupMap = infoGroups.stream().collect(Collectors.groupingBy(WoffDetailInfo::getSrcBusEntryId));
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalLocal = BigDecimal.ZERO;
        boolean isBasedonAmt = woffBill.getBoolean("payproperty.isbasedonamt");
        DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Long srcBusEntryId = entry.getLong("e_srcentryid");
            BigDecimal e_quantity = BigDecimal.ZERO;
            BigDecimal e_discountAmt = BigDecimal.ZERO;
            BigDecimal e_tax = BigDecimal.ZERO;
            BigDecimal e_taxLocAmt = BigDecimal.ZERO;
            BigDecimal e_amount = BigDecimal.ZERO;
            BigDecimal e_localAmt = BigDecimal.ZERO;
            BigDecimal e_priceTaxTotal = BigDecimal.ZERO;
            BigDecimal e_priceTaxTotalLocal = BigDecimal.ZERO;
            List<WoffDetailInfo> infos = infoGroupMap.get(srcBusEntryId);
            if (infos == null) {
                entrys.remove(i);
                --i;
                continue;
            }
            for (WoffDetailInfo info : infos) {
                woffBill.set("srcfinbillid", (Object)info.getFinId());
                woffBill.set("bizdate", (Object)info.getWoffBizDate());
                e_quantity = e_quantity.add(info.getQuantity());
                e_discountAmt = e_discountAmt.add(info.getDiscountAmt());
                e_tax = e_tax.add(info.getTax());
                e_taxLocAmt = e_taxLocAmt.add(info.getTaxLocAmt());
                e_amount = e_amount.add(info.getAmount());
                e_localAmt = e_localAmt.add(info.getLocalAmt());
                e_priceTaxTotal = e_priceTaxTotal.add(info.getPriceTaxTotal());
                e_priceTaxTotalLocal = e_priceTaxTotalLocal.add(info.getPriceTaxTotalLocal());
            }
            if (isBasedonAmt) {
                boolean isPresent = entry.getBoolean("e_ispresent");
                if (!isPresent && infos.size() > 1) {
                    e_quantity = new BigDecimal(e_priceTaxTotal.compareTo(BigDecimal.ZERO));
                }
                entry.set("e_discountmode", (Object)"NULL");
                entry.set("e_discountrate", (Object)BigDecimal.ZERO);
                if (!isPresent) {
                    entry.set("e_unitprice", (Object)e_amount.abs());
                    entry.set("e_taxunitprice", (Object)e_priceTaxTotal.abs());
                    entry.set("e_actunitprice", (Object)e_amount.abs());
                    entry.set("e_acttaxunitprice", (Object)e_priceTaxTotal.abs());
                }
            }
            this.fillUnitRateConv(entry, e_quantity);
            entry.set("e_discountamount", (Object)e_discountAmt);
            entry.set("e_quantity", (Object)e_quantity);
            entry.set("e_tax", (Object)e_tax);
            entry.set("e_taxlocalamt", (Object)e_taxLocAmt);
            entry.set("e_amount", (Object)e_amount);
            entry.set("e_localamt", (Object)e_localAmt);
            entry.set(this.e_priceTaxTotalKey, (Object)e_priceTaxTotal);
            entry.set(this.e_priceTaxTotalLocalKey, (Object)e_priceTaxTotalLocal);
            entry.set("e_uninvoicedqty", (Object)e_quantity);
            entry.set("e_uninvoicedamt", (Object)e_priceTaxTotal);
            entry.set("e_uninvoicedlocamt", (Object)e_priceTaxTotalLocal);
            entry.set("e_unwoffqty", (Object)e_quantity);
            entry.set("e_unwoffamt", (Object)e_priceTaxTotal);
            entry.set("e_unwofflocamt", (Object)e_priceTaxTotalLocal);
            entry.set("e_unwoffnotaxamt", (Object)e_amount);
            entry.set("e_unwoffnotaxlocamt", (Object)e_localAmt);
            entry.set("e_unwofftax", (Object)e_tax);
            entry.set("e_unwofftaxlocal", (Object)e_taxLocAmt);
            entry.set("e_uninvnotaxamt", (Object)e_amount);
            entry.set("e_uninvnotaxlocalamt", (Object)e_localAmt);
            tax = tax.add(e_tax);
            taxLocAmt = taxLocAmt.add(e_taxLocAmt);
            amount = amount.add(e_amount);
            localAmt = localAmt.add(e_localAmt);
            priceTaxTotal = priceTaxTotal.add(e_priceTaxTotal);
            priceTaxTotalLocal = priceTaxTotalLocal.add(e_priceTaxTotalLocal);
        }
        woffBill.set("tax", (Object)tax);
        woffBill.set("taxlocamt", (Object)taxLocAmt);
        woffBill.set("amount", (Object)amount);
        woffBill.set("localamt", (Object)localAmt);
        woffBill.set(this.priceTaxTotalKey, (Object)priceTaxTotal);
        woffBill.set(this.priceTaxTotalLocalKey, (Object)priceTaxTotalLocal);
        woffBill.set("uninvoicedamt", (Object)priceTaxTotal);
        woffBill.set("uninvoicedlocamt", (Object)priceTaxTotalLocal);
        woffBill.set("unwoffamt", (Object)priceTaxTotal);
        woffBill.set("unwofflocamt", (Object)priceTaxTotalLocal);
        woffBill.set("unwoffnotaxamt", (Object)amount);
        woffBill.set("unwoffnotaxlocamt", (Object)localAmt);
        woffBill.set("unwofftax", (Object)tax);
        woffBill.set("unwofftaxlocal", (Object)taxLocAmt);
    }

    private void fillUnitRateConv(DynamicObject entry, BigDecimal e_quantity) {
        DynamicObject material = entry.getDynamicObject("e_material");
        DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
        DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
        BigDecimal unitRateConv = entry.getBigDecimal("e_unitcoefficient");
        if (EmptyUtils.isEmpty(unitRateConv)) {
            if (!ObjectUtils.isEmpty((Object)material)) {
                String convKey;
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    entry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if ((unitRateConv = this.unitRateConvCache.get(convKey = material.getLong("id") + "_" + measureUnit.getLong("id") + "_" + baseUnit.getLong("id"))) == null) {
                    unitRateConv = UnitConvertHelper.getUnitRateConv(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    this.unitRateConvCache.put(convKey, unitRateConv);
                }
            } else {
                unitRateConv = BigDecimal.ONE;
            }
            entry.set("e_unitcoefficient", (Object)unitRateConv);
        }
        entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(e_quantity, unitRateConv, baseUnit));
    }

    protected void doOperation(List<WoffDetailInfo> woffDetailInfos, List<DynamicObject> woffList) {
        List successPkIds;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.busEntityKey, (DynamicObject[])woffList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (result.isSuccess() && !(successPkIds = result.getSuccessPkIds()).isEmpty() && (result = OperationServiceHelper.executeOperate((String)"nocontrolsubmit", (String)this.busEntityKey, (Object[])successPkIds.toArray(), (OperateOption)option)).isSuccess() && !(successPkIds = result.getSuccessPkIds()).isEmpty()) {
            logger.info("------WoffService-operationResult.successPkIds------" + successPkIds);
            result = OperationServiceHelper.executeOperate((String)"audit", (String)this.busEntityKey, (Object[])successPkIds.toArray(), (OperateOption)option);
        }
        if (result.isSuccess()) {
            this.updateSrcBusEntry(woffDetailInfos);
        } else {
            logger.info("------WoffService-operationResult.Message------" + result.getMessage());
            OperationHelper.assertResult(this.busEntityKey, result);
        }
    }

    @Override
    public Result wholeWoffBill(DynamicObject[] finBills, String woffRuleId) throws KDBizException {
        if (!ObjectUtils.isEmpty((Object)woffRuleId)) {
            this.woffRuleId = woffRuleId;
        }
        try (TXHandle tx = TX.required((String)"wholeWoffBill");){
            try {
                Set<Long> srcBusIds = this.initWoffDetailInfo(finBills);
                if (!ObjectUtils.isEmpty(srcBusIds)) {
                    ConcurrencyCtrlUtil.addCtrlInTX(this.busEntityKey, "woff", srcBusIds);
                    Map<String, Object> returnData = this.genWoffBill();
                    String message = (String)returnData.get("message");
                    if (!ObjectUtils.isEmpty((Object)message)) {
                        throw new KDBizException(message);
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw e;
            }
        }
        return null;
    }

    protected boolean matchConditions(DynamicObject finBill) {
        String entityName = finBill.getDataEntityType().getName();
        boolean isAr = entityName.equals("ar_finarbill");
        String sourceBillType = finBill.getString("sourcebilltype");
        if (!isAr && EmptyUtils.isEmpty(sourceBillType)) {
            logger.info("WoffService-" + finBill.getString("billno") + "\u8d22\u52a1\u5355\u6ca1\u6709\u6e90\u5355\uff0c\u4e0d\u6ee1\u8db3\u51b2\u56de\u6761\u4ef6\u3002");
            return false;
        }
        BillModel model = BillModelFactory.getModel(entityName);
        DynamicObjectCollection entries = finBill.getDynamicObjectCollection(model.ENTRY);
        if (!ObjectUtils.isEmpty((Object)entries)) {
            DynamicObject entry = (DynamicObject)entries.get(0);
            String srcEntryId = entry.getString(model.E_SOURCEBILLENTRYID);
            String coreBillNo = entry.getString(model.E_COREBILLNO);
            if (isAr) {
                if ((EmptyUtils.isEmpty(sourceBillType) || EmptyUtils.isEmpty(srcEntryId)) && EmptyUtils.isEmpty(coreBillNo)) {
                    logger.info("WoffService-" + finBill.getString("billno") + "\u8d22\u52a1\u5355\u6ca1\u6709\u6e90\u5355\u5206\u5f55id\u548c\u6838\u5fc3\u5355\u636e\u53f7\uff0c\u4e0d\u6ee1\u8db3\u51b2\u56de\u6761\u4ef6\u3002");
                    return false;
                }
            } else if (EmptyUtils.isEmpty(srcEntryId)) {
                logger.info("WoffService-" + finBill.getString("billno") + "\u8d22\u52a1\u5355\u6ca1\u6709\u6e90\u5355\u5206\u5f55id\uff0c\u4e0d\u6ee1\u8db3\u51b2\u56de\u6761\u4ef6\u3002");
                return false;
            }
        }
        return true;
    }

    protected boolean isScmcBill(boolean isAr, String sourceBillType, DynamicObject entryInfo) {
        boolean isScmc = false;
        if (!isAr && (sourceBillType.startsWith("im_") || sourceBillType.startsWith("pm_") || sourceBillType.startsWith("sm_") || sourceBillType.startsWith("conm_"))) {
            isScmc = true;
        }
        return isScmc;
    }

    protected boolean isCoreBill(boolean isAr, DynamicObject entryInfo) {
        if (isAr) {
            Long entryId = entryInfo.getLong("id");
            String coreBillType = entryInfo.getString("e_corebilltype");
            String coreBillNo = entryInfo.getString("e_corebillno");
            int coreBillEntrySeq = entryInfo.getInt("e_corebillentryseq");
            if (!(StringUtils.isEmpty(coreBillType) || StringUtils.isEmpty(coreBillNo) || coreBillEntrySeq == 0 || this.srcBusFinIds.contains(entryId))) {
                return true;
            }
        }
        return false;
    }

    protected void fillSrcBusInfo4SameSource(Long orgId, List<WoffDetailInfo> infoGroups) {
        Map<Long, List<WoffDetailInfo>> finScmcSrcEntryIdMap = infoGroups.stream().collect(Collectors.groupingBy(WoffDetailInfo::getFinSrcEntryId));
        WoffHelper.fillSrcBusInfo(this.busEntityKey, orgId, "entry.e_srcentryid", finScmcSrcEntryIdMap);
    }

    protected void fillSrcBusInfo4CoreBill(Long orgId, List<WoffDetailInfo> infoGroups) {
        HashMap<String, List<WoffDetailInfo>> coreBillMap = new HashMap<String, List<WoffDetailInfo>>(8);
        HashSet<String> coreBillTypes = new HashSet<String>(8);
        HashSet<String> coreBillNos = new HashSet<String>(8);
        HashSet<Integer> coreBillEntrySeqs = new HashSet<Integer>(8);
        for (WoffDetailInfo woffDetailInfo : infoGroups) {
            String key;
            List woffDetailInfos;
            int coreBillEntrySeq;
            String coreBillNo;
            String coreBillType = woffDetailInfo.getCoreBillType();
            if (!StringUtils.isEmpty(coreBillType)) {
                coreBillTypes.add(coreBillType);
            }
            if (!StringUtils.isEmpty(coreBillNo = woffDetailInfo.getCoreBillNo())) {
                coreBillNos.add(coreBillNo);
            }
            if ((coreBillEntrySeq = woffDetailInfo.getCoreBillEntrySeq()) != 0) {
                coreBillEntrySeqs.add(coreBillEntrySeq);
            }
            if ((woffDetailInfos = (List)coreBillMap.get(key = coreBillType + "_" + coreBillNo + "_" + coreBillEntrySeq)) != null) {
                woffDetailInfos.add(woffDetailInfo);
                continue;
            }
            ArrayList<WoffDetailInfo> tmp_woffDetailInfos = new ArrayList<WoffDetailInfo>(8);
            tmp_woffDetailInfos.add(woffDetailInfo);
            coreBillMap.put(key, tmp_woffDetailInfos);
        }
        WoffHelper.fillSrcBusInfoByCoreBill(this.busEntityKey, orgId, coreBillTypes, coreBillNos, coreBillEntrySeqs, coreBillMap);
    }

    protected void updateSrcBusEntry(List<WoffDetailInfo> woffDetailInfos) {
        DynamicObject[] srcBusBills;
        Map<Long, List<WoffDetailInfo>> srcBusEntryIdMap = woffDetailInfos.stream().filter(woffDetailInfo -> WoffModeEnum.SAMESOURCE == woffDetailInfo.getWoffMode() || WoffModeEnum.COREBILL == woffDetailInfo.getWoffMode()).collect(Collectors.groupingBy(WoffDetailInfo::getSrcBusEntryId));
        Set<Long> srcBusEntryIdSet = srcBusEntryIdMap.keySet();
        logger.info("WoffService-\u540c\u6e90\u51b2\u56de\u573a\u666f\u9700\u8981\u66f4\u65b0\u6e90\u6682\u4f30\u5355\u5f00\u7968\u4fe1\u606f\uff1a" + srcBusEntryIdSet);
        for (DynamicObject srcBill : srcBusBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)"billno,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,payproperty.isbasedonamt,entry.id,entry.e_ispresent,entry.e_invoicedqty,entry.e_uninvoicedqty,entry.e_quantity,entry.e_invoicedamt,entry.e_uninvoicedamt,entry.e_invoicedlocamt,entry.e_uninvoicedlocamt,e_invoicednotaxamt,e_invnotaxlocalamt,e_uninvnotaxamt,e_uninvnotaxlocalamt,entry.linetype", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", srcBusEntryIdSet)})) {
            DynamicObjectCollection srcEntries = srcBill.getDynamicObjectCollection("entry");
            for (DynamicObject srcEntry : srcEntries) {
                Long entryId = srcEntry.getLong("id");
                if (!srcBusEntryIdSet.contains(entryId)) continue;
                List<WoffDetailInfo> woffDetailInfoList = srcBusEntryIdMap.get(entryId);
                BigDecimal finQuantity = BigDecimal.ZERO;
                BigDecimal finAmount = BigDecimal.ZERO;
                BigDecimal finLocalAmt = BigDecimal.ZERO;
                BigDecimal finPriceTaxTotal = BigDecimal.ZERO;
                BigDecimal finPriceTaxTotalLocal = BigDecimal.ZERO;
                boolean isAllWoff = false;
                for (WoffDetailInfo woffDetailInfo2 : woffDetailInfoList) {
                    finQuantity = finQuantity.add(woffDetailInfo2.getFinQuantity());
                    finAmount = finAmount.add(woffDetailInfo2.getFinAmount());
                    finLocalAmt = finLocalAmt.add(woffDetailInfo2.getFinLocAmt());
                    finPriceTaxTotal = finPriceTaxTotal.add(woffDetailInfo2.getFinPriceTaxTotal());
                    finPriceTaxTotalLocal = finPriceTaxTotalLocal.add(woffDetailInfo2.getFinPriceTaxTotalLocal());
                    if (isAllWoff) continue;
                    isAllWoff = woffDetailInfo2.isAllverify();
                }
                WoffHelper.retifyImBusData(srcBill, srcEntry, finPriceTaxTotal, finPriceTaxTotalLocal, finQuantity, finAmount, finLocalAmt, isAllWoff);
            }
        }
        SaveServiceHelper.update((DynamicObject[])srcBusBills);
    }

    protected void returnSrcBusEntry(DynamicObject[] finBills, Set<Long> srcBusIdSet) {
        long begin = System.currentTimeMillis();
        ArrayList<WoffDetailInfo> sameSourceFinDetailInfos = new ArrayList<WoffDetailInfo>(64);
        for (DynamicObject finBill : finBills) {
            String sourceBillType = finBill.getString("sourcebilltype");
            boolean isAr = "ar_finarbill".equals(finBill.getDynamicObjectType().getName());
            boolean isbasedonamt = false;
            DynamicObject payproperty = finBill.getDynamicObject("payproperty");
            if (payproperty != null) {
                isbasedonamt = payproperty.getBoolean("isbasedonamt");
            }
            DynamicObjectCollection entrys = finBill.getDynamicObjectCollection(this.finEntryKey);
            for (DynamicObject entry : entrys) {
                if (!this.isScmcBill(isAr, sourceBillType, entry) && !this.isCoreBill(isAr, entry)) continue;
                WoffDetailInfo finDetailInfo = this.getWoffDetailInfoByFin(finBill, entry, isbasedonamt);
                sameSourceFinDetailInfos.add(finDetailInfo);
            }
        }
        logger.info("---WoffService.returnSrcBusEntry.finBill---" + (System.currentTimeMillis() - begin) + "ms");
        begin = System.currentTimeMillis();
        Map<Long, List<WoffDetailInfo>> sameSourceFinEntryMap = sameSourceFinDetailInfos.stream().filter(info -> info.getFinSrcEntryId() != null && info.getFinSrcEntryId() != 0L).collect(Collectors.groupingBy(WoffDetailInfo::getFinSrcEntryId));
        Map<String, List<WoffDetailInfo>> sameCoreBillEntryMap = sameSourceFinDetailInfos.stream().filter(info -> !StringUtils.isEmpty(info.getCoreBillKey())).collect(Collectors.groupingBy(WoffDetailInfo::getCoreBillKey));
        HashMap<String, WoffDetailInfo> woffEntryMap = new HashMap<String, WoffDetailInfo>(this.sameSourceWoffDetailInfos.size());
        for (WoffDetailInfo sameSourceWoffDetailInfo : this.sameSourceWoffDetailInfos) {
            String key = sameSourceWoffDetailInfo.getFinId() + "-" + sameSourceWoffDetailInfo.getSrcBusEntryId();
            woffEntryMap.put(key, sameSourceWoffDetailInfo);
        }
        DynamicObject[] srcBusBills = BusinessDataServiceHelper.load((String)this.busEntityKey, (String)"payproperty.isbasedonamt,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,entry.id,entry.e_srcentryid,entry.e_ispresent,entry.e_invoicedqty,entry.e_uninvoicedqty,entry.e_invoicedamt,entry.e_uninvoicedamt,entry.e_invoicedlocamt,entry.e_uninvoicedlocamt,entry.e_invoicednotaxamt,entry.e_invnotaxlocalamt,entry.e_uninvnotaxamt,entry.e_uninvnotaxlocalamt,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq,entry.e_quantity", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIdSet)});
        logger.info("---WoffService.returnSrcBusEntry.loadSrcBusBills---" + (System.currentTimeMillis() - begin) + "ms");
        begin = System.currentTimeMillis();
        for (DynamicObject srcBusBill : srcBusBills) {
            boolean isAmt = srcBusBill.getBoolean("payproperty.isbasedonamt");
            DynamicObjectCollection srcBusEntrys = srcBusBill.getDynamicObjectCollection("entry");
            BigDecimal invoicedAmt = BigDecimal.ZERO;
            BigDecimal invoicedLocAmt = BigDecimal.ZERO;
            block4: for (DynamicObject srcBusEntry : srcBusEntrys) {
                Long sameSourceEntryId = srcBusEntry.getLong("e_srcentryid");
                List<WoffDetailInfo> finEntryInfos = sameSourceFinEntryMap.get(sameSourceEntryId);
                if (EmptyUtils.isEmpty(finEntryInfos)) {
                    String coreBillType = srcBusEntry.getString("e_corebilltype");
                    String coreBillNo = srcBusEntry.getString("e_corebillno");
                    int coreBillEntrySeq = srcBusEntry.getInt("e_corebillentryseq");
                    String coreBillKey = coreBillType + "_" + coreBillNo + "_" + coreBillEntrySeq;
                    finEntryInfos = sameCoreBillEntryMap.get(coreBillKey);
                    if (EmptyUtils.isEmpty(finEntryInfos)) continue;
                }
                for (WoffDetailInfo finEntryInfo : finEntryInfos) {
                    String key = finEntryInfo.getFinId() + "-" + srcBusEntry.getLong("id");
                    WoffDetailInfo sameSourceWoffDetailInfo = (WoffDetailInfo)woffEntryMap.get(key);
                    if (ObjectUtils.isEmpty((Object)sameSourceWoffDetailInfo)) continue;
                    BigDecimal e_invoicedAmt = finEntryInfo.getFinPriceTaxTotal();
                    BigDecimal e_invoicedLocAmt = finEntryInfo.getFinPriceTaxTotalLocal();
                    BigDecimal e_invoiceNoTaxAmt = finEntryInfo.getFinAmount();
                    BigDecimal e_invoiceNoTaxLocAmt = finEntryInfo.getFinLocAmt();
                    srcBusEntry.set("e_invoicedamt", (Object)srcBusEntry.getBigDecimal("e_invoicedamt").subtract(e_invoicedAmt));
                    srcBusEntry.set("e_invoicedlocamt", (Object)srcBusEntry.getBigDecimal("e_invoicedlocamt").subtract(e_invoicedLocAmt));
                    srcBusEntry.set("e_uninvoicedamt", (Object)srcBusEntry.getBigDecimal("e_uninvoicedamt").add(e_invoicedAmt));
                    srcBusEntry.set("e_uninvoicedlocamt", (Object)srcBusEntry.getBigDecimal("e_uninvoicedlocamt").add(e_invoicedLocAmt));
                    srcBusEntry.set("e_invoicednotaxamt", (Object)srcBusEntry.getBigDecimal("e_invoicednotaxamt").subtract(e_invoiceNoTaxAmt));
                    srcBusEntry.set("e_invnotaxlocalamt", (Object)srcBusEntry.getBigDecimal("e_invnotaxlocalamt").subtract(e_invoiceNoTaxLocAmt));
                    srcBusEntry.set("e_uninvnotaxamt", (Object)srcBusEntry.getBigDecimal("e_uninvnotaxamt").add(e_invoiceNoTaxAmt));
                    srcBusEntry.set("e_uninvnotaxlocalamt", (Object)srcBusEntry.getBigDecimal("e_uninvnotaxlocalamt").add(e_invoiceNoTaxLocAmt));
                    this.returnSrcBusEntryQty(isAmt, srcBusEntry, finEntryInfo.getFinQuantity());
                    invoicedAmt = invoicedAmt.add(e_invoicedAmt);
                    invoicedLocAmt = invoicedLocAmt.add(e_invoicedLocAmt);
                    continue block4;
                }
            }
            srcBusBill.set("invoicedamt", (Object)srcBusBill.getBigDecimal("invoicedamt").subtract(invoicedAmt));
            srcBusBill.set("invoicedlocamt", (Object)srcBusBill.getBigDecimal("invoicedlocamt").subtract(invoicedLocAmt));
            srcBusBill.set("uninvoicedamt", (Object)srcBusBill.getBigDecimal("uninvoicedamt").add(invoicedAmt));
            srcBusBill.set("uninvoicedlocamt", (Object)srcBusBill.getBigDecimal("uninvoicedlocamt").add(invoicedLocAmt));
        }
        SaveServiceHelper.update((DynamicObject[])srcBusBills);
        logger.info("---WoffService.returnSrcBusEntry.updateSrcBusBills---" + (System.currentTimeMillis() - begin) + "ms");
    }

    private void returnSrcBusEntryQty(boolean isAmt, DynamicObject srcBusEntry, BigDecimal finQuantity) {
        boolean isPresent = srcBusEntry.getBoolean("e_ispresent");
        if (isAmt && !isPresent) {
            BigDecimal uninvoicedAmt = srcBusEntry.getBigDecimal("e_uninvoicedamt");
            int compareTo = uninvoicedAmt.compareTo(BigDecimal.ZERO);
            if (compareTo == 0) {
                if (srcBusEntry.getBigDecimal("e_invoicedamt").compareTo(BigDecimal.ZERO) > 0) {
                    srcBusEntry.set("e_invoicedqty", (Object)1);
                    srcBusEntry.set("e_uninvoicedqty", (Object)0);
                } else if (srcBusEntry.getBigDecimal("e_invoicedamt").compareTo(BigDecimal.ZERO) == 0) {
                    srcBusEntry.set("e_invoicedqty", (Object)0);
                    srcBusEntry.set("e_uninvoicedqty", (Object)srcBusEntry.getBigDecimal("e_quantity"));
                } else {
                    srcBusEntry.set("e_invoicedqty", (Object)-1);
                    srcBusEntry.set("e_uninvoicedqty", (Object)0);
                }
            } else {
                boolean isDirection;
                BigDecimal quantity = srcBusEntry.getBigDecimal("e_quantity");
                boolean bl = isDirection = uninvoicedAmt.multiply(quantity).compareTo(BigDecimal.ZERO) > 0;
                if (isDirection) {
                    srcBusEntry.set("e_invoicedqty", (Object)0);
                    srcBusEntry.set("e_uninvoicedqty", (Object)srcBusEntry.getBigDecimal("e_quantity"));
                } else {
                    srcBusEntry.set("e_invoicedqty", (Object)srcBusEntry.getBigDecimal("e_quantity"));
                    srcBusEntry.set("e_uninvoicedqty", (Object)0);
                }
            }
        } else if (isAmt && isPresent) {
            int compareTo = srcBusEntry.getBigDecimal("e_uninvoicedqty").compareTo(BigDecimal.ZERO);
            switch (compareTo) {
                case 1: {
                    srcBusEntry.set("e_invoicedqty", (Object)1);
                    srcBusEntry.set("e_uninvoicedqty", (Object)0);
                    break;
                }
                case 0: {
                    if (srcBusEntry.getBigDecimal("e_invoicedqty").compareTo(BigDecimal.ZERO) > 0) {
                        srcBusEntry.set("e_invoicedqty", (Object)0);
                        srcBusEntry.set("e_uninvoicedqty", (Object)1);
                        break;
                    }
                    srcBusEntry.set("e_invoicedqty", (Object)0);
                    srcBusEntry.set("e_uninvoicedqty", (Object)-1);
                    break;
                }
                case -1: {
                    srcBusEntry.set("e_invoicedqty", (Object)-1);
                    srcBusEntry.set("e_uninvoicedqty", (Object)0);
                    break;
                }
            }
        } else {
            srcBusEntry.set("e_invoicedqty", (Object)srcBusEntry.getBigDecimal("e_invoicedqty").subtract(finQuantity));
            srcBusEntry.set("e_uninvoicedqty", (Object)srcBusEntry.getBigDecimal("e_uninvoicedqty").add(finQuantity));
        }
    }

    public Set<Long> initUnWoffDetailInfo(DynamicObject[] finBills) throws KDBizException {
        long begin = System.currentTimeMillis();
        this.initSrcModel(finBills);
        int size = finBills.length;
        HashSet<Long> finIds = new HashSet<Long>(size);
        HashSet<Long> sameSourceFinId = new HashSet<Long>(size);
        for (DynamicObject finBill : finBills) {
            boolean isAr = "ar_finarbill".equals(finBill.getDynamicObjectType().getName());
            finIds.add(finBill.getLong("id"));
            String sourceBillType = finBill.getString("sourcebilltype");
            DynamicObjectCollection entryCol = finBill.getDynamicObjectCollection(this.finEntryKey);
            for (DynamicObject entryInfo : entryCol) {
                if (!this.isScmcBill(isAr, sourceBillType, entryInfo) && !this.isCoreBill(isAr, entryInfo)) continue;
                sameSourceFinId.add(finBill.getLong("id"));
            }
        }
        logger.info("---WoffService.finIds---" + (System.currentTimeMillis() - begin) + "ms");
        begin = System.currentTimeMillis();
        try (DataSet woffDataSet = QueryServiceHelper.queryDataSet((String)"woffBillSet", (String)this.busEntityKey, (String)"id, srcfinbillid, sourcebillid, entry.e_srcbillid, entry.e_srcentryid, entry.e_corebillno, entry.e_corebillentryseq", (QFilter[])new QFilter[]{new QFilter("srcfinbillid", "in", finIds)}, (String)"");){
            for (Row woffRow : woffDataSet) {
                Long srcFinBillId = woffRow.getLong("srcfinbillid");
                this.woffIdMap.put(woffRow.getLong("id"), srcFinBillId);
                if (!sameSourceFinId.contains(srcFinBillId)) continue;
                WoffDetailInfo info = new WoffDetailInfo();
                info.setWoffBusId(woffRow.getLong("id"));
                Long srcBusId = woffRow.getLong("entry.e_srcbillid");
                if (ObjectUtils.isEmpty((Object)srcBusId)) {
                    String sourceBillId = woffRow.getString("sourcebillid");
                    if (ObjectUtils.isEmpty((Object)sourceBillId)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6682\u4f30\u51b2\u56de\u8f6c\u6362\u89c4\u5219\u7684\u5b57\u6bb5\u6620\u5c04\u4e2d\u3010\u5355\u636e\u5934.\u6e90\u5355ID\u3011\u3002", (String)"AbstractWoffService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    srcBusId = Long.parseLong(sourceBillId.split(",")[0]);
                }
                info.setSrcBusId(srcBusId);
                info.setSrcBusEntryId(woffRow.getLong("entry.e_srcentryid"));
                info.setFinId(srcFinBillId);
                this.sameSourceWoffDetailInfos.add(info);
            }
        }
        Set<Long> srcBusIdSet = this.sameSourceWoffDetailInfos.stream().map(WoffDetailInfo::getSrcBusId).collect(Collectors.toSet());
        logger.info("WoffService-\u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u88ab\u51b2\u56de\u7684\u6e90\u6682\u4f30\u5355ID\u96c6\u5408\uff1a" + srcBusIdSet);
        logger.info("---WoffService.srcBusIdSet---" + (System.currentTimeMillis() - begin) + "ms");
        return srcBusIdSet;
    }

    public List<ErrorInfo> delWoffBill(DynamicObject[] finBills, Set<Long> srcBusIdSet) throws KDBizException {
        List<ErrorInfo> errList;
        block25: {
            errList = null;
            try (TXHandle tx = TX.required((String)"delWoffBill");){
                if (ObjectUtils.isEmpty(this.woffIdMap)) {
                    List<ErrorInfo> list = errList;
                    return list;
                }
                try {
                    long begin = System.currentTimeMillis();
                    this.returnSrcBusEntry(finBills, srcBusIdSet);
                    logger.info("---WoffService.returnSrcBusEntry---" + (System.currentTimeMillis() - begin) + "ms");
                    begin = System.currentTimeMillis();
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", "true");
                    option.setVariableValue("mutex_writeback", "false");
                    Set<Long> delWoffIds = this.woffIdMap.keySet();
                    logger.info("WoffService-\u6240\u6709\u8981\u5220\u9664\u7684\u51b2\u56de\u5355ID\u96c6\u5408\uff1a" + delWoffIds);
                    OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"noprotocolunaudit", (String)this.busEntityKey, (Object[])delWoffIds.toArray(), (OperateOption)option);
                    logger.info("---WoffService.noprotocolunaudit---" + (System.currentTimeMillis() - begin) + "ms");
                    begin = System.currentTimeMillis();
                    if (unauditResult.isSuccess()) {
                        List successPkIds = unauditResult.getSuccessPkIds();
                        if (successPkIds.size() > 0) {
                            option.setVariableValue("isStrict", "false");
                            option.setVariableValue("ignoreValidation", "true");
                            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.busEntityKey, (Object[])successPkIds.toArray(), (OperateOption)option);
                            OperationHelper.assertResult(deleteResult);
                            logger.info("---WoffService.delete---" + (System.currentTimeMillis() - begin) + "ms");
                        }
                        break block25;
                    }
                    try {
                        OperationHelper.assertResult(unauditResult);
                        logger.info("------unauditResult.Message------" + unauditResult.getMessage());
                        errList = this.setErrorMsgList(unauditResult);
                    }
                    catch (Exception e) {
                        List validateInfos = unauditResult.getAllErrorOrValidateInfo();
                        StringBuilder sb = new StringBuilder();
                        if (validateInfos.isEmpty()) {
                            sb.append(unauditResult.getMessage());
                        } else {
                            for (IOperateInfo err : validateInfos) {
                                sb.append(err.getMessage()).append('\n');
                            }
                        }
                        ErrorCode errorCode = new ErrorCode("noprotocolunaudit_err", sb.toString());
                        logger.info("---WoffService.noprotocolunaudit_err---" + sb);
                        throw new OperationException(errorCode);
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                }
            }
        }
        return errList;
    }

    private List<ErrorInfo> setErrorMsgList(OperationResult opResult) {
        ArrayList<ErrorInfo> errList = new ArrayList<ErrorInfo>();
        StringBuilder sb = new StringBuilder();
        List validateErrors = opResult.getValidateResult().getValidateErrors();
        for (ValidateResult vr : validateErrors) {
            List allErrorInfo = vr.getAllErrorInfo();
            for (OperateErrorInfo errInfo : allErrorInfo) {
                sb.append(errInfo.getPkValue()).append(" -- ").append(errInfo.getMessage()).append(',');
                ErrorInfo error = new ErrorInfo();
                error.setPk(this.woffIdMap.get(errInfo.getPkValue()));
                error.setMsg(errInfo.getMessage());
                errList.add(error);
            }
        }
        logger.info(sb.append("------opResult.OperateErrors------").toString());
        return errList;
    }

    @Override
    public Result wholeDelWoffBill(DynamicObject[] finBills) throws KDBizException {
        Result result = null;
        try (TXHandle tx = TX.required((String)"wholeDelWoffBill");){
            try {
                List<ErrorInfo> errList;
                Set<Long> srcBusIds = this.initUnWoffDetailInfo(finBills);
                if (!ObjectUtils.isEmpty(srcBusIds)) {
                    ConcurrencyCtrlUtil.addCtrlInTX(this.busEntityKey, "woff", srcBusIds);
                }
                if (!ObjectUtils.isEmpty(errList = this.delWoffBill(finBills, srcBusIds))) {
                    result = Result.fail("6", ResManager.loadKDString((String)"\u5220\u9664\u51b2\u56de\u5355\u5931\u8d25\u3002", (String)"AbstractWoffService_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                    result.setData(errList);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
                throw e;
            }
        }
        return result;
    }
}

