/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.bus;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.bus.AbstractWoffService;
import kd.fi.arapcommon.service.bus.ArWoffService;

public class ApWoffService
extends AbstractWoffService {
    private static final Log logger = LogFactory.getLog(ArWoffService.class);
    protected Map<Long, Boolean> orgParamMap = new HashMap<Long, Boolean>();

    public ApWoffService() {
        this.finBillKey = "ap_finapbill";
        this.finEntryKey = "detailentry";
        this.finQuantityKey = "quantity";
        this.finSrcIdKey = "e_sourcebillid";
        this.finSrcEntryIdKey = "e_sourcebillentryid";
        this.busEntityKey = "ap_busbill";
        this.woffRuleId = "712748085842822144";
        this.priceTaxTotalKey = "pricetaxtotal";
        this.priceTaxTotalLocalKey = "pricetaxtotalbase";
        this.e_priceTaxTotalKey = "e_pricetaxtotal";
        this.e_priceTaxTotalLocalKey = "e_pricetaxtotalbase";
        this.amountKey = "amount";
        this.e_amountKey = "e_amount";
        this.e_localAmtKey = "e_amountbase";
    }

    @Override
    public boolean matchConditions(DynamicObject finBill) {
        boolean flag;
        boolean isMatch = super.matchConditions(finBill);
        if (!isMatch) {
            return false;
        }
        Long orgPk = finBill.getLong("org.id");
        boolean p004 = false;
        if (!this.orgParamMap.containsKey(orgPk)) {
            p004 = this.getBizParam(orgPk, "ap_004");
            this.orgParamMap.put(orgPk, p004);
        } else {
            p004 = this.orgParamMap.get(orgPk);
        }
        if (!p004) {
            logger.info("\u7ec4\u7ec7ID\uff1a%d \u7cfb\u7edf\u53c2\u6570\u4e0d\u51b2\u56de\u3002", (Object)orgPk);
            return false;
        }
        boolean bl = flag = finBill.getBoolean("istanspay") || finBill.getBoolean("ispremium") || BillTypeConsts.APFIN_BORROW.compareTo(finBill.getLong("billtypeid.id")) == 0;
        if (flag) {
            logger.info(finBill.getString("billno") + "\u8d22\u52a1\u5355\u4e0d\u6ee1\u8db3\u51b2\u56de\u6761\u4ef6\uff0c\u53ef\u80fd\u539f\u56e0\u6e90\u5355\u662f\u8d22\u52a1\u5355\uff0c\u5305\u62ec\u8f6c\u4ed8\u3001\u8d28\u4fdd\u91d1\u5355\u636e\u3001\u501f\u8d37\u9879\u8c03\u6574\uff0c\u51b2\u9500\u5355\u7279\u6b8a\u5904\u7406\u3002");
            return false;
        }
        return true;
    }

    public boolean getBizParam(Object orgPk, String param) {
        boolean p = false;
        Object v = ArApHelper.getParameter(orgPk, param, false);
        if (!ObjectUtils.isEmpty((Object)v)) {
            if (v instanceof Boolean) {
                p = (Boolean)v;
            } else if (v instanceof String) {
                p = "1".equals(v);
            }
        }
        return p;
    }
}

