/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.bus;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.service.bus.WoffModeEnum;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;

public class WoffDetailInfo {
    private Long finId;
    private String finBillNo;
    private Long finEntryId;
    private boolean isBasedonamt = false;
    private boolean isFinWrittenoff = false;
    private String finSrcBillType;
    private boolean isScmcBill;
    private boolean isCoreBill;
    private String coreBillType;
    private String coreBillNo;
    private int coreBillEntrySeq;
    private Long coreBillId;
    private Long coreBillEntryId;
    private String coreBillKey;
    private WoffModeEnum woffMode;
    private Long finSrcId;
    private Long finSrcEntryId;
    private boolean isAllverify = false;
    private BigDecimal finQuantity = BigDecimal.ZERO;
    private BigDecimal finAmount = BigDecimal.ZERO;
    private BigDecimal finLocAmt = BigDecimal.ZERO;
    private BigDecimal finPriceTaxTotal = BigDecimal.ZERO;
    private BigDecimal finPriceTaxTotalLocal = BigDecimal.ZERO;
    private Long srcBusId;
    private Long srcBusEntryId;
    private DynamicObject srcBusEntryInfo;
    private Long woffBusId;
    private Date woffBizDate;
    private BigDecimal quantity = BigDecimal.ZERO;
    private BigDecimal discountAmt = BigDecimal.ZERO;
    private BigDecimal tax = BigDecimal.ZERO;
    private BigDecimal taxLocAmt = BigDecimal.ZERO;
    private BigDecimal amount = BigDecimal.ZERO;
    private BigDecimal localAmt = BigDecimal.ZERO;
    private BigDecimal priceTaxTotal = BigDecimal.ZERO;
    private BigDecimal priceTaxTotalLocal = BigDecimal.ZERO;
    private Long lineType;
    private Long expenseItem;

    public void setFinSrcBillType(String finSrcBillType) {
        this.finSrcBillType = finSrcBillType;
    }

    public void setScmcBill(boolean scmcBill) {
        this.isScmcBill = scmcBill;
    }

    public void initWoffMode() {
        this.woffMode = !ObjectUtils.isEmpty((Object)this.finSrcBillType) && ("ar_busbill".equals(this.finSrcBillType) || "ap_busbill".equals(this.finSrcBillType)) ? WoffModeEnum.DIRECT : (this.isFinWrittenoff ? WoffModeEnum.WRITTENOFF : (this.isScmcBill ? WoffModeEnum.SAMESOURCE : (this.isCoreBill ? WoffModeEnum.COREBILL : WoffModeEnum.INDIRECT)));
    }

    public void fillWoffInfo(BusEntryInfo busWoffInfo, String priceTaxTotalKey, String priceTaxTotalLocalKey) {
        if (this.srcBusEntryInfo == null) {
            return;
        }
        BigDecimal busUnwoffQty = this.srcBusEntryInfo.getBigDecimal("entry.e_quantity").add(busWoffInfo.getQuantity()).negate();
        BigDecimal busUnwoffAmt = this.srcBusEntryInfo.getBigDecimal("entry." + priceTaxTotalKey).add(busWoffInfo.getRecAmount()).negate();
        BigDecimal busUnwoffNoTaxAmt = this.srcBusEntryInfo.getBigDecimal("entry.e_amount").add(busWoffInfo.getAmount()).negate();
        this.quantity = this.finQuantity.negate();
        boolean isAllWoff = this.isAllverify;
        if (this.isBasedonamt) {
            boolean bl = isAllWoff = isAllWoff || busUnwoffNoTaxAmt.abs().compareTo(this.finAmount.abs()) <= 0;
            if (!this.srcBusEntryInfo.getBoolean("entry.e_ispresent") && this.finPriceTaxTotal.compareTo(BigDecimal.ZERO) != 0) {
                this.quantity = new BigDecimal(busUnwoffAmt.compareTo(BigDecimal.ZERO));
            } else if (isAllWoff) {
                this.quantity = busUnwoffQty;
            }
        } else {
            boolean bl = isAllWoff = isAllWoff || busUnwoffQty.abs().compareTo(this.finQuantity.abs()) <= 0;
            if (isAllWoff) {
                this.quantity = busUnwoffQty;
            }
        }
        PriceLocalCalculator localCalculator = this.calculate();
        this.discountAmt = localCalculator.getDiscountamount();
        if (isAllWoff) {
            busWoffInfo.setIsWoff(true);
            this.isAllverify = true;
            this.tax = this.srcBusEntryInfo.getBigDecimal("entry.e_tax").add(busWoffInfo.getTax()).negate();
            this.taxLocAmt = this.srcBusEntryInfo.getBigDecimal("entry.e_taxlocalamt").add(busWoffInfo.getTaxLocAmt()).negate();
            this.amount = this.srcBusEntryInfo.getBigDecimal("entry.e_amount").add(busWoffInfo.getAmount()).negate();
            this.localAmt = this.srcBusEntryInfo.getBigDecimal("entry.e_localamt").add(busWoffInfo.getLocalAmt()).negate();
            this.priceTaxTotal = busUnwoffAmt;
            this.priceTaxTotalLocal = this.srcBusEntryInfo.getBigDecimal("entry." + priceTaxTotalLocalKey).add(busWoffInfo.getRecLocAmt()).negate();
        } else {
            this.tax = localCalculator.getTax();
            this.taxLocAmt = localCalculator.getTaxlocal();
            this.amount = localCalculator.getAmount();
            this.localAmt = localCalculator.getAmountlocal();
            this.priceTaxTotal = localCalculator.getPricetaxtotal();
            this.priceTaxTotalLocal = localCalculator.getPricetaxtotallocal();
            busWoffInfo.setQuantity(busWoffInfo.getQuantity().add(this.quantity));
            busWoffInfo.setTax(busWoffInfo.getTax().add(this.tax));
            busWoffInfo.setTaxLocAmt(busWoffInfo.getTaxLocAmt().add(this.taxLocAmt));
            busWoffInfo.setAmount(busWoffInfo.getAmount().add(this.amount));
            busWoffInfo.setLocalAmt(busWoffInfo.getLocalAmt().add(this.localAmt));
            busWoffInfo.setRecAmount(busWoffInfo.getRecAmount().add(this.priceTaxTotal));
            busWoffInfo.setRecLocAmt(busWoffInfo.getRecLocAmt().add(this.priceTaxTotalLocal));
        }
    }

    private PriceLocalCalculator calculate() {
        BigDecimal rate = this.srcBusEntryInfo.getBigDecimal("exchangerate");
        String quotation = this.srcBusEntryInfo.getString("quotation");
        boolean includeTax = this.srcBusEntryInfo.getBoolean("isincludetax");
        int precision = this.srcBusEntryInfo.getInt("currency.amtprecision");
        int localprecision = this.srcBusEntryInfo.getInt("basecurrency.amtprecision");
        AbstractPriceCalculator calculator = null;
        BigDecimal taxRate = this.srcBusEntryInfo.getBigDecimal("entry.e_taxrate");
        String discountMode = this.srcBusEntryInfo.getString("entry.e_discountmode");
        BigDecimal discountRate = this.srcBusEntryInfo.getBigDecimal("entry.e_discountrate");
        BigDecimal discountAmount = this.srcBusEntryInfo.getBigDecimal("entry.e_discountamount").negate();
        if (this.isBasedonamt) {
            discountMode = "NULL";
            discountRate = BigDecimal.ZERO;
            BigDecimal woffAmt = this.finAmount.negate();
            calculator = new PriceTotalCalculator(this.quantity, woffAmt, taxRate, discountMode, discountRate, precision);
        } else if (includeTax) {
            if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                discountAmount = discountRate.multiply(this.quantity).setScale(precision, RoundingMode.HALF_UP);
            }
            calculator = new TaxUnitPriceCalculator(this.quantity, this.srcBusEntryInfo.getBigDecimal("entry.e_taxunitprice"), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmount);
        } else {
            if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                discountAmount = discountRate.multiply(this.quantity).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP);
            }
            calculator = new UnitPriceCalculator(this.quantity, this.srcBusEntryInfo.getBigDecimal("entry.e_unitprice"), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmount);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, rate, localprecision, quotation);
        localCalculator.calculate();
        return localCalculator;
    }

    public Long getFinId() {
        return this.finId;
    }

    public void setFinId(Long finId) {
        this.finId = finId;
    }

    public String getFinBillNo() {
        return this.finBillNo;
    }

    public void setFinBillNo(String finBillNo) {
        this.finBillNo = finBillNo;
    }

    public Long getFinEntryId() {
        return this.finEntryId;
    }

    public void setFinEntryId(Long finEntryId) {
        this.finEntryId = finEntryId;
    }

    public boolean isBasedonamt() {
        return this.isBasedonamt;
    }

    public void setBasedonamt(boolean basedonamt) {
        this.isBasedonamt = basedonamt;
    }

    public boolean isFinWrittenoff() {
        return this.isFinWrittenoff;
    }

    public void setFinWrittenoff(boolean finWrittenoff) {
        this.isFinWrittenoff = finWrittenoff;
    }

    public boolean isCoreBill() {
        return this.isCoreBill;
    }

    public void setCoreBill(boolean coreBill) {
        this.isCoreBill = coreBill;
    }

    public String getCoreBillType() {
        return this.coreBillType;
    }

    public void setCoreBillType(String coreBillType) {
        this.coreBillType = coreBillType;
    }

    public String getCoreBillNo() {
        return this.coreBillNo;
    }

    public void setCoreBillNo(String coreBillNo) {
        this.coreBillNo = coreBillNo;
    }

    public int getCoreBillEntrySeq() {
        return this.coreBillEntrySeq;
    }

    public void setCoreBillEntrySeq(int coreBillEntrySeq) {
        this.coreBillEntrySeq = coreBillEntrySeq;
    }

    public Long getCoreBillId() {
        return this.coreBillId;
    }

    public void setCoreBillId(Long coreBillId) {
        this.coreBillId = coreBillId;
    }

    public Long getCoreBillEntryId() {
        return this.coreBillEntryId;
    }

    public void setCoreBillEntryId(Long coreBillEntryId) {
        this.coreBillEntryId = coreBillEntryId;
    }

    public String getCoreBillKey() {
        return this.coreBillKey;
    }

    public void setCoreBillKey(String coreBillKey) {
        this.coreBillKey = coreBillKey;
    }

    public String getFinSrcBillType() {
        return this.finSrcBillType;
    }

    public boolean isScmcBill() {
        return this.isScmcBill;
    }

    public WoffModeEnum getWoffMode() {
        return this.woffMode;
    }

    public void setWoffMode(WoffModeEnum woffMode) {
        this.woffMode = woffMode;
    }

    public Long getFinSrcId() {
        return this.finSrcId;
    }

    public void setFinSrcId(Long finSrcId) {
        this.finSrcId = finSrcId;
    }

    public Long getFinSrcEntryId() {
        return this.finSrcEntryId;
    }

    public void setFinSrcEntryId(Long finSrcEntryId) {
        this.finSrcEntryId = finSrcEntryId;
    }

    public boolean isAllverify() {
        return this.isAllverify;
    }

    public void setAllverify(boolean allverify) {
        this.isAllverify = allverify;
    }

    public BigDecimal getFinQuantity() {
        return this.finQuantity;
    }

    public void setFinQuantity(BigDecimal finQuantity) {
        this.finQuantity = finQuantity;
    }

    public BigDecimal getFinPriceTaxTotal() {
        return this.finPriceTaxTotal;
    }

    public void setFinPriceTaxTotal(BigDecimal finPriceTaxTotal) {
        this.finPriceTaxTotal = finPriceTaxTotal;
    }

    public BigDecimal getFinPriceTaxTotalLocal() {
        return this.finPriceTaxTotalLocal;
    }

    public void setFinPriceTaxTotalLocal(BigDecimal finPriceTaxTotalLocal) {
        this.finPriceTaxTotalLocal = finPriceTaxTotalLocal;
    }

    public Long getSrcBusId() {
        return this.srcBusId;
    }

    public void setSrcBusId(Long srcBusId) {
        this.srcBusId = srcBusId;
    }

    public Long getSrcBusEntryId() {
        return this.srcBusEntryId;
    }

    public void setSrcBusEntryId(Long srcBusEntryId) {
        this.srcBusEntryId = srcBusEntryId;
    }

    public DynamicObject getSrcBusEntryInfo() {
        return this.srcBusEntryInfo;
    }

    public void setSrcBusEntryInfo(DynamicObject srcBusEntryInfo) {
        this.srcBusEntryInfo = srcBusEntryInfo;
    }

    public Long getWoffBusId() {
        return this.woffBusId;
    }

    public void setWoffBusId(Long woffBusId) {
        this.woffBusId = woffBusId;
    }

    public Date getWoffBizDate() {
        return this.woffBizDate;
    }

    public void setWoffBizDate(Date woffBizDate) {
        this.woffBizDate = woffBizDate;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getDiscountAmt() {
        return this.discountAmt;
    }

    public void setDiscountAmt(BigDecimal discountAmt) {
        this.discountAmt = discountAmt;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getTaxLocAmt() {
        return this.taxLocAmt;
    }

    public void setTaxLocAmt(BigDecimal taxLocAmt) {
        this.taxLocAmt = taxLocAmt;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getLocalAmt() {
        return this.localAmt;
    }

    public void setLocalAmt(BigDecimal localAmt) {
        this.localAmt = localAmt;
    }

    public BigDecimal getPriceTaxTotal() {
        return this.priceTaxTotal;
    }

    public void setPriceTaxTotal(BigDecimal priceTaxTotal) {
        this.priceTaxTotal = priceTaxTotal;
    }

    public BigDecimal getPriceTaxTotalLocal() {
        return this.priceTaxTotalLocal;
    }

    public void setPriceTaxTotalLocal(BigDecimal priceTaxTotalLocal) {
        this.priceTaxTotalLocal = priceTaxTotalLocal;
    }

    public BigDecimal getFinAmount() {
        return this.finAmount;
    }

    public void setFinAmount(BigDecimal finAmount) {
        this.finAmount = finAmount;
    }

    public BigDecimal getFinLocAmt() {
        return this.finLocAmt;
    }

    public void setFinLocAmt(BigDecimal finLocAmt) {
        this.finLocAmt = finLocAmt;
    }

    public Long getLineType() {
        return this.lineType;
    }

    public void setLineType(Long lineType) {
        this.lineType = lineType;
    }

    public Long getExpenseItem() {
        return this.expenseItem;
    }

    public void setExpenseItem(Long expenseItem) {
        this.expenseItem = expenseItem;
    }
}

