/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.bus;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.service.bus.WoffDetailInfo;
import kd.fi.arapcommon.service.woff.info.BusEntryInfo;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class WoffHelper {
    private static final Log logger = LogFactory.getLog(WoffHelper.class);
    public static final String finArSelectFields = "id,billno,org.id,org.name,payproperty.isbasedonamt,bizdate,billtype,sourcebilltype,istransfer,iswrittenoff,entry.id,entry.e_srcid,entry.e_srcentryid,entry.e_isallverify,entry.e_quantity,entry.e_recamount,entry.e_reclocalamt,entry.linetype";
    public static final String finApSelectFields = "id,billno,org.id,org.name,payproperty.isbasedonamt,bizdate,billtypeid,sourcebilltype,istanspay,ispremium,iswrittenoff,detailentry.id,detailentry.e_sourcebillid,detailentry.e_sourcebillentryid,detailentry.e_isallverify,detailentry.quantity,detailentry.e_pricetaxtotal,detailentry.e_pricetaxtotalbase,detailentry.linetype";
    public static final String busSelectFields = "id,quotation,exchangerate,currency.amtprecision,basecurrency.amtprecision,isincludetax,entry.id,entry.e_srcentryid,entry.e_ispresent,entry.e_unitprice,entry.e_taxunitprice,entry.e_taxrate,entry.e_discountmode,entry.e_discountrate,entry.e_discountamount,entry.e_quantity,entry.e_amount,entry.e_localamt,entry.e_tax,entry.e_taxlocalamt,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq,entry.linetype,billtype.number,entry.e_expenseitem";
    public static final String srcBusSelectFields = "billno,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,payproperty.isbasedonamt,entry.id,entry.e_ispresent,entry.e_invoicedqty,entry.e_uninvoicedqty,entry.e_quantity,entry.e_invoicedamt,entry.e_uninvoicedamt,entry.e_invoicedlocamt,entry.e_uninvoicedlocamt,e_invoicednotaxamt,e_invnotaxlocalamt,e_uninvnotaxamt,e_uninvnotaxlocalamt,entry.linetype";

    public static String newWoffService() {
        String newWoffService = StdConfig.get("newWoffService");
        if (EmptyUtils.isEmpty(newWoffService)) {
            newWoffService = "false";
        }
        return newWoffService;
    }

    public static void fillSrcBusInfo(String busEntityKey, Long orgId, String propertyKey, Map<Long, List<WoffDetailInfo>> matchFinEntryIdMap) {
        boolean isAr = "ar_busbill".equals(busEntityKey);
        String e_priceTaxTotalKey = isAr ? "entry.e_recamount" : "entry.e_pricetaxtotal";
        String e_priceTaxTotalLocalKey = isAr ? "entry.e_reclocalamt" : "entry.e_pricetaxtotalbase";
        Set<Long> srcBusFilterIds = matchFinEntryIdMap.keySet();
        logger.info("WoffService-fillSrcBusInfo propertyKey: " + propertyKey + ", Ids: " + srcBusFilterIds);
        QFilter filter = new QFilter(propertyKey, "in", srcBusFilterIds).and("billstatus", "=", (Object)"C").and("entry.e_unwoffqty", "<>", (Object)BigDecimal.ZERO);
        if (orgId != null) {
            filter = filter.and("org", "=", (Object)orgId);
        }
        DynamicObjectCollection srcBusEntrys = QueryServiceHelper.query((String)busEntityKey, (String)("id,quotation,exchangerate,currency.amtprecision,basecurrency.amtprecision,isincludetax,entry.id,entry.e_srcentryid,entry.e_ispresent,entry.e_unitprice,entry.e_taxunitprice,entry.e_taxrate,entry.e_discountmode,entry.e_discountrate,entry.e_discountamount,entry.e_quantity,entry.e_amount,entry.e_localamt,entry.e_tax,entry.e_taxlocalamt,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq,entry.linetype,billtype.number,entry.e_expenseitem," + e_priceTaxTotalKey + "," + e_priceTaxTotalLocalKey), (QFilter[])new QFilter[]{filter});
        for (DynamicObject srcBusEntry : srcBusEntrys) {
            List<WoffDetailInfo> infos = matchFinEntryIdMap.get(srcBusEntry.getLong(propertyKey));
            String billTypeNum = srcBusEntry.getString("billtype.number");
            Long finLineTypeId = srcBusEntry.getLong("entry.linetype");
            Long finexpenseItemId = srcBusEntry.getLong("entry.e_expenseitem");
            for (WoffDetailInfo info : infos) {
                if ("ap_busbill_salefee_BT_S".equals(billTypeNum) || "ap_busbill_purfee_BT_S".equals(billTypeNum)) {
                    Long busLineTypeId = info.getLineType();
                    Long expenseItem = info.getExpenseItem();
                    if (!finLineTypeId.equals(busLineTypeId) || !expenseItem.equals(finexpenseItemId)) continue;
                    info.setSrcBusId(srcBusEntry.getLong("id"));
                    info.setSrcBusEntryId(srcBusEntry.getLong("entry.id"));
                    info.setSrcBusEntryInfo(srcBusEntry);
                    continue;
                }
                info.setSrcBusId(srcBusEntry.getLong("id"));
                info.setSrcBusEntryId(srcBusEntry.getLong("entry.id"));
                info.setSrcBusEntryInfo(srcBusEntry);
            }
        }
    }

    public static void fillSrcBusInfoByCoreBill(String busEntityKey, Long orgId, Set<String> coreBillTypes, Set<String> coreBillNos, Set<Integer> coreBillEntrySeqs, Map<String, List<WoffDetailInfo>> coreBillMap) {
        boolean isAr = "ar_busbill".equals(busEntityKey);
        String e_priceTaxTotalKey = isAr ? "entry.e_recamount" : "entry.e_pricetaxtotal";
        String e_priceTaxTotalLocalKey = isAr ? "entry.e_reclocalamt" : "entry.e_pricetaxtotalbase";
        QFilter filter = new QFilter("entry.e_corebilltype", "in", coreBillTypes);
        filter.and(new QFilter("entry.e_corebillno", "in", coreBillNos));
        filter.and(new QFilter("entry.e_corebillentryseq", "in", coreBillEntrySeqs));
        filter.and(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        if (orgId != null) {
            filter = filter.and("org", "=", (Object)orgId);
        }
        DynamicObjectCollection srcBusEntrys = QueryServiceHelper.query((String)busEntityKey, (String)("id,quotation,exchangerate,currency.amtprecision,basecurrency.amtprecision,isincludetax,entry.id,entry.e_srcentryid,entry.e_ispresent,entry.e_unitprice,entry.e_taxunitprice,entry.e_taxrate,entry.e_discountmode,entry.e_discountrate,entry.e_discountamount,entry.e_quantity,entry.e_amount,entry.e_localamt,entry.e_tax,entry.e_taxlocalamt,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillentryseq,entry.linetype,billtype.number,entry.e_expenseitem," + e_priceTaxTotalKey + "," + e_priceTaxTotalLocalKey), (QFilter[])new QFilter[]{filter});
        for (DynamicObject srcBusEntry : srcBusEntrys) {
            String coreBillType = srcBusEntry.getString("entry.e_corebilltype");
            String coreBillNo = srcBusEntry.getString("entry.e_corebillno");
            int coreBillEntrySeq = srcBusEntry.getInt("entry.e_corebillentryseq");
            String key = coreBillType + "_" + coreBillNo + "_" + coreBillEntrySeq;
            List infos = coreBillMap.getOrDefault(key, new ArrayList(2));
            for (WoffDetailInfo info : infos) {
                BigDecimal finQuantity;
                BigDecimal busQuantity = srcBusEntry.getBigDecimal("entry.e_quantity");
                if (busQuantity.multiply(finQuantity = info.getFinQuantity()).compareTo(BigDecimal.ZERO) <= 0) continue;
                info.setSrcBusId(srcBusEntry.getLong("id"));
                info.setSrcBusEntryId(srcBusEntry.getLong("entry.id"));
                info.setSrcBusEntryInfo(srcBusEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, BusEntryInfo> getWoffInfoMap(String busEntityKey, Long orgId, Set<Long> srcBusEntryIds) {
        HashMap<Long, BusEntryInfo> woffMap = new HashMap<Long, BusEntryInfo>(64);
        QFilter filter = new QFilter("org", "=", (Object)orgId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isadjust", "=", (Object)"1").and("writeoffbusiness", "=", (Object)Boolean.FALSE).and("entry.e_srcentryid", "in", srcBusEntryIds);
        boolean isAr = "ar_busbill".equals(busEntityKey);
        String recAmountKey = isAr ? "entry.e_recamount" : "entry.e_pricetaxtotal";
        String recLocAmtKey = isAr ? "entry.e_reclocalamt" : "entry.e_pricetaxtotalbase";
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"woff.getWoffInfoMap", (String)busEntityKey, (String)("entry.e_srcbillid, entry.e_srcentryid, entry.e_quantity, entry.e_tax, entry.e_taxlocalamt, entry.e_amount, entry.e_localamt, " + recAmountKey + "," + recLocAmtKey), (QFilter[])new QFilter[]{filter}, null);
            ds = ds.groupBy(new String[]{"entry.e_srcentryid", "entry.e_srcentryid"}).sum("entry.e_quantity", "fqty").sum("entry.e_tax", "ftax").sum("entry.e_taxlocalamt", "ftaxlocamt").sum("entry.e_amount", "famt").sum("entry.e_localamt", "flocamt").sum(recAmountKey, "frecamt").sum(recLocAmtKey, "freclocamt").finish();
            for (Row entry : ds) {
                BusEntryInfo weInfo = new BusEntryInfo();
                Long srcEntryId = entry.getLong("entry.e_srcentryid");
                weInfo.setSrcEntryPk(srcEntryId);
                weInfo.setQuantity(entry.getBigDecimal("fqty"));
                weInfo.setTax(entry.getBigDecimal("ftax"));
                weInfo.setTaxLocAmt(entry.getBigDecimal("ftaxlocamt"));
                weInfo.setAmount(entry.getBigDecimal("famt"));
                weInfo.setLocalAmt(entry.getBigDecimal("flocamt"));
                weInfo.setRecAmount(entry.getBigDecimal("frecamt"));
                weInfo.setRecLocAmt(entry.getBigDecimal("freclocamt"));
                woffMap.put(srcEntryId, weInfo);
            }
        }
        return woffMap;
    }

    public static void retifyImBusData(DynamicObject srcBill, DynamicObject srcEntry, BigDecimal finPriceTaxTotal, BigDecimal finPriceTaxTotalLocal, BigDecimal finQuantity, BigDecimal finAmount, BigDecimal finLocalAmt, boolean isAllWoff) {
        boolean isAmt = srcBill.getBoolean("payproperty.isbasedonamt");
        if (BigDecimal.ZERO.compareTo(finPriceTaxTotal) != 0) {
            srcEntry.set("e_invoicedamt", (Object)srcEntry.getBigDecimal("e_invoicedamt").add(finPriceTaxTotal));
            srcEntry.set("e_uninvoicedamt", (Object)srcEntry.getBigDecimal("e_uninvoicedamt").subtract(finPriceTaxTotal));
            srcEntry.set("e_invoicedlocamt", (Object)srcEntry.getBigDecimal("e_invoicedlocamt").add(finPriceTaxTotalLocal));
            srcEntry.set("e_uninvoicedlocamt", (Object)srcEntry.getBigDecimal("e_uninvoicedlocamt").subtract(finPriceTaxTotalLocal));
            srcEntry.set("e_invoicednotaxamt", (Object)srcEntry.getBigDecimal("e_invoicednotaxamt").add(finAmount));
            srcEntry.set("e_invnotaxlocalamt", (Object)srcEntry.getBigDecimal("e_invnotaxlocalamt").add(finLocalAmt));
            srcEntry.set("e_uninvnotaxamt", (Object)srcEntry.getBigDecimal("e_uninvnotaxamt").subtract(finAmount));
            srcEntry.set("e_uninvnotaxlocalamt", (Object)srcEntry.getBigDecimal("e_uninvnotaxlocalamt").subtract(finLocalAmt));
            srcBill.set("invoicedamt", (Object)srcBill.getBigDecimal("invoicedamt").add(finPriceTaxTotal));
            srcBill.set("uninvoicedamt", (Object)srcBill.getBigDecimal("uninvoicedamt").subtract(finPriceTaxTotal));
            srcBill.set("invoicedlocamt", (Object)srcBill.getBigDecimal("invoicedlocamt").add(finPriceTaxTotalLocal));
            srcBill.set("uninvoicedlocamt", (Object)srcBill.getBigDecimal("uninvoicedlocamt").subtract(finPriceTaxTotalLocal));
        }
        if (BigDecimal.ZERO.compareTo(finQuantity) != 0) {
            boolean isPresent = srcEntry.getBoolean("e_ispresent");
            if (Objects.nonNull(isAmt) && isAmt && !isPresent) {
                if (isAllWoff) {
                    srcEntry.set("e_invoicedqty", (Object)srcEntry.getBigDecimal("e_quantity"));
                    srcEntry.set("e_uninvoicedqty", (Object)0);
                } else {
                    srcEntry.set("e_invoicedqty", (Object)0);
                    srcEntry.set("e_uninvoicedqty", (Object)srcEntry.getBigDecimal("e_quantity"));
                }
            } else if (Objects.nonNull(isAmt) && isAmt && isPresent) {
                int compareTo = srcEntry.getBigDecimal("e_uninvoicedqty").compareTo(BigDecimal.ZERO);
                switch (compareTo) {
                    case 1: {
                        srcEntry.set("e_invoicedqty", (Object)1);
                        srcEntry.set("e_uninvoicedqty", (Object)0);
                        break;
                    }
                    case 0: {
                        if (srcEntry.getBigDecimal("e_invoicedqty").compareTo(BigDecimal.ZERO) > 0) {
                            srcEntry.set("e_invoicedqty", (Object)0);
                            srcEntry.set("e_uninvoicedqty", (Object)1);
                            break;
                        }
                        srcEntry.set("e_invoicedqty", (Object)0);
                        srcEntry.set("e_uninvoicedqty", (Object)-1);
                        break;
                    }
                    case -1: {
                        srcEntry.set("e_invoicedqty", (Object)-1);
                        srcEntry.set("e_uninvoicedqty", (Object)0);
                        break;
                    }
                }
            } else {
                srcEntry.set("e_invoicedqty", (Object)srcEntry.getBigDecimal("e_invoicedqty").add(finQuantity));
                srcEntry.set("e_uninvoicedqty", (Object)srcEntry.getBigDecimal("e_uninvoicedqty").subtract(finQuantity));
            }
        }
    }

    public static List<Set<Long>> splitList(List<Long> list) {
        ArrayList<Set<Long>> groupList = new ArrayList<Set<Long>>();
        HashSet<Long> set = new HashSet<Long>(64);
        for (int i = 0; i < list.size(); ++i) {
            Long aLong = list.get(i);
            if (!set.add(aLong)) continue;
            list.remove(i);
            --i;
        }
        groupList.add(set);
        if (list.size() > 0) {
            groupList.addAll(WoffHelper.splitList(list));
        }
        return groupList;
    }
}

