/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.service.buswoff.AbstractBusWoffService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public abstract class AbstractBusSameSourceWoff
extends AbstractBusWoffService {
    @Override
    public BusWoffResult busAssignWoff(Set<Long> finIds, Map<Long, BFRowId> sourceBusBFRowMap) {
        return this.busWoff(finIds);
    }

    @Override
    protected Map<String, String> getOtherMatchField() {
        Map<String, String> matchFieldMapCommon = super.getOtherMatchField();
        HashMap<String, String> matchFieldMap = new HashMap<String, String>(1);
        matchFieldMap.put(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLENTRYID, this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLENTRYID);
        matchFieldMap.putAll(matchFieldMapCommon);
        return matchFieldMap;
    }

    @Override
    protected void initFinMatchSelector(List<String> finMatchFields) {
    }

    @Override
    protected List<String> getFinSelector(List<String> finMatchFields) {
        List<String> selector = super.getFinSelector(finMatchFields);
        selector.add(this.finModel.HEAD_ORG);
        selector.add("payproperty.isbasedonamt");
        selector.add("currency.amtprecision");
        selector.add("basecurrency.amtprecision");
        selector.add(this.finModel.HEAD_EXCHANGERATE);
        selector.add(this.finModel.HEAD_QUOTATION);
        selector.add(this.finModel.HEAD_ISINCLUDETAX);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTMODE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTAMOUNT);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_UNITPRICE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXUNITPRICE);
        return selector;
    }

    @Override
    protected void initBusMatchSelector(List<String> busMatchFields) {
    }

    @Override
    protected List<String> getBusSelector(List<String> matchFields) {
        List<String> selector = super.getBusSelector(matchFields);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDQTY);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDONOTAXAMT);
        return selector;
    }

    @Override
    protected QFilter getSrcBusQFilter(DataSet finDataSet) {
        QFilter filter = super.getSrcBusQFilter(finDataSet);
        HashSet<Long> srcEntryIdSet = new HashSet<Long>(8);
        for (Row row : finDataSet.copy()) {
            Long srcEntryId;
            if (ObjectUtils.isEmpty((Object)row.get(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLENTRYID)) || (srcEntryId = row.getLong(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLENTRYID)) == 0L) continue;
            srcEntryIdSet.add(srcEntryId);
        }
        if (!ObjectUtils.isEmpty(srcEntryIdSet)) {
            filter.and(this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLENTRYID, "in", srcEntryIdSet);
        } else {
            filter = null;
        }
        return filter;
    }

    @Override
    protected List<BusWoffRecordVO> match(DataSet finDataSet, List<String> finMatchFields, DataSet busDataSet, List<String> busMatchFields) {
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(8);
        HashMap<Long, Row> busRowMap = new HashMap<Long, Row>(8);
        for (Row row : busDataSet) {
            busRowMap.putIfAbsent(row.getLong(this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLENTRYID), row);
        }
        HashMap<Long, BusWoffRecordVO> finEnableInvoiceListVO = new HashMap<Long, BusWoffRecordVO>(2);
        HashMap<Long, BusWoffRecordVO> busEnableWoffRecordListVO = new HashMap<Long, BusWoffRecordVO>(2);
        for (Row finRow : finDataSet) {
            BusWoffRecordVO woffRecordVO;
            Row busRow;
            Long srcBusEntryId = finRow.getLong(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLENTRYID);
            if (ObjectUtils.isEmpty((Object)srcBusEntryId) || (busRow = (Row)busRowMap.get(srcBusEntryId)) == null) continue;
            String billTypeNum = busRow.getString("billtype.number");
            Long finLineTypeId = finRow.getLong(this.finModel.ENTRY + "." + this.finModel.E_LINETYPE);
            Long finexpenseItemId = finRow.getLong(this.finModel.ENTRY + "." + this.finModel.E_EXPENSEITEM);
            if ("ap_busbill_salefee_BT_S".equals(billTypeNum) || "ap_busbill_purfee_BT_S".equals(billTypeNum)) {
                Long busLineTypeId = busRow.getLong(this.busModel.ENTRY + "." + this.busModel.E_LINETYPE);
                Long expenseItem = busRow.getLong(this.busModel.ENTRY + "." + this.busModel.E_EXPENSEITEM);
                if (!finLineTypeId.equals(busLineTypeId) || !expenseItem.equals(finexpenseItemId)) continue;
            }
            if ((woffRecordVO = this.dealWoffRecord(finEnableInvoiceListVO, finRow, busEnableWoffRecordListVO, busRow)) == null) continue;
            woffRecordListVO.add(woffRecordVO);
        }
        return woffRecordListVO;
    }

    @Override
    protected void dealFinInvoice(Row finRow, BusWoffRecordVO finEnableInvoiceVO, BusWoffRecordVO busWoffRecordVO) {
        BusWoffHelper.calculatorFinInvoice(this.finModel, finRow, finEnableInvoiceVO, busWoffRecordVO);
    }

    @Override
    protected void writeBackSrcBusEntry(Set<Long> srcBusIdSet, List<BusWoffRecordVO> woffRecordListVO) {
        int batchSize = this.getBusWoffBatchSize();
        BusWoffHelper.writeBackSrcBusEntry(this.busWoffParam.getBusEntity(), srcBusIdSet, woffRecordListVO, batchSize);
    }

    @Override
    protected Object[] prepareDelWoff(BusWoffResult result) {
        HashSet<Long> delWoffIds = new HashSet<Long>(8);
        List<BusWoffRecordVO> woffRecordListVO = this.getWoffRecordVO(result, delWoffIds);
        if (!woffRecordListVO.isEmpty()) {
            this.writeBackSrcBusEntry(woffRecordListVO);
        }
        return delWoffIds.toArray();
    }

    private void writeBackSrcBusEntry(List<BusWoffRecordVO> woffRecordListVO) {
        if (ObjectUtils.isEmpty(woffRecordListVO)) {
            return;
        }
        Set<Long> srcBusIdSet = woffRecordListVO.stream().map(BusWoffRecordVO::getSrcBusId).collect(Collectors.toSet());
        logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u6700\u521d\u6e90\u6682\u4f30\u5355ID\u96c6\u5408 \uff1a" + srcBusIdSet);
        ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), "woff", srcBusIdSet);
        ArrayList<String> finMatchFields = new ArrayList<String>(2);
        ArrayList<String> busMatchFields = new ArrayList<String>(2);
        this.initMatchSelector(finMatchFields, busMatchFields);
        DataSet srcBusDataSet = this.getBusDataSet(srcBusIdSet, busMatchFields);
        if (ObjectUtils.isEmpty((Object)srcBusDataSet)) {
            return;
        }
        DataSet finDataSet = this.getFinDataSet(finMatchFields);
        if (ObjectUtils.isEmpty((Object)finDataSet)) {
            return;
        }
        this.woffMatch(finDataSet, finMatchFields, srcBusDataSet, busMatchFields, woffRecordListVO, true, true);
    }
}

