/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.model.BusBillModel;
import kd.fi.arapcommon.model.FinBillModel;
import kd.fi.arapcommon.service.bus.WoffModeEnum;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.buswoff.BusWoffParam;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.buswoff.IBusWoffService;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StdConfig;

public abstract class AbstractBusWoffService
implements IBusWoffService {
    protected static final Log logger = LogFactory.getLog(AbstractBusWoffService.class);
    protected static final String orderByDate = "bookdate";
    protected static final String ctrlBizKey = "woff";
    protected BusWoffParam busWoffParam;
    protected FinBillModel finModel;
    protected BusBillModel busModel;

    protected void initBusWoffParam(Set<Long> billIds, Map<Long, BFRowId> sourceBusBFRowMap) {
        this.initBusWoffParam(billIds);
        if (!ObjectUtils.isEmpty(sourceBusBFRowMap)) {
            this.busWoffParam.setSourceBusBFRowMap(sourceBusBFRowMap);
        }
    }

    protected abstract void initBusWoffParam(Set<Long> var1);

    protected void idempotentValidator() {
        boolean isExists = QueryServiceHelper.exists((String)this.busWoffParam.getBusEntity(), (QFilter[])new QFilter[]{new QFilter(this.busModel.HEAD_SRCFINBILLID, "in", this.busWoffParam.getBillIds())});
        if (isExists) {
            throw new KDBizException(new ErrorCode("idempotent", ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u6210\u529f\u6267\u884c\u201c\u5355\u5230\u51b2\u56de\u201d\u7684\u8d22\u52a1\u5355\uff0c\u65e0\u6cd5\u518d\u6b21\u51b2\u56de\u3002", (String)"AbstractBusWoffService_2", (String)"fi-arapcommon", (Object[])new Object[0])), new Object[0]);
        }
    }

    @Override
    public BusWoffResult busWoff(Set<Long> finIds) {
        BusWoffResult result = new BusWoffResult();
        if (ObjectUtils.isEmpty(finIds)) {
            return result;
        }
        this.initBusWoffParam(finIds);
        this.idempotentValidator();
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"buswoff");){
            ArrayList<String> finMatchFields = new ArrayList<String>(2);
            ArrayList<String> busMatchFields = new ArrayList<String>(2);
            logger.info("----------BusWoffService " + this.getClass().getSimpleName() + " start----------");
            this.initMatchSelector(finMatchFields, busMatchFields);
            DataSet finDataSet = this.getFinDataSet(finMatchFields);
            if (ObjectUtils.isEmpty((Object)finDataSet)) {
                BusWoffResult busWoffResult = result;
                return busWoffResult;
            }
            Set<Long> srcBusIdSet = this.getBusIdSet(this.getSrcBusQFilter(finDataSet));
            if (ObjectUtils.isEmpty(srcBusIdSet)) {
                BusWoffResult busWoffResult = result;
                return busWoffResult;
            }
            logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u9700\u8981\u51b2\u56de\u7684\u6e90\u6682\u4f30\u5355ID\u96c6\u5408\uff1a" + srcBusIdSet);
            ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), ctrlBizKey, srcBusIdSet);
            DataSet busDataSet = this.getBusDataSet(srcBusIdSet, busMatchFields);
            logger.info("----------BusWoffService match start----------");
            List<BusWoffRecordVO> woffRecordListV0 = this.match(finDataSet, finMatchFields, busDataSet, busMatchFields);
            logger.info("----------BusWoffService batchBusWoff start----------");
            List<Object> woffBillIds = this.batchBusWoff(woffRecordListV0);
            this.buildBusWoffResult(result, woffRecordListV0, woffBillIds);
            logger.info("----------BusWoffService end----------");
            BusWoffResult busWoffResult = result;
            return busWoffResult;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                logger.error(e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected Map<String, String> getOtherMatchField() {
        if (this.busWoffParam == null) {
            this.initBusWoffParam(null);
        }
        Map<String, String> matchField = new HashMap<String, String>(2);
        if (!ObjectUtils.isEmpty((Object)this.busWoffParam)) {
            matchField = BusWoffHelper.getOtherMatchField(this.busWoffParam.getWoffMode(), this.busWoffParam.getFinEntity());
        }
        return matchField;
    }

    @Override
    public void initMatchSelector(List<String> finMatchFields, List<String> busMatchFields) {
        Map<String, String> matchFieldMap = this.getOtherMatchField();
        finMatchFields.addAll(matchFieldMap.keySet());
        busMatchFields.addAll(matchFieldMap.values());
        this.initFinMatchSelector(finMatchFields);
        this.initBusMatchSelector(busMatchFields);
    }

    protected void initFinMatchSelector(List<String> finMatchFields) {
        finMatchFields.add(this.finModel.HEAD_ORG);
        finMatchFields.add(this.finModel.HEAD_CURRENCY);
        finMatchFields.add(this.finModel.HEAD_ASSTACTTYPE);
        finMatchFields.add(this.finModel.HEAD_ASSTACT);
        finMatchFields.add("payproperty.isbasedonamt");
    }

    protected List<String> getFinSelector(List<String> finMatchFields) {
        ArrayList<String> selector = new ArrayList<String>(8);
        if (!ObjectUtils.isEmpty(finMatchFields)) {
            selector.addAll(finMatchFields);
        }
        selector.add("id");
        selector.add(this.finModel.HEAD_BIZDATE);
        selector.add(orderByDate);
        selector.add(this.finModel.ENTRY_PK);
        String e_sourcebillentryid = this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLENTRYID;
        if (!selector.contains(e_sourcebillentryid)) {
            selector.add(e_sourcebillentryid);
        }
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_EXPENSEITEM);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_LINETYPE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_ISALLVERIFY);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_QUANTITY);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_AMOUNT);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_LOCALAMT);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_PRICETAXTOTAL);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_PRICETAXTOTALLOC);
        return selector;
    }

    protected QFilter getFinQFilter() {
        return new QFilter("id", "in", this.busWoffParam.getBillIds());
    }

    protected DataSet getFinDataSet(List<String> matchFields) {
        List<String> selector = this.getFinSelector(matchFields);
        HashSet<String> selectorSet = new HashSet<String>(selector);
        selector = new ArrayList<String>(selectorSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)this.busWoffParam.getFinEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{this.getFinQFilter()}, (String)"");
        if (!dataSet.hasNext()) {
            return null;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        boolean isAr = "ar_finarbill".equals(this.busWoffParam.getFinEntity());
        String needDealAsstacttype = isAr ? "bd_supplier" : "bd_customer";
        HashSet<Long> needDealAsstactIdSet = new HashSet<Long>(2);
        for (Row row : dataSet.copy()) {
            orgIds.add(row.getLong("org"));
            if (ObjectUtils.isEmpty(matchFields) || !matchFields.contains("asstact") || !needDealAsstacttype.equals(row.getString("asstacttype"))) continue;
            needDealAsstactIdSet.add(row.getLong("asstact"));
        }
        BusWoffHelper.matchSystemParameter(isAr, orgIds);
        if (ObjectUtils.isEmpty(orgIds)) {
            return null;
        }
        if (!ObjectUtils.isEmpty(needDealAsstactIdSet)) {
            dataSet = this.dealAsstactDataSet(needDealAsstacttype, needDealAsstactIdSet, dataSet, selector);
        }
        dataSet = dataSet.orderBy(this.getOrderByField(matchFields).toArray(new String[0]));
        return dataSet;
    }

    protected DataSet dealAsstactDataSet(String asstacttype, Set<Long> asstactIdSet, DataSet dataSet, List<String> selector) {
        return dataSet;
    }

    protected List<String> getOrderByField(List<String> matchField) {
        ArrayList<String> orderSelector = new ArrayList<String>(2);
        if (!ObjectUtils.isEmpty(matchField)) {
            orderSelector.addAll(matchField);
        }
        orderSelector.add(orderByDate);
        return orderSelector;
    }

    protected QFilter getSrcBusQFilter(DataSet finDataSet) {
        return new QFilter(this.busModel.HEAD_BILLSTATUS, "=", (Object)"C").and(this.busModel.HEAD_WRITEOFFBUSINESS, "=", (Object)Boolean.FALSE).and(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFQTY, "<>", (Object)BigDecimal.ZERO);
    }

    protected Set<Long> getBusIdSet(QFilter filter) {
        HashSet<Long> srcBusIdSet = new HashSet<Long>(4);
        if (filter == null) {
            return srcBusIdSet;
        }
        DataSet dataSet = ArApXDBHelper.queryDataSet(this.busWoffParam.getBusEntity(), "id", filter, "", "buswoffquery");
        for (Row row : dataSet) {
            srcBusIdSet.add(row.getLong("id"));
        }
        return srcBusIdSet;
    }

    protected void initBusMatchSelector(List<String> busMatchFields) {
        busMatchFields.add(this.busModel.HEAD_ORG);
        busMatchFields.add(this.busModel.HEAD_CURRENCY);
        busMatchFields.add(this.busModel.HEAD_ASSTACTTYPE);
        busMatchFields.add(this.busModel.HEAD_ASSTACT);
        busMatchFields.add("payproperty.isbasedonamt");
    }

    protected List<String> getBusSelector(List<String> matchFields) {
        String e_ispresent;
        ArrayList<String> selector = new ArrayList<String>(28);
        if (!ObjectUtils.isEmpty(matchFields)) {
            selector.addAll(matchFields);
        }
        if (!selector.contains("payproperty.isbasedonamt")) {
            selector.add("payproperty.isbasedonamt");
        }
        selector.add("id");
        selector.add(this.busModel.HEAD_BILLNO);
        selector.add("asstact.masterid");
        selector.add(orderByDate);
        selector.add("currency.amtprecision");
        selector.add("basecurrency.amtprecision");
        selector.add(this.busModel.HEAD_EXCHANGERATE);
        selector.add(this.busModel.HEAD_QUOTATION);
        selector.add(this.busModel.HEAD_ISINCLUDETAX);
        selector.add("billtype.number");
        selector.add(this.busModel.ENTRY_PK);
        String e_sourcebillentryid = this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLENTRYID;
        if (!selector.contains(e_sourcebillentryid)) {
            selector.add(e_sourcebillentryid);
        }
        if (!selector.contains(e_ispresent = this.busModel.ENTRY + "." + this.busModel.E_ISPRESENT)) {
            selector.add(e_ispresent);
        }
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_QUANTITY);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_AMOUNT);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_EXPENSEITEM);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_LINETYPE);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFQTY);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFTAX);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFTAXLOCAL);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFNOTAXAMT);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFNOTAXLOCAMT);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFAMT);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFLOCAMT);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNINVOICEDQTY);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNINVNOTAXAMT);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_TAXRATE);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_DISCOUNTMODE);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_DISCOUNTRATE);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_DISCOUNTAMOUNT);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_UNITPRICE);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_TAXUNITPRICE);
        return selector;
    }

    protected DataSet getBusDataSet(Set<Long> srcBusIdSet, List<String> matchFields) {
        List<String> selector = this.getBusSelector(matchFields);
        HashSet<String> selectorSet = new HashSet<String>(selector);
        selector = new ArrayList<String>(selectorSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getBusDataSet", (String)this.busWoffParam.getBusEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIdSet)}, (String)"");
        if (!dataSet.hasNext()) {
            return null;
        }
        if (!ObjectUtils.isEmpty(matchFields) && matchFields.contains("asstact")) {
            String needDealAsstacttype = "ar_finarbill".equals(this.busWoffParam.getFinEntity()) ? "bd_supplier" : "bd_customer";
            HashSet<Long> needDealAsstactIdSet = new HashSet<Long>(2);
            for (Row row : dataSet.copy()) {
                if (!needDealAsstacttype.equals(row.getString("asstacttype"))) continue;
                needDealAsstactIdSet.add(row.getLong("asstact"));
            }
            if (!ObjectUtils.isEmpty(needDealAsstactIdSet)) {
                dataSet = this.dealAsstactDataSet(needDealAsstacttype, needDealAsstactIdSet, dataSet, selector);
            }
        }
        dataSet = dataSet.orderBy(this.getOrderByField(matchFields).toArray(new String[0]));
        return dataSet;
    }

    protected abstract List<BusWoffRecordVO> match(DataSet var1, List<String> var2, DataSet var3, List<String> var4);

    protected int compare(Row finRow, List<String> finMatchFields, Row busRow, List<String> busMatchFields, StringBuilder isNullEquality) {
        Long materialId;
        int comparator = 0;
        boolean usedMaterial = false;
        if (finMatchFields.contains(this.finModel.ENTRY + "." + this.finModel.E_MATERIAL + ".masterid") && (materialId = finRow.getLong(this.finModel.ENTRY + "." + this.finModel.E_MATERIAL + ".masterid")) != null && materialId != 0L) {
            usedMaterial = true;
        }
        for (int i = 0; i < finMatchFields.size(); ++i) {
            String busField = busMatchFields.get(i);
            Object finValue = finRow.get(finMatchFields.get(i));
            Object busValue = busRow.get(busField);
            if (!ObjectUtils.isEmpty((Object)finValue) && !ObjectUtils.isEmpty((Object)busValue)) {
                if (finValue instanceof Long) {
                    if (usedMaterial && busField.contains("expenseitem") || !usedMaterial && busField.contains("material") || !usedMaterial && busField.contains("measureunit")) continue;
                    if ((Long)finValue > (Long)busValue) {
                        comparator = 1;
                    } else if ((Long)finValue < (Long)busValue) {
                        comparator = -1;
                    } else if ((Long)finValue == 0L) {
                        if (busField.contains("linetype")) continue;
                        isNullEquality.setLength(0);
                        return 0;
                    }
                } else if (finValue instanceof Integer) {
                    if ((Integer)finValue > (Integer)busValue) {
                        comparator = 1;
                    } else if ((Integer)finValue < (Integer)busValue) {
                        comparator = -1;
                    } else if ((long)((Integer)finValue).intValue() == 0L) {
                        isNullEquality.setLength(0);
                        return 0;
                    }
                } else {
                    comparator = finValue instanceof Date ? ((Date)finValue).compareTo((Date)busValue) : (finValue instanceof BigDecimal ? ((BigDecimal)finValue).compareTo((BigDecimal)busValue) : String.valueOf(finValue).compareTo(String.valueOf(busValue)));
                }
                if (comparator == 0) continue;
                return comparator;
            }
            if (usedMaterial && busField.contains("expenseitem") || !usedMaterial && busField.contains("material") || !usedMaterial && busField.contains("measureunit") || busField.contains("linetype") && busValue == null) continue;
            if (ObjectUtils.isEmpty((Object)finValue) && ObjectUtils.isEmpty((Object)busValue)) {
                isNullEquality.setLength(0);
                return 0;
            }
            if (!ObjectUtils.isEmpty((Object)busValue)) {
                return -1;
            }
            return 1;
        }
        return comparator;
    }

    protected BusWoffRecordVO getBusEnableInvoiceListVO(Map<Long, BusWoffRecordVO> busEnableWoffRecordListVO, Row busRow) {
        Long busEntryId = busRow.getLong(this.busModel.ENTRY_PK);
        BusWoffRecordVO busEnableWoffRecordVO = busEnableWoffRecordListVO.get(busEntryId);
        if (busEnableWoffRecordVO == null) {
            BigDecimal busUnWoffQty = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFQTY);
            BigDecimal busUnWoffNoTaxAmt = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFNOTAXAMT);
            BigDecimal busUnInvoicedQty = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNINVOICEDQTY);
            BigDecimal busUnInvoicedNoTaxAmt = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNINVNOTAXAMT);
            BigDecimal busEnableWoffQty = busUnWoffQty;
            BigDecimal busEnableWoffNoTaxAmt = busUnWoffNoTaxAmt;
            if (WoffModeEnum.DIRECT != this.busWoffParam.getWoffMode()) {
                boolean isBasedonAmt;
                if (busUnWoffQty.abs().compareTo(busUnInvoicedQty.abs()) > 0) {
                    busEnableWoffQty = busUnInvoicedQty;
                }
                if ((isBasedonAmt = busRow.getBoolean("payproperty.isbasedonamt").booleanValue()) && busUnWoffNoTaxAmt.abs().compareTo(busUnInvoicedNoTaxAmt.abs()) > 0) {
                    busEnableWoffNoTaxAmt = busUnInvoicedNoTaxAmt;
                }
            }
            busEnableWoffRecordVO = new BusWoffRecordVO(busEntryId, busEnableWoffQty, busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFTAX), busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFTAXLOCAL), busEnableWoffNoTaxAmt, busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFNOTAXLOCAMT), busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFAMT), busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFLOCAMT), busUnWoffQty, busUnWoffNoTaxAmt);
            busEnableWoffRecordVO.setBusLastForAll(busEnableWoffRecordVO.getInvoicedNoTaxAmt().equals(busEnableWoffRecordVO.getPriceTaxTotal().subtract(busEnableWoffRecordVO.getTax())));
            busEnableWoffRecordListVO.put(busEntryId, busEnableWoffRecordVO);
        }
        return busEnableWoffRecordVO;
    }

    protected BusWoffRecordVO dealWoffRecord(Map<Long, BusWoffRecordVO> finEnableInvoiceListVO, Row finRow, Map<Long, BusWoffRecordVO> busEnableWoffRecordListVO, Row busRow) {
        AbstractPriceCalculator calculator;
        BigDecimal curQuantity;
        BusWoffRecordVO finEnableInvoiceVO = BusWoffHelper.getFinEnableInvoiceListVO(finEnableInvoiceListVO, finRow, this.finModel);
        if (finEnableInvoiceVO.isFinAllWoffed()) {
            return null;
        }
        BusWoffRecordVO busEnableWoffRecordVO = this.getBusEnableInvoiceListVO(busEnableWoffRecordListVO, busRow);
        if (busEnableWoffRecordVO.isBusLastForAll()) {
            return null;
        }
        boolean isAllWoff = finRow.getBoolean(this.finModel.ENTRY + "." + this.finModel.E_ISALLVERIFY);
        boolean isBasedonAmt = busRow.getBoolean("payproperty.isbasedonamt");
        BigDecimal curNoTaxAmt = BigDecimal.ZERO;
        boolean busLastForAll = false;
        int precision = busRow.getInteger("currency.amtprecision");
        BigDecimal taxRate = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_TAXRATE);
        String discountMode = busRow.getString(this.busModel.ENTRY + "." + this.busModel.E_DISCOUNTMODE);
        BigDecimal discountRate = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_DISCOUNTRATE);
        BigDecimal discountAmount = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_DISCOUNTAMOUNT).negate();
        if (isBasedonAmt) {
            BigDecimal busAmount;
            curQuantity = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_QUANTITY).negate();
            BigDecimal finAmount = finRow.getBigDecimal(this.finModel.ENTRY + "." + this.finModel.E_AMOUNT);
            if (finAmount.multiply(busAmount = busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_AMOUNT)).compareTo(BigDecimal.ZERO) > 0) {
                if (isAllWoff) {
                    curNoTaxAmt = busEnableWoffRecordVO.getAmount().negate();
                    busLastForAll = true;
                } else if (WoffModeEnum.DIRECT == this.busWoffParam.getWoffMode()) {
                    if (finEnableInvoiceVO.getInvoicedNoTaxAmt().abs().compareTo(busEnableWoffRecordVO.getAmount().abs()) >= 0) {
                        curNoTaxAmt = busEnableWoffRecordVO.getAmount().negate();
                        busLastForAll = true;
                    } else {
                        curNoTaxAmt = finEnableInvoiceVO.getInvoicedNoTaxAmt().negate();
                    }
                } else if (finEnableInvoiceVO.getInvoicedNoTaxAmt().abs().compareTo(busEnableWoffRecordVO.getAmount().abs()) >= 0) {
                    logger.info("realunwoffamt:" + busEnableWoffRecordVO.getRealUnWoffAmt());
                    curNoTaxAmt = busEnableWoffRecordVO.getAmount().negate();
                    busLastForAll = busEnableWoffRecordVO.getRealUnWoffAmt().abs().compareTo(busEnableWoffRecordVO.getAmount().abs()) == 0;
                } else {
                    curNoTaxAmt = finEnableInvoiceVO.getInvoicedNoTaxAmt().negate();
                }
            }
            if (busRow.getBoolean(this.busModel.ENTRY + "." + this.busModel.E_ISPRESENT).booleanValue() || finAmount.compareTo(BigDecimal.ZERO) == 0 && busAmount.compareTo(BigDecimal.ZERO) == 0) {
                curNoTaxAmt = busEnableWoffRecordVO.getAmount().negate();
                busLastForAll = true;
            }
            discountMode = "NULL";
            discountRate = BigDecimal.ZERO;
            calculator = new PriceTotalCalculator(curQuantity, curNoTaxAmt, taxRate, discountMode, discountRate, precision);
        } else {
            if (!isAllWoff && finEnableInvoiceVO.getInvoicedQty().abs().compareTo(busEnableWoffRecordVO.getQuantity().abs()) < 0) {
                curQuantity = finEnableInvoiceVO.getInvoicedQty().negate();
            } else {
                curQuantity = busEnableWoffRecordVO.getQuantity().negate();
                boolean bl = busLastForAll = WoffModeEnum.DIRECT == this.busWoffParam.getWoffMode() || busEnableWoffRecordVO.getQuantity().compareTo(busEnableWoffRecordVO.getRealUnWoffQty()) == 0;
                if (!busLastForAll) {
                    logger.info("realunwoffqty:" + busEnableWoffRecordVO.getRealUnWoffQty());
                }
            }
            if (busRow.getBoolean(this.busModel.HEAD_ISINCLUDETAX).booleanValue()) {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    discountAmount = discountRate.multiply(curQuantity).setScale(precision, RoundingMode.HALF_UP);
                }
                calculator = new TaxUnitPriceCalculator(curQuantity, busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_TAXUNITPRICE), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmount);
            } else {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    discountAmount = discountRate.multiply(curQuantity).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP);
                }
                calculator = new UnitPriceCalculator(curQuantity, busRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNITPRICE), taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmount);
            }
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, busRow.getBigDecimal(this.busModel.HEAD_EXCHANGERATE), (int)busRow.getInteger("basecurrency.amtprecision"), busRow.getString(this.busModel.HEAD_QUOTATION));
        localCalculator.calculate();
        BusWoffRecordVO vo = new BusWoffRecordVO(finRow.getLong("id"), finRow.getLong(this.finModel.ENTRY_PK), busRow.getLong("id"), busRow.getLong(this.busModel.ENTRY_PK));
        vo.setWoffBizDate(finRow.getDate(this.finModel.HEAD_BIZDATE));
        vo.setQuantity(localCalculator.getQuantity());
        vo.setDiscountAmt(localCalculator.getDiscountamount());
        vo.setDiscountLocaAmt(localCalculator.getDiscountamountlocal());
        if (busLastForAll) {
            busEnableWoffRecordVO.setBusLastForAll(true);
            vo.setBusLastForAll(true);
            vo.setTax(busEnableWoffRecordVO.getTax().negate());
            vo.setTaxLocalAmt(busEnableWoffRecordVO.getTaxLocalAmt().negate());
            vo.setAmount(busEnableWoffRecordVO.getAmount().negate());
            vo.setLocalAmt(busEnableWoffRecordVO.getLocalAmt().negate());
            vo.setPriceTaxTotal(busEnableWoffRecordVO.getPriceTaxTotal().negate());
            vo.setPriceTaxTotalBase(busEnableWoffRecordVO.getPriceTaxTotalBase().negate());
        } else {
            vo.setTax(localCalculator.getTax());
            vo.setTaxLocalAmt(localCalculator.getTaxlocal());
            vo.setAmount(localCalculator.getAmount());
            vo.setLocalAmt(localCalculator.getAmountlocal());
            vo.setPriceTaxTotal(localCalculator.getPricetaxtotal());
            vo.setPriceTaxTotalBase(localCalculator.getPricetaxtotallocal());
            busEnableWoffRecordVO.setQuantity(busEnableWoffRecordVO.getQuantity().add(curQuantity));
            busEnableWoffRecordVO.setRealUnWoffQty(busEnableWoffRecordVO.getRealUnWoffQty().add(curQuantity));
            busEnableWoffRecordVO.setTax(busEnableWoffRecordVO.getTax().add(localCalculator.getTax()));
            busEnableWoffRecordVO.setTaxLocalAmt(busEnableWoffRecordVO.getTaxLocalAmt().add(localCalculator.getTaxlocal()));
            busEnableWoffRecordVO.setAmount(busEnableWoffRecordVO.getAmount().add(localCalculator.getAmount()));
            busEnableWoffRecordVO.setRealUnWoffAmt(busEnableWoffRecordVO.getRealUnWoffAmt().add(localCalculator.getAmount()));
            busEnableWoffRecordVO.setLocalAmt(busEnableWoffRecordVO.getLocalAmt().add(localCalculator.getAmountlocal()));
            busEnableWoffRecordVO.setPriceTaxTotal(busEnableWoffRecordVO.getPriceTaxTotal().add(localCalculator.getPricetaxtotal()));
            busEnableWoffRecordVO.setPriceTaxTotalBase(busEnableWoffRecordVO.getPriceTaxTotalBase().add(localCalculator.getPricetaxtotallocal()));
            busEnableWoffRecordVO.setBusLastForAll(busEnableWoffRecordVO.getInvoicedNoTaxAmt().equals(busEnableWoffRecordVO.getPriceTaxTotal().subtract(busEnableWoffRecordVO.getTax())));
        }
        this.dealFinInvoice(finRow, finEnableInvoiceVO, vo);
        return vo;
    }

    protected void dealFinInvoice(Row finRow, BusWoffRecordVO finEnableInvoiceVO, BusWoffRecordVO busWoffRecordVO) {
    }

    protected List<Object> batchBusWoff(List<BusWoffRecordVO> woffRecordListVO) {
        ArrayList<Object> woffBillIds = new ArrayList<Object>(2);
        if (ObjectUtils.isEmpty(woffRecordListVO)) {
            return woffBillIds;
        }
        woffRecordListVO.removeIf(woffRecordVO -> woffRecordVO.getQuantity().compareTo(BigDecimal.ZERO) == 0);
        if (ObjectUtils.isEmpty(woffRecordListVO)) {
            return woffBillIds;
        }
        HashMap<Long, List<Long>> srcBusIdMap = new HashMap<Long, List<Long>>(2);
        ArrayList<BusWoffRecordVO> batchWoffRecordListVO = new ArrayList<BusWoffRecordVO>(2);
        int batchSize = this.getBusWoffBatchSize();
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOByFinId = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getFinId));
        int batchEntryCount = 0;
        for (List<BusWoffRecordVO> curWoffRecordListVOByFinId : woffRecordListVOByFinId.values()) {
            Map<Long, List<BusWoffRecordVO>> woffRecordListVOBySrcBusId = WoffModeEnum.WRITTENOFF == this.busWoffParam.getWoffMode() ? curWoffRecordListVOByFinId.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getWoffBusId)) : curWoffRecordListVOByFinId.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getSrcBusId));
            for (Map.Entry<Long, List<BusWoffRecordVO>> curWoffRecordListVOEntry : woffRecordListVOBySrcBusId.entrySet()) {
                Long srcBusId = curWoffRecordListVOEntry.getKey();
                List<BusWoffRecordVO> curWoffRecordListVO = curWoffRecordListVOEntry.getValue();
                List srcBusEntryIds = WoffModeEnum.WRITTENOFF == this.busWoffParam.getWoffMode() ? curWoffRecordListVO.stream().map(BusWoffRecordVO::getWoffBusEntryId).collect(Collectors.toList()) : curWoffRecordListVO.stream().map(BusWoffRecordVO::getSrcBusEntryId).collect(Collectors.toList());
                if (batchSize <= curWoffRecordListVO.size()) {
                    HashMap<Long, List<Long>> srcMap = new HashMap<Long, List<Long>>(1);
                    srcMap.put(srcBusId, srcBusEntryIds);
                    woffBillIds.addAll(this.doBusWoff(srcMap, curWoffRecordListVO));
                    continue;
                }
                int endBatchEntryCount = batchEntryCount + curWoffRecordListVO.size();
                if (endBatchEntryCount > batchSize || !ObjectUtils.isEmpty(srcBusIdMap.get(srcBusId))) {
                    woffBillIds.addAll(this.doBusWoff(srcBusIdMap, batchWoffRecordListVO));
                    srcBusIdMap.clear();
                    batchWoffRecordListVO.clear();
                    srcBusIdMap.put(srcBusId, srcBusEntryIds);
                    batchWoffRecordListVO.addAll(curWoffRecordListVO);
                    batchEntryCount = curWoffRecordListVO.size();
                    continue;
                }
                if (endBatchEntryCount == batchSize) {
                    srcBusIdMap.put(srcBusId, srcBusEntryIds);
                    batchWoffRecordListVO.addAll(curWoffRecordListVO);
                    woffBillIds.addAll(this.doBusWoff(srcBusIdMap, batchWoffRecordListVO));
                    srcBusIdMap.clear();
                    batchWoffRecordListVO.clear();
                    batchEntryCount = 0;
                    continue;
                }
                srcBusIdMap.put(srcBusId, srcBusEntryIds);
                batchWoffRecordListVO.addAll(curWoffRecordListVO);
                batchEntryCount += curWoffRecordListVO.size();
            }
        }
        if (!ObjectUtils.isEmpty(srcBusIdMap)) {
            woffBillIds.addAll(this.doBusWoff(srcBusIdMap, batchWoffRecordListVO));
        }
        return woffBillIds;
    }

    private List<Object> doBusWoff(Map<Long, List<Long>> srcBusIdMap, List<BusWoffRecordVO> batchWoffRecordListVO) {
        List<Object> woffBillIds = new ArrayList<Object>(2);
        if (ObjectUtils.isEmpty(srcBusIdMap)) {
            return woffBillIds;
        }
        List<DynamicObject> woffList = BOTPHelper.push4Result(this.busWoffParam.getBusEntity(), this.busModel.ENTRY, this.busWoffParam.getBusEntity(), this.busWoffParam.getWoffRuleId(), srcBusIdMap);
        if (ObjectUtils.isEmpty(woffList)) {
            logger.info("------AbstractBusWoffService-\u6ca1\u6709\u83b7\u5f97\u4e0b\u63a8\u751f\u6210\u7684\u51b2\u56de\u5355\u3002");
            return woffBillIds;
        }
        ArrayList<BusWoffRecordVO> batchWoffRecordListVOTemp = new ArrayList<BusWoffRecordVO>(batchWoffRecordListVO.size());
        batchWoffRecordListVOTemp.addAll(batchWoffRecordListVO);
        woffBillIds = this.buildWoffBill(batchWoffRecordListVOTemp, woffList);
        if (!ObjectUtils.isEmpty(woffBillIds)) {
            this.writeBackSrcBusEntry(srcBusIdMap.keySet(), batchWoffRecordListVO);
        }
        return woffBillIds;
    }

    @Deprecated
    protected List<Object> doBusWoff(Set<Long> srcBusIdSet, List<BusWoffRecordVO> batchWoffRecordListVO) {
        List<Object> woffBillIds = new ArrayList<Object>(2);
        if (ObjectUtils.isEmpty(srcBusIdSet)) {
            return woffBillIds;
        }
        Map<String, Object> map = BOTPHelper.push4Result(this.busWoffParam.getBusEntity(), this.busWoffParam.getBusEntity(), this.busWoffParam.getWoffRuleId(), srcBusIdSet.stream().collect(Collectors.toList()));
        Object convertResult = map.get("convertResult");
        if (convertResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertResult;
            String convertReport = BOTPHelper.getConvertReport(result);
            logger.info("------AbstractBusWoffService-botp.ConvertReport------" + convertReport);
            throw new KDBizException(new ErrorCode("botp", String.format(ResManager.loadKDString((String)"\u6682\u4f30\u51b2\u56de\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"AbstractBusWoffService_1", (String)"fi-arapcommon", (Object[])new Object[0]), convertReport)), new Object[0]);
        }
        List woffList = (List)map.get("trgBills");
        if (ObjectUtils.isEmpty((Object)woffList)) {
            logger.info("------AbstractBusWoffService-\u6ca1\u6709\u83b7\u5f97\u4e0b\u63a8\u751f\u6210\u7684\u51b2\u56de\u5355\u3002");
            return woffBillIds;
        }
        ArrayList<BusWoffRecordVO> batchWoffRecordListVOTemp = new ArrayList<BusWoffRecordVO>(batchWoffRecordListVO.size());
        batchWoffRecordListVOTemp.addAll(batchWoffRecordListVO);
        woffBillIds = this.buildWoffBill(batchWoffRecordListVOTemp, woffList);
        if (!ObjectUtils.isEmpty(woffBillIds)) {
            this.writeBackSrcBusEntry(srcBusIdSet, batchWoffRecordListVO);
        }
        return woffBillIds;
    }

    private List<Object> buildWoffBill(List<BusWoffRecordVO> batchWoffRecordListVO, List<DynamicObject> woffList) {
        QueryUtil queryUtil = new QueryUtil();
        for (DynamicObject woffBill : woffList) {
            Long srcBusId = ((DynamicObject)woffBill.getDynamicObjectCollection(this.busModel.ENTRY).get(0)).getLong(this.busModel.E_SOURCEBILLID);
            if (srcBusId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6682\u4f30\u51b2\u56de\u8f6c\u6362\u89c4\u5219\u7684\u5b57\u6bb5\u6620\u5c04\u4e2d\u3010\u660e\u7ec6.\u6e90\u5355id\u3011\u3002", (String)"AbstractBusWoffService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            Map<Long, List<BusWoffRecordVO>> woffRecordListVOByFinId = WoffModeEnum.WRITTENOFF == this.busWoffParam.getWoffMode() ? batchWoffRecordListVO.stream().filter(busWoffRecordVO -> srcBusId.equals(busWoffRecordVO.getWoffBusId())).collect(Collectors.groupingBy(BusWoffRecordVO::getFinId)) : batchWoffRecordListVO.stream().filter(busWoffRecordVO -> srcBusId.equals(busWoffRecordVO.getSrcBusId())).collect(Collectors.groupingBy(BusWoffRecordVO::getFinId));
            if (ObjectUtils.isEmpty(woffRecordListVOByFinId.values())) continue;
            List<BusWoffRecordVO> woffRecordListVO = woffRecordListVOByFinId.values().iterator().next();
            this.resetWoffBill(woffBill, woffRecordListVO, queryUtil);
            batchWoffRecordListVO.removeAll(woffRecordListVO);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        List<Object> successPkIds = new ArrayList(8);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.busWoffParam.getBusEntity(), (DynamicObject[])woffList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (result.isSuccess() && !(successPkIds = result.getSuccessPkIds()).isEmpty() && (result = OperationServiceHelper.executeOperate((String)"nocontrolsubmit", (String)this.busWoffParam.getBusEntity(), (Object[])successPkIds.toArray(), (OperateOption)option)).isSuccess() && !(successPkIds = result.getSuccessPkIds()).isEmpty() && (result = OperationServiceHelper.executeOperate((String)"audit", (String)this.busWoffParam.getBusEntity(), (Object[])successPkIds.toArray(), (OperateOption)option)).isSuccess()) {
            successPkIds = result.getSuccessPkIds();
        }
        if (!result.isSuccess()) {
            logger.info("------WoffService-operationResult.Message------" + result.getMessage());
            OperationHelper.assertResult(this.busWoffParam.getBusEntity(), result);
        }
        return successPkIds;
    }

    protected void resetWoffBill(DynamicObject woffBill, List<BusWoffRecordVO> woffRecordListVO, QueryUtil queryUtil) {
        if (ObjectUtils.isEmpty(woffRecordListVO)) {
            return;
        }
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOBySrcBusEntryId = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getSrcBusEntryId));
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocalAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalLocal = BigDecimal.ZERO;
        boolean isBasedonAmt = woffBill.getBoolean("payproperty.isbasedonamt");
        woffBill.set(this.busModel.HEAD_BILLSRCTYPE, (Object)this.busWoffParam.getWoffMode().getValue());
        DynamicObjectCollection entrys = woffBill.getDynamicObjectCollection(this.busModel.ENTRY);
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            List<BusWoffRecordVO> busWoffRecordListVO = woffRecordListVOBySrcBusEntryId.get(entry.getLong(this.busModel.E_SOURCEBILLENTRYID));
            if (ObjectUtils.isEmpty(busWoffRecordListVO)) {
                entrys.remove(i);
                --i;
                continue;
            }
            BigDecimal e_quantity = BigDecimal.ZERO;
            BigDecimal e_discountAmt = BigDecimal.ZERO;
            BigDecimal e_tax = BigDecimal.ZERO;
            BigDecimal e_taxLocalAmt = BigDecimal.ZERO;
            BigDecimal e_amount = BigDecimal.ZERO;
            BigDecimal e_localAmt = BigDecimal.ZERO;
            BigDecimal e_priceTaxTotal = BigDecimal.ZERO;
            BigDecimal e_priceTaxTotalLocal = BigDecimal.ZERO;
            for (BusWoffRecordVO vo : busWoffRecordListVO) {
                woffBill.set("srcfinbillid", (Object)vo.getFinId());
                woffBill.set("bizdate", (Object)vo.getWoffBizDate());
                e_quantity = e_quantity.add(vo.getQuantity());
                e_discountAmt = e_discountAmt.add(vo.getDiscountAmt());
                e_tax = e_tax.add(vo.getTax());
                e_taxLocalAmt = e_taxLocalAmt.add(vo.getTaxLocalAmt());
                e_amount = e_amount.add(vo.getAmount());
                e_localAmt = e_localAmt.add(vo.getLocalAmt());
                e_priceTaxTotal = e_priceTaxTotal.add(vo.getPriceTaxTotal());
                e_priceTaxTotalLocal = e_priceTaxTotalLocal.add(vo.getPriceTaxTotalBase());
            }
            if (isBasedonAmt) {
                if (busWoffRecordListVO.size() > 1 && !entry.getBoolean(this.busModel.E_ISPRESENT) && BigDecimal.ZERO.compareTo(entry.getBigDecimal(this.busModel.E_UNITPRICE)) != 0) {
                    e_quantity = new BigDecimal(e_priceTaxTotal.compareTo(BigDecimal.ZERO));
                }
                entry.set("e_discountmode", (Object)"NULL");
                entry.set("e_discountrate", (Object)BigDecimal.ZERO);
                entry.set("e_unitprice", (Object)e_amount.abs());
                entry.set("e_taxunitprice", (Object)e_priceTaxTotal.abs());
                entry.set("e_actunitprice", (Object)e_amount.abs());
                entry.set("e_acttaxunitprice", (Object)e_priceTaxTotal.abs());
            }
            this.fillUnitRateConv(entry, e_quantity, queryUtil);
            entry.set("e_discountamount", (Object)e_discountAmt);
            entry.set("e_quantity", (Object)e_quantity);
            entry.set("e_tax", (Object)e_tax);
            entry.set("e_taxlocalamt", (Object)e_taxLocalAmt);
            entry.set("e_amount", (Object)e_amount);
            entry.set("e_localamt", (Object)e_localAmt);
            entry.set(this.busModel.E_PRICETAXTOTAL, (Object)e_priceTaxTotal);
            entry.set(this.busModel.E_PRICETAXTOTALLOC, (Object)e_priceTaxTotalLocal);
            entry.set("e_uninvoicedqty", (Object)e_quantity);
            entry.set("e_uninvoicedamt", (Object)e_priceTaxTotal);
            entry.set("e_uninvoicedlocamt", (Object)e_priceTaxTotalLocal);
            entry.set("e_unwoffqty", (Object)e_quantity);
            entry.set("e_unwoffamt", (Object)e_priceTaxTotal);
            entry.set("e_unwofflocamt", (Object)e_priceTaxTotalLocal);
            entry.set("e_unwoffnotaxamt", (Object)e_amount);
            entry.set("e_unwoffnotaxlocamt", (Object)e_localAmt);
            entry.set("e_unwofftax", (Object)e_tax);
            entry.set("e_unwofftaxlocal", (Object)e_taxLocalAmt);
            entry.set("e_uninvnotaxamt", (Object)e_amount);
            entry.set("e_uninvnotaxlocalamt", (Object)e_localAmt);
            tax = tax.add(e_tax);
            taxLocalAmt = taxLocalAmt.add(e_taxLocalAmt);
            amount = amount.add(e_amount);
            localAmt = localAmt.add(e_localAmt);
            priceTaxTotal = priceTaxTotal.add(e_priceTaxTotal);
            priceTaxTotalLocal = priceTaxTotalLocal.add(e_priceTaxTotalLocal);
        }
        woffBill.set("tax", (Object)tax);
        woffBill.set("taxlocamt", (Object)taxLocalAmt);
        woffBill.set("amount", (Object)amount);
        woffBill.set("localamt", (Object)localAmt);
        woffBill.set(this.busModel.HEAD_PRICETAXTOTAL, (Object)priceTaxTotal);
        woffBill.set(this.busModel.HEAD_PRICETAXTOTALLOC, (Object)priceTaxTotalLocal);
        woffBill.set("uninvoicedamt", (Object)priceTaxTotal);
        woffBill.set("uninvoicedlocamt", (Object)priceTaxTotalLocal);
        woffBill.set("unwoffamt", (Object)priceTaxTotal);
        woffBill.set("unwofflocamt", (Object)priceTaxTotalLocal);
        woffBill.set("unwoffnotaxamt", (Object)amount);
        woffBill.set("unwoffnotaxlocamt", (Object)localAmt);
        woffBill.set("unwofftax", (Object)tax);
        woffBill.set("unwofftaxlocal", (Object)taxLocalAmt);
    }

    private void fillUnitRateConv(DynamicObject entry, BigDecimal e_quantity, QueryUtil queryUtil) {
        DynamicObject material = entry.getDynamicObject("e_material");
        DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
        DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
        BigDecimal unitRateConv = entry.getBigDecimal("e_unitcoefficient");
        if (EmptyUtils.isEmpty(unitRateConv)) {
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    entry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                unitRateConv = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
            } else {
                unitRateConv = BigDecimal.ONE;
            }
            entry.set("e_unitcoefficient", (Object)unitRateConv);
        }
        entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(e_quantity, unitRateConv, baseUnit));
    }

    protected void writeBackSrcBusEntry(Set<Long> srcBusIdSet, List<BusWoffRecordVO> woffRecordListVO) {
    }

    protected DataSet getSrcBusDataSet(Set<Long> srcBusIdSet, List<String> busMatchFields) {
        StringBuilder selector = new StringBuilder("id,billno,invoicedamt,uninvoicedamt,invoicedlocamt,uninvoicedlocamt,entry.id,entry.e_quantity,entry.e_amount,entry.e_invoicedqty,entry.e_uninvoicedqty,entry.e_invoicedamt,entry.e_uninvoicedamt,entry.e_invoicedlocamt,entry.e_uninvoicedlocamt,entry.e_invoicednotaxamt,entry.e_uninvnotaxamt,entry.e_invnotaxlocalamt,entry.e_uninvnotaxlocalamt,bookdate");
        if (!ObjectUtils.isEmpty(busMatchFields)) {
            selector.append(',').append(String.join((CharSequence)",", busMatchFields));
        } else {
            selector.append(",payproperty.isbasedonamt");
            selector.append(",entry.e_ispresent");
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getSrcBusDataSet", (String)this.busWoffParam.getBusEntity(), (String)selector.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIdSet)}, (String)"");
        dataSet = dataSet.orderBy(this.getOrderByField(busMatchFields).toArray(new String[0]));
        return dataSet;
    }

    protected void buildBusWoffResult(BusWoffResult result, List<BusWoffRecordVO> woffRecordListV0, List<Object> woffBillIds) {
        for (BusWoffRecordVO vo : woffRecordListV0) {
            result.getFinBillIds().add(vo.getFinId());
            result.getSrcBusBillIds().add(vo.getSrcBusId());
        }
        result.getWoffBillIds().addAll(woffBillIds);
    }

    protected int getBusWoffBatchSize() {
        String settleBatchSize = StdConfig.get("buswoff.batchsize");
        return settleBatchSize == null ? 2000 : Integer.parseInt(settleBatchSize);
    }

    @Override
    public BusWoffResult busUnWoffBills(Set<Long> finIds) {
        BusWoffResult result = new BusWoffResult();
        if (ObjectUtils.isEmpty(finIds)) {
            return result;
        }
        this.initBusWoffParam(finIds);
        Throwable throwable = null;
        try (TXHandle tx = TX.required((String)"delBusWoffBills");){
            List successPkIds;
            logger.info("----------BusWoffService unwoff start----------");
            Object[] delWoffIds = this.prepareDelWoff(result);
            if (ObjectUtils.isEmpty((Object[])delWoffIds)) {
                BusWoffResult busWoffResult = result;
                return busWoffResult;
            }
            logger.info("----------BusWoffService unwoff executeOperate start----------");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("WF", "false");
            option.setVariableValue("mutex_writeback", "false");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"noprotocolunaudit", (String)this.busWoffParam.getBusEntity(), (Object[])delWoffIds, (OperateOption)option);
            if (operationResult.isSuccess() && !(successPkIds = operationResult.getSuccessPkIds()).isEmpty()) {
                option.setVariableValue("isStrict", "false");
                option.setVariableValue("ignoreValidation", "true");
                operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.busWoffParam.getBusEntity(), (Object[])successPkIds.toArray(), (OperateOption)option);
            }
            if (!operationResult.isSuccess()) {
                logger.info("------BusWoffService-operationResult.Message------" + operationResult.getMessage());
                OperationHelper.assertResult(this.busWoffParam.getBusEntity(), operationResult);
            }
            Boolean isSuccess = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)this.busWoffParam.getBusEntity(), (String)"delete", operationResult.getSuccessPkIds().stream().map(v -> (Long)v).collect(Collectors.toList()), (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
            logger.info("Voucher Delete White List result: " + isSuccess);
            result.getWoffBillIds().addAll(operationResult.getSuccessPkIds());
            logger.info("----------BusWoffService unwoff end----------");
            BusWoffResult busWoffResult = result;
            return busWoffResult;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                logger.error(e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected Object[] prepareDelWoff(BusWoffResult result) {
        HashSet<Long> delWoffIds = new HashSet<Long>(8);
        this.getWoffRecordVO(result, delWoffIds);
        return delWoffIds.toArray();
    }

    protected List<BusWoffRecordVO> getWoffRecordVO(BusWoffResult result, Set<Long> delWoffIds) {
        QFilter filter = new QFilter(this.busModel.HEAD_SRCFINBILLID, "in", this.busWoffParam.getBillIds()).and(this.busModel.HEAD_BILLSRCTYPE, "=", (Object)this.busWoffParam.getWoffMode().getValue());
        DataSet woffDataSet = QueryServiceHelper.queryDataSet((String)"prepareDelWoff", (String)this.busWoffParam.getBusEntity(), (String)"id, srcfinbillid, billsrctype, entry.e_srcbillid, entry.e_srcentryid, entry.e_quantity, entry.e_amount", (QFilter[])new QFilter[]{filter}, (String)"");
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(8);
        for (Row row : woffDataSet) {
            result.getFinBillIds().add(row.getLong(this.busModel.HEAD_SRCFINBILLID));
            result.getSrcBusBillIds().add(row.getLong("entry.e_srcbillid"));
            delWoffIds.add(row.getLong("id"));
            BusWoffRecordVO vo = new BusWoffRecordVO(row.getLong(this.busModel.HEAD_SRCFINBILLID), row.getLong("entry.e_srcbillid"), row.getLong("entry.e_srcentryid"), row.getLong("id"), row.getBigDecimal("entry.e_quantity"), row.getBigDecimal("entry.e_amount"));
            woffRecordListVO.add(vo);
        }
        return woffRecordListVO;
    }

    protected Map<Long, Set<String>> woffMatch(DataSet finDataSet, List<String> finMatchFields, DataSet srcBusDataSet, List<String> busMatchFields, List<BusWoffRecordVO> woffRecordListVO, boolean isRevert, boolean execSqlUpdate) {
        HashMap<Long, List> finRowMap = new HashMap<Long, List>(4);
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOByFinId = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getFinId));
        for (Row finRow : finDataSet) {
            Long finId = finRow.getLong("id");
            finRowMap.computeIfAbsent(finId, v -> new ArrayList(2)).add(finRow);
            List woffRecordListVO2 = woffRecordListVOByFinId.getOrDefault(finId, new ArrayList(2));
            for (BusWoffRecordVO vo : woffRecordListVO2) {
                vo.setFinOrderDate(finRow.getDate(orderByDate));
            }
        }
        int batchSize = this.getBusWoffBatchSize();
        HashMap<Long, Set<String>> overfulfilBillnoMap = new HashMap<Long, Set<String>>(2);
        HashMap<Long, BigDecimal[]> headParamMap = new HashMap<Long, BigDecimal[]>(2);
        ArrayList<Object[]> entryParams = new ArrayList<Object[]>(8);
        ArrayList<Object[]> entryEParams = new ArrayList<Object[]>(8);
        HashMap<Long, BusWoffRecordVO> finEnableInvoiceListVO = new HashMap<Long, BusWoffRecordVO>(2);
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOMap = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getSrcBusEntryId));
        boolean isAr = "ar_busbill".equals(this.busWoffParam.getBusEntity());
        for (Row srcBusRow : srcBusDataSet) {
            Long srcBusEntryId = srcBusRow.getLong(this.busModel.ENTRY_PK);
            List<BusWoffRecordVO> woffRecordListVOBySrcBusEntryId = woffRecordListVOMap.get(srcBusEntryId);
            if (ObjectUtils.isEmpty(woffRecordListVOBySrcBusEntryId)) continue;
            BigDecimal woffQuantity = BigDecimal.ZERO;
            BigDecimal woffAmount = BigDecimal.ZERO;
            BigDecimal finQuantity = BigDecimal.ZERO;
            BigDecimal finAmount = BigDecimal.ZERO;
            BigDecimal finLocalAmt = BigDecimal.ZERO;
            BigDecimal finPriceTaxTotal = BigDecimal.ZERO;
            BigDecimal finPriceTaxTotalLocal = BigDecimal.ZERO;
            woffRecordListVOBySrcBusEntryId = ((Stream)woffRecordListVOBySrcBusEntryId.stream().parallel()).sorted(Comparator.comparing(BusWoffRecordVO::getFinOrderDate, Comparator.nullsLast(Date::compareTo))).collect(Collectors.toList());
            HashMap<Long, Set> overfulfilBillnoMapTemp = new HashMap<Long, Set>(2);
            for (BusWoffRecordVO vo : woffRecordListVOBySrcBusEntryId) {
                List finRowById = finRowMap.getOrDefault(vo.getFinId(), new ArrayList(2));
                Iterator iterator = finRowById.iterator();
                while (iterator.hasNext()) {
                    Row finRow = (Row)iterator.next();
                    StringBuilder isNullEquality = new StringBuilder("false");
                    int comparator = this.compare(finRow, finMatchFields, srcBusRow, busMatchFields, isNullEquality);
                    if (ObjectUtils.isEmpty((Object)isNullEquality) || comparator != 0) continue;
                    if (!ObjectUtils.isEmpty((Object)vo.getFinEntryId())) {
                        vo = vo.cloneVo();
                        woffRecordListVO.add(vo);
                    }
                    Long finEntryId = finRow.getLong(this.finModel.ENTRY_PK);
                    vo.setFinEntryId(finEntryId);
                    vo.setSrcBusBillNo(srcBusRow.getString(this.busModel.HEAD_BILLNO));
                    overfulfilBillnoMapTemp.computeIfAbsent(vo.getFinId(), v -> new HashSet(2)).add(vo.getSrcBusBillNo());
                    BusWoffRecordVO finEnableInvoiceVO = BusWoffHelper.getFinEnableInvoiceListVO(finEnableInvoiceListVO, finRow, this.finModel);
                    if (finEnableInvoiceVO.isFinAllWoffed()) {
                        iterator.remove();
                        continue;
                    }
                    this.dealFinInvoice(finRow, finEnableInvoiceVO, vo);
                    woffQuantity = woffQuantity.add(vo.getQuantity());
                    woffAmount = woffAmount.add(vo.getAmount());
                    finQuantity = finQuantity.add(vo.getInvoicedQty());
                    finAmount = finAmount.add(vo.getInvoicedNoTaxAmt());
                    finLocalAmt = finLocalAmt.add(vo.getInvNoTaxLocalAmt());
                    finPriceTaxTotal = finPriceTaxTotal.add(vo.getInvoicedAmt());
                    finPriceTaxTotalLocal = finPriceTaxTotalLocal.add(vo.getInvoicedLocAmt());
                }
            }
            boolean overfulfil = false;
            if (!isRevert) {
                Boolean isBasedonAmt = srcBusRow.getBoolean("payproperty.isbasedonamt");
                BigDecimal unWoffQty = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFQTY);
                BigDecimal unInvocedQty = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNINVOICEDQTY);
                BigDecimal unWoffNoTaxAmt = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFNOTAXAMT);
                BigDecimal unInvoiceNoTaxAmt = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNINVNOTAXAMT);
                BigDecimal quantity = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_QUANTITY);
                BigDecimal amount = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_AMOUNT);
                if (isBasedonAmt.booleanValue()) {
                    if (unWoffNoTaxAmt.multiply(amount).compareTo(BigDecimal.ZERO) < 0 || unInvoiceNoTaxAmt.multiply(amount).compareTo(BigDecimal.ZERO) < 0) {
                        overfulfil = true;
                    } else {
                        BigDecimal canWoffAmt;
                        BigDecimal bigDecimal = canWoffAmt = unInvoiceNoTaxAmt.abs().compareTo(unWoffNoTaxAmt.abs()) > 0 ? unWoffNoTaxAmt : unInvoiceNoTaxAmt;
                        if (canWoffAmt.abs().compareTo(woffAmount.abs()) < 0) {
                            overfulfil = true;
                        }
                    }
                } else if (unWoffQty.multiply(quantity).compareTo(BigDecimal.ZERO) < 0 || unInvocedQty.multiply(quantity).compareTo(BigDecimal.ZERO) < 0) {
                    overfulfil = true;
                } else {
                    BigDecimal canWoffQty;
                    BigDecimal bigDecimal = canWoffQty = unInvocedQty.abs().compareTo(unWoffQty.abs()) > 0 ? unWoffQty : unInvocedQty;
                    if (canWoffQty.abs().compareTo(woffQuantity.abs()) < 0) {
                        overfulfil = true;
                    }
                }
            }
            if (overfulfil) {
                for (Map.Entry mapEntry : overfulfilBillnoMapTemp.entrySet()) {
                    overfulfilBillnoMap.computeIfAbsent((Long)mapEntry.getKey(), (Function<Long, Set<String>>)((Function<Long, Set>)v -> new HashSet(2))).addAll((Collection)mapEntry.getValue());
                }
                continue;
            }
            if (!execSqlUpdate) continue;
            BusWoffHelper.dealSqlParams(headParamMap, entryParams, entryEParams, srcBusRow, isRevert, finQuantity, finAmount, finLocalAmt, finPriceTaxTotal, finPriceTaxTotalLocal);
            if (entryParams.size() < batchSize) continue;
            BusWoffHelper.execSqlUpdate(isAr, headParamMap, entryParams, entryEParams);
            headParamMap.clear();
            entryParams.clear();
            entryEParams.clear();
        }
        if (execSqlUpdate && !entryParams.isEmpty()) {
            BusWoffHelper.execSqlUpdate(isAr, headParamMap, entryParams, entryEParams);
        }
        return overfulfilBillnoMap;
    }
}

