/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.service.bus.WoffModeEnum;
import kd.fi.arapcommon.service.buswoff.AbstractBusWoffService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StringUtils;

public abstract class AbstractBusWrittenOffWoff
extends AbstractBusWoffService {
    private Map<Long, Long> srcFinIdToWrittenOff = new HashMap<Long, Long>(2);

    @Override
    public BusWoffResult busAssignWoff(Set<Long> finIds, Map<Long, BFRowId> sourceBusBFRowMap) {
        return this.busWoff(finIds);
    }

    @Override
    protected Map<String, String> getOtherMatchField() {
        Map<String, String> matchFieldMapCommon = super.getOtherMatchField();
        HashMap<String, String> matchFieldMap = new HashMap<String, String>(2);
        matchFieldMap.put(this.finModel.ENTRY + ".groupnumber", this.busModel.ENTRY + ".groupnumber");
        matchFieldMap.put(this.finModel.ENTRY + ".groupseq", this.busModel.ENTRY + ".groupseq");
        matchFieldMap.put(this.finModel.ENTRY + "." + this.finModel.E_COREBILLTYPE, this.busModel.ENTRY + "." + this.busModel.E_COREBILLTYPE);
        matchFieldMap.put(this.finModel.ENTRY + "." + this.finModel.E_COREBILLNO, this.busModel.ENTRY + "." + this.busModel.E_COREBILLNO);
        matchFieldMap.put(this.finModel.ENTRY + "." + this.finModel.E_COREBILLENTRYSEQ, this.busModel.ENTRY + "." + this.busModel.E_COREBILLENTRYSEQ);
        matchFieldMap.putAll(matchFieldMapCommon);
        return matchFieldMap;
    }

    @Override
    protected QFilter getFinQFilter() {
        return new QFilter("id", "in", this.srcFinIdToWrittenOff.keySet());
    }

    @Override
    protected List<String> getFinSelector(List<String> finMatchFields) {
        List<String> selector = super.getFinSelector(finMatchFields);
        if (!selector.contains(this.finModel.HEAD_ORG)) {
            selector.add(this.finModel.HEAD_ORG);
        }
        if (!selector.contains("payproperty.isbasedonamt")) {
            selector.add("payproperty.isbasedonamt");
        }
        selector.add("asstact.masterid");
        selector.add("currency.amtprecision");
        selector.add("basecurrency.amtprecision");
        selector.add(this.finModel.HEAD_EXCHANGERATE);
        selector.add(this.finModel.HEAD_QUOTATION);
        selector.add(this.finModel.HEAD_ISINCLUDETAX);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLID);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTMODE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTAMOUNT);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_UNITPRICE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXUNITPRICE);
        return selector;
    }

    @Override
    protected DataSet getFinDataSet(List<String> matchFields) {
        QFilter filter = new QFilter("id", "in", this.busWoffParam.getBillIds()).and("iswrittenoff", "=", (Object)Boolean.TRUE);
        DataSet writtenOffDataSet = QueryServiceHelper.queryDataSet((String)"queryWrittenOff", (String)this.busWoffParam.getFinEntity(), (String)("id," + this.finModel.HEAD_BIZDATE + "," + this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLID), (QFilter[])new QFilter[]{filter}, (String)"");
        writtenOffDataSet.copy().forEach(row -> this.srcFinIdToWrittenOff.put(row.getLong(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLID), row.getLong("id")));
        return writtenOffDataSet;
    }

    @Override
    protected QFilter getSrcBusQFilter(DataSet finDataSet) {
        return new QFilter(this.busModel.HEAD_SRCFINBILLID, "in", this.srcFinIdToWrittenOff.keySet()).and(this.busModel.HEAD_ISADJUST, "=", (Object)Boolean.TRUE);
    }

    @Override
    protected List<String> getBusSelector(List<String> matchFields) {
        List<String> selector = super.getBusSelector(matchFields);
        selector.add(this.busModel.HEAD_SRCFINBILLID);
        selector.add(this.busModel.HEAD_BILLSRCTYPE);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLID);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDQTY);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDONOTAXAMT);
        return selector;
    }

    @Override
    protected List<BusWoffRecordVO> match(DataSet finDataSet, List<String> finMatchFields, DataSet busDataSet, List<String> busMatchFields) {
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(64);
        if (finDataSet == null || busDataSet == null) {
            return woffRecordListVO;
        }
        HashMap<Long, Date> bizDateMap = new HashMap<Long, Date>(2);
        for (Object row : finDataSet) {
            bizDateMap.put(row.getLong("id"), row.getDate(this.finModel.HEAD_BIZDATE));
        }
        HashSet<Long> needMatchSrcBusIdSet = new HashSet<Long>(2);
        for (Row row : busDataSet) {
            String billsrctype = row.getString(this.busModel.HEAD_BILLSRCTYPE);
            if (StringUtils.isEmpty(billsrctype)) continue;
            BusWoffRecordVO vo = new BusWoffRecordVO(row.getLong(this.busModel.HEAD_SRCFINBILLID), row.getLong("entry.e_srcbillid"), row.getLong("entry.e_srcentryid"), row.getLong("id"), row.getBigDecimal("entry.e_quantity"), row.getBigDecimal("entry.e_amount"));
            vo.setWoffBusEntryId(row.getLong(this.busModel.ENTRY_PK));
            vo.setWoffBusBillNo(row.getString(this.busModel.HEAD_BILLNO));
            vo.setWoffBillSrcType(billsrctype);
            woffRecordListVO.add(vo);
            if (WoffModeEnum.DIRECT.getValue().equals(billsrctype)) continue;
            needMatchSrcBusIdSet.add(row.getLong(this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLID));
        }
        logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u6700\u521d\u6e90\u6682\u4f30\u5355ID\u96c6\u5408\uff1a" + needMatchSrcBusIdSet);
        ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), "woff", needMatchSrcBusIdSet);
        Map<String, List<BusWoffRecordVO>> woffModeListVOMap = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getWoffBillSrcType));
        for (Map.Entry<String, List<BusWoffRecordVO>> woffModeListVOMapEntry : woffModeListVOMap.entrySet()) {
            if (WoffModeEnum.DIRECT.getValue().equals(woffModeListVOMapEntry.getKey())) continue;
            finMatchFields.clear();
            busMatchFields.clear();
            this.initMatchSelector(woffModeListVOMapEntry.getKey(), finMatchFields, busMatchFields);
            DataSet srcFinDataSet = super.getFinDataSet(finMatchFields);
            Set<Long> srcBusIdSet = woffModeListVOMapEntry.getValue().stream().map(BusWoffRecordVO::getSrcBusId).collect(Collectors.toSet());
            DataSet srcBusDataSet = this.getBusDataSet(srcBusIdSet, busMatchFields);
            if (WoffModeEnum.PREPAID.getValue().equals(woffModeListVOMapEntry.getKey())) {
                int batchSize = this.getBusWoffBatchSize();
                BusWoffHelper.prepaidWoffMatch(this.finModel, srcFinDataSet, srcBusDataSet, woffModeListVOMapEntry.getValue(), batchSize, true, true);
                continue;
            }
            this.woffMatch(srcFinDataSet, finMatchFields, srcBusDataSet, busMatchFields, woffModeListVOMapEntry.getValue(), true, true);
        }
        for (BusWoffRecordVO vo : woffRecordListVO) {
            Long writtenOffId = this.srcFinIdToWrittenOff.get(vo.getFinId());
            vo.setWoffBizDate((Date)bizDateMap.get(writtenOffId));
        }
        return woffRecordListVO;
    }

    abstract void initMatchSelector(String var1, List<String> var2, List<String> var3);

    @Override
    protected void dealFinInvoice(Row finRow, BusWoffRecordVO finEnableInvoiceVO, BusWoffRecordVO busWoffRecordVO) {
        BusWoffHelper.calculatorFinInvoice(this.finModel, finRow, finEnableInvoiceVO, busWoffRecordVO);
    }

    @Override
    protected void resetWoffBill(DynamicObject woffBill, List<BusWoffRecordVO> woffRecordListVO, QueryUtil queryUtil) {
        if (ObjectUtils.isEmpty(woffRecordListVO)) {
            return;
        }
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOBySrcBusEntryId = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getWoffBusId));
        List<BusWoffRecordVO> busWoffRecordListVO = woffRecordListVOBySrcBusEntryId.get(woffBill.getLong(this.busModel.HEAD_SOURCEBILLID));
        woffBill.set(this.busModel.HEAD_BILLSRCTYPE, (Object)this.busWoffParam.getWoffMode().getValue());
        woffBill.set(this.busModel.HEAD_WRITEOFFBUSINESS, (Object)Boolean.TRUE);
        if (ObjectUtils.isEmpty(busWoffRecordListVO)) {
            return;
        }
        BusWoffRecordVO busWoffRecordVO = busWoffRecordListVO.get(0);
        woffBill.set(this.busModel.HEAD_SRCFINBILLID, (Object)this.srcFinIdToWrittenOff.get(busWoffRecordVO.getFinId()));
        woffBill.set(this.busModel.HEAD_REMARK, (Object)String.format(ResManager.loadKDString((String)"\u51b2\u9500%s", (String)"BusBillWriteBackFromFinBillAuditService_0", (String)"fi-arapcommon", (Object[])new Object[0]), busWoffRecordVO.getWoffBusBillNo()));
        Date bizDate = busWoffRecordVO.getWoffBizDate();
        if (!EmptyUtils.isEmpty(bizDate)) {
            woffBill.set(this.busModel.HEAD_BIZDATE, (Object)bizDate);
        }
    }

    @Override
    protected void writeBackSrcBusEntry(Set<Long> srcBusIdSet, List<BusWoffRecordVO> woffRecordListVO) {
        Map<Long, List<BusWoffRecordVO>> woffRecordListVOByWoffBusId = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getWoffBusId));
        for (Long srcBusId : srcBusIdSet) {
            Set<Long> srcBusEntryIdSet = woffRecordListVOByWoffBusId.get(srcBusId).stream().map(BusWoffRecordVO::getSrcBusEntryId).collect(Collectors.toSet());
            BusWoffHelper.writeOffExecSqlUpdate(this.busWoffParam.getBusEntity(), true, srcBusIdSet, srcBusEntryIdSet);
        }
    }

    @Override
    protected void buildBusWoffResult(BusWoffResult result, List<BusWoffRecordVO> woffRecordListV0, List<Object> woffBillIds) {
        for (BusWoffRecordVO vo : woffRecordListV0) {
            result.getFinBillIds().add(this.srcFinIdToWrittenOff.get(vo.getFinId()));
            result.getSrcBusBillIds().add(vo.getSrcBusId());
        }
        result.getWoffBillIds().addAll(woffBillIds);
    }

    public Map<Long, Set<String>> unAuditValidate(Map<Long, Long> srcFinIdToWrittenOff) {
        Map<Long, Set<String>> overfullSrcFinBillnoMap = new HashMap<Long, Set<String>>(2);
        if (ObjectUtils.isEmpty(srcFinIdToWrittenOff)) {
            return overfullSrcFinBillnoMap;
        }
        this.srcFinIdToWrittenOff = srcFinIdToWrittenOff;
        this.initBusWoffParam(srcFinIdToWrittenOff.values().stream().collect(Collectors.toSet()));
        ArrayList<String> finMatchFields = new ArrayList<String>(2);
        ArrayList<String> busMatchFields = new ArrayList<String>(2);
        this.initMatchSelector(finMatchFields, busMatchFields);
        overfullSrcFinBillnoMap = this.prepareUnWoff(srcFinIdToWrittenOff.keySet(), null, true, finMatchFields, busMatchFields);
        return overfullSrcFinBillnoMap;
    }

    private Map<Long, Set<String>> prepareUnWoff(Set<Long> srcFinIds, Set<Long> writtenOffIdSet, boolean onlyValidator, List<String> finMatchFields, List<String> busMatchFields) {
        HashMap<Long, Set<String>> overfullSrcFinBillnoMap = new HashMap<Long, Set<String>>(2);
        QFilter filter = new QFilter(this.busModel.HEAD_SRCFINBILLID, "in", srcFinIds).and(this.busModel.HEAD_ISADJUST, "=", (Object)Boolean.TRUE);
        Set<Long> woffIdSet = this.getBusIdSet(filter);
        if (ObjectUtils.isEmpty(woffIdSet)) {
            return overfullSrcFinBillnoMap;
        }
        if (!onlyValidator) {
            logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u51b2\u9500\u6e90\u8d22\u52a1\u5355\u5bf9\u5e94\u7684\u5355\u5230\u6682\u4f30\u51b2\u56de\u5355ID\u96c6\u5408\uff1a" + woffIdSet);
            ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), "woff", woffIdSet);
        }
        DataSet woffDataSet = this.getBusDataSet(woffIdSet, busMatchFields);
        HashSet<Long> srcBusIdSet = new HashSet<Long>(2);
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(8);
        for (Object row : woffDataSet) {
            srcBusIdSet.add(row.getLong("entry.e_srcbillid"));
            BusWoffRecordVO busWoffRecordVO = new BusWoffRecordVO(row.getLong(this.busModel.HEAD_SRCFINBILLID), row.getLong("entry.e_srcbillid"), row.getLong("entry.e_srcentryid"), row.getLong("id"), row.getBigDecimal("entry.e_quantity"), row.getBigDecimal("entry.e_amount"));
            busWoffRecordVO.setBasedonAmt(row.getBoolean("payproperty.isbasedonamt"));
            busWoffRecordVO.setWoffBillSrcType(row.getString(this.busModel.HEAD_BILLSRCTYPE));
            woffRecordListVO.add(busWoffRecordVO);
        }
        if (!onlyValidator) {
            logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u9700\u8981\u91cd\u65b0\u5360\u7528\u7684\u6e90\u6682\u4f30\u5355ID\u96c6\u5408\uff1a" + srcBusIdSet);
            ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), "woff", srcBusIdSet);
        }
        Map<String, List<BusWoffRecordVO>> woffModeListVOMap = woffRecordListVO.stream().collect(Collectors.groupingBy(BusWoffRecordVO::getWoffBillSrcType));
        for (Map.Entry entry : woffModeListVOMap.entrySet()) {
            DataSet srcBusDataSet;
            String string = (String)entry.getKey();
            List woffRecordListVOTemp = (List)entry.getValue();
            if (ObjectUtils.isEmpty((Object)string)) {
                for (BusWoffRecordVO vo : woffRecordListVOTemp) {
                    this.srcFinIdToWrittenOff.remove(vo.getFinId());
                }
                continue;
            }
            finMatchFields.clear();
            busMatchFields.clear();
            this.initMatchSelector(string, finMatchFields, busMatchFields);
            DataSet srcFinDataSet = super.getFinDataSet(finMatchFields);
            if (ObjectUtils.isEmpty((Object)srcFinDataSet) || ObjectUtils.isEmpty((Object)(srcBusDataSet = this.getBusDataSet(srcBusIdSet, busMatchFields)))) continue;
            Map<Object, Object> overfullSrcFinBillnoMapTemp = new HashMap(2);
            if (WoffModeEnum.DIRECT.getValue().equals(string)) {
                overfullSrcFinBillnoMapTemp = this.botpUnWoffValidator(srcBusDataSet, woffRecordListVOTemp);
            } else if (WoffModeEnum.PREPAID.getValue().equals(string)) {
                int batchSize = this.getBusWoffBatchSize();
                Map<Long, String> overfullSrcFinBillnoTemp = BusWoffHelper.prepaidWoffMatch(this.finModel, srcFinDataSet, srcBusDataSet, woffRecordListVOTemp, batchSize, false, !onlyValidator);
                for (Map.Entry<Long, String> entry2 : overfullSrcFinBillnoTemp.entrySet()) {
                    overfullSrcFinBillnoMapTemp.computeIfAbsent(entry2.getKey(), v -> new HashSet(2)).add(entry2.getValue());
                }
            } else {
                overfullSrcFinBillnoMapTemp = this.woffMatch(srcFinDataSet, finMatchFields, srcBusDataSet, busMatchFields, woffRecordListVOTemp, false, !onlyValidator);
            }
            if (ObjectUtils.isEmpty(overfullSrcFinBillnoMapTemp)) continue;
            overfullSrcFinBillnoMap.putAll(overfullSrcFinBillnoMapTemp);
        }
        if (!onlyValidator) {
            HashSet<Long> srcFinIdSetOk = new HashSet<Long>(2);
            for (Map.Entry<Long, Long> entry : this.srcFinIdToWrittenOff.entrySet()) {
                Long srcFinId = entry.getKey();
                Set overfulfilBillnoTemp = (Set)overfullSrcFinBillnoMap.get(srcFinId);
                if (!ObjectUtils.isEmpty((Object)overfulfilBillnoTemp)) continue;
                srcFinIdSetOk.add(srcFinId);
                if (writtenOffIdSet == null) continue;
                writtenOffIdSet.add(entry.getValue());
            }
            if (!srcFinIdSetOk.isEmpty()) {
                HashSet<Long> hashSet = new HashSet<Long>(2);
                HashSet<Long> hashSet2 = new HashSet<Long>(2);
                for (BusWoffRecordVO vo : woffRecordListVO) {
                    if (!srcFinIdSetOk.contains(vo.getFinId())) continue;
                    hashSet.add(vo.getSrcBusId());
                    hashSet2.add(vo.getSrcBusEntryId());
                }
                BusWoffHelper.writeOffExecSqlUpdate(this.busWoffParam.getBusEntity(), false, hashSet, hashSet2);
            }
        }
        return overfullSrcFinBillnoMap;
    }

    private Map<Long, Set<String>> botpUnWoffValidator(DataSet srcBusDataSet, List<BusWoffRecordVO> botpWoffRecordListVO) {
        HashMap<Long, Set<String>> overfullSrcFinBillnoMap = new HashMap<Long, Set<String>>(2);
        if (ObjectUtils.isEmpty(botpWoffRecordListVO)) {
            return overfullSrcFinBillnoMap;
        }
        HashMap<Long, List> botpWoffRecordListVOBySrcBusEntryId = new HashMap<Long, List>(2);
        HashSet<Long> srcBusIdSet = new HashSet<Long>(2);
        HashSet<Long> srcBusEntryIdSet = new HashSet<Long>(2);
        for (BusWoffRecordVO vo : botpWoffRecordListVO) {
            srcBusIdSet.add(vo.getSrcBusId());
            srcBusEntryIdSet.add(vo.getSrcBusEntryId());
            botpWoffRecordListVOBySrcBusEntryId.computeIfAbsent(vo.getSrcBusEntryId(), v -> new ArrayList(2)).add(vo);
        }
        Map<Long, List<Long>> srcBusToSrcFin = BOTPNewHelper.loadNearTargetRowIds(this.busWoffParam.getBusEntity(), this.busModel.ENTRY, srcBusIdSet.toArray(new Long[0]), srcBusEntryIdSet.toArray(new Long[0]), this.busWoffParam.getFinEntity());
        for (Row srcBusRow : srcBusDataSet) {
            Long srcBusEntryId = srcBusRow.getLong(this.busModel.ENTRY_PK);
            List botpWoffRecordListVOTemp = botpWoffRecordListVOBySrcBusEntryId.getOrDefault(srcBusEntryId, new ArrayList(2));
            List srcFinEntryIds = srcBusToSrcFin.getOrDefault(srcBusEntryId, new ArrayList(2));
            if (botpWoffRecordListVOTemp.isEmpty() || srcFinEntryIds.isEmpty()) continue;
            BigDecimal woffQuantity = BigDecimal.ZERO;
            BigDecimal woffAmount = BigDecimal.ZERO;
            for (BusWoffRecordVO vo : botpWoffRecordListVOTemp) {
                woffQuantity = woffQuantity.add(vo.getQuantity());
                woffAmount = woffAmount.add(vo.getAmount());
            }
            Boolean isBasedonAmt = srcBusRow.getBoolean("payproperty.isbasedonamt");
            BigDecimal unWoffQty = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFQTY);
            BigDecimal unInvocedQty = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNINVOICEDQTY);
            BigDecimal unWoffNoTaxAmt = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNWOFFNOTAXAMT);
            BigDecimal unInvoiceNoTaxAmt = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_UNINVNOTAXAMT);
            BigDecimal quantity = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_QUANTITY);
            BigDecimal amount = srcBusRow.getBigDecimal(this.busModel.ENTRY + "." + this.busModel.E_AMOUNT);
            boolean overfulfil = false;
            if (isBasedonAmt.booleanValue()) {
                if (unWoffNoTaxAmt.multiply(amount).compareTo(BigDecimal.ZERO) < 0 || unInvoiceNoTaxAmt.multiply(amount).compareTo(BigDecimal.ZERO) < 0) {
                    overfulfil = true;
                } else {
                    BigDecimal canWoffAmt;
                    BigDecimal bigDecimal = canWoffAmt = unInvoiceNoTaxAmt.abs().compareTo(unWoffNoTaxAmt.abs()) > 0 ? unWoffNoTaxAmt : unInvoiceNoTaxAmt;
                    if (canWoffAmt.abs().compareTo(woffAmount.abs()) < 0) {
                        overfulfil = true;
                    }
                }
            } else if (unWoffQty.multiply(quantity).compareTo(BigDecimal.ZERO) < 0 || unInvocedQty.multiply(quantity).compareTo(BigDecimal.ZERO) < 0) {
                overfulfil = true;
            } else {
                BigDecimal canWoffQty;
                BigDecimal bigDecimal = canWoffQty = unInvocedQty.abs().compareTo(unWoffQty.abs()) > 0 ? unWoffQty : unInvocedQty;
                if (canWoffQty.abs().compareTo(woffQuantity.abs()) < 0) {
                    overfulfil = true;
                }
            }
            if (!overfulfil) continue;
            for (BusWoffRecordVO vo : botpWoffRecordListVOTemp) {
                overfullSrcFinBillnoMap.computeIfAbsent(vo.getFinId(), v -> new HashSet(2)).add(srcBusRow.getString(this.busModel.HEAD_BILLNO));
            }
        }
        return overfullSrcFinBillnoMap;
    }

    @Override
    protected Object[] prepareDelWoff(BusWoffResult result) {
        ArrayList<String> finMatchFields = new ArrayList<String>(2);
        ArrayList<String> busMatchFields = new ArrayList<String>(2);
        this.initMatchSelector(finMatchFields, busMatchFields);
        this.getFinDataSet(finMatchFields);
        HashSet<Long> writtenOffIdSet = new HashSet<Long>(2);
        Map<Long, Set<String>> overfullSrcFinBillnoMap = this.prepareUnWoff(this.srcFinIdToWrittenOff.keySet(), writtenOffIdSet, false, finMatchFields, busMatchFields);
        Map<Long, String> errors = result.getErrors();
        for (Map.Entry<Long, Long> mapEntry : this.srcFinIdToWrittenOff.entrySet()) {
            Long srcFinId = mapEntry.getKey();
            Set<String> overfulfilBillnoTemp = overfullSrcFinBillnoMap.get(srcFinId);
            if (ObjectUtils.isEmpty(overfulfilBillnoTemp)) continue;
            errors.put(this.srcFinIdToWrittenOff.get(mapEntry.getValue()), String.format(this.getValidatorError(), String.join((CharSequence)",", overfulfilBillnoTemp)));
        }
        HashSet<Long> writtenOffWoffId = new HashSet<Long>(2);
        if (!ObjectUtils.isEmpty(writtenOffIdSet)) {
            DataSet writtenOffWoffDataSet = QueryServiceHelper.queryDataSet((String)"", (String)this.busWoffParam.getBusEntity(), (String)("id," + this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLID), (QFilter[])new QFilter[]{new QFilter(this.busModel.HEAD_SRCFINBILLID, "in", writtenOffIdSet)}, (String)"");
            for (Row row : writtenOffWoffDataSet) {
                writtenOffWoffId.add(row.getLong("id"));
                result.getSrcBusBillIds().add(row.getLong(this.busModel.ENTRY + "." + this.busModel.E_SOURCEBILLID));
            }
            result.setFinBillIds(writtenOffIdSet);
            result.getWoffBillIds().addAll(writtenOffWoffId);
        }
        return writtenOffWoffId.toArray();
    }

    abstract String getValidatorError();
}

