/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.service.bus.WoffModeEnum;
import kd.fi.arapcommon.service.buswoff.BusCoreBillWoffFromFinar;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;

public class BusGroupWoffFromFinar
extends BusCoreBillWoffFromFinar {
    @Override
    protected void initBusWoffParam(Set<Long> billIds) {
        super.initBusWoffParam(billIds);
        this.busWoffParam.setWoffMode(WoffModeEnum.GROUPCOREBILL);
    }

    @Override
    protected Map<Long, QFilter> getQFilterByAppParameters(List<Long> orgIds) {
        return BusWoffHelper.getQFilterByAppParameters(Boolean.TRUE, orgIds, "ap_004", "ar_0041", "ar0041_conditionvalue", this.busWoffParam.getBusEntity());
    }

    @Override
    protected Map<String, String> getOtherMatchField() {
        Map<String, String> matchFieldMapCommon = super.getOtherMatchField();
        HashMap<String, String> matchFieldMap = new HashMap<String, String>(2);
        matchFieldMap.put(this.finModel.ENTRY + ".groupnumber", this.busModel.ENTRY + ".groupnumber");
        matchFieldMap.put(this.finModel.ENTRY + ".groupseq", this.busModel.ENTRY + ".groupseq");
        matchFieldMap.putAll(matchFieldMapCommon);
        return matchFieldMap;
    }

    @Override
    protected QFilter getSrcBusQFilter(DataSet finDataSet) {
        QFilter filter = super.getSrcBusQFilter(finDataSet);
        if (filter == null) {
            return null;
        }
        HashSet<String> groupNumberSet = new HashSet<String>(8);
        HashSet<String> groupSeqSet = new HashSet<String>(8);
        for (Row row : finDataSet.copy()) {
            String groupnumber = row.getString(this.finModel.ENTRY + ".groupnumber");
            String groupseq = row.getString(this.finModel.ENTRY + ".groupseq");
            if (StringUtils.isEmpty((CharSequence)groupnumber) || StringUtils.isEmpty((CharSequence)groupseq)) continue;
            groupNumberSet.add(groupnumber);
            groupSeqSet.add(groupseq);
        }
        if (ObjectUtils.isEmpty(groupNumberSet) || ObjectUtils.isEmpty(groupSeqSet)) {
            filter = null;
        } else {
            filter.and(this.busModel.ENTRY + ".groupnumber", "in", groupNumberSet).and(this.busModel.ENTRY + ".groupseq", "in", groupSeqSet);
        }
        return filter;
    }
}

