/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.buswoff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.model.BusBillModel;
import kd.fi.arapcommon.model.FinBillModel;
import kd.fi.arapcommon.service.bus.WoffModeEnum;
import kd.fi.arapcommon.service.buswoff.AbstractBusWoffService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.buswoff.BusWoffParam;
import kd.fi.arapcommon.service.buswoff.BusWoffRecordVO;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;

public class BusPrepaidWoffFromFinAr
extends AbstractBusWoffService {
    @Override
    public BusWoffResult busAssignWoff(Set<Long> finIds, Map<Long, BFRowId> sourceBusBFRowMap) {
        this.initBusWoffParam(finIds, sourceBusBFRowMap);
        return this.busWoff(finIds);
    }

    @Override
    protected void initBusWoffParam(Set<Long> billIds) {
        this.busWoffParam = new BusWoffParam("ar_finarbill", "ar_busbill", billIds, "697561685841434624", WoffModeEnum.PREPAID);
        this.finModel = (FinBillModel)BillModelFactory.getModel("ar_finarbill");
        this.busModel = (BusBillModel)BillModelFactory.getModel("ar_busbill");
    }

    @Override
    protected List<String> getFinSelector(List<String> finMatchFields) {
        List<String> selector = super.getFinSelector(finMatchFields);
        selector.add(this.finModel.HEAD_SOURCEBILLTYPE);
        selector.add(this.finModel.HEAD_BILLTYPE);
        selector.add("currency.amtprecision");
        selector.add("basecurrency.amtprecision");
        selector.add(this.finModel.HEAD_EXCHANGERATE);
        selector.add(this.finModel.HEAD_QUOTATION);
        selector.add(this.finModel.HEAD_ISINCLUDETAX);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLID);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTMODE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTRATE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_DISCOUNTAMOUNT);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_UNITPRICE);
        selector.add(this.finModel.ENTRY + "." + this.finModel.E_TAXUNITPRICE);
        return selector;
    }

    @Override
    protected QFilter getFinQFilter() {
        return super.getFinQFilter().and(BusWoffHelper.getFinArQFilter()).and(this.finModel.HEAD_SOURCEBILLTYPE, "=", (Object)"ap_finapbill");
    }

    @Override
    protected QFilter getSrcBusQFilter(DataSet finDataSet) {
        Map<Long, BFRowId> sourceBusBFRowMap = this.busWoffParam.getSourceBusBFRowMap();
        if (ObjectUtils.isEmpty(sourceBusBFRowMap)) {
            HashMap<Long, Long> srcFinApTofinArMap = new HashMap<Long, Long>(8);
            HashSet<Long> srcFinApIdSet = new HashSet<Long>(2);
            for (Row row : finDataSet.copy()) {
                long billtypeId = row.getLong(this.finModel.HEAD_BILLTYPE);
                if (BillTypeConsts.ARFIN_STANDARD.compareTo(billtypeId) == 0 || BillTypeConsts.ARFIN_SERSAL.compareTo(billtypeId) == 0 || BillTypeConsts.ARFIN_EXPENSE.compareTo(billtypeId) == 0 || BillTypeConsts.ARFIN_BORROW.compareTo(billtypeId) == 0) continue;
                srcFinApTofinArMap.put(row.getLong(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLENTRYID), row.getLong(this.finModel.ENTRY_PK));
                srcFinApIdSet.add(row.getLong(this.finModel.ENTRY + "." + this.finModel.E_SOURCEBILLID));
            }
            if (ObjectUtils.isEmpty(srcFinApTofinArMap)) {
                return null;
            }
            QFilter srcFinApFilter = new QFilter("id", "in", srcFinApIdSet).and("detailentry.id", "in", srcFinApTofinArMap.keySet()).and("detailentry.e_prepaid", "=", (Object)Boolean.TRUE);
            DataSet srcFinApDataSet = QueryServiceHelper.queryDataSet((String)"PrepaidWoff-querySrcFinAp", (String)"ap_finapbill", (String)"id,sourcebilltype,detailentry.id,detailentry.e_sourcebillid,detailentry.e_sourcebillentryid", (QFilter[])new QFilter[]{srcFinApFilter}, (String)"");
            if (!srcFinApDataSet.hasNext()) {
                return null;
            }
            HashMap srcBusApTofinApMap = new HashMap(8);
            HashSet<Long> srcBusApIdSet = new HashSet<Long>(2);
            HashMap<Long, Long> finApEntryIdToBillId = new HashMap<Long, Long>(8);
            for (Object row : srcFinApDataSet) {
                if ("ap_busbill".equals(row.getString("sourcebilltype"))) {
                    srcBusApTofinApMap.put(row.getLong("detailentry.e_sourcebillentryid"), row.getLong("detailentry.id"));
                    srcBusApIdSet.add(row.getLong("detailentry.e_sourcebillid"));
                    continue;
                }
                finApEntryIdToBillId.put(row.getLong("detailentry.id"), row.getLong("id"));
            }
            if (!ObjectUtils.isEmpty(finApEntryIdToBillId)) {
                Map<Long, BFRowId> sourceBusApBFRowMap = BOTPHelper.loadNearSrcBFRowIdMap("ap_finapbill", "detailentry", finApEntryIdToBillId.values().toArray(new Long[0]), finApEntryIdToBillId.keySet().toArray(new Long[0]), "ap_busbill");
                for (Map.Entry entry : sourceBusApBFRowMap.entrySet()) {
                    BFRowId srcBusApBFRowId = (BFRowId)entry.getValue();
                    srcBusApTofinApMap.put(srcBusApBFRowId.getEntryId(), entry.getKey());
                    srcBusApIdSet.add(srcBusApBFRowId.getBillId());
                }
            }
            if (ObjectUtils.isEmpty(srcBusApTofinApMap)) {
                return null;
            }
            QFilter srcBusApFilter = new QFilter("id", "in", srcBusApIdSet).and("entry.id", "in", srcBusApTofinApMap.keySet());
            srcBusApFilter.and("entry.e_prepaid", "=", (Object)Boolean.TRUE);
            DataSet srcBusApDataSet = QueryServiceHelper.queryDataSet((String)"PrepaidWoff-querySrcBusAp", (String)"ap_busbill", (String)"id,entry.id", (QFilter[])new QFilter[]{srcBusApFilter}, (String)"");
            if (!srcBusApDataSet.hasNext()) {
                return null;
            }
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>(8);
            for (Row row : srcBusApDataSet) {
                hashMap.put(row.getLong("entry.id"), row.getLong("id"));
            }
            Map<Long, List<BFRowId>> targetBusBFRowIdsMap = BOTPHelper.loadTarBFRowIdMap("ap_busbill", "entry", hashMap.values().toArray(new Long[0]), hashMap.keySet().toArray(new Long[0]), this.busWoffParam.getBusEntity());
            for (Map.Entry<Long, List<BFRowId>> targetBusRowIdEntry : targetBusBFRowIdsMap.entrySet()) {
                Long finApEntryId = (Long)srcBusApTofinApMap.get(targetBusRowIdEntry.getKey());
                sourceBusBFRowMap.put((Long)srcFinApTofinArMap.get(finApEntryId), targetBusRowIdEntry.getValue().get(0));
            }
        } else {
            logger.info("----------\u4ee3\u57ab\u51b2\u56de\u5206\u5f55\u5173\u7cfb\u7531\u670d\u52a1\u5916\u90e8\u4f20\u5165----------");
        }
        if (ObjectUtils.isEmpty(sourceBusBFRowMap)) {
            return null;
        }
        HashSet<Long> srcBusIds = new HashSet<Long>(8);
        HashSet<Long> srcBusEntryIds = new HashSet<Long>(sourceBusBFRowMap.size());
        for (Map.Entry<Long, BFRowId> bfRowIdEntry : sourceBusBFRowMap.entrySet()) {
            BFRowId bfRowId = bfRowIdEntry.getValue();
            srcBusIds.add(bfRowId.getBillId());
            srcBusEntryIds.add(bfRowId.getEntryId());
        }
        return super.getSrcBusQFilter(finDataSet).and("id", "in", srcBusIds).and(this.busModel.ENTRY_PK, "in", srcBusEntryIds);
    }

    @Override
    protected List<String> getBusSelector(List<String> matchFields) {
        List<String> selector = super.getBusSelector(matchFields);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDQTY);
        selector.add(this.busModel.ENTRY + "." + this.busModel.E_INVOICEDONOTAXAMT);
        return selector;
    }

    @Override
    protected List<BusWoffRecordVO> match(DataSet finDataSet, List<String> finMatchFields, DataSet busDataSet, List<String> busMatchFields) {
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(8);
        Map<Long, BFRowId> sourceBusBFRowMap = this.busWoffParam.getSourceBusBFRowMap();
        if (ObjectUtils.isEmpty(sourceBusBFRowMap)) {
            return woffRecordListVO;
        }
        HashMap<Long, Row> busRowMap = new HashMap<Long, Row>(8);
        for (Row row : busDataSet) {
            busRowMap.put(row.getLong(this.busModel.ENTRY_PK), row);
        }
        HashMap<Long, BusWoffRecordVO> finEnableInvoiceListVO = new HashMap<Long, BusWoffRecordVO>(2);
        HashMap<Long, BusWoffRecordVO> busEnableWoffRecordListVO = new HashMap<Long, BusWoffRecordVO>(2);
        for (Row finRow : finDataSet) {
            BusWoffRecordVO woffRecordVO;
            Long srcBusEntryId = sourceBusBFRowMap.get(finRow.getLong(this.finModel.ENTRY_PK)).getEntryId();
            if (ObjectUtils.isEmpty((Object)srcBusEntryId) || (woffRecordVO = this.dealWoffRecord(finEnableInvoiceListVO, finRow, busEnableWoffRecordListVO, (Row)busRowMap.get(srcBusEntryId))) == null) continue;
            woffRecordListVO.add(woffRecordVO);
        }
        return woffRecordListVO;
    }

    @Override
    protected void dealFinInvoice(Row finRow, BusWoffRecordVO finEnableInvoiceVO, BusWoffRecordVO busWoffRecordVO) {
        BusWoffHelper.calculatorFinInvoice(this.finModel, finRow, finEnableInvoiceVO, busWoffRecordVO);
    }

    @Override
    protected void writeBackSrcBusEntry(Set<Long> srcBusIdSet, List<BusWoffRecordVO> woffRecordListVO) {
        int batchSize = this.getBusWoffBatchSize();
        BusWoffHelper.writeBackSrcBusEntry(this.busWoffParam.getBusEntity(), srcBusIdSet, woffRecordListVO, batchSize);
    }

    @Override
    protected Object[] prepareDelWoff(BusWoffResult result) {
        QFilter filter = new QFilter(this.busModel.HEAD_SRCFINBILLID, "in", this.busWoffParam.getBillIds()).and(this.busModel.HEAD_BILLSRCTYPE, "=", (Object)this.busWoffParam.getWoffMode().getValue());
        DataSet woffDataSet = QueryServiceHelper.queryDataSet((String)"prepaidPrepareDelWoff", (String)this.busWoffParam.getBusEntity(), (String)"id, srcfinbillid, billsrctype, entry.id, entry.e_srcbillid, entry.e_srcentryid, entry.e_quantity, entry.e_amount", (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, Long> delWoffIdMap = new HashMap<Long, Long>(8);
        ArrayList<BusWoffRecordVO> woffRecordListVO = new ArrayList<BusWoffRecordVO>(8);
        for (Row row : woffDataSet) {
            result.getFinBillIds().add(row.getLong(this.busModel.HEAD_SRCFINBILLID));
            result.getSrcBusBillIds().add(row.getLong("entry.e_srcbillid"));
            delWoffIdMap.put(row.getLong("entry.id"), row.getLong("id"));
            BusWoffRecordVO vo = new BusWoffRecordVO(row.getLong(this.busModel.HEAD_SRCFINBILLID), row.getLong("entry.e_srcbillid"), row.getLong("entry.e_srcentryid"), row.getLong("id"), row.getBigDecimal("entry.e_quantity"), row.getBigDecimal("entry.e_amount"));
            vo.setWoffBusEntryId(row.getLong("entry.id"));
            woffRecordListVO.add(vo);
        }
        if (woffRecordListVO.isEmpty()) {
            return null;
        }
        this.writeBackSrcBusEntry(delWoffIdMap, woffRecordListVO);
        return delWoffIdMap.values().toArray();
    }

    private void writeBackSrcBusEntry(Map<Long, Long> delWoffIdMap, List<BusWoffRecordVO> woffRecordListVO) {
        if (ObjectUtils.isEmpty(woffRecordListVO)) {
            return;
        }
        Set<Long> srcBusIdSet = woffRecordListVO.stream().map(BusWoffRecordVO::getSrcBusId).collect(Collectors.toSet());
        logger.info("----------BusWoffService \u9700\u8981\u52a0\u9501\u63a7\u5236\u5e76\u53d1\u7684\u6700\u521d\u6e90\u6682\u4f30\u5355ID\u96c6\u5408 \uff1a" + srcBusIdSet);
        ConcurrencyCtrlUtil.addCtrlInTX(this.busWoffParam.getBusEntity(), "woff", srcBusIdSet);
        ArrayList<String> finMatchFields = new ArrayList<String>(2);
        ArrayList<String> busMatchFields = new ArrayList<String>(2);
        this.initMatchSelector(finMatchFields, busMatchFields);
        DataSet srcBusDataSet = this.getBusDataSet(srcBusIdSet, busMatchFields);
        List<String> selector = this.getFinSelector(finMatchFields);
        DataSet finDataSet = QueryServiceHelper.queryDataSet((String)"queryFin", (String)this.busWoffParam.getFinEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{new QFilter("id", "in", this.busWoffParam.getBillIds())}, (String)"");
        int batchSize = this.getBusWoffBatchSize();
        BusWoffHelper.prepaidWoffMatch(this.finModel, finDataSet, srcBusDataSet, woffRecordListVO, batchSize, true, true);
    }
}

