/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.concurrency;

import java.util.HashSet;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.HeavyLockCtrlStrategy;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;
import kd.fi.arapcommon.service.concurrency.LightLockCtrlNoDBStrategy;
import kd.fi.arapcommon.service.concurrency.LightLockCtrlStrategy;
import kd.fi.arapcommon.service.concurrency.NoLockCtrlStrategy;
import kd.fi.arapcommon.util.StdConfig;

public class BillConcuCtrlStrategyFactory {
    private static final String HEAVY_CTRL = "heavy_ctrl";
    private static final String NO_CTRL = "no_ctrl";
    private static final String MUTEX_CTRL = "mutex_ctrl";

    @Deprecated
    public static IBillConcurrencyCtrlStrategy getCtrlStrategy(BillConcuControlParam param) {
        if (param == null) {
            return new NoLockCtrlStrategy();
        }
        String paramCacheKey = param.getBiz();
        String paramValue = StdConfig.get(paramCacheKey);
        if (HEAVY_CTRL.equals(paramValue)) {
            return new HeavyLockCtrlStrategy(param);
        }
        if (NO_CTRL.equals(paramValue)) {
            return new NoLockCtrlStrategy();
        }
        if ("settle".equals(param.getBiz()) && !MUTEX_CTRL.equals(paramValue)) {
            return new LightLockCtrlNoDBStrategy(param);
        }
        return new LightLockCtrlStrategy(param);
    }

    public static IBillConcurrencyCtrlStrategy getCtrlStrategy(List<BillConcuControlParam> params) {
        if (params == null || params.isEmpty()) {
            return new NoLockCtrlStrategy();
        }
        HashSet<String> paramBizs = new HashSet<String>(params.size());
        for (BillConcuControlParam param : params) {
            paramBizs.add(param.getBiz());
        }
        if (paramBizs.size() > 1) {
            throw new KDBizException("BillConcuCtrlStrategyFactory.getCtrlStrategy biz exist more,please check");
        }
        String paramCacheKey = params.get(0).getBiz();
        String paramValue = StdConfig.get(paramCacheKey);
        if (HEAVY_CTRL.equals(paramValue)) {
            return new HeavyLockCtrlStrategy(params);
        }
        if (NO_CTRL.equals(paramValue)) {
            return new NoLockCtrlStrategy();
        }
        if ("settle".equals(paramCacheKey) && !MUTEX_CTRL.equals(paramValue)) {
            return new LightLockCtrlNoDBStrategy(params);
        }
        return new LightLockCtrlStrategy(params);
    }
}

