/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.concurrency;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.concurrency.AppCacheLockParam;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;

public class LightLockCtrlNoDBStrategy
implements IBillConcurrencyCtrlStrategy {
    private static final Log logger = LogFactory.getLog(LightLockCtrlNoDBStrategy.class);
    private static final String appId = "ap";
    private final int LOCK_EXPIRE_TIME = 86400;
    private final List<BillConcuControlParam> params;
    private final IAppCache cache;
    private final String dLockKey = "arap-lockctrl-" + CacheKeyUtil.getAcctId();

    public LightLockCtrlNoDBStrategy(BillConcuControlParam param) {
        ArrayList<BillConcuControlParam> params = new ArrayList<BillConcuControlParam>(1);
        params.add(param);
        this.params = params;
        this.cache = AppCache.get((String)appId);
    }

    public LightLockCtrlNoDBStrategy(List<BillConcuControlParam> params) {
        this.params = params;
        this.cache = AppCache.get((String)appId);
    }

    @Override
    public void addCtrl() {
        if (this.params == null || this.params.isEmpty()) {
            logger.info("LightLockCtrlNoDBStrategy addCtrl params is null or size=0, return");
            return;
        }
        int try_again = 1;
        logger.info("LightLockCtrlNoDBStrategy addCtrl begin:" + this.params);
        this.doAddCtrl(try_again);
        logger.info("LightLockCtrlNoDBStrategy addCtrl end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseCtrl() {
        logger.info("LightLockCtrlNoDBStrategy releaseCtrl begin");
        if (this.params == null || this.params.isEmpty()) {
            logger.info("LightLockCtrlNoDBStrategy releaseCtrl param is null;return;");
            return;
        }
        String biz = this.params.get(0).getBiz();
        for (BillConcuControlParam param : this.params) {
            Set<Long> billIds = param.getBillIds();
            String billEntity = param.getBillEntity();
            if (!ObjectUtils.isEmpty((Object)billEntity) && !ObjectUtils.isEmpty((Object)biz) && !ObjectUtils.isEmpty(billIds)) continue;
            logger.info("LightLockCtrlNoDBStrategy releaseCtrl param property is null;return;" + param);
            return;
        }
        DLock lock = DLock.createReentrant((String)(this.dLockKey + "-" + biz));
        lock.fastMode();
        try {
            lock.lock();
            Map<String, List<AppCacheLockParam>> lockMap = ConcurrencyCtrlUtil.getCacheLockMapByBiz(this.cache, biz);
            if (lockMap != null && lockMap.size() > 0) {
                for (BillConcuControlParam param : this.params) {
                    Set<Long> billIds = param.getBillIds();
                    String billEntity = param.getBillEntity();
                    List<AppCacheLockParam> billLockParamList = lockMap.get(billEntity);
                    if (ObjectUtils.isEmpty(billLockParamList)) continue;
                    billLockParamList.removeIf(billLockParam -> billIds.contains(billLockParam.getId()));
                    lockMap.put(billEntity, billLockParamList);
                }
                this.cache.put(biz, (Object)SerializationUtils.toJsonString(lockMap), 86400);
            }
        }
        finally {
            lock.unlock();
        }
        logger.info("LightLockCtrlNoDBStrategy releaseCtrl end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddCtrl(int try_again) {
        block16: {
            String biz = this.params.get(0).getBiz();
            for (BillConcuControlParam param : this.params) {
                Set<Long> billIds = param.getBillIds();
                String billEntity = param.getBillEntity();
                if (!ObjectUtils.isEmpty((Object)billEntity) && !ObjectUtils.isEmpty((Object)biz) && !ObjectUtils.isEmpty(billIds)) continue;
                logger.info("LightLockCtrlNoDBStrategy param property is null;return;" + param);
                return;
            }
            DLock lock = DLock.createReentrant((String)(this.dLockKey + "-" + biz));
            lock.fastMode();
            try {
                block18: {
                    Set value;
                    String key;
                    block17: {
                        List<AppCacheLockParam> billLockParamList;
                        Set billIds;
                        String billEntity;
                        lock.lock();
                        Map<String, List<AppCacheLockParam>> lockMap = ConcurrencyCtrlUtil.getCacheLockMapByBiz(this.cache, biz);
                        HashMap<String, Set> canAddLockMap = new HashMap<String, Set>(2);
                        HashMap canNotAddLockMap = new HashMap(2);
                        for (BillConcuControlParam billConcuControlParam : this.params) {
                            billEntity = billConcuControlParam.getBillEntity();
                            billIds = billConcuControlParam.getBillIds();
                            billLockParamList = lockMap.get(billEntity);
                            if (billLockParamList == null || billLockParamList.size() == 0) {
                                canAddLockMap.put(billEntity, billIds);
                                continue;
                            }
                            Set billLockIdSet = billLockParamList.stream().map(AppCacheLockParam::getId).collect(Collectors.toSet());
                            HashSet result = new HashSet(8);
                            result.addAll(billLockIdSet);
                            result.retainAll(billIds);
                            if (result.isEmpty()) {
                                canAddLockMap.put(billEntity, billIds);
                                continue;
                            }
                            canNotAddLockMap.put(billEntity, result);
                            break;
                        }
                        if (canNotAddLockMap.isEmpty()) {
                            if (!canAddLockMap.isEmpty()) {
                                for (Map.Entry entry : canAddLockMap.entrySet()) {
                                    billEntity = (String)entry.getKey();
                                    billIds = (Set)entry.getValue();
                                    billLockParamList = lockMap.get(billEntity);
                                    if (billLockParamList == null || billLockParamList.size() == 0) {
                                        lockMap.put(billEntity, ConcurrencyCtrlUtil.buildLockParamListByIds(billIds));
                                        continue;
                                    }
                                    billLockParamList.addAll(ConcurrencyCtrlUtil.buildLockParamListByIds(billIds));
                                    lockMap.put(billEntity, billLockParamList);
                                }
                                this.cache.put(biz, (Object)SerializationUtils.toJsonString(lockMap), 86400);
                            }
                            break block16;
                        }
                        Iterator iterator = canNotAddLockMap.entrySet().iterator();
                        Map.Entry entry = iterator.next();
                        key = (String)entry.getKey();
                        value = (Set)entry.getValue();
                        if (!this.params.get(0).isNeedWait()) break block17;
                        if (try_again < 60) break block18;
                    }
                    String msg = ConcurrencyCtrlUtil.getConCuCtrlMsg(key, biz, value);
                    throw new KDBizException(new ErrorCode(biz + "_datamutex", msg), new Object[0]);
                }
                lock.unlock();
                this.sleep();
                this.doAddCtrl(++try_again);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public List<BillConcuControlParam> getCtrlParams() {
        return this.params;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

