/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.concurrency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.fi.arapcommon.helper.MutexLockHelper;
import kd.fi.arapcommon.service.concurrency.BillConcuControlParam;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.concurrency.IBillConcurrencyCtrlStrategy;

public class LightLockCtrlStrategy
implements IBillConcurrencyCtrlStrategy {
    private static final Log logger = LogFactory.getLog(LightLockCtrlStrategy.class);
    private final List<BillConcuControlParam> params;

    public LightLockCtrlStrategy(BillConcuControlParam param) {
        ArrayList<BillConcuControlParam> params = new ArrayList<BillConcuControlParam>(1);
        params.add(param);
        this.params = params;
    }

    public LightLockCtrlStrategy(List<BillConcuControlParam> params) {
        this.params = params;
    }

    @Override
    public void addCtrl() {
        if (this.params == null || this.params.isEmpty()) {
            logger.info("LightLockCtrlStrategy addCtrl param is null;return;");
            return;
        }
        int try_again = 1;
        logger.info("LightLockCtrlStrategy addCtrl begin:" + this.params);
        this.doAddCtrl(try_again);
    }

    @Override
    public void releaseCtrl() {
        String billEntity;
        Set<Long> billIds;
        if (this.params == null || this.params.isEmpty()) {
            logger.info("LightLockCtrlStrategy releaseCtrl param is null;return;");
            return;
        }
        String biz = this.params.get(0).getBiz();
        for (BillConcuControlParam param : this.params) {
            billIds = param.getBillIds();
            billEntity = param.getBillEntity();
            if (!ObjectUtils.isEmpty((Object)billEntity) && !ObjectUtils.isEmpty((Object)biz) && !ObjectUtils.isEmpty(billIds)) continue;
            logger.info("LightLockCtrlStrategy releaseCtrl param property is null;return;" + param);
            return;
        }
        for (BillConcuControlParam param : this.params) {
            billIds = param.getBillIds();
            billEntity = param.getBillEntity();
            MutexLockHelper.batchRelease(billEntity, billIds, biz);
        }
    }

    private void doAddCtrl(int try_again) {
        String billEntity;
        Set<Long> billIds;
        String biz = this.params.get(0).getBiz();
        for (BillConcuControlParam param : this.params) {
            billIds = param.getBillIds();
            billEntity = param.getBillEntity();
            if (!ObjectUtils.isEmpty((Object)billEntity) && !ObjectUtils.isEmpty((Object)biz) && !ObjectUtils.isEmpty(billIds)) continue;
            logger.info("LightLockCtrlStrategy param property is null;return;" + param);
            return;
        }
        for (BillConcuControlParam param : this.params) {
            billIds = param.getBillIds();
            billEntity = param.getBillEntity();
            String netGroupId = RuntimeMetaType.NetCtrlOperate + "." + billEntity + "." + biz;
            if (netGroupId.length() > 36) {
                netGroupId = netGroupId.substring(netGroupId.length() - 36);
            }
            ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(billIds.size());
            for (long billId : billIds) {
                Map<String, Object> requireParam = this.createDataMutexParam(billId, billEntity, netGroupId, biz);
                mutexRequireList.add(requireParam);
            }
            HashSet<Long> successIds = new HashSet<Long>(8);
            HashSet<Long> failIds = new HashSet<Long>(8);
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                logger.info(this.buildRequireMutexLog(param, mutexResult));
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String billId = (String)mutexItem.getKey();
                    Boolean required = (Boolean)mutexItem.getValue();
                    if (required.booleanValue()) {
                        successIds.add(Long.parseLong(billId));
                        continue;
                    }
                    failIds.add(Long.parseLong(billId));
                }
            }
            catch (IOException exception) {
                ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519\uff1a%s\u3002", (String)"MutexLockHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]), exception.getMessage()));
                throw new KDException((Throwable)exception, ec, new Object[0]);
            }
            if (successIds.size() >= billIds.size()) continue;
            logger.info("try_again " + try_again + "-successIds:" + successIds + "-failIds:" + failIds);
            MutexLockHelper.batchRelease(billEntity, successIds, biz);
            if (!param.isNeedWait() || try_again >= 60) {
                String msg = ConcurrencyCtrlUtil.getConCuCtrlMsg(billEntity, biz, failIds);
                throw new KDBizException(new ErrorCode(biz + "_datamutex", msg), new Object[0]);
            }
            successIds.clear();
            failIds.clear();
            this.sleep();
            this.doAddCtrl(++try_again);
        }
    }

    @Override
    public List<BillConcuControlParam> getCtrlParams() {
        return this.params;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Map<String, Object> createDataMutexParam(long billId, String billEntity, String netGroupId, String biz) {
        HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
        requireParam.put("dataObjId", String.valueOf(billId));
        requireParam.put("groupId", netGroupId);
        requireParam.put("entityKey", billEntity);
        requireParam.put("operationKey", biz);
        requireParam.put("isStrict", Boolean.TRUE);
        return requireParam;
    }

    private String buildRequireMutexLog(BillConcuControlParam param, Map<String, Boolean> mutexResult) {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append("dataMutex.batchrequire(");
        logMsg.append(param.getBillEntity()).append(',');
        logMsg.append(param.getBiz()).append(',');
        logMsg.append(param.getBillIds().size()).append(',');
        logMsg.append(param.getBillIds());
        logMsg.append("), ");
        if (mutexResult == null) {
            logMsg.append("return null");
        } else {
            logMsg.append("return ");
            logMsg.append(SerializationUtils.toJsonString(mutexResult));
        }
        return logMsg.toString();
    }
}

