/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.event;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.freeze.AbstractFinApPrePayFreezeService;
import kd.fi.arapcommon.service.freeze.ConmBillPrePayChangeFreeze;
import kd.fi.arapcommon.service.freeze.PurorderBillPrePayChangeFreeze;
import kd.fi.arapcommon.service.freeze.SctmBillPrePayChangeFreeze;

public class FinApFreezeByPreChange
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(FinApFreezeByPreChange.class);

    public Object handleEvent(KDBizEvent e) {
        String source = e.getSource();
        String eventNumber = e.getEventNumber();
        logger.info("\u91c7\u8d2d\u53d8\u66f4\u9884\u4ed8\uff1a\u4e8b\u4ef6\u7f16\u7801==>{}\uff0c\u4e8b\u4ef6\u53c2\u6570==>{}", (Object)eventNumber, (Object)source);
        List params = SerializationUtils.fromJsonStringToList((String)e.getSource(), Map.class);
        if (params == null) {
            logger.info("params is null");
            return null;
        }
        for (Map param : params) {
            String entityNo = (String)param.get("entityno");
            if ("pm_purorderbill".equals(entityNo)) {
                this.freezeByPurChange(param);
                continue;
            }
            if ("conm_purcontract".equals(entityNo)) {
                this.freezeByConmChange(param);
                continue;
            }
            if (!"sctm_scpo".equals(entityNo)) continue;
            this.freezeBySctmChange(param);
        }
        return null;
    }

    private void freezeBySctmChange(Map<String, Object> param) {
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        List sctmBillIds = SerializationUtils.fromJsonStringToList((String)((String)param.get("billids")), Long.class);
        QFilter filter = new QFilter("id", "in", (Object)sctmBillIds);
        DataSet conDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"sctm_scpo", (String)"id,billentry_pay.payamount,billentry_pay.isprepay", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : conDataSet) {
            BigDecimal curPreAmt;
            Long conBillId = row.getLong("id");
            BigDecimal sumConmPerAmt = (BigDecimal)coreBillPrePayAmt.get(conBillId);
            BigDecimal bigDecimal = curPreAmt = row.getBoolean("billentry_pay.isprepay") != false ? row.getBigDecimal("billentry_pay.payamount") : BigDecimal.ZERO;
            if (sumConmPerAmt == null) {
                coreBillPrePayAmt.put(conBillId, curPreAmt);
                continue;
            }
            coreBillPrePayAmt.put(conBillId, sumConmPerAmt.add(curPreAmt));
        }
        Map<Long, BigDecimal> coreBillSumPrePayMap = this.loadPayedPreBillAmt(sctmBillIds);
        this.finApBillFreeze("sctm_scpo", coreBillPrePayAmt, coreBillSumPrePayMap);
    }

    private void freezeByConmChange(Map<String, Object> param) {
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        List conBillIds = SerializationUtils.fromJsonStringToList((String)((String)param.get("billids")), Long.class);
        QFilter filter = new QFilter("id", "in", (Object)conBillIds);
        DataSet conDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"conm_purcontract", (String)"id,payentry.payamount,payentry.isprepay", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : conDataSet) {
            BigDecimal curPreAmt;
            Long conBillId = row.getLong("id");
            BigDecimal sumConmPerAmt = (BigDecimal)coreBillPrePayAmt.get(conBillId);
            BigDecimal bigDecimal = curPreAmt = row.getBoolean("payentry.isprepay") != false ? row.getBigDecimal("payentry.payamount") : BigDecimal.ZERO;
            if (sumConmPerAmt == null) {
                coreBillPrePayAmt.put(conBillId, curPreAmt);
                continue;
            }
            coreBillPrePayAmt.put(conBillId, sumConmPerAmt.add(curPreAmt));
        }
        Map<Long, BigDecimal> coreBillSumPrePayMap = this.loadPayedPreBillAmt(conBillIds);
        this.finApBillFreeze("conm_purcontract", coreBillPrePayAmt, coreBillSumPrePayMap);
    }

    private void freezeByPurChange(Map<String, Object> param) {
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        List purOrderBillIds = SerializationUtils.fromJsonStringToList((String)((String)param.get("billids")), Long.class);
        QFilter filter = new QFilter("id", "in", (Object)purOrderBillIds);
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)"pm_purorderbill", (String)"id,purbillentry_pay.payamount,purbillentry_pay.isprepay", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : purDataSet) {
            BigDecimal curPreAmt;
            Long purBillId = row.getLong("id");
            BigDecimal sumPurPerAmt = (BigDecimal)coreBillPrePayAmt.get(purBillId);
            BigDecimal bigDecimal = curPreAmt = row.getBoolean("purbillentry_pay.isprepay") != false ? row.getBigDecimal("purbillentry_pay.payamount") : BigDecimal.ZERO;
            if (sumPurPerAmt == null) {
                coreBillPrePayAmt.put(purBillId, curPreAmt);
                continue;
            }
            coreBillPrePayAmt.put(purBillId, sumPurPerAmt.add(curPreAmt));
        }
        Map<Long, BigDecimal> coreBillSumPrePayMap = this.loadPayedPreBillAmt(purOrderBillIds);
        this.finApBillFreeze("pm_purorderbill", coreBillPrePayAmt, coreBillSumPrePayMap);
    }

    private void finApBillFreeze(String billEntity, Map<Long, BigDecimal> coreBillPrePayAmt, Map<Long, BigDecimal> coreBillSumPrePayMap) {
        HashSet<Long> freezeCoreBillIds = new HashSet<Long>(16);
        HashSet<Long> unFreezeCoreBillIds = new HashSet<Long>(16);
        for (Map.Entry<Long, BigDecimal> entrySet : coreBillPrePayAmt.entrySet()) {
            Long coreBillId = entrySet.getKey();
            BigDecimal coreBillPre = entrySet.getValue();
            if (coreBillPre == null || coreBillPre.compareTo(BigDecimal.ZERO) == 0) {
                unFreezeCoreBillIds.add(coreBillId);
                continue;
            }
            BigDecimal coreSumPrePayAmt = coreBillSumPrePayMap.get(coreBillId);
            if (coreSumPrePayAmt == null) {
                freezeCoreBillIds.add(coreBillId);
                continue;
            }
            if (coreSumPrePayAmt.compareTo(coreBillPre) < 0) {
                freezeCoreBillIds.add(coreBillId);
                continue;
            }
            unFreezeCoreBillIds.add(coreBillId);
        }
        AbstractFinApPrePayFreezeService service = "pm_purorderbill".equals(billEntity) ? new PurorderBillPrePayChangeFreeze() : ("conm_purcontract".equals(billEntity) ? new ConmBillPrePayChangeFreeze() : new SctmBillPrePayChangeFreeze());
        if (freezeCoreBillIds.size() > 0) {
            service.freeze(freezeCoreBillIds, true);
        }
        if (unFreezeCoreBillIds.size() > 0) {
            service.freeze(unFreezeCoreBillIds, false);
        }
    }

    private Map<Long, BigDecimal> loadPayedPreBillAmt(List<Long> coreBillIds) {
        HashMap<Long, BigDecimal> coreBillSumPrePayMap = new HashMap<Long, BigDecimal>(16);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        payBillFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        DataSet prePayBills = QueryServiceHelper.queryDataSet((String)"finapfreezepay", (String)"cas_paybill", (String)"id,entry.e_corebillid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (Row row : prePayBills) {
            Long coreBillId = row.getLong("entry.e_corebillid");
            BigDecimal currentPayAmt = row.getBigDecimal("entry.e_payableamt").subtract(row.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPrePayAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId);
            if (coreBillSumPrePayAmt != null) {
                coreBillSumPrePayMap.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
                continue;
            }
            coreBillSumPrePayMap.put(coreBillId, currentPayAmt);
        }
        return coreBillSumPrePayMap;
    }
}

