/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.service.fin.PlanEntryOrdinalDisposer;
import kd.fi.arapcommon.service.fin.PlanEntryProportDisposer;

public class ApPlanEntryDisposer
extends PlanEntryOrdinalDisposer {
    @Override
    public void deleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        boolean isZeroAmountBill;
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        boolean bl = isZeroAmountBill = finBill.getBigDecimal(this.getPriceTaxAmtKey()).compareTo(BigDecimal.ZERO) == 0;
        if (!disposeEntry.isEmpty() && isZeroAmountBill) {
            DynamicObject row = (DynamicObject)disposeEntry.get(0);
            String unlockAmountKey = this.getEntryUnlockAmountKey();
            String lockedAmountKey = this.getEntryLockedAmountKey();
            this.increaseAmount(row, unlockAmountKey, disposeAmount);
            this.reduceAmount(row, lockedAmountKey, disposeAmount);
        } else if (this.isPremiumSrcBill(finBill)) {
            this.premiumSrcBillDeleteDispose(finBill, disposeAmount);
        } else {
            super.deleteDispose(finBill, disposeAmount);
        }
    }

    protected boolean isPremiumSrcBill(DynamicObject finBill) {
        return finBill.getBigDecimal("premiumamt").compareTo(BigDecimal.ZERO) != 0;
    }

    protected void premiumSrcBillDeleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        BigDecimal premiumamt = finBill.getBigDecimal("premiumamt");
        PlanEntryProportDisposer prePlanDis = BeanFactory.getBean(PlanEntryProportDisposer.class, new Object[0]);
        prePlanDis.deleteDispose(finBill, premiumamt);
        super.deleteDispose(finBill, disposeAmount);
        prePlanDis.saveDispose(finBill, premiumamt);
    }

    @Override
    public Collection<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(10);
        selectors.add("pricetaxtotal");
        selectors.add("e_pricetaxtotal");
        selectors.add("unlockamt");
        selectors.add("lockedamt");
        selectors.add("planpricetax");
        selectors.add("unplanlockamt");
        selectors.add("planlockedamt");
        selectors.add("currency");
        selectors.add("premiumamt");
        return selectors;
    }

    @Override
    protected String getPriceTaxAmtKey() {
        return "pricetaxtotal";
    }
}

