/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.fin.ProportionateEntryDisposerTemplate;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArMaterialEntryDisposer4ApplyPay
extends ProportionateEntryDisposerTemplate {
    @Override
    public void saveDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        if (EmptyUtils.isEmpty(disposeAmount)) {
            return;
        }
        BigDecimal billLockAmount = this.getBillLockedAmount(finBill);
        boolean disposeAll = disposeAmount.compareTo(billLockAmount) == 0;
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        List noPresentDisposeEntry = disposeEntry.stream().filter(row -> this.getEntryAmount((DynamicObject)row).compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        BigDecimal billAmount = this.getBillAmount(finBill);
        String unlockAmountKey = this.getEntryUnlockAmountKey();
        String lockedAmountKey = this.getEntryLockedAmountKey();
        int precision = this.getPrecision(finBill);
        BigDecimal remainDisposeAmount = disposeAmount;
        BigDecimal rowRemainDisposeAmt = BigDecimal.ZERO;
        for (int i = 0; i < noPresentDisposeEntry.size(); ++i) {
            DynamicObject row2 = (DynamicObject)noPresentDisposeEntry.get(i);
            BigDecimal entryAmount = this.getEntryAmount(row2);
            BigDecimal unLockAmt = row2.getBigDecimal(unlockAmountKey);
            BigDecimal lockedAmt = row2.getBigDecimal(lockedAmountKey);
            if (disposeAll) {
                row2.set(lockedAmountKey, (Object)BigDecimal.ZERO);
                row2.set(unlockAmountKey, (Object)entryAmount);
                continue;
            }
            if (i == noPresentDisposeEntry.size() - 1) {
                this.increaseAmount(row2, lockedAmountKey, remainDisposeAmount);
                this.reduceAmount(row2, unlockAmountKey, remainDisposeAmount);
                continue;
            }
            BigDecimal disposeRate = entryAmount.divide(billAmount, 10, RoundingMode.HALF_UP);
            BigDecimal rowDisposeAmount = disposeAmount.multiply(disposeRate).setScale(precision, RoundingMode.HALF_UP);
            if ((rowDisposeAmount = rowDisposeAmount.add(rowRemainDisposeAmt)).multiply(entryAmount).compareTo(BigDecimal.ZERO) > 0 && rowDisposeAmount.abs().compareTo(unLockAmt.abs()) > 0) {
                this.increaseAmount(row2, lockedAmountKey, entryAmount.subtract(lockedAmt));
                this.reduceAmount(row2, unlockAmountKey, unLockAmt);
                rowRemainDisposeAmt = rowDisposeAmount.subtract(unLockAmt);
                remainDisposeAmount = remainDisposeAmount.subtract(unLockAmt);
                continue;
            }
            this.increaseAmount(row2, lockedAmountKey, rowDisposeAmount);
            this.reduceAmount(row2, unlockAmountKey, rowDisposeAmount);
            remainDisposeAmount = remainDisposeAmount.subtract(rowDisposeAmount);
        }
    }

    @Override
    public void deleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        if (EmptyUtils.isEmpty(disposeAmount)) {
            return;
        }
        BigDecimal unLockedAmount = this.getBillUnlockAmount(finBill);
        boolean disposeAll = disposeAmount.compareTo(unLockedAmount) == 0;
        DynamicObjectCollection entries = this.getDisposeEntry(finBill);
        String unlockAmountKey = this.getEntryUnlockAmountKey();
        String lockedAmountKey = this.getEntryLockedAmountKey();
        int precision = this.getPrecision(finBill);
        BigDecimal billAmount = this.getBillAmount(finBill);
        BigDecimal remainDisposeAmount = disposeAmount;
        BigDecimal rowRemainDisposeAmt = BigDecimal.ZERO;
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject row = (DynamicObject)entries.get(i);
            BigDecimal entryAmount = this.getEntryAmount(row);
            BigDecimal unLockAmt = row.getBigDecimal(unlockAmountKey);
            BigDecimal lockedAmt = row.getBigDecimal(lockedAmountKey);
            if (disposeAll) {
                row.set(unlockAmountKey, (Object)BigDecimal.ZERO);
                row.set(lockedAmountKey, (Object)entryAmount);
                continue;
            }
            if (i == entries.size() - 1) {
                this.reduceAmount(row, lockedAmountKey, remainDisposeAmount);
                this.increaseAmount(row, unlockAmountKey, remainDisposeAmount);
                continue;
            }
            BigDecimal disposeRate = entryAmount.divide(billAmount, 10, RoundingMode.HALF_UP);
            BigDecimal rowDisposeAmount = disposeAmount.multiply(disposeRate).setScale(precision, RoundingMode.HALF_UP);
            if ((rowDisposeAmount = rowDisposeAmount.add(rowRemainDisposeAmt)).multiply(entryAmount).compareTo(BigDecimal.ZERO) > 0 && rowDisposeAmount.abs().compareTo(lockedAmt.abs()) > 0) {
                this.reduceAmount(row, lockedAmountKey, row.getBigDecimal(lockedAmountKey));
                this.increaseAmount(row, unlockAmountKey, entryAmount.subtract(unLockAmt));
                rowRemainDisposeAmt = rowDisposeAmount.subtract(lockedAmt);
                remainDisposeAmount = remainDisposeAmount.subtract(lockedAmt);
                continue;
            }
            this.increaseAmount(row, unlockAmountKey, rowDisposeAmount);
            this.reduceAmount(row, lockedAmountKey, rowDisposeAmount);
            remainDisposeAmount = remainDisposeAmount.subtract(rowDisposeAmount);
        }
    }

    @Override
    protected BigDecimal getBillUnlockAmount(DynamicObject finBill) {
        DynamicObjectCollection planEntry = finBill.getDynamicObjectCollection("entry");
        BigDecimal totoalLockedAmount = BigDecimal.ZERO;
        for (DynamicObject planRow : planEntry) {
            BigDecimal rowLockedAmount = planRow.getBigDecimal("e_unlockamt");
            totoalLockedAmount = totoalLockedAmount.add(rowLockedAmount);
        }
        return totoalLockedAmount.abs();
    }

    @Override
    protected BigDecimal getBillLockedAmount(DynamicObject finBill) {
        DynamicObjectCollection entries = finBill.getDynamicObjectCollection("entry");
        BigDecimal totoalUnlockAmount = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            BigDecimal rowUnlockAmount = entry.getBigDecimal("e_lockedamt");
            totoalUnlockAmount = totoalUnlockAmount.add(rowUnlockAmount);
        }
        return totoalUnlockAmount.abs();
    }

    @Override
    protected BigDecimal getBillAmount(DynamicObject finBill) {
        return finBill.getBigDecimal("recamount");
    }

    @Override
    protected DynamicObjectCollection getDisposeEntry(DynamicObject finBill) {
        return finBill.getDynamicObjectCollection("entry");
    }

    @Override
    protected BigDecimal getEntryAmount(DynamicObject row) {
        return row.getBigDecimal("e_recamount");
    }

    @Override
    protected String getEntryUnlockAmountKey() {
        return "e_unlockamt";
    }

    @Override
    protected String getEntryLockedAmountKey() {
        return "e_lockedamt";
    }

    @Override
    protected int getPrecision(DynamicObject finBill) {
        return finBill.getInt("currency.amtprecision");
    }
}

