/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.fin.OrdinalEntryDisposerTemplate;

public abstract class PlanEntryOrdinalDisposer
extends OrdinalEntryDisposerTemplate {
    @Override
    public void saveDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        boolean isZeroAmountBill;
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        boolean bl = isZeroAmountBill = finBill.getBigDecimal(this.getPriceTaxAmtKey()).compareTo(BigDecimal.ZERO) == 0;
        if (disposeEntry.size() > 0 && isZeroAmountBill) {
            DynamicObject row = (DynamicObject)disposeEntry.get(0);
            this.increaseAmount(row, this.getEntryLockedAmountKey(), disposeAmount);
            this.reduceAmount(row, this.getEntryUnlockAmountKey(), disposeAmount);
        } else {
            super.saveDispose(finBill, disposeAmount);
        }
    }

    @Override
    public void deleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        boolean isZeroAmountBill;
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        boolean bl = isZeroAmountBill = finBill.getBigDecimal(this.getPriceTaxAmtKey()).compareTo(BigDecimal.ZERO) == 0;
        if (!disposeEntry.isEmpty() && isZeroAmountBill) {
            DynamicObject row = (DynamicObject)disposeEntry.get(0);
            this.increaseAmount(row, this.getEntryUnlockAmountKey(), disposeAmount);
            this.reduceAmount(row, this.getEntryLockedAmountKey(), disposeAmount);
        } else {
            super.deleteDispose(finBill, disposeAmount);
        }
    }

    @Override
    protected DynamicObjectCollection getDisposeEntry(DynamicObject finBill) {
        return finBill.getDynamicObjectCollection("planentity");
    }

    @Override
    protected String getEntryUnlockAmountKey() {
        return "unplanlockamt";
    }

    @Override
    protected String getEntryLockedAmountKey() {
        return "planlockedamt";
    }

    protected abstract String getPriceTaxAmtKey();
}

