/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.service.fin.EntryDisposer;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class ProportionateEntryDisposerTemplate
implements EntryDisposer {
    @Override
    public void saveDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        if (EmptyUtils.isEmpty(disposeAmount)) {
            return;
        }
        BigDecimal billUnlockAmount = this.getBillUnlockAmount(finBill);
        boolean disposeAll = disposeAmount.compareTo(billUnlockAmount) == 0;
        DynamicObjectCollection disposeEntry = this.getDisposeEntry(finBill);
        LinkedList<DynamicObject> noPresentDisposeEntry = new LinkedList<DynamicObject>();
        for (DynamicObject row : disposeEntry) {
            if (this.getEntryAmount(row).compareTo(BigDecimal.ZERO) == 0) continue;
            noPresentDisposeEntry.add(row);
        }
        BigDecimal billAmount = this.getBillAmount(finBill);
        String unlockAmountKey = this.getEntryUnlockAmountKey();
        String lockedAmountKey = this.getEntryLockedAmountKey();
        int precision = this.getPrecision(finBill);
        int count = 0;
        BigDecimal remainDisposeAmount = disposeAmount;
        BigDecimal rowRemainDisposeAmt = BigDecimal.ZERO;
        for (DynamicObject row : noPresentDisposeEntry) {
            BigDecimal entryAmount = this.getEntryAmount(row);
            BigDecimal unLockAmt = row.getBigDecimal(unlockAmountKey);
            BigDecimal lockedAmt = row.getBigDecimal(lockedAmountKey);
            if (disposeAll) {
                this.increaseAmount(row, lockedAmountKey, entryAmount.subtract(lockedAmt));
                this.reduceAmount(row, unlockAmountKey, unLockAmt);
                continue;
            }
            if (++count == noPresentDisposeEntry.size()) {
                this.increaseAmount(row, lockedAmountKey, remainDisposeAmount);
                this.reduceAmount(row, unlockAmountKey, remainDisposeAmount);
                continue;
            }
            BigDecimal disposeRate = entryAmount.divide(billAmount, 10, RoundingMode.HALF_UP);
            BigDecimal rowDisposeAmount = disposeAmount.multiply(disposeRate).setScale(precision, RoundingMode.HALF_UP);
            if ((rowDisposeAmount = rowDisposeAmount.add(rowRemainDisposeAmt)).multiply(entryAmount).compareTo(BigDecimal.ZERO) > 0 && rowDisposeAmount.abs().compareTo(unLockAmt.abs()) > 0) {
                this.increaseAmount(row, lockedAmountKey, entryAmount.subtract(lockedAmt));
                this.reduceAmount(row, unlockAmountKey, unLockAmt);
                rowRemainDisposeAmt = rowDisposeAmount.subtract(unLockAmt);
                remainDisposeAmount = remainDisposeAmount.subtract(unLockAmt);
                continue;
            }
            this.increaseAmount(row, lockedAmountKey, rowDisposeAmount);
            this.reduceAmount(row, unlockAmountKey, rowDisposeAmount);
            remainDisposeAmount = remainDisposeAmount.subtract(rowDisposeAmount);
            rowRemainDisposeAmt = BigDecimal.ZERO;
        }
    }

    @Override
    public void deleteDispose(DynamicObject finBill, BigDecimal disposeAmount) {
        if (EmptyUtils.isEmpty(disposeAmount)) {
            return;
        }
        BigDecimal totoalLockedAmount = this.getBillLockedAmount(finBill);
        boolean disposeAll = disposeAmount.compareTo(totoalLockedAmount) == 0;
        DynamicObjectCollection entry = this.getDisposeEntry(finBill);
        ArrayList<DynamicObject> noPresentDisposeEntry = new ArrayList<DynamicObject>(entry.size());
        for (DynamicObject row : entry) {
            if (this.getEntryAmount(row).compareTo(BigDecimal.ZERO) == 0) continue;
            noPresentDisposeEntry.add(row);
        }
        String unlockAmountKey = this.getEntryUnlockAmountKey();
        String lockedAmountKey = this.getEntryLockedAmountKey();
        int precision = this.getPrecision(finBill);
        int count = 0;
        BigDecimal billAmount = this.getBillAmount(finBill);
        BigDecimal remainDisposeAmount = disposeAmount;
        BigDecimal rowRemainDisposeAmt = BigDecimal.ZERO;
        for (DynamicObject row : noPresentDisposeEntry) {
            BigDecimal entryAmount = this.getEntryAmount(row);
            BigDecimal unLockAmt = row.getBigDecimal(unlockAmountKey);
            BigDecimal lockedAmt = row.getBigDecimal(lockedAmountKey);
            if (disposeAll) {
                this.reduceAmount(row, lockedAmountKey, lockedAmt);
                this.increaseAmount(row, unlockAmountKey, entryAmount.subtract(unLockAmt));
                continue;
            }
            if (++count == noPresentDisposeEntry.size()) {
                this.reduceAmount(row, lockedAmountKey, remainDisposeAmount);
                this.increaseAmount(row, unlockAmountKey, remainDisposeAmount);
                continue;
            }
            BigDecimal disposeRate = entryAmount.divide(billAmount, 10, RoundingMode.HALF_UP);
            BigDecimal rowDisposeAmount = disposeAmount.multiply(disposeRate).setScale(precision, RoundingMode.HALF_UP);
            if ((rowDisposeAmount = rowDisposeAmount.add(rowRemainDisposeAmt)).multiply(entryAmount).compareTo(BigDecimal.ZERO) > 0 && rowDisposeAmount.abs().compareTo(lockedAmt.abs()) > 0) {
                this.reduceAmount(row, lockedAmountKey, row.getBigDecimal(lockedAmountKey));
                this.increaseAmount(row, unlockAmountKey, entryAmount.subtract(unLockAmt));
                rowRemainDisposeAmt = rowDisposeAmount.subtract(lockedAmt);
                remainDisposeAmount = remainDisposeAmount.subtract(lockedAmt);
                continue;
            }
            this.increaseAmount(row, unlockAmountKey, rowDisposeAmount);
            this.reduceAmount(row, lockedAmountKey, rowDisposeAmount);
            remainDisposeAmount = remainDisposeAmount.subtract(rowDisposeAmount);
            rowRemainDisposeAmt = BigDecimal.ZERO;
        }
    }

    protected void increaseAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.add(amount);
        row.set(amountKey, (Object)result);
    }

    protected void reduceAmount(DynamicObject row, String amountKey, BigDecimal amount) {
        BigDecimal originalAmount = row.getBigDecimal(amountKey);
        BigDecimal result = originalAmount.subtract(amount);
        row.set(amountKey, (Object)result);
    }

    protected abstract BigDecimal getBillUnlockAmount(DynamicObject var1);

    protected abstract BigDecimal getBillLockedAmount(DynamicObject var1);

    protected abstract BigDecimal getBillAmount(DynamicObject var1);

    protected abstract DynamicObjectCollection getDisposeEntry(DynamicObject var1);

    protected abstract BigDecimal getEntryAmount(DynamicObject var1);

    protected abstract String getEntryUnlockAmountKey();

    protected abstract String getEntryLockedAmountKey();

    protected abstract int getPrecision(DynamicObject var1);
}

