/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.fin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

public abstract class TransferAllService {
    protected static final Log logger = LogFactory.getLog(TransferAllService.class);
    protected DynamicObject transferInfo;
    protected String finBillKey;
    protected String finDetailEntryKey;
    protected String finPlanEntryKey;
    protected String finDetailEntryUnLockKey;
    protected int currencyPrecison;
    protected int localCurrencyPrecison;
    protected String quotation;
    protected BigDecimal exchange;
    protected String ruleId;
    protected DynamicObject[] needMatchSplitSchemes;
    protected String finHeadPriceTaxTotalLocalKey;
    protected String finHeadDueDate;
    protected Map<String, Set<String>> extendFields = new HashMap<String, Set<String>>(2);
    protected boolean isMaterialSettle;

    public TransferAllService(DynamicObject transferInfo) {
        this.transferInfo = transferInfo;
        this.localCurrencyPrecison = transferInfo.getInt("basecurrency.amtprecision");
        this.currencyPrecison = transferInfo.getInt("fincurrency.amtprecision");
        this.quotation = transferInfo.getString("quotation");
        this.exchange = transferInfo.getBigDecimal("head_exchangerate");
    }

    public TransferAllService init() {
        this.initParams();
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes(this.finBillKey, this.transferInfo.getLong("org.id"));
        return this;
    }

    protected abstract void initParams();

    public void transfer() {
        logger.info("TransferAllService.transfer() start");
        DynamicObjectCollection transferFromInfos = this.transferInfo.getDynamicObjectCollection("entryentity");
        List<Long> transferFromIds = transferFromInfos.stream().map(info -> info.getLong("id")).collect(Collectors.toList());
        ConcurrencyCtrlUtil.addCtrlInTX(this.finBillKey, "transferall", new HashSet<Long>(transferFromIds), false);
        List<DynamicObject> pushBills = BOTPHelper.push(this.finBillKey, this.finBillKey, this.ruleId, transferFromIds);
        logger.info("\u8f6c\u51fa\u65b9\u4fe1\u606f\u5927\u5c0f\uff1a" + transferFromInfos.size() + ",\u4e0b\u63a8\u5355\u636e\u5927\u5c0f\uff1a" + pushBills.size());
        DynamicObjectCollection transferTagInfos = this.transferInfo.getDynamicObjectCollection("tagentry");
        List<DynamicObject> transferBills = this.buildTransferBills(pushBills, transferFromInfos, transferTagInfos);
        this.postProcessTransferBill(transferFromIds, transferBills);
        this.validateTransferBills(transferBills);
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)this.finBillKey, (DynamicObject[])transferBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(operateResult);
        List successPkIds = operateResult.getSuccessPkIds();
        if (!this.isTransferasSaved() && !ObjectUtils.isEmpty((Object)successPkIds)) {
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.finBillKey, (Object[])successPkIds.toArray(new Object[0]), (OperateOption)option);
            OperationHelper.assertResult(submitResult);
        }
        this.disposeSrcBills(transferFromIds, transferBills);
        logger.info("TransferAllService.transfer() end");
    }

    private List<DynamicObject> buildTransferBills(List<DynamicObject> pushBills, DynamicObjectCollection transferFromInfos, DynamicObjectCollection transferTagInfos) {
        ArrayList<DynamicObject> transferBills = new ArrayList<DynamicObject>(pushBills.size() * transferTagInfos.size());
        CloneUtils cloneUtil = new CloneUtils(false, true);
        BigDecimal transferTotalAmt = BigDecimal.ZERO;
        for (DynamicObject transferFromInfo : transferFromInfos) {
            transferTotalAmt = transferTotalAmt.add(transferFromInfo.getBigDecimal("cantransferamt"));
        }
        int srcBillIndex = 0;
        int srcBillSize = pushBills.size();
        int transferTagIndex = 0;
        int transferTagSize = transferTagInfos.size();
        HashMap<Integer, BigDecimal> remainTransferAllPriceTaxTotalMap = new HashMap<Integer, BigDecimal>(transferTagInfos.size());
        HashMap<Integer, BigDecimal> remainTransferAllAmountMap = new HashMap<Integer, BigDecimal>(transferTagInfos.size());
        for (DynamicObject pushBill : pushBills) {
            HashMap<Integer, BigDecimal> remainDetailEntryPriceTaxTotalMap = new HashMap<Integer, BigDecimal>(transferTagInfos.size());
            transferTagIndex = 0;
            if (this.isNoEnd(++srcBillIndex, srcBillSize)) {
                BigDecimal pushBillCanTransferAmt = pushBill.getBigDecimal("pricetaxtotal");
                BigDecimal transverseProportion = pushBillCanTransferAmt.divide(transferTotalAmt, 10, RoundingMode.HALF_UP);
                BigDecimal remainTransferBillTotalAmount = BigDecimal.ZERO;
                for (DynamicObject transferTagInfo : transferTagInfos) {
                    BigDecimal transferBillPriceTaxTotal;
                    DynamicObject transferBill = (DynamicObject)cloneUtil.clone((IDataEntityBase)pushBill);
                    BigDecimal transferTagPriceTaxTotal = transferTagInfo.getBigDecimal("transpricetaxtotal");
                    BigDecimal transferTagAmount = transferTagInfo.getBigDecimal("transamount");
                    if (this.isNoEnd(++transferTagIndex, transferTagSize)) {
                        transferBillPriceTaxTotal = transferTagPriceTaxTotal.multiply(transverseProportion).setScale(this.currencyPrecison, RoundingMode.HALF_UP);
                        remainTransferBillTotalAmount = remainTransferBillTotalAmount.add(transferBillPriceTaxTotal);
                    } else {
                        transferBillPriceTaxTotal = pushBillCanTransferAmt.subtract(remainTransferBillTotalAmount);
                    }
                    BigDecimal transferBillAmount = transferTagAmount.multiply(transverseProportion).setScale(this.currencyPrecison, RoundingMode.HALF_UP);
                    if (srcBillIndex == 1) {
                        remainTransferAllPriceTaxTotalMap.put(transferTagIndex, transferBillPriceTaxTotal);
                        remainTransferAllAmountMap.put(transferTagIndex, transferBillAmount);
                    } else {
                        remainTransferAllPriceTaxTotalMap.put(transferTagIndex, ((BigDecimal)remainTransferAllPriceTaxTotalMap.get(transferTagIndex)).add(transferBillPriceTaxTotal));
                        remainTransferAllAmountMap.put(transferTagIndex, ((BigDecimal)remainTransferAllAmountMap.get(transferTagIndex)).add(transferBillAmount));
                    }
                    this.calculateAndFillDetailEntry(transferTagIndex, transferTagSize, remainDetailEntryPriceTaxTotalMap, transferBill, transferBillPriceTaxTotal, transferBillAmount);
                    this.fillHead(transferBill, transferTagInfo, transferBillPriceTaxTotal, transferBillAmount);
                    this.calculateAndFillPlanEntry(transferBill, transferBillPriceTaxTotal);
                    transferBills.add(transferBill);
                }
                continue;
            }
            for (DynamicObject transferTagInfo : transferTagInfos) {
                DynamicObject transferBill = (DynamicObject)cloneUtil.clone((IDataEntityBase)pushBill);
                BigDecimal transferTagPriceTaxTotal = transferTagInfo.getBigDecimal("transpricetaxtotal");
                BigDecimal transferTagAmount = transferTagInfo.getBigDecimal("transamount");
                BigDecimal transferBillPriceTaxTotal = transferTagPriceTaxTotal.subtract(remainTransferAllPriceTaxTotalMap.get(++transferTagIndex) == null ? BigDecimal.ZERO : (BigDecimal)remainTransferAllPriceTaxTotalMap.get(transferTagIndex));
                BigDecimal transferBillAmount = transferTagAmount.subtract(remainTransferAllAmountMap.get(transferTagIndex) == null ? BigDecimal.ZERO : (BigDecimal)remainTransferAllAmountMap.get(transferTagIndex));
                this.calculateAndFillDetailEntry(transferTagIndex, transferTagSize, remainDetailEntryPriceTaxTotalMap, transferBill, transferBillPriceTaxTotal, transferBillAmount);
                this.fillHead(transferBill, transferTagInfo, transferBillPriceTaxTotal, transferBillAmount);
                this.calculateAndFillPlanEntry(transferBill, transferBillPriceTaxTotal);
                transferBills.add(transferBill);
            }
        }
        return transferBills;
    }

    private void calculateAndFillDetailEntry(int transferTagIndex, int transferTagSize, Map<Integer, BigDecimal> remainDetailEntryPriceTaxTotalMap, DynamicObject transferBill, BigDecimal transferBillPriceTaxTotal, BigDecimal transferBillAmount) {
        DynamicObjectCollection detailEntries = transferBill.getDynamicObjectCollection(this.finDetailEntryKey);
        BigDecimal unLockTotalAmt = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntries) {
            unLockTotalAmt = unLockTotalAmt.add(detailEntry.getBigDecimal(this.finDetailEntryUnLockKey));
        }
        if (this.isNoEnd(transferTagIndex, transferTagSize)) {
            BigDecimal remainDetailEntryTotalAmount = BigDecimal.ZERO;
            BigDecimal remainDetailEntryAmount = BigDecimal.ZERO;
            int detailEntryIndex = 0;
            int detailEntrySize = detailEntries.size();
            for (DynamicObject detailEntry : detailEntries) {
                BigDecimal detailEntryAmount;
                BigDecimal detailEntryPriceTaxTotal;
                BigDecimal unLockAmt = detailEntry.getBigDecimal(this.finDetailEntryUnLockKey);
                BigDecimal unLockProportion = unLockAmt.divide(unLockTotalAmt, 10, RoundingMode.HALF_UP);
                if (this.isNoEnd(++detailEntryIndex, detailEntrySize)) {
                    detailEntryPriceTaxTotal = transferBillPriceTaxTotal.multiply(unLockProportion).setScale(this.currencyPrecison, RoundingMode.HALF_UP);
                    detailEntryAmount = transferBillAmount.multiply(unLockProportion).setScale(this.currencyPrecison, RoundingMode.HALF_UP);
                    remainDetailEntryTotalAmount = remainDetailEntryTotalAmount.add(detailEntryPriceTaxTotal);
                    remainDetailEntryAmount = remainDetailEntryAmount.add(detailEntryAmount);
                } else {
                    detailEntryPriceTaxTotal = transferBillPriceTaxTotal.subtract(remainDetailEntryTotalAmount);
                    detailEntryAmount = transferBillAmount.subtract(remainDetailEntryAmount);
                }
                if (transferTagIndex == 1) {
                    remainDetailEntryPriceTaxTotalMap.put(detailEntryIndex, detailEntryPriceTaxTotal);
                } else {
                    remainDetailEntryPriceTaxTotalMap.put(detailEntryIndex, remainDetailEntryPriceTaxTotalMap.get(detailEntryIndex).add(detailEntryPriceTaxTotal));
                }
                this.fillDetailEntry(detailEntry, detailEntryPriceTaxTotal, detailEntryAmount);
            }
        } else {
            BigDecimal remainDetailEntryAmount = BigDecimal.ZERO;
            int detailEntrySize = detailEntries.size();
            for (int detailEntryIndex = 1; detailEntryIndex <= detailEntrySize; ++detailEntryIndex) {
                BigDecimal detailEntryAmount;
                DynamicObject detailEntry = (DynamicObject)detailEntries.get(detailEntryIndex - 1);
                BigDecimal unLockAmt = detailEntry.getBigDecimal(this.finDetailEntryUnLockKey);
                BigDecimal detailEntryPriceTaxTotal = unLockAmt.subtract(remainDetailEntryPriceTaxTotalMap.get(detailEntryIndex) == null ? BigDecimal.ZERO : remainDetailEntryPriceTaxTotalMap.get(detailEntryIndex));
                if (this.isNoEnd(detailEntryIndex, detailEntrySize)) {
                    BigDecimal unLockProportion = unLockAmt.divide(unLockTotalAmt, 10, RoundingMode.HALF_UP);
                    detailEntryAmount = transferBillPriceTaxTotal.compareTo(transferBillAmount) == 0 ? detailEntryPriceTaxTotal : transferBillAmount.multiply(unLockProportion).setScale(this.currencyPrecison, RoundingMode.HALF_UP);
                    remainDetailEntryAmount = remainDetailEntryAmount.add(detailEntryAmount);
                } else {
                    detailEntryAmount = transferBillAmount.subtract(remainDetailEntryAmount);
                }
                this.fillDetailEntry(detailEntry, detailEntryPriceTaxTotal, detailEntryAmount);
            }
        }
    }

    private void calculateAndFillPlanEntry(DynamicObject transferBill, BigDecimal transferBillPriceTaxTotal) {
    }

    protected abstract void fillHead(DynamicObject var1, DynamicObject var2, BigDecimal var3, BigDecimal var4);

    protected abstract void fillDetailEntry(DynamicObject var1, BigDecimal var2, BigDecimal var3);

    protected abstract void fillPlanEntry(DynamicObject var1, DynamicObject var2, BigDecimal var3, BigDecimal var4, Date var5);

    protected abstract void postProcessTransferBill(List<Long> var1, List<DynamicObject> var2);

    protected abstract void disposeSrcBills(List<Long> var1, List<DynamicObject> var2);

    protected BigDecimal getLocalAmt(BigDecimal srcAmt, BigDecimal exchange, int presion) {
        BigDecimal localAmt = "0".equals(this.quotation) ? srcAmt.multiply(exchange).setScale(presion, RoundingMode.HALF_UP) : srcAmt.divide(exchange, presion, RoundingMode.HALF_UP);
        return localAmt;
    }

    protected Map<Long, Map<String, Object>> getAsstactInfo(List<DynamicObject> asstacts) {
        if (asstacts.size() == 0) {
            throw new KDBizException("asstacts size is 0");
        }
        HashMap<Long, Map<String, Object>> asstactInfo = new HashMap<Long, Map<String, Object>>(asstacts.size());
        String asstactType = asstacts.get(0).getDataEntityType().getName();
        Set asstactIds = asstacts.stream().map(asstact -> asstact.getLong("id")).collect(Collectors.toSet());
        if ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) {
            Map asstactDOs = BusinessDataServiceHelper.loadFromCache((Object[])asstactIds.toArray(), (String)asstactType);
            asstactDOs.forEach((key, asstact) -> {
                HashMap<String, String> infoMap = new HashMap<String, String>(8);
                DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
                String accountOb = null;
                DynamicObject bebankOb = null;
                for (int i = 0; i < bankColls.size(); ++i) {
                    DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
                    if (bankInfo.getBoolean("isdefault_bank")) {
                        accountOb = bankInfo.getString("bankaccount");
                        bebankOb = bankInfo.getDynamicObject("bank");
                        break;
                    }
                    if (i != 0) continue;
                    accountOb = bankInfo.getString("bankaccount");
                    bebankOb = bankInfo.getDynamicObject("bank");
                }
                infoMap.put("accountOb", accountOb);
                infoMap.put("bebankOb", (String)bebankOb);
                if ("bd_supplier".equals(asstactType)) {
                    infoMap.put("paycond", (String)asstact.getDynamicObject("paycond"));
                    infoMap.put("receivingsupplierid", (String)asstact.getDynamicObject("receivingsupplierid"));
                    infoMap.put("e_invoicesupplierid", (String)asstact.getDynamicObject("invoicesupplierid"));
                    infoMap.put("e_deliversupplierid", (String)asstact.getDynamicObject("deliversupplierid"));
                    infoMap.put("bizfunction", asstact.getString("bizfunction"));
                } else {
                    infoMap.put("paycond", null);
                }
                infoMap.put("settlementtypeid", (String)asstact.getDynamicObject("settlementtypeid"));
                asstactInfo.put((Long)key, infoMap);
            });
        } else if ("bos_user".equals(asstactType)) {
            Map asstactDOs = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)"id,payer,payerbank,payeraccount", (QFilter[])new QFilter[]{new QFilter("payer", "in", asstactIds)}, (String)"isdefault desc");
            HashMap<Long, DynamicObject> asstactMap = new HashMap<Long, DynamicObject>(asstactDOs.size());
            asstactDOs.forEach((key, value) -> asstactMap.put(value.getLong("payer.id"), (DynamicObject)value));
            asstactMap.forEach((key, value) -> {
                HashMap<String, String> infoMap = new HashMap<String, String>(4);
                String accountOb = value.getString("payeraccount");
                DynamicObject bebankOb = value.getDynamicObject("payerbank");
                infoMap.put("accountOb", accountOb);
                infoMap.put("bebankOb", (String)bebankOb);
                infoMap.put("paycond", null);
                infoMap.put("settlementtypeid", null);
                asstactInfo.put((Long)key, (Map<String, Object>)infoMap);
            });
        }
        return asstactInfo;
    }

    private void validateTransferBills(List<DynamicObject> transferBills) {
        DecimalScopeValidator decimalScopeValidator = new DecimalScopeValidator();
        for (DynamicObject bill : transferBills) {
            decimalScopeValidator.validate(bill);
        }
    }

    private boolean isNoEnd(int index, int size) {
        return index != size;
    }

    private boolean isTransferasSaved() {
        String isTransferasSaved = StdConfig.get("isTransferasSaved");
        return "true".equals(isTransferasSaved);
    }
}

