/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.FreezeStateEnum;
import kd.fi.arapcommon.service.freeze.selector.FreezeListFactory;
import kd.fi.arapcommon.service.freeze.selector.IFreezeListProvider;
import kd.fi.arapcommon.service.freeze.template.AbstractBillFreezeBase;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;

@Deprecated
public abstract class BillFreezeListBase
extends AbstractBillFreezeBase {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{this.getBarSearchLogEntity()});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] pks = selectedRows.getPrimaryKeyValues();
        if (pks.length > 0 && ("freeze".equals(key) || "unfreeze".equals(key))) {
            DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
            if (bills.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"BillFreezeListBase_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long orgId = bills[0].getLong(this.getOrgEntity() + ".id");
            for (DynamicObject bill : bills) {
                if (bill.getLong(this.getOrgEntity() + ".id") == orgId) continue;
                String opMsg = "freeze".equals(key) ? ResManager.loadKDString((String)"\u51bb\u7ed3", (String)"BillFreezeListBase_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u89e3\u51bb", (String)"BillFreezeListBase_2", (String)"fi-arapcommon", (Object[])new Object[0]);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u7ec4\u7ec7\u7684\u5355\u636e\u8fdb\u884c%s\u64cd\u4f5c\u3002", (String)"BillFreezeListBase_3", (String)"fi-arapcommon", (Object[])new Object[0]), opMsg));
                args.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (this.getBarSearchLogEntity().equals(key)) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listview.getSelectedRows();
            if (selectedRows.size() == 0) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BillFreezeListBase_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() != 1) {
                listview.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"BillFreezeListBase_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            this.searchFreezeLog(Collections.singletonList((String)selectedRows.get(0).getPrimaryKeyValue()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (args.getOperationResult() == null || !"freeze".equals(key) && !"unfreeze".equals(key)) {
            return;
        }
        OperationResult operationResult = args.getOperationResult();
        if (!operationResult.isSuccess() && operationResult.getSuccessPkIds().size() < 1) {
            return;
        }
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection listSelectedRowCollection = listview.getSelectedRows();
        ArrayList<Object> ids = new ArrayList<Object>(listSelectedRowCollection.size());
        boolean isShowErrorMessage = true;
        if (!operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
            List sucPKIds = operationResult.getSuccessPkIds();
            Iterator iterator = sucPKIds.iterator();
            while (iterator.hasNext()) {
                Object sucPKId = iterator.next();
                ids.add(sucPKId);
            }
            isShowErrorMessage = false;
        } else {
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                ids.add(listSelectedRow.getPrimaryKeyValue());
            }
        }
        boolean isEntryShow = false;
        if ("ap_payapply".equals(listview.getBillFormId())) {
            isEntryShow = true;
        }
        FreezeVO freezeVO = new FreezeVO();
        freezeVO.setEntryFreeze(false);
        freezeVO.setFreezeOpKey(key);
        freezeVO.setEntryShow(isEntryShow);
        freezeVO.setPkIds(ids);
        freezeVO.setEntryEntity(this.getEntryEntity());
        freezeVO.setOpType("manual");
        freezeVO.setBillEntity(listview.getBillFormId());
        IFreezeListProvider freezeListProvider = FreezeListFactory.getFreezeListProvider(freezeVO.getBillEntity());
        List<String> selector = freezeListProvider.billConvertLogSelector(freezeVO.isEntryFreeze());
        QFilter qFilter = new QFilter("id", "in", freezeVO.getPkIds());
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)freezeVO.getBillEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{qFilter});
        long orgId = bills[0].getLong(this.getOrgEntity() + ".id");
        freezeVO.setBills(Arrays.asList(bills));
        freezeVO.setOrgId(orgId);
        if ("freeze".equals(key)) {
            this.freezeDispose(freezeVO, isShowErrorMessage, operationResult);
        }
        if ("unfreeze".equals(key)) {
            this.freezeDispose(freezeVO, isShowErrorMessage, operationResult);
        }
    }

    private void freezeDispose(FreezeVO freezeVO, boolean isShowErrorMessage, OperationResult operationResult) {
        String freezeState = "freeze".equals(freezeVO.getFreezeOpKey()) ? FreezeStateEnum.ALLFREEZE.getValue() : FreezeStateEnum.UNFREEZE.getValue();
        freezeVO.setFreezeState(freezeState);
        if ("freeze".equals(freezeVO.getFreezeOpKey()) && this.getFreezeWhySysParam(freezeVO.getOrgId()) || "unfreeze".equals(freezeVO.getFreezeOpKey()) && this.getUnFreezeWhySysParam(freezeVO.getOrgId())) {
            operationResult.setShowMessage(isShowErrorMessage);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("ap_freezelist");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("freezeVO", (Object)freezeVO);
            if (FreezeStateEnum.UNFREEZE.getValue().equals(freezeState)) {
                fsp.setCaption(ResManager.loadKDString((String)"\u89e3\u51bb\u4fe1\u606f", (String)"BillFreezeListBase_6", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bar_freeze");
            fsp.setCloseCallBack(closeCallBack);
            this.getView().showForm(fsp);
            return;
        }
        for (DynamicObject bill : freezeVO.getBills()) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(this.getEntryEntity());
            for (DynamicObject entry : entrys) {
                entry.set(this.getEntryFreezeStateEntity(), (Object)freezeState);
            }
            bill.set(this.getFreezeStateEntity(), (Object)freezeState);
        }
        this.updateBillFreezeState(freezeVO);
    }
}

