/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.enums.FreezeStateEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.freeze.selector.FreezeListFactory;
import kd.fi.arapcommon.service.freeze.selector.IFreezeListProvider;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;

public abstract class BillUnAuditUnFreezeOpBase
extends AbstractOperationServicePlugIn {
    private Map<Long, Boolean> ap010Cache = new HashMap<Long, Boolean>();
    private Map<Long, Boolean> unFreezePermCache = new HashMap<Long, Boolean>();
    private long userId = RequestContext.get().getCurrUserId();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject info = dataEntity.getDataEntity();
                    long orgId = (Long)info.getDynamicObject(BillUnAuditUnFreezeOpBase.this.getOrgEntity()).getPkValue();
                    String freezeState = info.getString(BillUnAuditUnFreezeOpBase.this.getFreezeStateEntity());
                    if (!FreezeStateEnum.ALLFREEZE.getValue().equals(freezeState) && !FreezeStateEnum.PARTFREEZE.getValue().equals(freezeState)) continue;
                    if (!BillUnAuditUnFreezeOpBase.this.geUnAuditAutoUnFreezeSysParam(orgId).booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u89e3\u51bb\u518d\u53cd\u5ba1\u6838\u3002", (String)"BillUnAuditUnFreezeOpBase_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                        continue;
                    }
                    if (BillUnAuditUnFreezeOpBase.this.getUnFreezePerm(orgId, info.getDataEntityType().getName()).booleanValue()) continue;
                    String errorMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u201c%s\u201d\u7684\u201c\u89e3\u51bb\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BillUnAuditUnFreezeOpBase_1", (String)"fi-arapcommon", (Object[])new Object[]{info.getDataEntityType().getDisplayName()});
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        String billEntity = "";
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(entities.length);
        for (DynamicObject info : entities) {
            String freezeState = info.getString(this.getFreezeStateEntity());
            if (!FreezeStateEnum.ALLFREEZE.getValue().equals(freezeState) && !FreezeStateEnum.PARTFREEZE.getValue().equals(freezeState)) continue;
            info.set(this.getFreezeStateEntity(), (Object)FreezeStateEnum.UNFREEZE.getValue());
            DynamicObjectCollection entrys = info.getDynamicObjectCollection(this.getEntryEntity());
            for (DynamicObject entry : entrys) {
                entry.set(this.getEntryFreezeStateEntity(), (Object)FreezeStateEnum.UNFREEZE.getValue());
            }
            if ("".equals(billEntity)) {
                billEntity = info.getDataEntityType().getName();
            }
            bills.add(info);
        }
        if (bills.size() > 0) {
            FreezeVO freezeVO = new FreezeVO();
            freezeVO.setEntryFreeze(false);
            freezeVO.setOpType("auto");
            freezeVO.setBills(bills);
            freezeVO.setFreezeMsg(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u81ea\u52a8\u89e3\u51bb", (String)"BillUnAuditUnFreezeOpBase_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            IFreezeListProvider freezeListProvider = FreezeListFactory.getFreezeListProvider(billEntity);
            List<DynamicObject> freezeLogs = freezeListProvider.billConvertFreezeLog(freezeVO);
            SaveServiceHelper.save((DynamicObject[])freezeLogs.toArray(new DynamicObject[0]));
        }
    }

    private Boolean getUnFreezePerm(Long orgId, String entityNum) {
        Boolean target = this.unFreezePermCache.get(orgId);
        if (target != null) {
            return target;
        }
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)this.userId, (Long)orgId, (String)"+HKZHSKFXOX", (String)entityNum, (String)"47150e89000000ac");
        target = hasPermResult == 1 ? Boolean.TRUE : Boolean.FALSE;
        this.unFreezePermCache.put(orgId, target);
        return target;
    }

    private Boolean geUnAuditAutoUnFreezeSysParam(Long orgId) {
        Boolean target = this.ap010Cache.get(orgId);
        if (target != null) {
            return target;
        }
        Object ap010 = ArApHelper.getParameter(orgId, this.getUnAuditAutoUnFreezeSysParamEntity(), false);
        this.ap010Cache.put(orgId, (Boolean)ap010);
        return (Boolean)ap010;
    }

    protected abstract String getOrgEntity();

    protected abstract String getFreezeStateEntity();

    protected abstract String getEntryFreezeStateEntity();

    protected abstract String getUnAuditAutoUnFreezeSysParamEntity();

    protected abstract String getEntryEntity();
}

