/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.freeze.PurOrderBillIsOverPayChangeFreeze;

public class StcpBillIsOverPayChangeFreeze
extends PurOrderBillIsOverPayChangeFreeze {
    @Override
    protected Map<Long, Set<Long>> findNeedFreezeBill(Set<Long> ids, boolean freeze) {
        this.getUnFinishPrePayCoreBill(ids, "sctm_scpo");
        Map<Long, String> coreBillKeys = this.coreMatchKeys(ids, "sctm_scpo");
        return this.getNeedFreezeApBillInfo(ids, freeze, coreBillKeys);
    }

    @Override
    protected Map<Long, BigDecimal> loadPayedPreBillAmt(Set<Long> coreBillIds) {
        HashMap<Long, BigDecimal> coreBillSumPrePayMap = new HashMap<Long, BigDecimal>(16);
        QFilter payBillFilter = new QFilter("entry.e_corebillid", "in", coreBillIds);
        payBillFilter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        payBillFilter.and("paymenttype.biztype", "=", (Object)"202");
        DataSet prePayBills = QueryServiceHelper.queryDataSet((String)"finapfreezepay", (String)"cas_paybill", (String)"id,entry.e_corebillid,entry.e_payableamt,entry.e_refundamt", (QFilter[])new QFilter[]{payBillFilter}, null);
        for (Row row : prePayBills) {
            Long coreBillId = row.getLong("entry.e_corebillid");
            BigDecimal currentPayAmt = row.getBigDecimal("entry.e_payableamt").subtract(row.getBigDecimal("entry.e_refundamt"));
            BigDecimal coreBillSumPrePayAmt = (BigDecimal)coreBillSumPrePayMap.get(coreBillId);
            if (coreBillSumPrePayAmt != null) {
                coreBillSumPrePayMap.put(coreBillId, coreBillSumPrePayAmt.add(currentPayAmt));
                continue;
            }
            coreBillSumPrePayMap.put(coreBillId, currentPayAmt);
        }
        return coreBillSumPrePayMap;
    }

    protected Set<Long> getUnFinishPrePayCoreBill(Set<Long> ids, String coreBillEntity) {
        Map<Long, BigDecimal> sumPrePayBills = this.loadPayedPreBillAmt(ids);
        HashMap<Long, BigDecimal> coreBillPrePayAmt = new HashMap<Long, BigDecimal>(16);
        QFilter filter = new QFilter("id", "in", ids);
        String selectors = "pm_purorderbill".equals(coreBillEntity) ? "id,purbillentry_pay.payamount payamount,purbillentry_pay.isprepay isprepay" : ("conm_purcontract".equals(coreBillEntity) ? "id,payentry.payamount payamount,payentry.isprepay isprepay" : "id,billentry_pay.payamount payamount,billentry_pay.isprepay isprepay");
        DataSet purDataSet = QueryServiceHelper.queryDataSet((String)"finapfreeze", (String)coreBillEntity, (String)selectors, (QFilter[])new QFilter[]{filter}, null);
        for (Row row : purDataSet) {
            BigDecimal curPreAmt;
            Long purBillId = row.getLong("id");
            BigDecimal sumPurPerAmt = (BigDecimal)coreBillPrePayAmt.get(purBillId);
            BigDecimal bigDecimal = curPreAmt = row.getBoolean("isprepay") != false ? row.getBigDecimal("payamount") : BigDecimal.ZERO;
            if (sumPurPerAmt == null) {
                coreBillPrePayAmt.put(purBillId, curPreAmt);
                continue;
            }
            coreBillPrePayAmt.put(purBillId, sumPurPerAmt.add(curPreAmt));
        }
        HashSet<Long> unFinishPrePayCoreBillIds = new HashSet<Long>(16);
        for (Map.Entry entrySet : coreBillPrePayAmt.entrySet()) {
            Long coreBillId = (Long)entrySet.getKey();
            BigDecimal preAmt = (BigDecimal)entrySet.getValue();
            BigDecimal sumPreAmt = sumPrePayBills.get(coreBillId);
            if (sumPreAmt != null && sumPreAmt.compareTo(preAmt) >= 0) continue;
            unFinishPrePayCoreBillIds.add(coreBillId);
        }
        return unFinishPrePayCoreBillIds;
    }
}

