/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze.selector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.OpRangeEnum;
import kd.fi.arapcommon.service.freeze.selector.IFreezeListProvider;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;

public class FinApBillProvider
implements IFreezeListProvider {
    private String userId = String.valueOf(RequestContext.get().getCurrUserId());

    @Override
    public List<String> getSelector(boolean isEntryFreeze) {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("0 e_billentity");
        selector.add("0 e_freezestate");
        selector.add("id e_billid");
        selector.add("org e_org");
        selector.add("billno e_billno");
        selector.add("asstacttype e_asstacttype");
        selector.add("asstact e_asstact");
        selector.add("asstact e_asstact_number");
        selector.add("currency e_currency");
        selector.add("currency e_settlecurrency");
        selector.add("planentity.planpricetax e_amount");
        selector.add("planentity.planpricetax e_freezeamt");
        selector.add("planentity.planlockedamt e_lockedamt");
        selector.add("planentity.e_freezestate plan_freezestate");
        selector.add("planentity.seq e_lineno");
        selector.add("planentity.id e_billentryid");
        return selector;
    }

    @Override
    public List<String> billConvertLogSelector(boolean isEntryFreeze) {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("id");
        selector.add("freezestate");
        selector.add("org");
        selector.add("billno");
        selector.add("asstacttype");
        selector.add("asstact");
        selector.add("planentity");
        selector.add("planentity.seq");
        selector.add("planentity.id");
        selector.add("planentity.e_freezestate");
        return selector;
    }

    @Override
    public LocaleString getAmountColumnProperty() {
        return new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"FinApBillProvider_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public LocaleString getLockAmtColumnProperty() {
        return new LocaleString(ResManager.loadKDString((String)"\u5df2\u9501\u5b9a\u91d1\u989d", (String)"FinApBillProvider_1", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    @Override
    public List<DynamicObject> billConvertFreezeLog(FreezeVO freezeVO) {
        ArrayList<DynamicObject> freezeLogs = new ArrayList<DynamicObject>(freezeVO.getBills().size());
        if (freezeVO.isEntryFreeze()) {
            for (DynamicObject bill : freezeVO.getBills()) {
                DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection("planentity");
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    if (!freezeVO.getEntryIds().contains(dynamicObject.get("id"))) continue;
                    DynamicObject freezelogObject = this.setFreezeLog(bill);
                    freezelogObject.set("businessop", dynamicObject.get("e_freezestate"));
                    freezelogObject.set("oprange", (Object)OpRangeEnum.PAYPLAN.getValue());
                    freezelogObject.set("lineno", dynamicObject.get("seq"));
                    freezelogObject.set("freezereason", (Object)freezeVO.getFreezeMsg());
                    freezelogObject.set("optype", (Object)freezeVO.getOpType());
                    freezelogObject.set("billentryid", dynamicObject.get("id"));
                    freezeLogs.add(freezelogObject);
                }
            }
        } else {
            for (DynamicObject bill : freezeVO.getBills()) {
                DynamicObject freezelogObject = this.setFreezeLog(bill);
                freezelogObject.set("businessop", bill.get("freezestate"));
                freezelogObject.set("oprange", (Object)OpRangeEnum.WHOLEORDER.getValue());
                freezelogObject.set("lineno", (Object)"");
                freezelogObject.set("freezereason", (Object)freezeVO.getFreezeMsg());
                freezelogObject.set("optype", (Object)freezeVO.getOpType());
                freezelogObject.set("billentryid", (Object)"");
                freezeLogs.add(freezelogObject);
            }
        }
        return freezeLogs;
    }

    private DynamicObject setFreezeLog(DynamicObject bill) {
        DynamicObject freezelogObject = BusinessDataServiceHelper.newDynamicObject((String)"ap_freezelog");
        freezelogObject.set("billstatus", (Object)"A");
        freezelogObject.set("creator", (Object)this.userId);
        freezelogObject.set("billtype", (Object)bill.getDataEntityType().getName());
        freezelogObject.set("billno", bill.get("billno"));
        freezelogObject.set("asstacttype", bill.get("asstacttype"));
        freezelogObject.set("asstact", bill.get("asstact.id"));
        freezelogObject.set("optime", (Object)new Date());
        freezelogObject.set("org", bill.get("org.id"));
        freezelogObject.set("billid", bill.get("id"));
        return freezelogObject;
    }
}

