/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.arapcommon.service.freeze.FreezeServiceHelper;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class AbstractBillFreezeEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{this.getBarSearchLogEntity()});
        this.addItemClickListeners(new String[]{this.getEntryToolEntity()});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(String.valueOf(bill.getLong("id")));
        if ("bar_searchlog".equals(key)) {
            FreezeServiceHelper freezeServiceHelper = new FreezeServiceHelper(this.getView());
            freezeServiceHelper.searchFreezeLog(ids);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("unaudit".equals(key) && this.getPageCache().get("operationConfirm") == null) {
            DynamicObject[] bills = new DynamicObject[]{this.getModel().getDataEntity()};
            FreezeServiceHelper freezeServiceHelper = new FreezeServiceHelper(this.getView());
            boolean res = freezeServiceHelper.unAuditOpConfirm((IFormPlugin)this, bills, this.getOrgEntity(), this.getFreezeStateEntity(), this.getUnAuditAutoUnFreezeSysParamEntity());
            args.setCancel(res);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String message;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("unaudit".equals(key)) {
            this.getPageCache().remove("operationConfirm");
        }
        if (!(args.getOperationResult() != null && args.getOperationResult().isSuccess() && ("freeze".equals(key) || "unfreeze".equals(key) || "m_freeze".equals(key) || "m_unfreeze".equals(key)))) {
            return;
        }
        this.getView().showLoading(null);
        DynamicObject bill = this.getModel().getDataEntity();
        ArrayList<Object> ids = new ArrayList<Object>(1);
        FreezeVO freezeVO = new FreezeVO();
        freezeVO.setEntryEntity(this.getEntryEntity());
        freezeVO.setOrgId(bill.getLong(this.getOrgEntity() + ".id"));
        ids.add(bill.getLong("id"));
        String billEntityNumber = this.getView().getEntityId();
        FreezeServiceHelper freezeServiceHelper = new FreezeServiceHelper(this.getView());
        freezeServiceHelper.convertFreezeVO(freezeVO, key, ids, billEntityNumber);
        if ("unaudit".equals(key) && EmptyUtils.isNotEmpty(args.getOperationResult().getMessage())) {
            this.getView().showSuccessNotification(args.getOperationResult().getMessage(), Integer.valueOf(5000));
            this.getView().invokeOperation("refresh");
            this.getView().hideLoading();
            return;
        }
        if ("freeze".equals(key)) {
            this.setEntryIds(freezeVO);
        }
        if (("m_freeze".equals(key) || "m_unfreeze".equals(key)) && !this.entryValidator(freezeVO)) {
            this.getView().hideLoading();
            return;
        }
        if (("unfreeze".equals(key) || "m_unfreeze".equals(key)) && (message = this.autoFreezeValidator(key, freezeVO)) != null) {
            this.getView().hideLoading();
            return;
        }
        freezeServiceHelper.freezeDispose(freezeVO, this.getFreezeWhySysParamEntity(), this.getUnFreezeWhySysParamEntity(), null, (IFormPlugin)this);
        if (!freezeVO.isNext()) {
            this.getView().hideLoading();
            return;
        }
        this.updateBillFreezeState(freezeVO);
    }

    public void setEntryIds(FreezeVO freezeVO) {
    }

    protected abstract String autoFreezeValidator(String var1, FreezeVO var2);

    private boolean entryValidator(FreezeVO freezeVO) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.getEntryEntity());
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u660e\u7ec6\u884c\u7684\u6570\u636e\u3002", (String)"AbstractBillFreezeEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        String msg = this.onAddValidators(freezeVO.getFreezeOpKey());
        if (EmptyUtils.isEmpty(msg)) {
            IDataModel model = this.getModel();
            ArrayList<Long> entryIds = new ArrayList<Long>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject row = model.getEntryRowEntity(this.getEntryEntity(), selectRows[i]);
                entryIds.add(row.getLong("id"));
            }
            freezeVO.setEntryShow(true);
            freezeVO.setEntryFreeze(true);
            freezeVO.setEntryIds(entryIds);
            return true;
        }
        this.getView().showTipNotification(msg);
        return false;
    }

    /*
     * Exception decompiling
     */
    protected void updateBillFreezeState(FreezeVO freezeVO) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[WHILELOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() == null) {
            return;
        }
        if ("bar_freeze".equals(actionId)) {
            Map returnData = (Map)e.getReturnData();
            FreezeVO freezeVO = (FreezeVO)returnData.get("freezeVO");
            this.updateBillFreezeState(freezeVO);
        }
        if ("operationConfirm".equals(actionId) && e.getReturnData() != null) {
            this.getView().getPageCache().put("operationConfirm", "ok");
            this.getView().invokeOperation("unaudit");
        }
    }

    protected abstract String getBarFreezeEntity();

    protected abstract String getBarUnFreezeEntity();

    protected abstract String getBarSearchLogEntity();

    protected abstract String getOrgEntity();

    protected abstract String getFreezeStateEntity();

    protected abstract String getEntryFreezeStateEntity();

    protected abstract String getFreezeWhySysParamEntity();

    protected abstract String getUnFreezeWhySysParamEntity();

    protected abstract String getUnAuditAutoUnFreezeSysParamEntity();

    protected abstract String getEntryEntity();

    protected abstract String getEntryToolEntity();

    protected abstract String onAddValidators(String var1);

    protected abstract void beginHandelDataTransaction(FreezeVO var1);

    protected abstract void rollbackHandelData(FreezeVO var1);

    private static /* synthetic */ Long lambda$updateBillFreezeState$0(DynamicObject v) {
        return v.getLong("id");
    }
}

