/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.freeze.template;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.FreezeStateEnum;
import kd.fi.arapcommon.service.freeze.selector.FreezeListFactory;
import kd.fi.arapcommon.service.freeze.selector.IFreezeListProvider;
import kd.fi.arapcommon.service.freeze.vo.FreezeVO;

public abstract class AbstractFreezeList
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "btnok": {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                FreezeVO freezeVO = this.getCustomParams();
                freezeVO.setFreezeMsg((String)this.getModel().getValue("freezemsg"));
                freezeVO.setFreezeDatas(this.getModel().getEntryEntity("entryentity"));
                customParams.put("freezeVO", freezeVO);
                this.getView().returnDataToParent((Object)customParams);
                this.getView().close();
            }
        }
    }

    protected FreezeVO getCustomParams() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (FreezeVO)JSONObject.parseObject((String)JSONObject.toJSONString(customParams.get("freezeVO")), FreezeVO.class);
    }

    private void initEntryData() {
        FreezeVO freezeVO = this.getCustomParams();
        String billEntity = freezeVO.getBillEntity();
        IFreezeListProvider freezeListProvider = FreezeListFactory.getFreezeListProvider(billEntity);
        List<String> selector = freezeListProvider.getSelector(freezeVO.isEntryFreeze());
        if (selector.size() < 1) {
            return;
        }
        DynamicObjectCollection bills = this.queryFreezeBills(freezeVO, selector = this.handleSelector(freezeVO, selector));
        if (bills.size() < 1) {
            return;
        }
        if ("ap_payapply".equals(freezeVO.getBillEntity())) {
            boolean hadDiffCurrency = false;
            for (DynamicObject bill : bills) {
                Long settleCurrency;
                Long payCurrency = bill.getLong("e_currency");
                if (payCurrency.equals(settleCurrency = Long.valueOf(bill.getLong("e_settlecurrency")))) continue;
                hadDiffCurrency = true;
                break;
            }
            if (hadDiffCurrency) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"e_seleamount"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"e_seleamount"});
            }
        }
        bills = this.handleEntryDataObj(freezeVO, bills);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = this.getTableValueSetter(bills, billEntity, freezeVO.getFreezeState());
        model.batchCreateNewEntryRow("entryentity", vs);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        TextEdit freezemsgGrid = (TextEdit)this.getControl("freezemsg");
        if (FreezeStateEnum.UNFREEZE.getValue().equals(freezeVO.getFreezeState())) {
            entryGrid.setColumnProperty("e_freezeamt", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u89e3\u51bb\u91d1\u989d", (String)"AbstractFreezeList_0", (String)"fi-arapcommon", (Object[])new Object[0])));
            freezemsgGrid.setCaption(new LocaleString(ResManager.loadKDString((String)"\u89e3\u51bb\u539f\u56e0", (String)"AbstractFreezeList_1", (String)"fi-arapcommon", (Object[])new Object[0])));
        }
        entryGrid.setColumnProperty("e_amount", "header", (Object)freezeListProvider.getAmountColumnProperty());
        entryGrid.setColumnProperty("e_lockedamt", "header", (Object)freezeListProvider.getLockAmtColumnProperty());
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public DynamicObjectCollection queryFreezeBills(FreezeVO freezeVO, List<String> selector) {
        QFilter qFilter = new QFilter("id", "in", freezeVO.getPkIds());
        String entity = freezeVO.getBillEntity();
        if ("ap_payapply".equals(entity) && freezeVO.isEntryFreeze()) {
            qFilter.and(freezeVO.getEntryEntity() + ".id", "in", freezeVO.getEntryIds());
        }
        if ("ap_payapply".equals(entity) && ("m_freeze".equals(freezeVO.getFreezeOpKey()) || "freeze".equals(freezeVO.getFreezeOpKey()))) {
            qFilter.and(freezeVO.getEntryEntity() + ".e_closestatus", "=", (Object)"A");
            qFilter.and(freezeVO.getEntryEntity() + ".e_freezestate", "=", (Object)"unfreeze");
        }
        if ("ap_payapply".equals(entity) && ("m_unfreeze".equals(freezeVO.getFreezeOpKey()) || "unfreeze".equals(freezeVO.getFreezeOpKey()))) {
            qFilter.and(freezeVO.getEntryEntity() + ".e_freezestate", "=", (Object)"allfreeze");
        }
        return QueryServiceHelper.query((String)freezeVO.getBillEntity(), (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{qFilter});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initEntryData();
    }

    private TableValueSetter getTableValueSetter(DynamicObjectCollection bills, String billEntity, String freezestate) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        ArrayList<String> fields = new ArrayList<String>(64);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        List fieldEdits = grid.getFieldEdits();
        for (FieldEdit field : fieldEdits) {
            vs.addField(field.getKey(), new Object[0]);
            fields.add(field.getKey());
        }
        for (DynamicObject obj : bills) {
            ArrayList<Object> rowObj = new ArrayList<Object>(fields.size());
            for (String field : fields) {
                if (this.isExistProperty(obj, field)) {
                    if (field.equals("e_billentity")) {
                        rowObj.add(billEntity);
                        continue;
                    }
                    if (field.equals("e_freezestate")) {
                        rowObj.add(freezestate);
                        continue;
                    }
                    rowObj.add(obj.get(field));
                    continue;
                }
                rowObj.add(null);
            }
            if (ObjectUtils.isEmpty(rowObj)) continue;
            vs.addRow(rowObj.toArray());
        }
        return vs;
    }

    private boolean isExistProperty(DynamicObject bill, String propertyName) {
        DynamicProperty property;
        boolean isExistProperty = false;
        DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
        if (dynamicObjectType != null && (property = dynamicObjectType.getProperty(propertyName)) != null) {
            isExistProperty = true;
        }
        return isExistProperty;
    }

    protected abstract List<String> handleSelector(FreezeVO var1, List<String> var2);

    protected abstract DynamicObjectCollection handleEntryDataObj(FreezeVO var1, DynamicObjectCollection var2);
}

