/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.service.fin.ApMaterialEntryDisposer;
import kd.fi.arapcommon.service.fin.ApPlanEntryDisposer;
import kd.fi.arapcommon.service.fin.ArMaterialEntryDisposer4ApplyPay;
import kd.fi.arapcommon.service.fin.ArPlanEntryDisposer;
import kd.fi.arapcommon.util.EmptyUtils;

@Deprecated
public class ApplyDisposeHelper {
    public static void disposeByPlan(List<DynamicObject> list, String entity, boolean isClose) {
        if (EmptyUtils.isEmpty(list)) {
            return;
        }
        Map<Long, List<BigDecimal>> amtMap = ApplyDisposeHelper.processDisposeAmt(list);
        ArrayList<Long> pks = new ArrayList<Long>(amtMap.keySet());
        if ("ar_finarbill".equals(entity)) {
            ApplyDisposeHelper.disposeArByPlan(pks.toArray(new Object[0]), amtMap, isClose);
        } else if ("ap_finapbill".equals(entity)) {
            ApplyDisposeHelper.disposeApByPlan(pks.toArray(new Object[0]), amtMap, isClose);
        }
    }

    public static void disposeByMaterial(List<DynamicObject> list, String entity, boolean isClose) {
        if (EmptyUtils.isEmpty(list)) {
            return;
        }
        Map<Long, List<BigDecimal>> amtMap = ApplyDisposeHelper.processDisposeAmt(list);
        ArrayList<Long> pks = new ArrayList<Long>(amtMap.keySet());
        if ("ar_finarbill".equals(entity)) {
            ApplyDisposeHelper.disposeArByMaterial(pks.toArray(new Object[0]), amtMap, isClose);
        } else if ("ap_finapbill".equals(entity)) {
            ApplyDisposeHelper.disposeApByMaterial(pks.toArray(new Object[0]), amtMap, isClose);
        }
    }

    public static void disposeArByMaterial(Object[] billId, Map<Long, List<BigDecimal>> amtMap, boolean isClose) {
        if (ObjectUtils.isEmpty((Object[])billId) || ObjectUtils.isEmpty(amtMap)) {
            return;
        }
        String arSelector = "e_reclocalamt,e_recamount,planpricetax,unplanlockamt,planlockedamt,currency,e_recamount,recamount,e_lockedamt,e_unlockamt,currency";
        DynamicObject[] finArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)arSelector, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billId)});
        ArPlanEntryDisposer arPlanEntryDisposer = new ArPlanEntryDisposer();
        for (DynamicObject finArBill : finArBills) {
            List disposeAmts = amtMap.getOrDefault(finArBill.getLong("id"), new ArrayList(2));
            for (BigDecimal disposeAmt : disposeAmts) {
                if (isClose) {
                    arPlanEntryDisposer.deleteDispose(finArBill, disposeAmt.negate());
                    continue;
                }
                arPlanEntryDisposer.saveDispose(finArBill, disposeAmt.negate());
            }
        }
        if (EmptyUtils.isNotEmpty(finArBills)) {
            SaveServiceHelper.save((DynamicObject[])finArBills);
        }
    }

    public static void disposeApByMaterial(Object[] billId, Map<Long, List<BigDecimal>> amtMap, boolean isClose) {
        DynamicObject[] finapBills;
        if (ObjectUtils.isEmpty((Object[])billId) || ObjectUtils.isEmpty(amtMap)) {
            return;
        }
        String selector = "pricetaxtotal,e_pricetaxtotal,unlockamt,lockedamt,planpricetax,unplanlockamt,planlockedamt,currency,planpricetaxloc,plansettledamt,plansettledlocamt,unplansettleamt,unplansettlelocamt,premiumamt";
        ApPlanEntryDisposer apPlanEntryDisposer = new ApPlanEntryDisposer();
        for (DynamicObject finApBill : finapBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billId)})) {
            List disposeAmts = amtMap.getOrDefault(finApBill.getLong("id"), new ArrayList(2));
            for (BigDecimal disposeAmt : disposeAmts) {
                if (isClose) {
                    apPlanEntryDisposer.deleteDispose(finApBill, disposeAmt);
                    continue;
                }
                apPlanEntryDisposer.saveDispose(finApBill, disposeAmt);
            }
        }
        if (EmptyUtils.isNotEmpty(finapBills)) {
            SaveServiceHelper.save((DynamicObject[])finapBills);
        }
    }

    public static void disposeApByPlan(Object[] billId, Map<Long, List<BigDecimal>> amtMap, boolean isClose) {
        if (EmptyUtils.isEmpty(billId) || EmptyUtils.isEmpty(amtMap)) {
            return;
        }
        List<String> selector = Arrays.asList("currency.amtprecision", "exchangerate", "pricetaxtotal", "detailentry.lockedamt", "detailentry.unlockamt", "detailentry.e_pricetaxtotal");
        DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billId)});
        ApMaterialEntryDisposer entryDisposerAp = new ApMaterialEntryDisposer();
        for (DynamicObject apBill : apBills) {
            List<BigDecimal> lockedamts = amtMap.get(apBill.getPkValue());
            if (EmptyUtils.isEmpty(lockedamts) || EmptyUtils.isEmpty(apBill.getBigDecimal("pricetaxtotal"))) continue;
            for (BigDecimal lockedamt : lockedamts) {
                if (isClose) {
                    entryDisposerAp.deleteDispose(apBill, lockedamt);
                    continue;
                }
                entryDisposerAp.saveDispose(apBill, lockedamt);
            }
        }
        if (EmptyUtils.isNotEmpty(apBills)) {
            SaveServiceHelper.save((DynamicObject[])apBills);
        }
    }

    public static void disposeArByPlan(Object[] billId, Map<Long, List<BigDecimal>> amtMap, boolean isClose) {
        if (EmptyUtils.isEmpty(billId) || EmptyUtils.isEmpty(amtMap)) {
            return;
        }
        List<String> selector = Arrays.asList("currency.amtprecision", "exchangerate", "recamount", "entry.e_lockedamt", "entry.e_unlockamt", "entry.e_recamount", "planlockedamt", "unplanlockamt", "unplanlockamt", "planpricetax");
        DynamicObject[] arBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billId)});
        ArMaterialEntryDisposer4ApplyPay disposer = new ArMaterialEntryDisposer4ApplyPay();
        for (DynamicObject arBill : arBills) {
            List<BigDecimal> disposeAmts = amtMap.get(arBill.getPkValue());
            for (BigDecimal disposeAmt : disposeAmts) {
                if (isClose) {
                    disposer.saveDispose(arBill, disposeAmt);
                    continue;
                }
                disposer.deleteDispose(arBill, disposeAmt);
            }
        }
        if (EmptyUtils.isNotEmpty(arBills)) {
            SaveServiceHelper.save((DynamicObject[])arBills);
        }
    }

    private static Map<Long, List<BigDecimal>> processDisposeAmt(List<DynamicObject> list) {
        DynamicObject[] newApplyBills;
        if (EmptyUtils.isEmpty(list)) {
            return new HashMap<Long, List<BigDecimal>>();
        }
        HashMap<Long, List<BigDecimal>> result = new HashMap<Long, List<BigDecimal>>(64);
        for (DynamicObject applyBill : newApplyBills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"billno,e_approvedamt,e_paidamt,sourcebillid,billstatus,lockedamt,entry_lk_sbillid", (QFilter[])new QFilter[]{new QFilter("id", "in", list.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()))})) {
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal disposeAmt = row.getBigDecimal("e_approvedamt").subtract(row.getBigDecimal("lockedamt"));
                DynamicObjectCollection entryLk = row.getDynamicObjectCollection("entry_lk");
                if (entryLk.size() <= 0) continue;
                Long billId = (Long)((DynamicObject)row.getDynamicObjectCollection("entry_lk").get(0)).get("entry_lk_sbillid");
                List disAmts = (List)result.get(billId);
                if (EmptyUtils.isEmpty(disAmts)) {
                    ArrayList<BigDecimal> amtList = new ArrayList<BigDecimal>(1);
                    amtList.add(disposeAmt);
                    result.put(billId, amtList);
                    continue;
                }
                disAmts.add(disposeAmt);
            }
        }
        return result;
    }
}

