/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class BusBillServiceHelper {
    private static BusBillServiceHelper instance = null;
    private static final Log logger = LogFactory.getLog(BusBillServiceHelper.class);

    public static synchronized BusBillServiceHelper getInstance() {
        if (instance == null) {
            instance = new BusBillServiceHelper();
        }
        return instance;
    }

    public void writeOff(DynamicObject[] busbills, boolean isAr) {
        String busEntityKey = isAr ? "ar_busbill" : "ap_busbill";
        List<DynamicObject> woffBills = this.buildWoffBill(busbills, isAr);
        if (!woffBills.isEmpty()) {
            List<DynamicObject> srcBusEntries = this.getSrcBusEntries4Woff(isAr, busEntityKey, woffBills);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)busEntityKey, (DynamicObject[])woffBills.toArray(new DynamicObject[0]), (OperateOption)option);
            if (result.isSuccess()) {
                OperationResult operationResult;
                ArrayList<Long> srcPks = new ArrayList<Long>(64);
                for (DynamicObject dynamicObject : woffBills) {
                    srcPks.add(Long.valueOf(dynamicObject.getString("sourcebillid")));
                }
                ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
                for (DynamicObject busEntry : srcBusEntries) {
                    if (!busEntry.getBoolean("e_iswriteoff")) continue;
                    srcEntryIdList.add(busEntry.getLong("id"));
                }
                option.setVariableValue("iswoff", "true");
                option.setVariableValue("srcPks", SerializationUtils.toJsonString(srcPks));
                if (!srcEntryIdList.isEmpty()) {
                    option.setVariableValue("srcEntryIds", SerializationUtils.toJsonString(srcEntryIdList));
                }
                if (!(operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)busEntityKey, (Object[])result.getSuccessPkIds().toArray(), (OperateOption)option)).isSuccess()) {
                    logger.info("------operationResult.Message------" + operationResult.getMessage());
                    List validateInfos = operationResult.getAllErrorOrValidateInfo();
                    StringBuilder sb = new StringBuilder();
                    if (validateInfos.isEmpty()) {
                        sb.append(operationResult.getMessage());
                    } else {
                        for (IOperateInfo err : validateInfos) {
                            sb.append(err.getMessage()).append('\n');
                        }
                    }
                    ErrorCode errorCode = new ErrorCode("audit_err", sb.toString());
                    throw new KDBizException(errorCode, new Object[0]);
                }
            } else {
                logger.info("------operationResult.Message------" + result.getMessage());
                List validateInfos = result.getAllErrorOrValidateInfo();
                StringBuffer sb = new StringBuffer();
                if (validateInfos.isEmpty()) {
                    sb.append(result.getMessage());
                } else {
                    for (IOperateInfo err : validateInfos) {
                        sb.append(err.getMessage()).append('\n');
                    }
                }
                ErrorCode errorCode = new ErrorCode("submit_err", sb.toString());
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }

    private List<DynamicObject> getSrcBusEntries4Woff(boolean isAr, String busEntityKey, List<DynamicObject> woffBills) {
        ArrayList<DynamicObject> srcBusEntries = new ArrayList<DynamicObject>();
        String sql4bus = "entry.id, e_quantity, e_iswriteoff";
        for (DynamicObject woffbill : woffBills) {
            Long srcPk = Long.valueOf(woffbill.getString("sourcebillid"));
            DynamicObject busBill = BusinessDataServiceHelper.loadSingle((Object)srcPk, (String)busEntityKey, (String)sql4bus);
            DynamicObjectCollection woffEntries = woffbill.getDynamicObjectCollection("entry");
            for (DynamicObject woffEntry : woffEntries) {
                BigDecimal woffQty;
                BigDecimal srcQty;
                DynamicObject srcBusEntry = new DynamicObject();
                for (DynamicObject busEntry : busBill.getDynamicObjectCollection("entry")) {
                    if (busEntry.getBoolean("e_iswriteoff") || !busEntry.getPkValue().equals(woffEntry.getLong("e_srcentryid"))) continue;
                    srcBusEntry = busEntry;
                    break;
                }
                if ((srcQty = srcBusEntry.getBigDecimal("e_quantity").abs()).compareTo(woffQty = woffEntry.getBigDecimal("e_quantity").abs()) != 0) {
                    BigDecimal sumQty = BigDecimal.ZERO;
                    sumQty = this.getWoffInvoicedAmt(srcPk, srcBusEntry.getLong("id"), isAr);
                    if (srcQty.subtract(sumQty.abs()).compareTo(woffQty) == 0) {
                        srcBusEntry.set("e_iswriteoff", (Object)Boolean.TRUE);
                    }
                } else {
                    srcBusEntry.set("e_iswriteoff", (Object)Boolean.TRUE);
                }
                srcBusEntries.add(srcBusEntry);
            }
        }
        return srcBusEntries;
    }

    private List<DynamicObject> buildWoffBill(DynamicObject[] srcBills, boolean isAr) {
        List<Long> srcPks = ArApHelper.getPks(srcBills);
        String busEntityKey = isAr ? "ar_busbill" : "ap_busbill";
        Map<String, Object> map = BOTPHelper.push4Result(busEntityKey, busEntityKey, isAr ? "697561685841434624" : "712748085842822144", srcPks);
        List trgBills = null;
        ConvertOperationResult result = (ConvertOperationResult)map.get("convertResult");
        if (result != null) {
            String convertReport = BOTPHelper.getConvertReport(result);
            logger.info("------botp.ConvertReport------" + convertReport);
            ErrorCode ec = new ErrorCode("botp", convertReport);
            throw new KDBizException(ec, new Object[0]);
        }
        trgBills = (List)map.get("trgBills");
        for (DynamicObject trgBill : trgBills) {
            if (EmptyUtils.isEmpty(trgBill.getString("billno"))) {
                String number = CodeRuleServiceHelper.getNumber((String)busEntityKey, (DynamicObject)trgBill, (String)trgBill.getDynamicObject("org").getPkValue().toString());
                trgBill.set("billno", (Object)number);
            }
            trgBill.set("isadjust", (Object)Boolean.TRUE);
            trgBill.set("isselfwoff", (Object)Boolean.TRUE);
            BigDecimal rate = trgBill.getBigDecimal("exchangerate");
            DynamicObjectCollection trgEntries = trgBill.getDynamicObjectCollection("entry");
            DynamicObject currency = trgBill.getDynamicObject("currency");
            currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency", (String)"id,amtprecision,priceprecision");
            int precision = currency.getInt("amtprecision");
            DynamicObject basecurrency = trgBill.getDynamicObject("basecurrency");
            basecurrency = !currency.getPkValue().equals(basecurrency.getPkValue()) ? BusinessDataServiceHelper.loadSingleFromCache((Object)basecurrency.getPkValue(), (String)"bd_currency", (String)"id,amtprecision,priceprecision") : currency;
            int localprecision = basecurrency.getInt("amtprecision");
            boolean includeTax = trgBill.getBoolean("isincludetax");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal taxlocamt = BigDecimal.ZERO;
            BigDecimal pricetaxtotal = BigDecimal.ZERO;
            BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
            BigDecimal uninvoicedlocamt = BigDecimal.ZERO;
            for (DynamicObject trgEntry : trgEntries) {
                this.setTrgEntry(trgEntry, srcBills, rate, isAr, includeTax, precision, localprecision);
                amount = amount.add(trgEntry.getBigDecimal("e_amount"));
                localamt = localamt.add(trgEntry.getBigDecimal("e_localamt"));
                tax = tax.add(trgEntry.getBigDecimal("e_tax"));
                taxlocamt = taxlocamt.add(trgEntry.getBigDecimal("e_taxlocalamt"));
                pricetaxtotal = pricetaxtotal.add(trgEntry.getBigDecimal(isAr ? "e_recamount" : "e_pricetaxtotal"));
                pricetaxtotalbase = pricetaxtotalbase.add(trgEntry.getBigDecimal(isAr ? "e_reclocalamt" : "e_pricetaxtotalbase"));
                uninvoicedlocamt = uninvoicedlocamt.add(trgEntry.getBigDecimal("e_uninvoicedlocamt"));
            }
            trgBill.set("amount", (Object)amount);
            trgBill.set("tax", (Object)tax);
            trgBill.set("localamt", (Object)localamt);
            trgBill.set("taxlocamt", (Object)taxlocamt);
            trgBill.set(isAr ? "recamount" : "pricetaxtotal", (Object)pricetaxtotal);
            trgBill.set(isAr ? "reclocalamt" : "pricetaxtotalbase", (Object)pricetaxtotalbase);
            trgBill.set("uninvoicedamt", (Object)pricetaxtotal);
            trgBill.set("uninvoicedlocamt", (Object)uninvoicedlocamt);
            DynamicObjectCollection planEntrys = trgBill.getDynamicObjectCollection("planentity");
            planEntrys.removeAll((Collection)planEntrys);
            DynamicObject planentry = new DynamicObject(planEntrys.getDynamicObjectType());
            planEntrys.add((Object)planentry);
            planentry.set("seq", (Object)1);
            planentry.set("planduedate", trgBill.get("duedate"));
            planentry.set("plansettletype", trgBill.get("settlementtype"));
            planentry.set("planpricetax", (Object)pricetaxtotal);
            planentry.set("planpricetaxloc", (Object)pricetaxtotalbase);
            planentry.set("p_uninvoicedamt", (Object)pricetaxtotal);
            planentry.set("p_uninvoicedlocamt", (Object)pricetaxtotalbase);
        }
        return trgBills;
    }

    private void setTrgEntry(DynamicObject trgEntry, DynamicObject[] srcBills, BigDecimal rate, boolean isAr, boolean includeTax, int precision, int localprecision) {
        block0: for (DynamicObject srcBill : srcBills) {
            DynamicObjectCollection srcEntries = srcBill.getDynamicObjectCollection("entry");
            for (DynamicObject srcEntry : srcEntries) {
                if (!srcEntry.getPkValue().equals(trgEntry.getLong("e_srcentryid"))) continue;
                this.setQtyAmtField(trgEntry, srcEntry, rate, isAr, includeTax, precision, localprecision);
                continue block0;
            }
        }
    }

    private void setQtyAmtField(DynamicObject trgEntry, DynamicObject srcEntry, BigDecimal rate, boolean isAr, boolean includeTax, int precision, int localprecision) {
        AbstractPriceCalculator calculator;
        BigDecimal quantity = srcEntry.getBigDecimal("e_uninvoicedqty").negate();
        if (quantity == null) {
            quantity = BigDecimal.ZERO;
        }
        PriceLocalCalculator localCalculator = null;
        BigDecimal taxRate = trgEntry.getBigDecimal("e_taxrate");
        String discountMode = trgEntry.getString("e_discountmode");
        BigDecimal discountRate = trgEntry.getBigDecimal("e_discountrate");
        if (includeTax) {
            calculator = new TaxUnitPriceCalculator(quantity, trgEntry.getBigDecimal("e_taxunitprice"), taxRate, discountMode, discountRate, precision);
            localCalculator = new PriceLocalCalculator(calculator, rate, localprecision);
        } else {
            calculator = new UnitPriceCalculator(quantity, trgEntry.getBigDecimal("e_unitprice"), taxRate, discountMode, discountRate, precision);
            localCalculator = new PriceLocalCalculator(calculator, rate, localprecision);
        }
        if (localCalculator != null) {
            localCalculator.calculate();
            trgEntry.set("e_quantity", (Object)localCalculator.getQuantity());
            BigDecimal covertRate = trgEntry.getBigDecimal("e_unitcoefficient");
            DynamicObject material = trgEntry.getDynamicObject("e_material");
            DynamicObject measureUnit = trgEntry.getDynamicObject("e_measureunit");
            DynamicObject baseUnit = null;
            if (!ObjectUtils.isEmpty((Object)material)) {
                baseUnit = material.getDynamicObject("baseunit");
                trgEntry.set("e_baseunit", (Object)baseUnit);
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                    covertRate = UnitConvertHelper.getUnitRateConv(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
                }
            } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = BigDecimal.ONE;
            }
            if (EmptyUtils.isEmpty(trgEntry.getBigDecimal("e_unitcoefficient"))) {
                trgEntry.set("e_unitcoefficient", (Object)covertRate);
            }
            if (EmptyUtils.isEmpty(trgEntry.getBigDecimal("e_baseunitqty"))) {
                trgEntry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            trgEntry.set("e_amount", (Object)localCalculator.getAmount());
            trgEntry.set("e_localamt", (Object)localCalculator.getAmountlocal());
            trgEntry.set("e_tax", (Object)localCalculator.getTax());
            trgEntry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
            trgEntry.set("e_discountamount", (Object)localCalculator.getDiscountamount().abs());
            BigDecimal recamount = localCalculator.getPricetaxtotal();
            BigDecimal uninvoicedamt = srcEntry.getBigDecimal("e_uninvoicedamt").negate();
            if (recamount.compareTo(uninvoicedamt) != 0) {
                recamount = uninvoicedamt;
            }
            trgEntry.set(isAr ? "e_recamount" : "e_pricetaxtotal", (Object)recamount);
            BigDecimal reclocalamt = localCalculator.getPricetaxtotallocal();
            trgEntry.set(isAr ? "e_reclocalamt" : "e_pricetaxtotalbase", (Object)reclocalamt);
            trgEntry.set("e_uninvoicedqty", (Object)quantity);
            trgEntry.set("e_uninvoicedamt", (Object)recamount);
            trgEntry.set("e_uninvoicedlocamt", (Object)reclocalamt);
        }
    }

    public void antiWriteOff(DynamicObject[] busbills, boolean isAr) {
        int size = busbills.length;
        ArrayList<Long> trgPks = new ArrayList<Long>(size);
        ArrayList<DynamicObject[]> srcPks = new ArrayList<DynamicObject[]>(size);
        for (DynamicObject busbill : busbills) {
            if (!busbill.getBoolean("isadjust") || !EmptyUtils.isEmpty(busbill.getLong("srcfinbillid"))) continue;
            trgPks.add(busbill.getLong("id"));
            DynamicObjectCollection entries = busbill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                DynamicObject[] srcPk = Long.valueOf(entry.getString("e_srcbillid"));
                if (srcPks.contains(srcPk)) continue;
                srcPks.add(srcPk);
            }
        }
        if (!trgPks.isEmpty()) {
            String busEntityKey = isAr ? "ar_busbill" : "ap_busbill";
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("history_writeback", "false");
            OperationResult unauditResult = OperationServiceHelper.executeOperate((String)"noprotocolunaudit", (String)busEntityKey, (Object[])trgPks.toArray(), (OperateOption)option);
            if (!unauditResult.isSuccess()) {
                logger.info("------unauditResult.Message------" + unauditResult.getMessage());
            }
            QFilter filter = new QFilter("id", "in", srcPks);
            DynamicObject[] srcBills = BusinessDataServiceHelper.load((String)busEntityKey, (String)"billno, billstatus, entry.e_iswriteoff", (QFilter[])new QFilter[]{filter});
            option.setVariableValue("isStrict", "false");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)busEntityKey, (Object[])trgPks.toArray(), (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                logger.info("------deleteResult.Message------" + deleteResult.getMessage());
                StringBuilder status = new StringBuilder();
                for (DynamicObject busbill : srcBills) {
                    status.append(busbill.getString("billno"));
                    status.append(" -- ");
                    status.append(busbill.getString("billstatus"));
                    status.append(',');
                }
                logger.info(status.append("------deleteBefore.status------").toString());
                StringBuffer sb = new StringBuffer();
                List validateErrors = deleteResult.getValidateResult().getValidateErrors();
                for (ValidateResult vr : validateErrors) {
                    List allErrorInfo = vr.getAllErrorInfo();
                    for (OperateErrorInfo errInfo : allErrorInfo) {
                        sb.append(errInfo.getPkValue());
                        sb.append(" -- ");
                        sb.append(errInfo.getMessage());
                        sb.append(',');
                    }
                }
                logger.info(sb.append("------deleteResult.OperateErrors------").toString());
            }
        }
    }

    public BigDecimal getWoffInvoicedAmt(long busPk, long busEntryPk, boolean isAr) {
        BigDecimal woffInvoicedQty = BigDecimal.ZERO;
        StringBuilder sql = new StringBuilder();
        String headTableName = null;
        String entryTableName = null;
        if (isAr) {
            headTableName = "T_AR_BusBill";
            entryTableName = "T_AR_BusBillEntry";
        } else {
            headTableName = "T_AP_BusBill";
            entryTableName = "T_AP_BusBillEntry";
        }
        sql.append(" SELECT SUM(entrys.FQuantity) as FQty ");
        sql.append(" FROM ");
        sql.append(headTableName);
        sql.append(" head ");
        sql.append(" LEFT JOIN ");
        sql.append(entryTableName);
        sql.append(" entrys ON entrys.FID = head.FID ");
        sql.append(" WHERE head.FBillStatus = 'C' AND head.FIsAdjust = '1' ");
        sql.append(" AND entrys.FSrcBillID = ? ");
        sql.append(" AND entrys.FSrcEntryID = ? ;");
        Object[] params = new Object[]{busPk, busEntryPk};
        try (DataSet ds = DB.queryDataSet((String)"getWoffInvoicedAmt", (DBRoute)DBRouteConst.AR, (String)sql.toString(), (Object[])params);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    woffInvoicedQty = data.getBigDecimal("FQty") != null ? data.getBigDecimal("FQty") : BigDecimal.ZERO;
                }
            }
        }
        return woffInvoicedQty;
    }
}

