/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DisposeBusHelper {
    public static final String arWriteoffRuleId = "697561685841434624";
    public static final String apWriteoffRuleId = "712748085842822144";

    public static void finDisposeBusPlan(DynamicObject[] datas, boolean isSave, boolean isAr) {
        String finBillEntity = isAr ? "ar_finarbill" : "ap_finapbill";
        String busBillEntity = isAr ? "ar_busbill" : "ap_busbill";
        String amtfeild = isAr ? "recamount" : "pricetaxtotal";
        for (DynamicObject finBill : datas) {
            BigDecimal amount;
            DynamicObject invoice;
            String sourcebilltype = finBill.getString("sourcebilltype");
            String srcBillID = finBill.getString("sourcebillid");
            Long busBillId = null;
            if (busBillEntity.equals(sourcebilltype)) {
                busBillId = Long.valueOf(srcBillID);
            } else if (("ar_invoice".equals(sourcebilltype) || "ap_invoice".equals(sourcebilltype)) && busBillEntity.equals((invoice = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)sourcebilltype, (String)"id,sourcebilltype,sourcebillid")).getString("sourcebilltype"))) {
                busBillId = Long.valueOf(invoice.getString("sourcebillid"));
            }
            if (busBillId == null) continue;
            BigDecimal disposeAmt = amount = finBill.getBigDecimal(amtfeild);
            if (isSave) {
                DynamicObject cacheInfo = BusinessDataServiceHelper.loadSingle((Object)finBill.getPkValue(), (String)finBillEntity);
                BigDecimal cacheamt = BigDecimal.ZERO;
                if (cacheInfo != null) {
                    cacheamt = cacheInfo.getBigDecimal(amtfeild);
                }
                disposeAmt = disposeAmt.subtract(cacheamt);
            } else {
                disposeAmt = disposeAmt.negate();
            }
            if (disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            if (amount.multiply(disposeAmt).compareTo(BigDecimal.ZERO) > 0) {
                DisposeBusHelper.disposeBusPlan(busBillId, disposeAmt, busBillEntity);
                continue;
            }
            DisposeBusHelper.disposeNegativeBusPlan(busBillId, disposeAmt.negate(), busBillEntity);
        }
    }

    private static void disposeBusPlan(Long busBillId, BigDecimal disposeAmt, String busentity) {
        DynamicObject busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)busentity, (String)"id,exchangerate,planentity.id,planentity.planduedate,planentity.planpricetax,planentity.p_invoicedamt,planentity.p_invoicedlocamt,planentity.p_uninvoicedamt,planentity.p_uninvoicedlocamt");
        BigDecimal rate = busBill.getBigDecimal("exchangerate");
        DynamicObjectCollection planColl = busBill.getDynamicObjectCollection("planentity");
        int size = planColl.size();
        for (int i = 0; i < size && disposeAmt.compareTo(BigDecimal.ZERO) != 0; ++i) {
            DynamicObject plan = (DynamicObject)planColl.get(i);
            BigDecimal uninvoicedAmt = plan.getBigDecimal("p_uninvoicedamt");
            BigDecimal invoicedAmt = plan.getBigDecimal("p_invoicedamt");
            BigDecimal curDisposeAmt = disposeAmt;
            if (i + 1 != size && uninvoicedAmt.compareTo(curDisposeAmt) < 0) {
                curDisposeAmt = uninvoicedAmt;
            }
            disposeAmt = disposeAmt.subtract(curDisposeAmt);
            BigDecimal uninvoicedAmt2 = uninvoicedAmt.subtract(curDisposeAmt);
            BigDecimal invoicedAmt2 = invoicedAmt.add(curDisposeAmt);
            plan.set("p_uninvoicedamt", (Object)uninvoicedAmt2);
            plan.set("p_uninvoicedlocamt", (Object)uninvoicedAmt2.multiply(rate));
            plan.set("p_invoicedamt", (Object)invoicedAmt2);
            plan.set("p_invoicedlocamt", (Object)invoicedAmt2.multiply(rate));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill});
    }

    private static void disposeNegativeBusPlan(Long busBillId, BigDecimal disposeAmt, String busentity) {
        DynamicObject busBill = BusinessDataServiceHelper.loadSingle((Object)busBillId, (String)busentity, (String)"id,exchangerate,planentity.id,planentity.planduedate,planentity.planpricetax,planentity.p_invoicedamt,planentity.p_invoicedlocamt,planentity.p_uninvoicedamt,planentity.p_uninvoicedlocamt");
        BigDecimal rate = busBill.getBigDecimal("exchangerate");
        DynamicObjectCollection planColl = busBill.getDynamicObjectCollection("planentity");
        for (int i = planColl.size() - 1; i >= 0 && disposeAmt.compareTo(BigDecimal.ZERO) != 0; --i) {
            DynamicObject plan = (DynamicObject)planColl.get(i);
            BigDecimal uninvoicedAmt = plan.getBigDecimal("p_uninvoicedamt");
            BigDecimal invoicedAmt = plan.getBigDecimal("p_invoicedamt");
            BigDecimal curDisposeAmt = disposeAmt;
            if (invoicedAmt.abs().compareTo(curDisposeAmt.abs()) < 0) {
                curDisposeAmt = invoicedAmt;
            }
            disposeAmt = disposeAmt.subtract(curDisposeAmt);
            BigDecimal uninvoicedAmt2 = uninvoicedAmt.add(curDisposeAmt);
            BigDecimal invoicedAmt2 = invoicedAmt.subtract(curDisposeAmt);
            plan.set("p_uninvoicedamt", (Object)uninvoicedAmt2);
            plan.set("p_uninvoicedlocamt", (Object)uninvoicedAmt2.multiply(rate));
            plan.set("p_invoicedamt", (Object)invoicedAmt2);
            plan.set("p_invoicedlocamt", (Object)invoicedAmt2.multiply(rate));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{busBill});
    }

    public static void adjustDisposeBusPlan(DynamicObject[] datas, String busentity, boolean isSave) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DynamicObject busBill : datas) {
            if (!busBill.getBoolean("isadjust")) continue;
            BigDecimal disposeAmt = busBill.getBigDecimal("noinvoiceamt");
            if (isSave) {
                DynamicObject cacheInfo = BusinessDataServiceHelper.loadSingle((Object)busBill.getPkValue(), (String)busentity);
                BigDecimal cacheamt = BigDecimal.ZERO;
                if (cacheInfo != null) {
                    cacheamt = cacheInfo.getBigDecimal("noinvoiceamt");
                }
                disposeAmt = disposeAmt.subtract(cacheamt);
                disposeAmt = disposeAmt.negate();
            }
            if (disposeAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            List<Object[]> paramListTemp = DisposeBusHelper.disposeBusPlanNoinvoiceamt(busBill.getLong("sourcebillid"), disposeAmt, busentity);
            paramList.addAll(paramListTemp);
        }
        if (paramList.size() < 1) {
            return;
        }
        String table = null;
        DBRoute DBKey = new DBRoute("ar");
        if ("ar_busbill".equals(busentity)) {
            table = "t_ar_busplanentry";
        } else {
            table = "t_ap_busplanentry";
            DBKey = new DBRoute("ap");
        }
        String sql = "update " + table + " set fnoinvoiceamt = fnoinvoiceamt+?,fnoinvoicelocamt = fnoinvoicelocamt+?, funinvoicedamt = funinvoicedamt-?,funinvoicedlocamt = funinvoicedlocamt-?  where fentryid=?";
        DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
    }

    private static List<Object[]> disposeBusPlanNoinvoiceamt(Object billId, BigDecimal disposeAmt, String busentity) {
        DynamicObjectCollection planColl;
        boolean isNegative;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        String filterFeild = "p_uninvoicedamt";
        String order = "asc";
        boolean bl = isNegative = disposeAmt.compareTo(BigDecimal.ZERO) < 0;
        if (isNegative) {
            filterFeild = "p_noinvoiceamt";
            order = "desc";
            disposeAmt = disposeAmt.negate();
        }
        if ((planColl = QueryServiceHelper.query((String)busentity, (String)"id,exchangerate,planentity.id,planentity.planduedate,planentity.planpricetax,planentity.p_noinvoiceamt,planentity.p_noinvoicelocamt,planentity.p_uninvoicedamt,planentity.p_uninvoicedlocamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("planentity." + filterFeild, ">", (Object)BigDecimal.ZERO)}, (String)("planentity.planduedate " + order))).size() == 0) {
            return paramList;
        }
        BigDecimal rate = ((DynamicObject)planColl.get(0)).getBigDecimal("exchangerate");
        for (DynamicObject plan : planColl) {
            if (disposeAmt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal filterAmt = plan.getBigDecimal("planentity." + filterFeild);
            BigDecimal curDisposeAmt = filterAmt.compareTo(disposeAmt) > 0 ? disposeAmt : filterAmt;
            disposeAmt = disposeAmt.subtract(curDisposeAmt);
            if (isNegative) {
                curDisposeAmt = curDisposeAmt.negate();
            }
            BigDecimal curDisposeLocamt = curDisposeAmt.multiply(rate);
            Object[] objArr = new Object[]{curDisposeAmt, curDisposeLocamt, curDisposeAmt, curDisposeLocamt, plan.getLong("planentity.id")};
            paramList.add(objArr);
        }
        return paramList;
    }
}

