/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.arapcommon.helper.BOTPHelper;

public class DisposePlanHelper {
    public static void disposePlan(Object billId, BigDecimal lockedamt, String entity) {
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        String table = null;
        String hintTable = null;
        String pricetaxtotal = null;
        DBRoute DBKey = new DBRoute("ap");
        if (entity.equals("ap_finapbill")) {
            table = "t_ap_finapplanentry";
            hintTable = "t_ap_finapplan";
            pricetaxtotal = "pricetaxtotal";
        } else {
            table = "t_ar_finarplanentry";
            hintTable = "t_ar_finarplan";
            pricetaxtotal = "recamount";
            DBKey = new DBRoute("ar");
        }
        long modifierId = RequestContext.get().getCurrUserId();
        Date modifyTime = Date.from(Instant.now());
        DynamicObjectCollection planColls = QueryServiceHelper.query((String)entity, (String)"id,exchangerate,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter(pricetaxtotal, "=", (Object)BigDecimal.ZERO)}, (String)"planentity.seq asc");
        if (!ObjectUtils.isEmpty((Object)planColls)) {
            DynamicObject plan = (DynamicObject)planColls.get(0);
            try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});){
                String sql = "update " + table + " set fplanlockedamt = fplanlockedamt+?,funplanlockamt = funplanlockamt-?,fmodifierid = ?,fmodifytime = ?  where fentryid=? and fid = ?";
                DB.execute((DBRoute)DBKey, (String)sql, (Object[])new Object[]{lockedamt, lockedamt, modifierId, modifyTime, plan.getLong("planentity.id"), billId});
                return;
            }
        }
        if (lockedamt.compareTo(BigDecimal.ZERO) > 0) {
            Object plan2;
            DynamicObjectCollection planColl = QueryServiceHelper.query((String)entity, (String)"id,exchangerate,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("planentity.unplanlockamt", ">", (Object)BigDecimal.ZERO)}, (String)"planentity.seq asc");
            if (planColl.size() == 0) {
                return;
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (Object plan2 : planColl) {
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal unPlanlockamt = plan2.getBigDecimal("planentity.unplanlockamt");
                BigDecimal curlockAmt = unPlanlockamt.compareTo(lockedamt) >= 0 ? lockedamt : unPlanlockamt;
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, modifierId, modifyTime, plan2.getLong("planentity.id"), billId};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});
            plan2 = null;
            try {
                String sql = "update " + table + " set fplanlockedamt = fplanlockedamt+?,funplanlockamt = funplanlockamt-?,fmodifierid = ?,fmodifytime = ?  where fentryid=? and fid = ?";
                DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
            }
            catch (Throwable sql) {
                plan2 = sql;
                throw sql;
            }
            finally {
                if (ctx != null) {
                    if (plan2 != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql) {
                            ((Throwable)plan2).addSuppressed(sql);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        DynamicObjectCollection planColl = QueryServiceHelper.query((String)entity, (String)"id,exchangerate,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("planentity.planlockedamt", ">", (Object)BigDecimal.ZERO)}, (String)"planentity.seq desc");
        if (planColl.size() == 0) {
            return;
        }
        lockedamt = lockedamt.negate();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DynamicObject plan : planColl) {
            if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal Planlockamt = plan.getBigDecimal("planentity.planlockedamt");
            BigDecimal curlockAmt = Planlockamt.compareTo(lockedamt) >= 0 ? lockedamt : Planlockamt;
            lockedamt = lockedamt.subtract(curlockAmt);
            Object[] objArr = new Object[]{curlockAmt, curlockAmt, modifierId, modifyTime, plan.getLong("planentity.id"), billId};
            paramList.add(objArr);
        }
        if (paramList.size() == 0) {
            return;
        }
        try (Iterator ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});){
            String sql = "update " + table + " set fplanlockedamt = fplanlockedamt-?,funplanlockamt = funplanlockamt+?,fmodifierid = ?,fmodifytime = ?  where fentryid=? and fid = ?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }

    public static void disposePayPlan(Object billId, BigDecimal lockedamt, String entity) {
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        if (entity.equals("ap_finapbill")) {
            DisposePlanHelper.disposeApPayPlan(billId, lockedamt);
        } else {
            DisposePlanHelper.disposeArPayPlan(billId, lockedamt);
        }
    }

    private static void disposeArPayPlan(Object billId, BigDecimal lockedamt) {
        String table = "t_ar_finarplanentry";
        String hintTable = "t_ar_finarplan";
        DBRoute DBKey = new DBRoute("ar");
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        if (lockedamt.compareTo(BigDecimal.ZERO) > 0) {
            Object plan;
            DynamicObjectCollection planColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,exchangerate,currency.amtprecision,recamount,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("planentity.unplanlockamt", ">", (Object)BigDecimal.ZERO)}, (String)"planentity.seq asc");
            if (planColl.size() == 0) {
                return;
            }
            int amtprecision = ((DynamicObject)planColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)planColl.get(0)).getBigDecimal("recamount"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < planColl.size(); ++i) {
                plan = (DynamicObject)planColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal receiveAmt = plan.getBigDecimal("planentity.planpricetax");
                BigDecimal curlockAmt = receiveAmt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == planColl.size() - 1) {
                    curlockAmt = receiveAmt.compareTo(lockedamt) >= 0 ? lockedamt : receiveAmt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, plan.getLong("planentity.id"), billId};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});
            plan = null;
            try {
                String sql = "update " + table + " set fplanlockedamt = ?, funplanlockamt = fplanpricetax - ?  where fentryid = ? and fid = ?";
                DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
            }
            catch (Throwable sql) {
                plan = sql;
                throw sql;
            }
            finally {
                if (ctx != null) {
                    if (plan != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql) {
                            ((Throwable)plan).addSuppressed(sql);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        DynamicObjectCollection planColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,exchangerate,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("planentity.planlockedamt", ">", (Object)BigDecimal.ZERO)}, (String)"planentity.seq desc");
        if (planColl.size() == 0) {
            return;
        }
        lockedamt = lockedamt.negate();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DynamicObject plan : planColl) {
            if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal Planlockamt = plan.getBigDecimal("planentity.planlockedamt");
            BigDecimal curlockAmt = Planlockamt.compareTo(lockedamt) >= 0 ? lockedamt : Planlockamt;
            lockedamt = lockedamt.subtract(curlockAmt);
            Object[] objArr = new Object[]{curlockAmt, curlockAmt, plan.getLong("planentity.id"), billId};
            paramList.add(objArr);
        }
        if (paramList.size() == 0) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});){
            String sql = "update " + table + " set fplanlockedamt = fplanlockedamt-?,funplanlockamt = funplanlockamt+?  where fentryid=? and fid = ?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }

    public static void disposeApPayPlan(Object billId, BigDecimal lockedamt) {
        String table = "t_ap_finapplanentry";
        String hintTable = "t_ap_finapplan";
        DBRoute DBKey = new DBRoute("ap");
        if (ObjectUtils.isEmpty((Object)billId)) {
            return;
        }
        if (lockedamt.compareTo(BigDecimal.ZERO) > 0) {
            Object plan;
            DynamicObjectCollection planColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,currency.amtprecision,pricetaxtotal,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("planentity.unplanlockamt", ">", (Object)BigDecimal.ZERO)}, (String)"planentity.seq asc");
            if (planColl.size() == 0) {
                return;
            }
            int amtprecision = ((DynamicObject)planColl.get(0)).getInt("currency.amtprecision");
            BigDecimal rate = lockedamt.divide(((DynamicObject)planColl.get(0)).getBigDecimal("pricetaxtotal"), 10, RoundingMode.HALF_UP);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < planColl.size(); ++i) {
                plan = (DynamicObject)planColl.get(i);
                if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal payAmt = plan.getBigDecimal("planentity.planpricetax");
                BigDecimal curlockAmt = payAmt.multiply(rate).setScale(amtprecision, RoundingMode.HALF_UP);
                if (i == planColl.size() - 1) {
                    curlockAmt = payAmt.compareTo(lockedamt) >= 0 ? lockedamt : payAmt;
                }
                lockedamt = lockedamt.subtract(curlockAmt);
                Object[] objArr = new Object[]{curlockAmt, curlockAmt, plan.getLong("planentity.id"), billId};
                paramList.add(objArr);
            }
            if (paramList.size() == 0) {
                return;
            }
            ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});
            plan = null;
            try {
                String sql = "update " + table + " set fplanlockedamt = fplanlockedamt+?, funplanlockamt = funplanlockamt - ?  where fentryid = ? and fid = ?";
                DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
            }
            catch (Throwable sql) {
                plan = sql;
                throw sql;
            }
            finally {
                if (ctx != null) {
                    if (plan != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable sql) {
                            ((Throwable)plan).addSuppressed(sql);
                        }
                    } else {
                        ctx.close();
                    }
                }
            }
        }
        DynamicObjectCollection planColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,exchangerate,planentity.id,planentity.seq,planentity.planduedate,planentity.planpricetax,planentity.planlockedamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{new QFilter("id", "=", billId), new QFilter("planentity.planlockedamt", ">", (Object)BigDecimal.ZERO)}, (String)"planentity.seq desc");
        if (planColl.size() == 0) {
            return;
        }
        lockedamt = lockedamt.negate();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (DynamicObject plan : planColl) {
            if (lockedamt.compareTo(BigDecimal.ZERO) == 0) break;
            BigDecimal Planlockamt = plan.getBigDecimal("planentity.planlockedamt");
            BigDecimal curlockAmt = Planlockamt.compareTo(lockedamt) >= 0 ? lockedamt : Planlockamt;
            lockedamt = lockedamt.subtract(curlockAmt);
            Object[] objArr = new Object[]{curlockAmt, curlockAmt, plan.getLong("planentity.id"), billId};
            paramList.add(objArr);
        }
        if (paramList.size() == 0) {
            return;
        }
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, billId)});){
            String sql = "update " + table + " set fplanlockedamt = fplanlockedamt-?,funplanlockamt = funplanlockamt+?  where fentryid=? and fid = ?";
            DB.executeBatch((DBRoute)DBKey, (String)sql, paramList);
        }
    }

    public static void disposePlanByBotp(DynamicObject appBill, boolean isclose) {
        DynamicObjectCollection collection = appBill.getDynamicObjectCollection("entry");
        HashMap<Long, List<Map<Long, Long>>> updatemap = new HashMap<Long, List<Map<Long, Long>>>();
        for (int i = 0; i < collection.size(); ++i) {
            HashMap<Long, BigDecimal> entrymap = new HashMap<Long, BigDecimal>();
            DynamicObject coll = (DynamicObject)collection.get(i);
            List<BFRow> listBfRow = BOTPHelper.loadSourceRowIds("ap_payapply", "entry", new Long[]{coll.getLong("id")});
            if (listBfRow.size() <= 0) continue;
            BFRow row = listBfRow.get(0);
            BFRowId sid = row.getSId();
            long billId = sid.getBillId();
            long entryId = sid.getEntryId();
            BigDecimal amount = coll.getBigDecimal("e_approvedamt").subtract(coll.getBigDecimal("e_paidamt"));
            boolean issuccess = amount != BigDecimal.ZERO;
            entrymap.put(entryId, amount);
            if (!issuccess) continue;
            ArrayList entry = (ArrayList)updatemap.get(billId);
            if (entry == null) {
                entry = new ArrayList(64);
                updatemap.put(billId, entry);
            }
            entry.add(entrymap);
        }
        if (!ObjectUtils.isEmpty(updatemap)) {
            DisposePlanHelper.updateApply(updatemap, isclose, appBill);
        }
    }

    private static void updateApply(Map<Long, List<Map<Long, Long>>> updatemap, boolean isclose, DynamicObject appBill) {
        for (Map.Entry<Long, List<Map<Long, Long>>> entry : updatemap.entrySet()) {
            Long biiId = entry.getKey();
            DynamicObject finpay = BusinessDataServiceHelper.loadSingle((Object)biiId, (String)"ap_finapbill");
            DynamicObjectCollection planEntryCol = finpay.getDynamicObjectCollection("planentity");
            List<Map<Long, Long>> entryvalueList = entry.getValue();
            block1: for (Map<Long, Long> entryvaluemap : entryvalueList) {
                for (DynamicObject entryInfo : planEntryCol) {
                    Set<Long> keyset = entryvaluemap.keySet();
                    ArrayList<Long> list = new ArrayList<Long>(keyset);
                    if (!entryInfo.getPkValue().equals(list.get(0))) continue;
                    BigDecimal loackamt = entryInfo.getBigDecimal("planlockedamt");
                    BigDecimal unloackamt = entryInfo.getBigDecimal("unplanlockamt");
                    if (!isclose) {
                        entryInfo.set("planlockedamt", (Object)loackamt.add((BigDecimal)((Object)entryvaluemap.get(list.get(0)))));
                        entryInfo.set("unplanlockamt", (Object)unloackamt.subtract((BigDecimal)((Object)entryvaluemap.get(list.get(0)))));
                        continue block1;
                    }
                    entryInfo.set("planlockedamt", (Object)loackamt.subtract((BigDecimal)((Object)entryvaluemap.get(list.get(0)))));
                    entryInfo.set("unplanlockamt", (Object)unloackamt.add((BigDecimal)((Object)entryvaluemap.get(list.get(0)))));
                    continue block1;
                }
            }
            SaveServiceHelper.save((IDataEntityType)finpay.getDataEntityType(), (Object[])new DynamicObject[]{finpay});
        }
    }
}

